package com.elitesland.scp.application.service.authority;

import cn.hutool.json.JSONUtil;
import com.elitescloud.boot.excel.common.DataExport;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.scp.application.facade.vo.param.authority.ScpManAuthorityParam;
import com.elitesland.scp.application.facade.vo.resp.authority.ScpManAuthorityPageRespVO;
import com.elitesland.scp.application.facade.vo.resp.authority.ScpsmanAuthorityExportVO;
import com.elitesland.scp.domain.convert.authority.ScpDemandAuthorityConvert;
import com.esotericsoftware.minlog.Log;
import lombok.RequiredArgsConstructor;
import org.springframework.stereotype.Component;

import java.util.List;
import java.util.stream.Collectors;

/**
 * ClassName: ScpManAuthorityExportImpl
 * Description:
 *
 * @author wz
 * @date 2024/3/19 19:10
 */
@Component
@RequiredArgsConstructor
public class ScpsmanAuthorityExportImpl implements DataExport<ScpsmanAuthorityExportVO, ScpManAuthorityParam> {

    private final ScpsmanAuthorityService scpsmanAuthorityService;

    @Override
    public String getTmplCode() {
        return "scpsman_authority_Export";
    }

    @Override
    public PagingVO<ScpsmanAuthorityExportVO> executeExport(ScpManAuthorityParam queryParam) {
        PagingVO<ScpManAuthorityPageRespVO> scpManAuthorityPageRespVOPagingVO = scpsmanAuthorityService.queryAuthorit(queryParam);
        if (scpManAuthorityPageRespVOPagingVO.isNotEmpty()) {
            List<ScpsmanAuthorityExportVO> collect = scpManAuthorityPageRespVOPagingVO.stream().map(ScpDemandAuthorityConvert.INSTANCE::pageVoToExport).collect(Collectors.toList());
            Log.info("计划员权限导出结果:{}", JSONUtil.toJsonStr(collect));
            return PagingVO.<ScpsmanAuthorityExportVO>builder()
                    .total(scpManAuthorityPageRespVOPagingVO.getTotal())
                    .records(collect)
                    .build();
        }
        return new PagingVO<>();
    }

}
