package com.elitesland.scp.domain.service.alloc;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.scp.application.facade.vo.param.alloc.ScpAllocSettingStorePageParamVO;
import com.elitesland.scp.application.facade.vo.param.alloc.ScpAllocSettingStoreParamVO;
import com.elitesland.scp.application.facade.vo.resp.alloc.ScpAllocSettingStoreRespVO;
import com.elitesland.scp.application.facade.vo.save.alloc.ScpAllocSettingStoreSaveVO;

import java.util.List;

public interface ScpAllocSettingStoreDomainService {

    /**
     * 订货强配活动门店查询
     *
     * @param paramVO
     * @return
     */
    PagingVO<ScpAllocSettingStoreRespVO> page(ScpAllocSettingStorePageParamVO paramVO);

    /**
     * 订货强配活动门店保存
     *
     * @param saveVOS 保存单据类型配置的值对象
     * @return 返回保存后的单据类型配置的ID
     */
    void batchSaveAllocSettingStore(List<ScpAllocSettingStoreSaveVO> saveVOS, int batchSize);

    default void batchSaveAllocSettingStore(List<ScpAllocSettingStoreSaveVO> saveVOS) {
        batchSaveAllocSettingStore(saveVOS, 100);
    }

    /**
     * 删除订货强配活动门店
     *
     * @param masId
     */
    void deleteByMasId(Long masId);

    /**
     * 删除订货强配活动门店
     *
     * @param ids
     */
    void deleteByIds(List<Long> ids);

    /**
     * 根据门店查询
     *
     * @param storeCode
     * @return
     */
    List<Long> findMasIdByStoreCode(List<String> storeCodes);

    /**
     * 更新已强配次数
     *
     * @param masIds
     * @param storeCode
     */
    void updateAllocNumByParam(List<Long> masIds, String storeCode);

    /**
     * 根据参数查询
     * @param paramVO
     */
    List<ScpAllocSettingStoreRespVO> findByParam(ScpAllocSettingStoreParamVO paramVO);

    /**
     * 更新门店
     * @param saveVO
     */
    Long updateAllocSettingStore(ScpAllocSettingStoreSaveVO saveVO);

    /**
     * 根据活动ID查询门店
     * @param masId
     * @return
     */
    List<ScpAllocSettingStoreRespVO> findByMasId(Long masId);

    List<ScpAllocSettingStoreRespVO> findEnabledByParam(ScpAllocSettingStoreParamVO paramVO);
}
