package com.elitesland.scp.domain.service.order;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.scp.application.facade.vo.param.order.ScpDemandSetPageParamVO;
import com.elitesland.scp.application.facade.vo.param.order.ScpDemandSetParamVO;
import com.elitesland.scp.application.facade.vo.resp.order.ScpDemandSetPageRespVO;
import com.elitesland.scp.application.facade.vo.save.order.ScpDemandSetSaveVO;
import com.elitesland.scp.infr.dto.order.ScpDemandSetDTO;

import java.util.List;
import java.util.Optional;

public interface ScpDemandSetDomainService {

    /**
     * 订货集查询
     *
     * @param paramVO
     * @return
     */
    PagingVO<ScpDemandSetPageRespVO> queryDemandSetList(ScpDemandSetPageParamVO paramVO);

    /**
     * 订货集详情查询
     *
     * @param id
     * @return
     */
    Optional<ScpDemandSetDTO> findDemandSetById(Long id);

    /**
     * 订货集保存
     *
     * @param saveVO 保存订货集的值对象
     * @return 返回保存后的订货集的ID
     */
    Long saveDemandSet(ScpDemandSetSaveVO saveVO);

    /**
     * 订货集状态变更
     *
     * @param ids    订货集的ID列表
     * @param enable 订货集的状态，true表示启用，false表示禁用
     */
    void enableDemandSet(List<Long> ids, Boolean enable);

    /**
     * 删除订货集
     *
     * @param ids
     */
    void deleteByIds(List<Long> ids);

    /**
     * 根据ids查询订货集
     *
     * @param ids 订货集的id列表
     * @return 返回订货集DTO对象的列表
     */
    List<ScpDemandSetDTO> findDemandSetByIds(List<Long> ids);

    /**
     * 根据参数查询订货集
     *
     * @param paramVO
     * @return
     */
    List<ScpDemandSetDTO> findDemandSetByParam(ScpDemandSetParamVO paramVO);

    /**
     * 更新订货集计算分配信息
     *
     * @param ids
     * @param msg
     */
    void updateDemandSetMsgByIds(List<Long> ids, String msg);

    /**
     * 更新订货集推送信息
     *
     * @param ids
     * @param msg
     */
    void updateDemandSetPushMsgById(List<Long> ids, String msg);

    /**
     * 更新推送状态
     * @param id
     */
    void completePushById(Long id);

    /**
     * 根据ID获取订货集状态
     * @param id
     * @return
     */
    Boolean getDemandSetStatusById(Long id);

    /**
     * 公共组件-订货集信息
     * @param paramVO
     * @return
     */
    PagingVO<ScpDemandSetPageRespVO> commonPage(ScpDemandSetPageParamVO paramVO);
}
