/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.scp.application.service.calendar;

import cn.hutool.core.collection.CollUtil;
import com.elitescloud.boot.exception.BusinessException;
import com.elitescloud.cloudt.common.annotation.SysCodeProc;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.sale.api.vo.resp.crm.CustBaseDTO;
import com.elitesland.scp.application.facade.vo.param.calendar.ScpStoreCalendarSetLinePageParamVO;
import com.elitesland.scp.application.facade.vo.param.calendar.ScpStoreCalendarSetLineParamVO;
import com.elitesland.scp.application.facade.vo.resp.calendar.ScpStoreCalendarSetLinePageRespVO;
import com.elitesland.scp.application.facade.vo.resp.calendar.ScpStoreCalendarSetLineRespVO;
import com.elitesland.scp.application.facade.vo.save.calendar.ScpStoreCalendarSetLineDelVO;
import com.elitesland.scp.application.facade.vo.save.calendar.ScpStoreCalendarSetLineSaveVO;
import com.elitesland.scp.application.service.calendar.ScpStoreCalendarSetLineService;
import com.elitesland.scp.domain.convert.calendar.ScpStoreCalendarSetLineConvert;
import com.elitesland.scp.domain.entity.calendar.ScpStoreCalendarSetLineDO;
import com.elitesland.scp.domain.service.calendar.ScpStoreCalendarSetLineDomainService;
import com.elitesland.scp.enums.ScpUdcEnum;
import com.elitesland.scp.rmi.RmiItemService;
import com.elitesland.scp.rmi.RmiOrgOuService;
import com.elitesland.scp.rmi.RmiOrgRegionRpcService;
import com.elitesland.scp.rmi.RmiSalRpcService;
import com.elitesland.support.provider.item.dto.ItmBrandRpcDTO;
import com.elitesland.support.provider.org.dto.OrgOuRpcSimpleDTO;
import com.elitesland.support.provider.org.dto.OrgRegionDTO;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.persistence.EntityManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class ScpStoreCalendarSetLineServiceImpl
implements ScpStoreCalendarSetLineService {
    private static final Logger log = LoggerFactory.getLogger(ScpStoreCalendarSetLineServiceImpl.class);
    private final ScpStoreCalendarSetLineDomainService scpStoreCalendarSetLineDomainService;
    private final EntityManager entityManager;
    private final RmiOrgOuService rmiOrgOuService;
    private final RmiItemService rmiItemService;
    private final RmiSalRpcService rmiSalRpcService;
    private final RmiOrgRegionRpcService rmiOrgRegionRpcService;

    @Override
    @SysCodeProc
    public PagingVO<ScpStoreCalendarSetLinePageRespVO> page(ScpStoreCalendarSetLinePageParamVO paramVO) {
        PagingVO<ScpStoreCalendarSetLinePageRespVO> page = this.scpStoreCalendarSetLineDomainService.queryCalendarSetLineList(paramVO);
        if (page.isNotEmpty()) {
            List records = page.getRecords();
            if (ScpUdcEnum.CALENDAR_TYPE_STORE.getValueCode().equals(((ScpStoreCalendarSetLinePageRespVO)records.get(0)).getType())) {
                List<String> ouCodes = records.stream().map(ScpStoreCalendarSetLinePageRespVO::getOuCode).filter(Objects::nonNull).distinct().collect(Collectors.toList());
                List<String> brandCodes = records.stream().map(ScpStoreCalendarSetLinePageRespVO::getBrandCode).filter(Objects::nonNull).distinct().collect(Collectors.toList());
                List regionCodes = records.stream().map(ScpStoreCalendarSetLinePageRespVO::getRegionCode).filter(Objects::nonNull).distinct().collect(Collectors.toList());
                List<String> custCodes = records.stream().map(ScpStoreCalendarSetLinePageRespVO::getCustCode).filter(Objects::nonNull).distinct().collect(Collectors.toList());
                Map<String, OrgOuRpcSimpleDTO> ouMap = this.rmiOrgOuService.findOuDtoMapByOuCodes(ouCodes);
                Map<String, ItmBrandRpcDTO> brandMap = this.rmiItemService.getBrandMap(brandCodes);
                Map<String, String> regionMap = this.rmiOrgOuService.findRegionMapByCodes(new HashSet<String>(regionCodes));
                Map<String, CustBaseDTO> custBaseMap = this.rmiSalRpcService.getCustBaseMapByCode(custCodes);
                records.forEach(row -> {
                    Optional.ofNullable((OrgOuRpcSimpleDTO)ouMap.get(row.getOuCode())).ifPresent(v -> row.setOuName(v.getOuName()));
                    Optional.ofNullable((ItmBrandRpcDTO)brandMap.get(row.getBrandCode())).ifPresent(v -> row.setBrandName(v.getBrandName()));
                    Optional.ofNullable((String)regionMap.get(row.getRegionCode())).ifPresent(row::setRegionName);
                    Optional.ofNullable((CustBaseDTO)custBaseMap.get(row.getCustCode())).ifPresent(v -> row.setCustName(v.getCustName()));
                });
            } else {
                List<String> regionCodes = records.stream().map(ScpStoreCalendarSetLinePageRespVO::getStoreCode).filter(Objects::nonNull).distinct().collect(Collectors.toList());
                Map<String, OrgRegionDTO> regionMap = this.rmiOrgRegionRpcService.findDetailRegionMapByCodes(regionCodes);
                records.forEach(row -> {
                    OrgRegionDTO orgRegionDTO = (OrgRegionDTO)regionMap.get(row.getStoreCode());
                    if (orgRegionDTO != null) {
                        row.setStoreId(orgRegionDTO.getId());
                        row.setStoreCode(orgRegionDTO.getRegionCode());
                        row.setStoreName(orgRegionDTO.getRegionName());
                        row.setApplicableObjName(orgRegionDTO.getApplicableObjName());
                        row.setApplicableAttrList(orgRegionDTO.getApplicableAttrList());
                        row.setApplicableAttrNameList(orgRegionDTO.getApplicableAttrNameList());
                        row.setAreaList(orgRegionDTO.getAreaList());
                        row.setParentOrgCode(orgRegionDTO.getParentOrgCode());
                        row.setParentOrgName(orgRegionDTO.getParentOrgName());
                        row.setEnabled(orgRegionDTO.getEnabled());
                    }
                });
            }
        }
        return page;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void saveCalendarSetLine(Long masId, List<ScpStoreCalendarSetLineSaveVO> saveVOS) {
        List<Long> storeIds = saveVOS.stream().map(ScpStoreCalendarSetLineSaveVO::getStoreId).collect(Collectors.toList());
        ScpStoreCalendarSetLineParamVO scpStoreCalendarSetLineParamVO = new ScpStoreCalendarSetLineParamVO();
        scpStoreCalendarSetLineParamVO.setMasId(masId);
        scpStoreCalendarSetLineParamVO.setStoreIds(storeIds);
        scpStoreCalendarSetLineParamVO.setTodayWeek(saveVOS.get(0).getTodayWeek());
        List<ScpStoreCalendarSetLineRespVO> calendarSets = this.scpStoreCalendarSetLineDomainService.findCalendarSetInfoByParam(scpStoreCalendarSetLineParamVO);
        if (CollUtil.isNotEmpty(calendarSets)) {
            String storeName = calendarSets.get(0).getStoreName();
            throw new BusinessException("\u95e8\u5e97\u3010" + storeName + "\u3011\u5df2\u5b58\u5728\uff0c\u8bf7\u68c0\u67e5");
        }
        List<ScpStoreCalendarSetLineDO> dataList = saveVOS.stream().map(row -> {
            ScpStoreCalendarSetLineDO scpStoreCalendarSetLineDO = ScpStoreCalendarSetLineConvert.INSTANCE.saveVoToDO((ScpStoreCalendarSetLineSaveVO)row);
            scpStoreCalendarSetLineDO.setMasId(masId);
            return scpStoreCalendarSetLineDO;
        }).collect(Collectors.toList());
        this.batchInsert(dataList, 1000);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void deleteByParam(ScpStoreCalendarSetLineDelVO paramVO) {
        this.scpStoreCalendarSetLineDomainService.deleteByParam(paramVO);
    }

    public void batchInsert(List<ScpStoreCalendarSetLineDO> dataList, int batchSize) {
        int index = 0;
        for (ScpStoreCalendarSetLineDO data : dataList) {
            this.entityManager.persist((Object)data);
            if (batchSize <= 1 || ++index % batchSize != 0) continue;
            this.entityManager.flush();
            this.entityManager.clear();
        }
        if (!dataList.isEmpty()) {
            this.entityManager.flush();
        }
    }

    public ScpStoreCalendarSetLineServiceImpl(ScpStoreCalendarSetLineDomainService scpStoreCalendarSetLineDomainService, EntityManager entityManager, RmiOrgOuService rmiOrgOuService, RmiItemService rmiItemService, RmiSalRpcService rmiSalRpcService, RmiOrgRegionRpcService rmiOrgRegionRpcService) {
        this.scpStoreCalendarSetLineDomainService = scpStoreCalendarSetLineDomainService;
        this.entityManager = entityManager;
        this.rmiOrgOuService = rmiOrgOuService;
        this.rmiItemService = rmiItemService;
        this.rmiSalRpcService = rmiSalRpcService;
        this.rmiOrgRegionRpcService = rmiOrgRegionRpcService;
    }
}

