/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.scp.infr.repo.mrp;

import cn.hutool.core.collection.CollectionUtil;
import com.elitesland.scp.application.facade.vo.resp.mrp.ScpMrpDPlanRespVO;
import com.elitesland.scp.domain.entity.mrp.QScpMrpDPlanDO;
import com.querydsl.core.types.EntityPath;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.Path;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.Projections;
import com.querydsl.core.types.QBean;
import com.querydsl.jpa.impl.JPAQuery;
import com.querydsl.jpa.impl.JPAQueryFactory;
import com.querydsl.jpa.impl.JPAUpdateClause;
import java.util.ArrayList;
import java.util.List;
import org.springframework.stereotype.Component;

@Component
public class ScpMrpDPlanRepoProc {
    private final JPAQueryFactory jpaQueryFactory;
    private final QScpMrpDPlanDO scpMrpDPlanDO = QScpMrpDPlanDO.scpMrpDPlanDO;
    private final QBean<ScpMrpDPlanRespVO> baseBean;

    public void updatePushStatus(List<Long> planIds, String pushStatus, String poNo, Long poDId, Integer poLineNo, String pushFailReason) {
        JPAUpdateClause updateClause = this.jpaQueryFactory.update((EntityPath)this.scpMrpDPlanDO).set((Path)this.scpMrpDPlanDO.pushStatus, (Object)pushStatus).where(new Predicate[]{this.scpMrpDPlanDO.id.in(planIds)});
        if (poNo == null) {
            updateClause.setNull((Path)this.scpMrpDPlanDO.poNo);
        } else {
            updateClause.set((Path)this.scpMrpDPlanDO.poNo, (Object)poNo);
        }
        if (poDId == null) {
            updateClause.setNull(this.scpMrpDPlanDO.poDId);
        } else {
            updateClause.set(this.scpMrpDPlanDO.poDId, (Object)poDId);
        }
        if (poLineNo == null) {
            updateClause.setNull(this.scpMrpDPlanDO.poLineNo);
        } else {
            updateClause.set(this.scpMrpDPlanDO.poLineNo, (Object)poLineNo);
        }
        if (pushFailReason == null) {
            updateClause.setNull((Path)this.scpMrpDPlanDO.pushFailReason);
        } else {
            updateClause.set((Path)this.scpMrpDPlanDO.pushFailReason, (Object)pushFailReason);
        }
        updateClause.execute();
    }

    public List<ScpMrpDPlanRespVO> findByIds(List<Long> ids) {
        if (CollectionUtil.isEmpty(ids)) {
            return new ArrayList<ScpMrpDPlanRespVO>();
        }
        return ((JPAQuery)((JPAQuery)this.jpaQueryFactory.select(this.baseBean).from((EntityPath)this.scpMrpDPlanDO)).where((Predicate)this.scpMrpDPlanDO.id.in(ids))).fetch();
    }

    public List<ScpMrpDPlanRespVO> findByMrpId(Long mrpId) {
        return ((JPAQuery)((JPAQuery)this.jpaQueryFactory.select(this.baseBean).from((EntityPath)this.scpMrpDPlanDO)).where((Predicate)this.scpMrpDPlanDO.mrpId.eq((Object)mrpId))).fetch();
    }

    public ScpMrpDPlanRepoProc(JPAQueryFactory jpaQueryFactory) {
        this.baseBean = Projections.bean(ScpMrpDPlanRespVO.class, (Expression[])new Expression[]{this.scpMrpDPlanDO.id, this.scpMrpDPlanDO.mrpId, this.scpMrpDPlanDO.masId, this.scpMrpDPlanDO.ouId, this.scpMrpDPlanDO.ouCode, this.scpMrpDPlanDO.ouName, this.scpMrpDPlanDO.suppId, this.scpMrpDPlanDO.suppCode, this.scpMrpDPlanDO.suppName, this.scpMrpDPlanDO.qty, this.scpMrpDPlanDO.poNo, this.scpMrpDPlanDO.poLineNo, this.scpMrpDPlanDO.pushStatus, this.scpMrpDPlanDO.pushFailReason, this.scpMrpDPlanDO.poDId, this.scpMrpDPlanDO.creator, this.scpMrpDPlanDO.createUserId, this.scpMrpDPlanDO.createTime, this.scpMrpDPlanDO.updater, this.scpMrpDPlanDO.modifyUserId, this.scpMrpDPlanDO.modifyTime, this.scpMrpDPlanDO.remark});
        this.jpaQueryFactory = jpaQueryFactory;
    }
}

