package com.elitesland.scp.infr.repo.minOrder;

import com.elitesland.scp.domain.entity.minOrder.ScpMinOrderSettingRegionDO;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.Modifying;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.querydsl.QuerydslPredicateExecutor;
import org.springframework.transaction.annotation.Transactional;

import java.util.List;
import java.util.Optional;

public interface ScpMinOrderSettingRegionRepo extends JpaRepository<ScpMinOrderSettingRegionDO, Long>, QuerydslPredicateExecutor<ScpMinOrderSettingRegionDO> {

    Optional<ScpMinOrderSettingRegionDO> findById(Long id);

    List<ScpMinOrderSettingRegionDO> findByMasId(Long masId);

    @Modifying(clearAutomatically = true)
    @Transactional(rollbackFor = Exception.class)
    @Query(value = "delete from scp_min_order_setting_region where mas_id = ?1 ", nativeQuery = true)
    void deleteByMasId(Long masId);

    @Modifying(clearAutomatically = true)
    @Transactional(rollbackFor = Exception.class)
    @Query(value = "delete from scp_min_order_setting_region where id in ?1 ", nativeQuery = true)
    void deleteByIds(List<Long> ids);
}
