/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.scp.domain.service.alloc;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.json.JSONUtil;
import com.alibaba.fastjson.JSON;
import com.elitescloud.cloudt.common.annotation.SysCodeProc;
import com.elitesland.scp.application.facade.vo.resp.alloc.ScpAllocSettingItemRespVO;
import com.elitesland.scp.application.facade.vo.save.alloc.ScpAllocSettingItemSaveVO;
import com.elitesland.scp.domain.convert.alloc.ScpAllocSettingItemConvert;
import com.elitesland.scp.domain.entity.alloc.ScpAllocSettingItemDO;
import com.elitesland.scp.domain.entity.alloc.ScpAllocSettingRedisDO;
import com.elitesland.scp.domain.service.alloc.ScpAllocSettingItemDomainService;
import com.elitesland.scp.infr.repo.alloc.ScpAllocSettingItemRepo;
import com.elitesland.scp.infr.repo.alloc.ScpAllocSettingItemRepoProc;
import com.elitesland.scp.infr.repo.order.ScpDemandOrderRepoProc;
import com.elitesland.scp.utils.SysUtils;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class ScpAllocSettingItemDomainServiceImpl
implements ScpAllocSettingItemDomainService {
    private static final Logger log = LoggerFactory.getLogger(ScpAllocSettingItemDomainServiceImpl.class);
    private final RedisTemplate redisTemplate;
    private final ScpAllocSettingItemRepo scpAllocSettingItemRepo;
    private final ScpAllocSettingItemRepoProc scpAllocSettingItemRepoProc;
    private final ScpDemandOrderRepoProc scpDemandOrderRepoProc;

    @Override
    @SysCodeProc
    public List<ScpAllocSettingItemRespVO> findByMasId(Long masId) {
        List<ScpAllocSettingItemDO> settingItemDOS = this.scpAllocSettingItemRepo.findByMasId(masId);
        if (CollUtil.isNotEmpty(settingItemDOS)) {
            return ScpAllocSettingItemConvert.INSTANCE.dosToRespVOS(settingItemDOS);
        }
        return new ArrayList<ScpAllocSettingItemRespVO>();
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void batchSaveAllocSettingItem(List<ScpAllocSettingItemSaveVO> saveVOS) {
        this.scpAllocSettingItemRepo.saveAll(ScpAllocSettingItemConvert.INSTANCE.saveVosDOS(saveVOS));
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void deleteByMasId(Long masId) {
        this.scpAllocSettingItemRepo.deleteByMasId(masId);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void deleteByIds(List<Long> ids) {
        this.scpAllocSettingItemRepo.deleteByIds(ids);
    }

    @Override
    public List<ScpAllocSettingItemRespVO> getEnableAllocSettingItemByStoreCode(String storeCode, String businessType, List<String> itemTypes) {
        ArrayList<ScpAllocSettingItemRespVO> respVOS = new ArrayList<ScpAllocSettingItemRespVO>();
        String allocBusinessType = SysUtils.getAllocBusinessType();
        if (Objects.equals(allocBusinessType, businessType)) {
            Object obj = this.redisTemplate.opsForValue().get((Object)("SCP:ALLOC:SETTING:" + storeCode));
            if (obj == null) {
                return new ArrayList<ScpAllocSettingItemRespVO>();
            }
            String str = (String)obj;
            ScpAllocSettingRedisDO setting = (ScpAllocSettingRedisDO)JSON.parseObject((String)str, ScpAllocSettingRedisDO.class);
            List<ScpAllocSettingRedisDO.ActivityDO> activityList = setting.getActivityList();
            for (ScpAllocSettingRedisDO.ActivityDO activityDO : activityList) {
                log.info("getEnableAllocSettingItemByStoreCode:{}", (Object)JSONUtil.toJsonStr((Object)activityDO));
                Object key = this.redisTemplate.opsForValue().get((Object)("SCP:ALLOC:SETTING:" + activityDO.getActivityId()));
                if (key == null) {
                    log.info("\u5f3a\u914d\u6d3b\u52a8ID:{}\uff0c\u7f13\u5b58\u4e0d\u5b58\u5728", (Object)activityDO.getActivityId());
                    continue;
                }
                if (LocalDateTime.now().isBefore(activityDO.getValidFrom()) || LocalDateTime.now().isAfter(activityDO.getValidTo())) {
                    log.info("\u5f3a\u914d\u6d3b\u52a8ID:{}\uff0c\u5df2\u8fc7\u671f", (Object)activityDO.getActivityId());
                    continue;
                }
                Long maxNum = this.scpDemandOrderRepoProc.countAllocatedOrderByItemCodes(storeCode, activityDO.getActivityCode(), activityDO.getValidFrom(), activityDO.getValidTo());
                if (activityDO.getMaxNum() <= 0 || maxNum != null && maxNum >= (long)activityDO.getMaxNum().intValue()) {
                    log.info("\u5f3a\u914d\u6d3b\u52a8ID:{},\u5df2\u8fbe\u5230\u6700\u5927\u5f3a\u914d\u6b21\u6570,\u4e0d\u53c2\u4e0e\u5f3a\u914d", (Object)activityDO.getActivityId());
                    continue;
                }
                List<ScpAllocSettingRedisDO.ActivityDO.InnerItemDO> innerItemDOS = activityDO.getInnerItemDOS();
                for (ScpAllocSettingRedisDO.ActivityDO.InnerItemDO innerItemDO : innerItemDOS) {
                    if (!itemTypes.contains(innerItemDO.getItemType2())) {
                        log.info("\u5f3a\u914d\u6d3b\u52a8ID:{}\uff0c\u5546\u54c1\u5206\u7c7b:{}\u4e0d\u5b58\u5728", (Object)activityDO.getActivityId(), (Object)innerItemDO.getItemType2());
                        continue;
                    }
                    ScpAllocSettingItemRespVO scpAllocSettingItemRespVO = new ScpAllocSettingItemRespVO();
                    scpAllocSettingItemRespVO.setItemId(innerItemDO.getItemId());
                    scpAllocSettingItemRespVO.setItemCode(innerItemDO.getItemCode());
                    scpAllocSettingItemRespVO.setItemName(innerItemDO.getItemName());
                    scpAllocSettingItemRespVO.setMasId(innerItemDO.getMasId());
                    scpAllocSettingItemRespVO.setMinNum(innerItemDO.getMinNum());
                    scpAllocSettingItemRespVO.setActivityCode(activityDO.getActivityCode());
                    scpAllocSettingItemRespVO.setImgUrl(innerItemDO.getImgUrl());
                    respVOS.add(scpAllocSettingItemRespVO);
                }
            }
        } else {
            log.info("\u4e1a\u52a1\u7c7b\u578b\u5fc5\u987b\u662f{}\u624d\u80fd\u5f3a\u914d\uff0c\u5f53\u524d\u4e1a\u52a1\u7c7b\u578b:{}", (Object)allocBusinessType, (Object)businessType);
        }
        log.info("\u95e8\u5e97:{},\u83b7\u53d6\u6210\u529f\u7684\u5f3a\u914d:{}", (Object)storeCode, (Object)JSONUtil.toJsonStr(respVOS));
        return respVOS;
    }

    @Override
    public List<ScpAllocSettingItemRespVO> getEnableAllocSettingItemByStoreCode(String storeCode, String businessType) {
        ArrayList<ScpAllocSettingItemRespVO> respVOS = new ArrayList<ScpAllocSettingItemRespVO>();
        String allocBusinessType = SysUtils.getAllocBusinessType();
        if (Objects.equals(allocBusinessType, businessType)) {
            Object obj = this.redisTemplate.opsForValue().get((Object)("SCP:ALLOC:SETTING:" + storeCode));
            if (obj == null) {
                return new ArrayList<ScpAllocSettingItemRespVO>();
            }
            String str = (String)obj;
            ScpAllocSettingRedisDO setting = (ScpAllocSettingRedisDO)JSON.parseObject((String)str, ScpAllocSettingRedisDO.class);
            List<ScpAllocSettingRedisDO.ActivityDO> activityList = setting.getActivityList();
            for (ScpAllocSettingRedisDO.ActivityDO activityDO : activityList) {
                log.info("getEnableAllocSettingItemByStoreCode:{}", (Object)JSONUtil.toJsonStr((Object)activityDO));
                Object key = this.redisTemplate.opsForValue().get((Object)("SCP:ALLOC:SETTING:" + activityDO.getActivityId()));
                if (key == null) {
                    log.info("\u5f3a\u914d\u6d3b\u52a8ID:{}\uff0c\u7f13\u5b58\u4e0d\u5b58\u5728", (Object)activityDO.getActivityId());
                    continue;
                }
                if (LocalDateTime.now().isBefore(activityDO.getValidFrom()) || LocalDateTime.now().isAfter(activityDO.getValidTo())) {
                    log.info("\u5f3a\u914d\u6d3b\u52a8ID:{}\uff0c\u5df2\u8fc7\u671f", (Object)activityDO.getActivityId());
                    continue;
                }
                if (activityDO.getMaxNum() <= 0) {
                    log.info("\u5f3a\u914d\u6d3b\u52a8ID:{},\u6700\u5927\u5f3a\u914d\u6b21\u6570\u5c0f\u4e8e\u7b49\u4e8e0,\u4e0d\u53c2\u4e0e\u5f3a\u914d", (Object)activityDO.getActivityId());
                    continue;
                }
                List<ScpAllocSettingRedisDO.ActivityDO.InnerItemDO> innerItemDOS = activityDO.getInnerItemDOS();
                for (ScpAllocSettingRedisDO.ActivityDO.InnerItemDO innerItemDO : innerItemDOS) {
                    ScpAllocSettingItemRespVO scpAllocSettingItemRespVO = new ScpAllocSettingItemRespVO();
                    scpAllocSettingItemRespVO.setItemId(innerItemDO.getItemId());
                    scpAllocSettingItemRespVO.setItemCode(innerItemDO.getItemCode());
                    scpAllocSettingItemRespVO.setItemName(innerItemDO.getItemName());
                    scpAllocSettingItemRespVO.setMasId(innerItemDO.getMasId());
                    scpAllocSettingItemRespVO.setMinNum(innerItemDO.getMinNum());
                    scpAllocSettingItemRespVO.setActivityCode(activityDO.getActivityCode());
                    scpAllocSettingItemRespVO.setImgUrl(innerItemDO.getImgUrl());
                    respVOS.add(scpAllocSettingItemRespVO);
                }
            }
        } else {
            log.info("\u4e1a\u52a1\u7c7b\u578b\u5fc5\u987b\u662f{}\u624d\u80fd\u5f3a\u914d\uff0c\u5f53\u524d\u4e1a\u52a1\u7c7b\u578b:{}", (Object)allocBusinessType, (Object)businessType);
        }
        log.info("\u95e8\u5e97:{},\u83b7\u53d6\u6210\u529f\u7684\u5f3a\u914d:{}", (Object)storeCode, (Object)JSONUtil.toJsonStr(respVOS));
        return respVOS;
    }

    @Override
    public List<Long> findMasIdByItemId(Long itemId) {
        return this.scpAllocSettingItemRepoProc.findMasIdByItemId(itemId);
    }

    public ScpAllocSettingItemDomainServiceImpl(RedisTemplate redisTemplate, ScpAllocSettingItemRepo scpAllocSettingItemRepo, ScpAllocSettingItemRepoProc scpAllocSettingItemRepoProc, ScpDemandOrderRepoProc scpDemandOrderRepoProc) {
        this.redisTemplate = redisTemplate;
        this.scpAllocSettingItemRepo = scpAllocSettingItemRepo;
        this.scpAllocSettingItemRepoProc = scpAllocSettingItemRepoProc;
        this.scpDemandOrderRepoProc = scpDemandOrderRepoProc;
    }
}

