/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.scp.infr.repo.survey;

import com.elitescloud.boot.jpa.common.BaseRepoProc;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitescloud.cloudt.system.vo.SysUserDTO;
import com.elitesland.scp.domain.entity.survey.QSurveyDO;
import com.elitesland.scp.domain.entity.survey.QSurveyPublishDO;
import com.elitesland.scp.domain.entity.survey.SurveyDO;
import com.elitesland.scp.domain.vo.survey.SurveyPagingParam;
import com.elitesland.scp.domain.vo.survey.SurveyRespVO;
import com.elitesland.scp.enums.ScpUdcEnum;
import com.querydsl.core.types.EntityPath;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.ExpressionUtils;
import com.querydsl.core.types.Path;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.Projections;
import com.querydsl.core.types.dsl.BooleanExpression;
import com.querydsl.core.types.dsl.EntityPathBase;
import com.querydsl.core.types.dsl.Expressions;
import com.querydsl.jpa.JPAExpressions;
import com.querydsl.jpa.JPQLQuery;
import com.querydsl.jpa.impl.JPAQuery;
import com.querydsl.jpa.impl.JPAUpdateClause;
import java.time.LocalDateTime;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

@Repository
public class SurveyRepoProc
extends BaseRepoProc<SurveyDO> {
    private static final QSurveyDO surveyDO = QSurveyDO.surveyDO;
    private static final QSurveyPublishDO surveyPublishDO = QSurveyPublishDO.surveyPublishDO;

    protected SurveyRepoProc() {
        super((EntityPathBase)surveyDO);
    }

    public PagingVO<SurveyRespVO> search(SurveyPagingParam queryVO) {
        JPAQuery jpaQuery = (JPAQuery)((JPAQuery)((JPAQuery)this.select(SurveyRespVO.class).from((EntityPath)surveyDO)).where(this.where(queryVO))).orderBy(SurveyRepoProc.surveyDO.createTime.desc());
        queryVO.setPaging(jpaQuery);
        return PagingVO.builder().total(jpaQuery.fetchCount()).records(jpaQuery.fetch()).build();
    }

    private Predicate where(SurveyPagingParam param) {
        BooleanExpression predicate = Expressions.ONE.eq((Expression)Expressions.ONE);
        if (StringUtils.isNotEmpty((String)param.getSurveyTitle())) {
            predicate = ExpressionUtils.and((Predicate)predicate, (Predicate)SurveyRepoProc.surveyDO.surveyTitle.like("%" + param.getSurveyTitle() + "%"));
        }
        if (StringUtils.isNotEmpty((String)param.getSurveyStatus())) {
            predicate = ExpressionUtils.and((Predicate)predicate, (Predicate)SurveyRepoProc.surveyDO.surveyStatus.eq((Object)param.getSurveyStatus()));
        }
        if (StringUtils.isNotEmpty((String)param.getPublisherName())) {
            predicate = ExpressionUtils.and((Predicate)predicate, (Predicate)SurveyRepoProc.surveyDO.publisherName.like("%" + param.getPublisherName() + "%"));
        }
        if (param.getCreateTimeFrom() != null) {
            predicate = ExpressionUtils.and((Predicate)predicate, (Predicate)SurveyRepoProc.surveyDO.createTime.goe((Comparable)param.getCreateTimeFrom()).or((Predicate)SurveyRepoProc.surveyDO.createTime.eq((Object)param.getCreateTimeFrom())));
        }
        if (param.getCreateTimeTo() != null) {
            predicate = ExpressionUtils.and((Predicate)predicate, (Predicate)SurveyRepoProc.surveyDO.createTime.loe((Comparable)param.getCreateTimeTo()).or((Predicate)SurveyRepoProc.surveyDO.createTime.eq((Object)param.getCreateTimeTo())));
        }
        if (StringUtils.isNotEmpty((String)param.getNeedFilterValidTime()) && "Y".equals(param.getNeedFilterValidTime())) {
            predicate = ExpressionUtils.and((Predicate)predicate, (Predicate)SurveyRepoProc.surveyDO.beginTime.loe((Comparable)LocalDateTime.now()).and((Predicate)SurveyRepoProc.surveyDO.endTime.goe((Comparable)LocalDateTime.now())));
        }
        if (StringUtils.isNotEmpty((String)param.getOuCode())) {
            JPQLQuery<Integer> subQuery = this.getPublishQuery(SurveyRepoProc.surveyDO.id.eq(SurveyRepoProc.surveyPublishDO.suvId), param);
            predicate = ExpressionUtils.and((Predicate)predicate, (Predicate)subQuery.exists());
        }
        return predicate;
    }

    private JPQLQuery<Integer> getPublishQuery(BooleanExpression id, SurveyPagingParam param) {
        JPQLQuery subQuery = (JPQLQuery)JPAExpressions.selectOne().from(new EntityPath[]{surveyPublishDO}).where(new Predicate[]{id});
        if (StringUtils.isNotEmpty((String)param.getOuCode())) {
            subQuery.where(new Predicate[]{SurveyRepoProc.surveyPublishDO.ouCode.eq((Object)param.getOuCode())});
        }
        if (StringUtils.isNotEmpty((String)param.getFillStatus())) {
            subQuery.where(new Predicate[]{SurveyRepoProc.surveyPublishDO.fillStatus.eq((Object)param.getFillStatus())});
        }
        return subQuery;
    }

    private <T> JPAQuery<T> select(Class<T> cls) {
        return (JPAQuery)this.jpaQueryFactory.select((Expression)Projections.bean(cls, (Expression[])new Expression[]{SurveyRepoProc.surveyDO.id, SurveyRepoProc.surveyDO.surveyTitle, SurveyRepoProc.surveyDO.surveyDesc, SurveyRepoProc.surveyDO.beginTime, SurveyRepoProc.surveyDO.endTime, SurveyRepoProc.surveyDO.surveyStatus, SurveyRepoProc.surveyDO.publisherId, SurveyRepoProc.surveyDO.publisherName, SurveyRepoProc.surveyDO.fillCount, SurveyRepoProc.surveyDO.createTime, SurveyRepoProc.surveyDO.creator, SurveyRepoProc.surveyDO.modifyTime, SurveyRepoProc.surveyDO.updater})).from((EntityPath)surveyDO);
    }

    @Transactional
    public void updateSurveyStatus(List<Long> idList, String surveyStatus) {
        JPAUpdateClause update = this.jpaQueryFactory.update((EntityPath)surveyDO).set((Path)SurveyRepoProc.surveyDO.surveyStatus, (Object)surveyStatus).set(SurveyRepoProc.surveyDO.modifyTime, (Object)LocalDateTime.now()).where(new Predicate[]{SurveyRepoProc.surveyDO.id.in(idList)});
        update.execute();
    }

    public List<SurveyRespVO> findSurvey(SurveyPagingParam param) {
        JPAQuery jpaQuery = (JPAQuery)((JPAQuery)((JPAQuery)this.select(SurveyRespVO.class).from((EntityPath)surveyDO)).where(this.where(param))).orderBy(SurveyRepoProc.surveyDO.createTime.desc());
        return jpaQuery.fetch();
    }

    @Transactional
    public void publish(Long id, SysUserDTO userDTO) {
        JPAUpdateClause update = this.jpaQueryFactory.update((EntityPath)surveyDO).set((Path)SurveyRepoProc.surveyDO.surveyStatus, (Object)ScpUdcEnum.SURVEY_STATUS_20.getValueCode()).set(SurveyRepoProc.surveyDO.publisherId, (Object)userDTO.getId()).set((Path)SurveyRepoProc.surveyDO.publisherName, (Object)userDTO.getLastName()).set(SurveyRepoProc.surveyDO.modifyTime, (Object)LocalDateTime.now()).where(new Predicate[]{SurveyRepoProc.surveyDO.id.eq((Object)id)});
        update.execute();
    }
}

