/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.scp.application.service.authority;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import com.elitescloud.boot.auth.util.SecurityContextUtil;
import com.elitescloud.boot.core.base.UdcProvider;
import com.elitescloud.boot.exception.BusinessException;
import com.elitescloud.boot.util.JSONUtil;
import com.elitescloud.cloudt.common.annotation.SysCodeProc;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitescloud.cloudt.security.entity.GeneralUserDetails;
import com.elitesland.sale.api.vo.resp.crm.CustBaseDTO;
import com.elitesland.sale.dto.CustBaseInfoDTO;
import com.elitesland.scp.application.facade.vo.param.authority.ScpManAuthorityParam;
import com.elitesland.scp.application.facade.vo.resp.authority.ScmsmanLoginStoreRespVO;
import com.elitesland.scp.application.facade.vo.resp.authority.ScpManAuthorityBusinessTypeVO;
import com.elitesland.scp.application.facade.vo.resp.authority.ScpsmanAuthorityComponentVO;
import com.elitesland.scp.application.facade.vo.resp.setting.ScpOrderSettingRespVO;
import com.elitesland.scp.application.service.UserService;
import com.elitesland.scp.application.service.authority.ScpsmanAuthorityComponentService;
import com.elitesland.scp.application.service.authority.ScpsmanAuthorityManager;
import com.elitesland.scp.common.CurrentUserDTO;
import com.elitesland.scp.domain.entity.scpsman.ScpsmanInfoDO;
import com.elitesland.scp.domain.service.setting.ScpOrderSettingDomainService;
import com.elitesland.scp.enums.UdcEnum;
import com.elitesland.scp.infr.repo.scpsman.ScpsmanInfoRepoProc;
import com.elitesland.scp.rmi.RmiSalRpcService;
import com.elitesland.support.provider.item.service.ItemRecvAddressRpcService;
import com.elitesland.support.provider.org.dto.OrgStoreBaseRpcDTO;
import com.elitesland.support.provider.org.param.OrgStoreBaseRpcParam;
import com.elitesland.support.provider.org.service.OrgStoreRpcService;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ScpsmanAuthorityComponentImpl
implements ScpsmanAuthorityComponentService {
    private static final Logger logger = LoggerFactory.getLogger(ScpsmanAuthorityComponentImpl.class);
    @Autowired
    private ScpsmanInfoRepoProc scpsmanInfoRepoProc;
    @Autowired
    private OrgStoreRpcService orgStoreRpcService;
    @Autowired
    private UdcProvider udcProvider;
    @Autowired
    private ScpOrderSettingDomainService scpOrderSettingDomainService;
    @Autowired
    private ItemRecvAddressRpcService itemRecvAddressRpcService;
    @Autowired
    private RmiSalRpcService rmiSalRpcService;
    @Autowired
    private ScpsmanAuthorityManager scpsmanAuthorityManager;

    @Override
    @SysCodeProc
    public PagingVO<ScpsmanAuthorityComponentVO> salemansAuthorityComponentPage(ScpManAuthorityParam paramVO) {
        List<ScpsmanAuthorityComponentVO> voList = this.storeList(paramVO);
        return new PagingVO((long)voList.size(), voList);
    }

    @Override
    public List<ScpsmanAuthorityComponentVO> storeList(ScpManAuthorityParam paramVO) {
        GeneralUserDetails user = SecurityContextUtil.currentUserIfUnauthorizedThrow();
        ScpsmanInfoDO scpsmanInfo = this.scpsmanInfoRepoProc.getByScpsmanNo(user.getUsername());
        if (scpsmanInfo == null) {
            return Collections.emptyList();
        }
        Map<String, OrgStoreBaseRpcDTO> storeMap = this.scpsmanAuthorityManager.queryStoreList(user, scpsmanInfo, (Integer)ObjectUtil.defaultIfNull((Object)paramVO.getSize(), (Object)-1), paramVO.getKeyword());
        if (storeMap.isEmpty()) {
            return Collections.emptyList();
        }
        List<ScpManAuthorityBusinessTypeVO> scpsmanBusinessTypeVOS = this.queryScpManBusinessType(scpsmanInfo, paramVO.getType() == null ? null : paramVO.getType().toString());
        Map storeType2Map = this.udcProvider.getValueMapByUdcCode("yst-supp", "STORE_TYPE2");
        return storeMap.values().stream().map(t -> {
            ScpsmanAuthorityComponentVO componentVO = new ScpsmanAuthorityComponentVO();
            componentVO.setScpsmanId(scpsmanInfo.getId());
            componentVO.setScpsmanNo(scpsmanInfo.getScpsmanNo());
            componentVO.setScpsman(scpsmanInfo.getName());
            componentVO.setOuId(scpsmanInfo.getOuId());
            componentVO.setOuName(scpsmanInfo.getOuName());
            componentVO.setOuCode(scpsmanInfo.getOuCode());
            componentVO.setEnableStatus(true);
            componentVO.setEnableStatusName("\u6fc0\u6d3b");
            componentVO.setType(0);
            componentVO.setTypeName("\u95e8\u5e97");
            componentVO.setStWhId(t.getId());
            componentVO.setStWhCode(t.getStoreCode());
            componentVO.setStWhName(t.getStoreName());
            componentVO.setStoreType2(t.getStoreType2());
            componentVO.setStoreType2Name((String)storeType2Map.get(t.getStoreType2()));
            componentVO.setStCustCode(t.getCustCode());
            componentVO.setStCustName(t.getCustName());
            componentVO.setBrandCode(t.getBrandCode());
            componentVO.setStoreOuCode(t.getOuCode());
            componentVO.setDailyFlag(t.getDailyFlag());
            componentVO.setPreDailyFlag(t.getPreDailyFlag());
            if (UdcEnum.SALE_SCPSMAN_TYPE_SHOPOWNER.getValueCode().equals(scpsmanInfo.getScpsmanType())) {
                componentVO.setPasswordSetFlag((Boolean)this.orgStoreRpcService.existStorePayPassword(t.getStoreCode()).computeData() == false);
            } else {
                componentVO.setPasswordSetFlag(Boolean.FALSE);
            }
            componentVO.setScpsmanType(scpsmanInfo.getScpsmanType());
            componentVO.setBusinessTypeAuths(scpsmanBusinessTypeVOS);
            componentVO.setHasAddress(this.itemRecvAddressRpcService.hasAddress(t.getStoreCode()));
            componentVO.setProtocolAgreeStatus(t.getProtocolAgreeStatus());
            componentVO.setProtocolAgreeUserPhone(t.getProtocolAgreeUserPhone());
            componentVO.setProtocolAgreeUserName(t.getProtocolAgreeUserName());
            componentVO.setLegalName(t.getLegalName());
            componentVO.setLegalPhone(t.getLegalPhone());
            return componentVO;
        }).collect(Collectors.toList());
    }

    @Override
    public List<ScpManAuthorityBusinessTypeVO> businessTypeQuery(ScpManAuthorityParam paramVO) {
        GeneralUserDetails user = SecurityContextUtil.currentUserIfUnauthorizedThrow();
        ScpsmanInfoDO scpManInfo = this.scpsmanInfoRepoProc.getByScpsmanNo(user.getUsername());
        if (scpManInfo == null) {
            return Collections.emptyList();
        }
        return this.queryScpManBusinessType(scpManInfo, paramVO.getType() == null ? null : paramVO.getType().toString());
    }

    @Override
    public ScpsmanAuthorityComponentVO appQuery(ScpManAuthorityParam paramVO) {
        GeneralUserDetails user = SecurityContextUtil.currentUserIfUnauthorizedThrow();
        paramVO.setType(0L);
        paramVO.setSize(1);
        List<ScpsmanAuthorityComponentVO> voList = this.storeList(paramVO);
        ScpsmanAuthorityComponentVO componentVO = null;
        if (voList.isEmpty()) {
            ScpsmanInfoDO scpsmanInfo = this.scpsmanInfoRepoProc.getByScpsmanNo(user.getUsername());
            if (scpsmanInfo == null) {
                return new ScpsmanAuthorityComponentVO();
            }
            componentVO = new ScpsmanAuthorityComponentVO();
            componentVO.setScpsmanId(scpsmanInfo.getId());
            componentVO.setScpsmanNo(scpsmanInfo.getScpsmanNo());
            componentVO.setScpsman(scpsmanInfo.getName());
            componentVO.setOuId(scpsmanInfo.getOuId());
            componentVO.setOuName(scpsmanInfo.getOuName());
            componentVO.setOuCode(scpsmanInfo.getOuCode());
            componentVO.setEnableStatus(true);
            componentVO.setEnableStatusName("\u6fc0\u6d3b");
            componentVO.setType(0);
            componentVO.setTypeName("\u95e8\u5e97");
            componentVO.setPasswordSetFlag(Boolean.FALSE);
            componentVO.setScpsmanType(scpsmanInfo.getScpsmanType());
            componentVO.setBusinessTypeAuths(Collections.emptyList());
            componentVO.setHasAddress(false);
        } else {
            componentVO = voList.get(0);
            logger.info("\u3010appQuery\u3011\u83b7\u53d6\u5f53\u524d\u767b\u5f55\u8d26\u53f7\u5bf9\u5e94\u7684\u8ba1\u5212\u5458\u6743\u9650\u6240\u5c5e\u95e8\u5e97\u7ed3\u679c\uff1a{}", (Object)cn.hutool.json.JSONUtil.toJsonStr((Object)componentVO));
            if (UdcEnum.SALE_SCPSMAN_TYPE_SHOPOWNER.getValueCode().equals(componentVO.getScpsmanType())) {
                if (((Boolean)this.orgStoreRpcService.existStorePayPassword(componentVO.getStWhCode()).computeData()).booleanValue()) {
                    componentVO.setPasswordSetFlag(Boolean.FALSE);
                } else {
                    componentVO.setPasswordSetFlag(Boolean.TRUE);
                }
            } else {
                componentVO.setPasswordSetFlag(Boolean.FALSE);
            }
            this.storeTypeQuery(componentVO);
        }
        return componentVO;
    }

    @Override
    public List<String> loginAndTypeQuery(ScpManAuthorityParam paramVO) {
        GeneralUserDetails user = SecurityContextUtil.currentUserIfUnauthorizedThrow();
        ScpsmanInfoDO scpsmanInfo = this.scpsmanInfoRepoProc.getByScpsmanNo(user.getUsername());
        if (scpsmanInfo == null) {
            return Collections.emptyList();
        }
        Map<String, OrgStoreBaseRpcDTO> storeMap = this.scpsmanAuthorityManager.queryStoreList(user, scpsmanInfo, -1);
        return new ArrayList<String>(storeMap.keySet());
    }

    @Override
    public ApiResult<ScmsmanLoginStoreRespVO> getLoginStoreByCurrentUser() {
        CurrentUserDTO currentUser = UserService.currentUser();
        if (ObjectUtil.isEmpty((Object)currentUser)) {
            throw new BusinessException("\u5f53\u524d\u767b\u5f55\u4eba\u67e5\u8be2\u5f02\u5e38");
        }
        ScmsmanLoginStoreRespVO respVO = new ScmsmanLoginStoreRespVO();
        respVO.setOnlyOne(false);
        GeneralUserDetails userDetails = SecurityContextUtil.currentUserIfUnauthorizedThrow();
        List<String> userNames = this.getCandidateStoreCodeByUser(userDetails);
        if (userNames.isEmpty()) {
            return ApiResult.ok((Object)respVO);
        }
        logger.info("\u67e5\u8be2\u95e8\u5e97\uff1a{}", (Object)JSONUtil.toJsonString(userNames));
        OrgStoreBaseRpcParam storeParam = new OrgStoreBaseRpcParam();
        storeParam.setStoreCodeList(userNames);
        List storeList = (List)this.orgStoreRpcService.findSimpleStoreByParam(storeParam).computeData();
        if (CollUtil.isEmpty((Collection)storeList)) {
            return ApiResult.ok((Object)respVO);
        }
        respVO.setStoreCodeDef(((OrgStoreBaseRpcDTO)storeList.get(0)).getStoreCode());
        respVO.setOnlyOne(true);
        return ApiResult.ok((Object)respVO);
    }

    private void storeTypeQuery(ScpsmanAuthorityComponentVO scpsmanAuthorityComponentVO) {
        List<CustBaseDTO> custBaseInfoDTOList;
        if (Objects.isNull(scpsmanAuthorityComponentVO)) {
            return;
        }
        if (StringUtils.isNotBlank((CharSequence)scpsmanAuthorityComponentVO.getStCustCode()) && CollectionUtil.isNotEmpty(custBaseInfoDTOList = this.rmiSalRpcService.findBaseByParam(Collections.singletonList(scpsmanAuthorityComponentVO.getStCustCode())))) {
            List<CustBaseInfoDTO> custBaseInfoDTOS;
            CustBaseDTO custBaseInfoDTO = custBaseInfoDTOList.get(0);
            scpsmanAuthorityComponentVO.setStoreCustCode(custBaseInfoDTO.getPreCustCode());
            if (StringUtils.isNotBlank((CharSequence)scpsmanAuthorityComponentVO.getStoreCustCode()) && CollectionUtil.isNotEmpty(custBaseInfoDTOS = this.rmiSalRpcService.getCustBaseInfoByCode(Collections.singletonList(scpsmanAuthorityComponentVO.getStoreCustCode())))) {
                CustBaseInfoDTO custBaseInfoDTO1 = custBaseInfoDTOS.get(0);
                scpsmanAuthorityComponentVO.setStoreCustName(custBaseInfoDTO1.getCustName());
                if (Objects.equals(custBaseInfoDTO1.getCustType2(), "A")) {
                    scpsmanAuthorityComponentVO.setStoreCustType2Flag(true);
                }
            }
        }
    }

    private List<ScpManAuthorityBusinessTypeVO> queryScpManBusinessType(ScpsmanInfoDO scpsmanInfoDO, String type) {
        String businessTypes = scpsmanInfoDO.getBusinessType();
        if (StrUtil.isBlank((CharSequence)businessTypes)) {
            return Collections.emptyList();
        }
        ArrayList<ScpManAuthorityBusinessTypeVO> scpManAuthorityBusinessTypeVOS = new ArrayList<ScpManAuthorityBusinessTypeVO>();
        Map businessTypeUDCMap = this.udcProvider.getValueMapByUdcCode("yst-suplan", "BUSINESS_TYPE");
        List<String> businessTypeList = Arrays.stream(businessTypes.split(",")).toList();
        for (String businessType : businessTypeList) {
            ScpOrderSettingRespVO cacheByBusinessType = this.scpOrderSettingDomainService.findCacheByBusinessType(businessType, type);
            ScpManAuthorityBusinessTypeVO scpManAuthorityBusinessTypeVO = new ScpManAuthorityBusinessTypeVO();
            scpManAuthorityBusinessTypeVO.setBusinessType(businessType);
            scpManAuthorityBusinessTypeVO.setBusinessTypeName((String)businessTypeUDCMap.get(businessType));
            scpManAuthorityBusinessTypeVO.setAllowDiscount(cacheByBusinessType.getAllowDiscount());
            scpManAuthorityBusinessTypeVOS.add(scpManAuthorityBusinessTypeVO);
        }
        return scpManAuthorityBusinessTypeVOS;
    }

    private List<String> getCandidateStoreCodeByUser(GeneralUserDetails userDetails) {
        ArrayList<String> userNames = new ArrayList<String>(4);
        String loginAccount = userDetails.getLoginAccount();
        if (StrUtil.isNotBlank((CharSequence)loginAccount)) {
            if (loginAccount.equals(userDetails.getUser().getMobile())) {
                return Collections.emptyList();
            }
            userNames.add(loginAccount);
        }
        if (StrUtil.isNotBlank((CharSequence)userDetails.getUser().getEmployeeCode())) {
            userNames.add(userDetails.getUser().getEmployeeCode());
        }
        return userNames;
    }
}

