/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.scp.application.web.survey;

import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.scp.domain.service.survey.SurveyService;
import com.elitesland.scp.domain.vo.survey.SurveyAnalysisRespVO;
import com.elitesland.scp.domain.vo.survey.SurveyAnswerRespVO;
import com.elitesland.scp.domain.vo.survey.SurveyAnswerSaveParam;
import com.elitesland.scp.domain.vo.survey.SurveyPagingParam;
import com.elitesland.scp.domain.vo.survey.SurveyPublishParam;
import com.elitesland.scp.domain.vo.survey.SurveyRespVO;
import com.elitesland.scp.domain.vo.survey.SurveySaveParam;
import com.github.xiaoymin.knife4j.annotations.ApiOperationSupport;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/survey/manage"}, produces={"application/json"})
@Api(tags={"\u95ee\u5377\u7ba1\u7406"})
public class SurveyController {
    private static final Logger log = LoggerFactory.getLogger(SurveyController.class);
    private final SurveyService surveyService;

    @PostMapping(value={"search"})
    @ApiOperation(value="\u5206\u9875\u5217\u8868")
    @ApiOperationSupport(order=1)
    public ApiResult<PagingVO<SurveyRespVO>> search(@RequestBody SurveyPagingParam searchParam) {
        return ApiResult.ok(this.surveyService.search(searchParam));
    }

    @PostMapping(value={"save"})
    @ApiOperation(value="\u7f16\u8f91\u4fdd\u5b58")
    @ApiOperationSupport(order=2)
    public ApiResult<Long> surveySave(@RequestBody @Validated SurveySaveParam saveVO) {
        return ApiResult.ok((Object)this.surveyService.saveOrUpdate(saveVO));
    }

    @PostMapping(value={"cancel"})
    @ApiOperation(value="\u4f5c\u5e9f")
    @ApiOperationSupport(order=3)
    public ApiResult<Long> cancel(@RequestBody List<Long> idList) {
        this.surveyService.cancel(idList);
        return ApiResult.ok();
    }

    @PostMapping(value={"/publish"})
    @ApiOperation(value="\u53d1\u5e03")
    @ApiOperationSupport(order=4)
    public ApiResult<Integer> publish(@RequestBody SurveyPublishParam param) {
        try {
            return ApiResult.ok((Object)this.surveyService.publish(param));
        }
        catch (Exception e) {
            return ApiResult.fail((String)e.getMessage());
        }
    }

    @PostMapping(value={"/get/{id}"})
    @ApiOperation(value="\u8be6\u60c5")
    @ApiOperationSupport(order=5)
    public ApiResult<SurveyRespVO> get(@PathVariable Long id) {
        try {
            return ApiResult.ok((Object)this.surveyService.get(id));
        }
        catch (Exception e) {
            return ApiResult.fail((String)e.getMessage());
        }
    }

    @PostMapping(value={"/findSurvey"})
    @ApiOperation(value="\u67e5\u8be2\u5f53\u524d\u7528\u6237\u662f\u5426\u6709\u95ee\u5377\u9700\u8981\u586b\u5199")
    @ApiOperationSupport(order=6)
    public ApiResult<SurveyRespVO> findSurvey() {
        try {
            return ApiResult.ok((Object)this.surveyService.findSurvey());
        }
        catch (Exception e) {
            return ApiResult.fail((String)e.getMessage());
        }
    }

    @PostMapping(value={"/fillSurvey"})
    @ApiOperation(value="\u586b\u5199\u95ee\u5377")
    @ApiOperationSupport(order=7)
    public ApiResult<Object> fillSurvey(@RequestBody List<SurveyAnswerSaveParam> saveParamList) {
        try {
            this.surveyService.fillSurvey(saveParamList);
            return ApiResult.ok();
        }
        catch (Exception e) {
            return ApiResult.fail((String)e.getMessage());
        }
    }

    @PostMapping(value={"/fillDetail/{id}"})
    @ApiOperation(value="\u95ee\u5377\u586b\u5199\u7edf\u8ba1\u8be6\u60c5")
    @ApiOperationSupport(order=8)
    public ApiResult<SurveyRespVO> fillDetail(@PathVariable Long id) {
        try {
            return ApiResult.ok((Object)this.surveyService.fillDetail(id));
        }
        catch (Exception e) {
            return ApiResult.fail((String)e.getMessage());
        }
    }

    @PostMapping(value={"/fillDetailList"})
    @ApiOperation(value="\u95ee\u5377\u586b\u5199\u7edf\u8ba1\u5217\u8868")
    @ApiOperationSupport(order=9)
    public ApiResult<PagingVO<SurveyAnswerRespVO>> fillDetailList(@RequestBody SurveyPagingParam param) {
        try {
            return ApiResult.ok(this.surveyService.fillDetailList(param));
        }
        catch (Exception e) {
            return ApiResult.fail((String)e.getMessage());
        }
    }

    @PostMapping(value={"/surveyAnalysis/{id}"})
    @ApiOperation(value="\u95ee\u5377\u56fe\u8868\u5206\u6790")
    @ApiOperationSupport(order=10)
    public ApiResult<List<SurveyAnalysisRespVO>> surveyAnalysis(@PathVariable Long id) {
        try {
            return ApiResult.ok(this.surveyService.surveyAnalysis(id));
        }
        catch (Exception e) {
            return ApiResult.fail((String)e.getMessage());
        }
    }

    public SurveyController(SurveyService surveyService) {
        this.surveyService = surveyService;
    }
}

