package com.elitesland.scp.application.service.authority;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.text.CharSequenceUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.json.JSONUtil;
import com.elitescloud.boot.common.param.IdCodeNameParam;
import com.elitescloud.boot.constant.Gender;
import com.elitescloud.boot.exception.BusinessException;
import com.elitescloud.boot.util.DatetimeUtil;
import com.elitescloud.cloudt.common.base.ApiCode;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitescloud.cloudt.system.constant.OrgType;
import com.elitescloud.cloudt.system.dto.SysEmployeeDetailDTO;
import com.elitescloud.cloudt.system.dto.SysOrgBasicDTO;
import com.elitescloud.cloudt.system.dto.SysUserBasicDTO;
import com.elitescloud.cloudt.system.dto.req.UserQueryDTO;
import com.elitescloud.cloudt.system.provider.org.EmployeeRpcService;
import com.elitescloud.cloudt.system.provider.org.OrgRpcService;
import com.elitescloud.cloudt.system.provider.org.UserRpcService;
import com.elitesland.inv.dto.invwh.InvWhRpcDTO;
import com.elitesland.inv.dto.invwh.InvWhRpcDtoParam;
import com.elitesland.scp.application.facade.vo.param.authority.*;
import com.elitesland.scp.application.facade.vo.resp.authority.ScpManAuthorityPageRespVO;
import com.elitesland.scp.application.facade.vo.resp.authority.ScpsmanAuthorityDRespVO;
import com.elitesland.scp.application.facade.vo.resp.authority.ScpsmanAuthorityRespVO;
import com.elitesland.scp.application.facade.vo.save.authority.ScpManAuthorityDSaveVO;
import com.elitesland.scp.application.facade.vo.save.authority.ScpManAuthoritySaveVO;
import com.elitesland.scp.application.facade.vo.scpsman.SalesmanInfoSaveVO;
import com.elitesland.scp.application.service.scpsman.ScpsmanInfoService;
import com.elitesland.scp.application.service.scpsman.ScpsmanInfoServiceImpl;
import com.elitesland.scp.domain.convert.authority.ScpDemandAuthorityConvert;
import com.elitesland.scp.domain.convert.authority.ScpDemandAuthorityDConvert;
import com.elitesland.scp.domain.entity.authority.ScpsmanAuthorityDDO;
import com.elitesland.scp.domain.entity.authority.ScpsmanAuthorityDO;
import com.elitesland.scp.domain.entity.scpsman.ScpsmanInfoDO;
import com.elitesland.scp.domain.service.authority.ScpDemandAuthorityDService;
import com.elitesland.scp.domain.service.authority.ScpDemandAuthorityService;
import com.elitesland.scp.enums.ScpUdcEnum;
import com.elitesland.scp.infr.repo.authority.ScpDemandAuthorityDRepo;
import com.elitesland.scp.infr.repo.authority.ScpDemandAuthorityDRepoProc;
import com.elitesland.scp.infr.repo.authority.ScpDemandAuthorityRepo;
import com.elitesland.scp.infr.repo.authority.ScpDemandAuthorityRepoProc;
import com.elitesland.scp.infr.repo.scpsman.ScpsmanInfoRepo;
import com.elitesland.scp.infr.repo.scpsman.ScpsmanInfoRepoProc;
import com.elitesland.scp.rmi.RmiInvStkRpcService;
import com.elitesland.scp.rmi.RmiOrgStoreRpcService;
import com.elitesland.scp.utils.DateTimeUtil;
import com.elitesland.support.provider.org.dto.OrgOuRpcSimpleDTO;
import com.elitesland.support.provider.org.dto.OrgRegionDTO;
import com.elitesland.support.provider.org.dto.OrgStoreBaseRpcDTO;
import com.elitesland.support.provider.org.dto.OrgStoreRpcDTO;
import com.elitesland.support.provider.org.param.OrgRegionQueryDTO;
import com.elitesland.support.provider.org.param.OrgStoreRpcParam;
import com.elitesland.support.provider.org.service.OrgOuRpcService;
import com.elitesland.support.provider.org.service.OrgRegionRpcService;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.core.task.TaskExecutor;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

import java.util.*;
import java.util.function.Function;
import java.util.stream.Collectors;

@Slf4j
@Service
@RequiredArgsConstructor
public class ScpsmanAuthprityServiceImpl implements ScpsmanAuthorityService {

    private final ScpDemandAuthorityService scpDemandAuthorityService;
    private final ScpDemandAuthorityRepo scpDemandAuthorityRepo;
    private final ScpDemandAuthorityRepoProc scpDemandAuthorityRepoProc;
    private final ScpDemandAuthorityDService scpDemandAuthorityDService;
    private final ScpsmanInfoRepo scpsmanInfoRepo;
    private final ScpsmanInfoRepoProc scpsmanInfoRepoProc;
    private final RmiInvStkRpcService rmiInvStkRpcService;
    private final RmiOrgStoreRpcService rmiOrgStoreRpcService;
    private final ScpDemandAuthorityDRepo scpDemandAuthorityDRepo;
    private final ScpDemandAuthorityDRepoProc scpDemandAuthorityDRepoProc;
    private final ScpsmanInfoService scpsmanInfoService;
    private final EmployeeRpcService employeeRpcService;
    private final UserRpcService userRpcService;
    private final OrgRegionRpcService orgRegionRpcService;
    private final OrgRpcService orgRpcService;
    private final OrgOuRpcService orgOuRpcService;
    private final TaskExecutor taskExecutor;

    /**
     * 分页查询专用
     *
     * @param paramVO
     * @return
     */
    @Override
    public PagingVO<ScpManAuthorityPageRespVO> queryAuthorit(ScpManAuthorityParam paramVO) {
        // 手机号筛选
        if (StringUtils.hasText(paramVO.getMobile())) {
            UserQueryDTO userQueryDTO = new UserQueryDTO();
            userQueryDTO.setMobiles(Set.of(paramVO.getMobile()));
            ApiResult<List<SysUserBasicDTO>> userResult = userRpcService.queryUser(userQueryDTO);
            if (userResult.isSuccess() && CollectionUtil.isNotEmpty(userResult.getData())) {
                paramVO.setLoginAccounts(List.of(userResult.getData().get(0).getUsername()));
            } else {
                return PagingVO.<ScpManAuthorityPageRespVO>builder().total(0).records(null).build();
            }
        }

        PagingVO<ScpManAuthorityPageRespVO> scpManAuthorityPageRespVOPagingVO =
                scpDemandAuthorityService.queryAuthorit(paramVO);
        if (CollectionUtil.isNotEmpty(scpManAuthorityPageRespVOPagingVO.getRecords())) {
            List<ScpManAuthorityPageRespVO> records = scpManAuthorityPageRespVOPagingVO.getRecords();

            Map<String, List<SysUserBasicDTO>> userMap = new HashMap<>();
            Set<String> loginAccounts = records.stream().map(ScpManAuthorityPageRespVO::getLoginAccount).filter(StringUtils::hasText).distinct().collect(Collectors.toSet());
            UserQueryDTO userQueryDTO = new UserQueryDTO();
            userQueryDTO.setUsernames(loginAccounts);
            ApiResult<List<SysUserBasicDTO>> userResult = userRpcService.queryUser(userQueryDTO);
            if (userResult.isSuccess() && CollectionUtil.isNotEmpty(userResult.getData())) {
                userMap = userResult.getData().stream().collect(Collectors.groupingBy(SysUserBasicDTO::getUsername));
            }
            for (ScpManAuthorityPageRespVO t : records) {
                t.setEnableStatusName(ObjectUtil.equal(t.getEnableStatus(), null) ? null : (t.getEnableStatus() ? "启用" :
                        "禁用"));

                if (userMap.containsKey(t.getLoginAccount())) {
                    t.setMobile(userMap.get(t.getLoginAccount()).get(0).getMobile());
                }
            }
        }

        return scpManAuthorityPageRespVOPagingVO;
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public void changeStatus(ScpManAuthorityStatusParamVO paramVO) {
        if (CollectionUtil.isEmpty(paramVO.getIds())) {
            throw new BusinessException(ApiCode.PARAMETER_EXCEPTION, "计划员权限ID集合不能为空");
        }
        scpDemandAuthorityService.changeStatus(paramVO.getIds(), paramVO.getStatus());
    }

    @Override
    public void region(ScpManAuthorityRegionParamVO paramVO) {
        //仓库
        if ("1".equals(paramVO.getType())) {
            InvWhRpcDtoParam param = new InvWhRpcDtoParam();
            param.setRegion(paramVO.getRegion());
            List<InvWhRpcDTO> invWhRpcDTOS = rmiInvStkRpcService.findWhDTOByParam(param).computeData();
            log.info("按区域获取仓库信息:{}", JSONUtil.toJsonStr(invWhRpcDTOS));
            List<ScpsmanAuthorityDDO> data = invWhRpcDTOS.stream().map(e -> {
                ScpsmanAuthorityDDO scpsmanAuthorityDDO = new ScpsmanAuthorityDDO();
                scpsmanAuthorityDDO.setMasId(paramVO.getMasId());
                scpsmanAuthorityDDO.setStWhId(e.getWhId());
                scpsmanAuthorityDDO.setStWhCode(e.getWhCode());
                scpsmanAuthorityDDO.setStWhName(e.getWhName());
                scpsmanAuthorityDDO.setType(1);
                scpsmanAuthorityDDO.setRegion(paramVO.getRegion());
                scpsmanAuthorityDDO.setAuthSource(CharSequenceUtil.blankToDefault(paramVO.getAuthSource(), ScpUdcEnum.SCPSMAN_AUTH_SOURCE_MANUAL.getValueCode()));
                return scpsmanAuthorityDDO;
            }).collect(Collectors.toList());
            log.info("按区域获取仓库信息2:{}", JSONUtil.toJsonStr(data));
            if (CollUtil.isNotEmpty(data)) {
                List<ScpsmanAuthorityDDO> filterExisting = filterExisting(data, paramVO.getMasId());
                log.info("按区域获取仓库信息3,过滤后:{}", JSONUtil.toJsonStr(filterExisting));
                scpDemandAuthorityDRepo.saveAll(filterExisting);
            }

        } else if ("0".equals(paramVO.getType())) { //门店
            List<OrgStoreBaseRpcDTO> orgStoreBaseByRegion =
                    rmiOrgStoreRpcService.findOrgStoreBaseByRegion(Arrays.asList(paramVO.getRegion()));
            log.info("按区域获取门店信息:{}", JSONUtil.toJsonStr(orgStoreBaseByRegion));
            List<ScpsmanAuthorityDDO> data = orgStoreBaseByRegion.stream().map(e -> {
                ScpsmanAuthorityDDO scpsmanAuthorityDDO = new ScpsmanAuthorityDDO();
                scpsmanAuthorityDDO.setMasId(paramVO.getMasId());
                scpsmanAuthorityDDO.setStWhId(e.getId());
                scpsmanAuthorityDDO.setStWhCode(e.getStoreCode());
                scpsmanAuthorityDDO.setStWhName(e.getStoreName());
                scpsmanAuthorityDDO.setType(0);
                scpsmanAuthorityDDO.setRegion(paramVO.getRegion());
                scpsmanAuthorityDDO.setAuthSource(CharSequenceUtil.blankToDefault(paramVO.getAuthSource(), ScpUdcEnum.SCPSMAN_AUTH_SOURCE_MANUAL.getValueCode()));
                return scpsmanAuthorityDDO;
            }).collect(Collectors.toList());
            log.info("按区域获取门店信息2:{}", JSONUtil.toJsonStr(data));
            if (CollUtil.isNotEmpty(data)) {
                List<ScpsmanAuthorityDDO> filterExisting = filterExisting(data, paramVO.getMasId());
                log.info("按区域获取门店信息3,过滤后:{}", JSONUtil.toJsonStr(filterExisting));

                scpDemandAuthorityDRepo.saveAll(filterExisting);
            }
        }


    }


    //过滤掉已经存在的门店/仓库数据
    private List<ScpsmanAuthorityDDO> filterExisting(List<ScpsmanAuthorityDDO> data, Long masId) {
        List<ScpsmanAuthorityDRespVO> existedAll = scpDemandAuthorityDRepoProc.findbyMasId(masId);
        List<String> existedStWhCodeAll = existedAll.stream().map(e -> e.getStWhCode()).collect(Collectors.toList());
        List<ScpsmanAuthorityDDO> filterData =
                data.stream().filter(e -> !existedStWhCodeAll.contains(e.getStWhCode())).collect(Collectors.toList());
        return filterData;
    }

    @Override
    public void saveWhStore(ScpManAuthorityWhStoreParamVO paramVO) {
        ScpsmanAuthorityDDO scpsmanAuthorityDDO = new ScpsmanAuthorityDDO();
        scpsmanAuthorityDDO.setMasId(paramVO.getMasId());
        scpsmanAuthorityDDO.setStWhId(paramVO.getStWhId());
        scpsmanAuthorityDDO.setStWhCode(paramVO.getStWhCode());
        scpsmanAuthorityDDO.setStWhName(paramVO.getStWhName());
        scpsmanAuthorityDDO.setType(paramVO.getType());
        scpsmanAuthorityDDO.setRegion(paramVO.getRegion());
        scpsmanAuthorityDDO.setAuthSource(CharSequenceUtil.blankToDefault(paramVO.getAuthSource(), ScpUdcEnum.SCPSMAN_AUTH_SOURCE_MANUAL.getValueCode()));
        scpDemandAuthorityDRepo.save(scpsmanAuthorityDDO);
    }

    /**
     * 物理删除
     *
     * @param ids
     */
    @Override
    public void deleteByIds(List<Long> ids) {
        if (CollectionUtil.isEmpty(ids)) {
            throw new BusinessException(ApiCode.PARAMETER_EXCEPTION, "计划员权限ID集合不能为空");
        }
        //1.先删除明细
        scpDemandAuthorityDService.deleteByIds(ids);
        //2.删除主表
        scpDemandAuthorityService.deleteByIds(ids);
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public void deleteByDIds(List<Long> ids) {
        if (CollectionUtil.isEmpty(ids)) {
            throw new BusinessException(ApiCode.PARAMETER_EXCEPTION, "ID集合不能为空");
        }
        scpDemandAuthorityDService.deleteByDIds(ids);
    }

    @Override
    public Optional<ScpsmanAuthorityRespVO> findIdOne(Long id) {
        Optional<ScpsmanAuthorityRespVO> scpManAuthorityRespVO =
                scpDemandAuthorityRepo.findById(id).map(ScpDemandAuthorityConvert.INSTANCE::doToVO);
        if (scpManAuthorityRespVO.isPresent()) {
            List<ScpsmanAuthorityDRespVO> scpsmanAuthorityDRespVOS = scpDemandAuthorityDService.findbyMasId(id);
            ScpsmanAuthorityRespVO respVO = scpManAuthorityRespVO.get();
            respVO.setScpsmanAuthorityDRespVOList(scpsmanAuthorityDRespVOS);
        }
        //计划员,数据补充
        this.translate(scpManAuthorityRespVO.get());
        return scpManAuthorityRespVO;
    }

    /**
     * 1.修改数据与数据库数据重复报错提示
     * 2.新增数据在数据库已存在报错
     *
     * @param saveVO
     * @return
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    public Long saveScpAuthority(ScpManAuthoritySaveVO saveVO) {
        log.info("保存计划员权限入参:{}", JSONUtil.toJsonStr(saveVO));
        List<ScpManAuthorityDSaveVO> scpManAuthorityDSaveVOS = saveVO.getScpManAuthorityDSaveVOS();
        log.info("过滤前:{}", JSONUtil.toJsonStr(scpManAuthorityDSaveVOS));
        List<ScpManAuthorityDSaveVO> distinctScpManAuthorityDSaveVOS = scpManAuthorityDSaveVOS.stream()
                .collect(Collectors.collectingAndThen(
                        Collectors.toMap(ScpManAuthorityDSaveVO::getStWhCode, vo -> vo,
                                (existing, replacement) -> existing),
                        map -> new ArrayList<>(map.values())
                ));
        log.info("过滤后:{}", JSONUtil.toJsonStr(distinctScpManAuthorityDSaveVOS));
        saveVO.setScpManAuthorityDSaveVOS(distinctScpManAuthorityDSaveVOS);

        Long masId = saveVO.getId();
        //1.id存在就是修改,全删全插
        Map<String, ScpsmanAuthorityDDO> authorityDDOMap = masId == null ? Collections.emptyMap() :
                scpDemandAuthorityDRepoProc.listByMasId(masId).stream()
                        .collect(Collectors.toMap(t -> t.getType() + ":" + t.getStWhId(), Function.identity(), (t1, t2) -> t1));

        if (masId != null) {
            scpDemandAuthorityDService.deleteByIds(Arrays.asList(masId));
        } else {
            //2.要求只能有一个计划员，新增时校验当前计划员是否存在
            if (scpDemandAuthorityService.existsByscpsmanNo(saveVO)) {
                throw new BusinessException("当前计划员已经存在，不允许新增");
            }
        }

        //检查新增数据是否重复
        this.checkMessage(saveVO);
        ScpsmanAuthorityDO scpsmanAuthorityDO = ScpDemandAuthorityConvert.INSTANCE.voToDo(saveVO);
        Long aLong = scpDemandAuthorityService.saveScpManAuthority(scpsmanAuthorityDO);
        if (CollectionUtil.isNotEmpty(saveVO.getScpManAuthorityDSaveVOS())) {
            List<ScpsmanAuthorityDDO> collect = saveVO.getScpManAuthorityDSaveVOS().stream().map(t -> {
                t.setMasId(aLong);

                // 权限来源
                if (CharSequenceUtil.isBlank(t.getAuthSource())) {
                    t.setAuthSource(ScpUdcEnum.SCPSMAN_AUTH_SOURCE_MANUAL.getValueCode());
                }

                var doo = ScpDemandAuthorityDConvert.INSTANCE.voToDo(t);
                doo.setId(null);

                // 修改前的数据
                var oldData = authorityDDOMap.get(t.getType() + ":" + t.getStWhId());
                if (oldData != null) {
                    doo.setAuthSourceId(oldData.getAuthSourceId());
                }
                return doo;
            }).collect(Collectors.toList());
            scpDemandAuthorityDService.saveScpManAuthority(collect);
        }

        return aLong;
    }

    @Override
    public List<ScpManAuthorityPageRespVO> findByScpsmanNoIn(List<String> scpsmanNoList) {
        List<ScpManAuthorityPageRespVO> byScpsmanNoIn = scpDemandAuthorityService.findByScpsmanNoIn(scpsmanNoList);
        byScpsmanNoIn.stream().forEach(t -> {
            t.setEnableStatusName(ObjectUtil.equal(t.getEnableStatus(), null) ? null : (t.getEnableStatus() ? "启用" : "禁用"));
        });
        return byScpsmanNoIn;
    }

    @Override
    public ApiResult<Boolean> createdByEmployee(String employeeCode) {
        if (CharSequenceUtil.isBlank(employeeCode)) {
            return ApiResult.fail("员工编码为空");
        }

        taskExecutor.execute(() -> {
            updateForEmployee(employeeCode);
        });
        return ApiResult.ok(true);
    }

    @Override
    public ApiResult<PagingVO<ScpsmanAuthorityDRespVO>> pageQuery(ScpsmanAuthorityDPageQueryParam queryParam) {
        return null;
    }

    private void updateForEmployee(String employeeCode) {
        // 获取员工信息
        var employee = employeeRpcService.getDetailByCode(employeeCode).computeData();
        if (employee == null) {
            log.error("员工不存在：{}", employeeCode);
            return;
        }
        // 员工组织
        Set<String> orgCodes = CollUtil.isEmpty(employee.getOrgList()) ? Collections.emptySet() :
                employee.getOrgList().stream().map(SysEmployeeDetailDTO.EmployeeOrg::getOrgCode).filter(StringUtils::hasText).collect(Collectors.toSet());

        Set<Long> orgIds = CollUtil.isEmpty(employee.getOrgList()) ? Collections.emptySet() :
                employee.getOrgList().stream().map(SysEmployeeDetailDTO.EmployeeOrg::getOrgId).filter(Objects::nonNull).collect(Collectors.toSet());

        // 员工所属计划员
        var scpsmanId = scpsmanInfoRepoProc.getIdByCode(employeeCode);
        Long scpsmanAuthorityId = scpsmanId == null ? null : scpDemandAuthorityRepoProc.getIdByScpsManId(scpsmanId);

        // 员工组织的区域的门店
        List<OrgStoreBaseRpcDTO> orgStoreListOfRegion = null;
        // 获取员工的所属区域
        var regionMap = queryRegionByOrg(orgCodes);
        if (regionMap.isEmpty()) {
            // 员工不是计划员，移除相关权限
            if (scpsmanAuthorityId != null) {
                scpDemandAuthorityDRepoProc.deleteByAuthSource(scpsmanAuthorityId, ScpUdcEnum.SCPSMAN_AUTH_SOURCE_EMP_REGION.getValueCode(), Set.of(employeeCode));
            }
        } else {
            // 根据区域查询门店
            orgStoreListOfRegion = this.queryOrgStoreByRegion(regionMap);
        }

        // 员工组织的门店
        List<OrgStoreBaseRpcDTO> orgStoreListOfOrg = this.queryOrgStoreByOrg(orgIds);
        if (CollUtil.isEmpty(orgStoreListOfOrg)) {
            // 员工不是计划员，移除相关权限
            if (scpsmanAuthorityId != null) {
                scpDemandAuthorityDRepoProc.deleteByAuthSource(scpsmanAuthorityId, ScpUdcEnum.SCPSMAN_AUTH_SOURCE_EMP_STORE.getValueCode(), Set.of(employeeCode));
            }
        }

        if (CollUtil.isEmpty(orgStoreListOfRegion) && CollUtil.isEmpty(orgStoreListOfOrg)) {
            // 既没区域也没门店
            if (scpsmanAuthorityId != null) {
                // 判断是否还有权限明细，没有的话删除权限和计划员
                var numOfAuthority = scpDemandAuthorityDRepoProc.countByMasId(scpsmanAuthorityId);
                if (numOfAuthority == 0) {
                    scpDemandAuthorityRepoProc.delete(scpsmanAuthorityId);
                    scpsmanInfoRepoProc.delete(scpsmanId);
                    userRpcService.removeUserType(employee.getUserId(), ScpsmanInfoServiceImpl.SCPSMAN, scpsmanId.toString());
                }
            }
            return;
        }

        // 判断是否为计划员
        if (scpsmanId == null) {
            // 自动创建计划员和权限
            scpsmanId = this.createScpsmanInfo(employee, orgCodes);
        }
        scpsmanAuthorityId = this.getOrCreateScpsmanAuthority(scpsmanId);

        // 更新区域的门店的权限
        if (CollUtil.isNotEmpty(orgStoreListOfRegion)) {
            updateByStoreOfEmployee(ScpUdcEnum.SCPSMAN_AUTH_SOURCE_EMP_REGION, scpsmanAuthorityId, employee, orgStoreListOfRegion);
        }
        // 更新组织的门店的权限
        if (CollUtil.isNotEmpty(orgStoreListOfOrg)) {
            updateByStoreOfEmployee(ScpUdcEnum.SCPSMAN_AUTH_SOURCE_EMP_STORE, scpsmanAuthorityId, employee, orgStoreListOfOrg);
        }
    }

    private void updateByStoreOfEmployee(ScpUdcEnum authSource, long scpsmanAuthorityId,
                                         SysEmployeeDetailDTO employee, List<OrgStoreBaseRpcDTO> orgStoreList) {
        var authSourceId = employee.getCode();
        var currentAuthorityIds = scpDemandAuthorityDRepoProc.getStWhIdListByMasId(scpsmanAuthorityId, 0);

        // 先删除现有的
        if (!currentAuthorityIds.isEmpty()) {
            scpDemandAuthorityDRepoProc.deleteByAuthSource(scpsmanAuthorityId, authSource.getValueCode(), Set.of(authSourceId));
        }

        var authorityList = orgStoreList.stream()
                .map(t -> {
                    ScpsmanAuthorityDDO scpsmanAuthorityDDO = new ScpsmanAuthorityDDO();
                    scpsmanAuthorityDDO.setMasId(scpsmanAuthorityId);
                    scpsmanAuthorityDDO.setStWhId(t.getId());
                    scpsmanAuthorityDDO.setStWhCode(t.getStoreCode());
                    scpsmanAuthorityDDO.setStWhName(t.getStoreName());
                    scpsmanAuthorityDDO.setType(0);
                    scpsmanAuthorityDDO.setRegion(t.getRegion());
                    scpsmanAuthorityDDO.setAuthSource(authSource.getValueCode());
                    scpsmanAuthorityDDO.setAuthSourceId(authSourceId);

                    return scpsmanAuthorityDDO;
                }).collect(Collectors.toList());
        if (!authorityList.isEmpty()) {
            scpDemandAuthorityDRepoProc.save(authorityList);
        }
    }

    private Map<String, SysOrgBasicDTO> filterCompanyOfEmployee(SysEmployeeDetailDTO employee) {
        if (CollUtil.isEmpty(employee.getOrgList())) {
            return Collections.emptyMap();
        }

        Map<String, SysOrgBasicDTO> orgCompanyMap = new HashMap<>(employee.getOrgList().size());
        for (var employeeOrg : employee.getOrgList()) {
            if (CollUtil.isEmpty(employeeOrg.getOrgList())) {
                continue;
            }
            for (int i = employeeOrg.getOrgList().size() - 1; i >= 0; i--) {
                var org = employeeOrg.getOrgList().get(i);
                if (OrgType.COMPANY.getValue().equals(org.getType())) {
                    orgCompanyMap.put(employeeOrg.getOrgCode(), org);
                    break;
                }
            }
        }
        return orgCompanyMap;
    }

    private Long createScpsmanInfo(SysEmployeeDetailDTO employee, Set<String> orgCodes) {
        // 查询公司
//        var regionCompanyMap = orgRpcService.getParentByCode(orgCodes, OrgType.COMPANY.getValue()).computeData();
        var regionCompanyMap = this.filterCompanyOfEmployee(employee);
        if (regionCompanyMap.isEmpty()) {
            throw new BusinessException("未查询到员工的所属公司");
        }
        var companyCodes = regionCompanyMap.values().stream().map(SysOrgBasicDTO::getCode).filter(StringUtils::hasText).collect(Collectors.toList());
        Map<String, OrgOuRpcSimpleDTO> companyMap = companyCodes.isEmpty() ? Collections.emptyMap() : orgOuRpcService.findSimpleByOuCodes(companyCodes).stream().collect(Collectors.toMap(OrgOuRpcSimpleDTO::getOuCode, Function.identity(), (t1, t2) -> t1));
        if (regionCompanyMap.isEmpty()) {
            throw new BusinessException("未查询到员工的所属公司");
        }

        SalesmanInfoSaveVO salesmanInfoSaveVO = new SalesmanInfoSaveVO();
        salesmanInfoSaveVO.setUserId(employee.getId());
        salesmanInfoSaveVO.setScpsmanNo(employee.getCode());
        salesmanInfoSaveVO.setLoginAccount(employee.getUsername());
        salesmanInfoSaveVO.setName(employee.getFullName());
        salesmanInfoSaveVO.setPhone(employee.getPhone());
        salesmanInfoSaveVO.setEmail(employee.getEmail());
        salesmanInfoSaveVO.setSex(Gender.FEMALE.getValue().equals(employee.getGender()) ? 2 : 1);
        salesmanInfoSaveVO.setBirthdayTime(DatetimeUtil.toStr(employee.getBirthDate()));
        salesmanInfoSaveVO.setIdCardNo(employee.getIdCard());
        salesmanInfoSaveVO.setDetailedAddress(employee.getAddress());
        salesmanInfoSaveVO.setJoinTime(employee.getJoinTime() == null ? null : DatetimeUtil.toStr(employee.getJoinTime().toLocalDate()));

        SysEmployeeDetailDTO.EmployeeOrg employeeOrg = null;
        OrgOuRpcSimpleDTO ou = null;
        for (Map.Entry<String, SysOrgBasicDTO> entry : regionCompanyMap.entrySet()) {
            var company = companyMap.get(entry.getValue().getCode());
            if (company == null) {
                continue;
            }

            ou = company;
            for (SysEmployeeDetailDTO.EmployeeOrg empOrg : employee.getOrgList()) {
                if (empOrg.getOrgCode().equals(entry.getKey())) {
                    employeeOrg = empOrg;
                    break;
                }
            }
            break;
        }
        Assert.notNull(ou, "未查询到员工的公司");
        Assert.notNull(employeeOrg, "未查询到员工的组织");

        salesmanInfoSaveVO.setOuId(ou.getId().toString());
        salesmanInfoSaveVO.setOuName(ou.getOuName());
        salesmanInfoSaveVO.setOuCode(ou.getOuCode());

        salesmanInfoSaveVO.setBuName(employeeOrg.getOrgName());
        salesmanInfoSaveVO.setBuCode(employeeOrg.getOrgCode());
        salesmanInfoSaveVO.setBuId(employeeOrg.getOrgId());
        salesmanInfoSaveVO.setOrgIdBelong(employeeOrg.getOrgId().toString());
        salesmanInfoSaveVO.setSource("EMP");

        scpsmanInfoService.save(salesmanInfoSaveVO).computeData();
        var id = scpsmanInfoRepoProc.getIdByCode(employee.getCode());
        Assert.notNull(id, "保存失败");
        return id;
    }

    private Long getOrCreateScpsmanAuthority(long scpsmanId) {
        var scpsmanAuthorityId = scpDemandAuthorityRepoProc.getIdByScpsManId(scpsmanId);
        if (scpsmanAuthorityId != null) {
            return scpsmanAuthorityId;
        }

        var scpsmanInfo = scpsmanInfoRepoProc.get(scpsmanId);
        Assert.notNull(scpsmanInfo, "计划员信息为空");

        ScpsmanAuthorityDO authorityDO = new ScpsmanAuthorityDO();
        authorityDO.setScpsmanId(scpsmanId);
        authorityDO.setScpsmanNo(scpsmanInfo.getScpsmanNo());
        authorityDO.setOuId(scpsmanInfo.getOuId());
        authorityDO.setOuName(scpsmanInfo.getOuName());
        authorityDO.setOuCode(scpsmanInfo.getOuCode());
        authorityDO.setEnableStatus(true);

        scpDemandAuthorityService.saveScpManAuthority(authorityDO);
        return authorityDO.getId();
    }

    private List<OrgStoreBaseRpcDTO> queryOrgStoreByRegion(Map<String, OrgRegionDTO> regionMap) {
        // 区域的组织编码
        var orgMap = orgRpcService.queryChildrenList(regionMap.keySet()).computeData();
        var orgCodes = orgMap.values().stream().flatMap(Collection::stream).map(IdCodeNameParam::getCode).collect(Collectors.toList());

        return rmiOrgStoreRpcService.findOrgStoreBaseByRegion(orgCodes);
    }

    private List<OrgStoreBaseRpcDTO> queryOrgStoreByOrg(Set<Long> orgIds) {
        if (CollUtil.isEmpty(orgIds)) {
            return Collections.emptyList();
        }
        //根据组织查询门店信息
        return rmiOrgStoreRpcService.findOrgStoreBaseByBuIds(new ArrayList<>(orgIds));
    }

    private Map<String, OrgRegionDTO> queryRegionByOrg(Set<String> orgCodes) {
        if (CollUtil.isEmpty(orgCodes)) {
            return Collections.emptyMap();
        }

        OrgRegionQueryDTO queryDTO = new OrgRegionQueryDTO();
        queryDTO.setRegionCodes(orgCodes);
        var regionList = orgRegionRpcService.queryList(queryDTO).computeData();
        if (CollUtil.isEmpty(regionList)) {
            return Collections.emptyMap();
        }
        return regionList.stream().collect(Collectors.toMap(OrgRegionDTO::getRegionCode, Function.identity(), (t1, t2) -> t1));
    }

    /**
     * 检查新增数据是否重复
     *
     * @param saveVO
     */
    private void checkMessage(ScpManAuthoritySaveVO saveVO) {
        ScpManAuthorityParam scpManAuthorityParam = new ScpManAuthorityParam();
        scpManAuthorityParam.setScpsmanId(saveVO.getScpsmanId());
        scpManAuthorityParam.setScpsmanNo(saveVO.getScpsmanNo());
        scpManAuthorityParam.setOuCode(saveVO.getOuCode());
        scpManAuthorityParam.setOuId(saveVO.getOuId());
        List<ScpManAuthorityPageRespVO> scpManAuthorityPageRespVOS = scpDemandAuthorityService.listQuery(scpManAuthorityParam);

        List<ScpManAuthorityDSaveVO> scpManAuthorityDSaveVOS = saveVO.getScpManAuthorityDSaveVOS();
        List<String> checkflag = new ArrayList<>();
        scpManAuthorityDSaveVOS.stream().forEach(t -> {
            checkflag.add(t.getType() + t.getStWhCode() + t.getStWhName());
        });
        if (CollectionUtil.isEmpty(scpManAuthorityPageRespVOS)) {
            return;
        }
        //新增判重
        if (saveVO.getId() == null) {
            scpManAuthorityPageRespVOS.stream().forEach(t -> {
                //标识
                String log = t.getType() + t.getStWhCode() + t.getStWhName();
                //判重
                List<String> checkList = checkflag.stream().filter(f -> f.equals(log)).collect(Collectors.toList());
                if (CollectionUtil.isNotEmpty(checkList)) {
                    throw new BusinessException("计划员姓名：" + saveVO.getScpsmanName() + ",公司：" + saveVO.getOuName() + ",门店名称/仓库名称:" + t.getStWhName() + ";数据重复");
                }
            });
        }
        //修改判重
        if (saveVO.getId() != null) {
            List<ScpManAuthorityPageRespVO> collect = scpManAuthorityPageRespVOS.stream().filter(t -> t.getId().compareTo(saveVO.getId()) != 0).collect(Collectors.toList());
            if (CollectionUtil.isEmpty(collect)) {
                return;
            }
            collect.stream().forEach(check -> {
                //标识
                String log = check.getType() + check.getStWhCode() + check.getStWhName();
                //判重
                List<String> checkList = checkflag.stream().filter(f -> f.equals(log)).collect(Collectors.toList());
                if (CollectionUtil.isNotEmpty(checkList)) {
                    throw new BusinessException("计划员姓名：" + saveVO.getScpsmanName() + ",公司：" + saveVO.getOuName() + ",门店名称/仓库名称:" + check.getStWhName() + ";数据重复");
                }
            });
        }
    }

    /**
     * 公司，计划员数据翻译，补充
     *
     * @param scpsmanAuthorityRespVO
     */
    private void translate(ScpsmanAuthorityRespVO scpsmanAuthorityRespVO) {
        //状态翻译
        scpsmanAuthorityRespVO.setEnableStatusName(ObjectUtil.equal(scpsmanAuthorityRespVO.getEnableStatus(), null) ? null : (scpsmanAuthorityRespVO.getEnableStatus() ? "启用" : "禁用"));
        //计划员翻译
        ScpsmanInfoDO byScpsmanNo = scpsmanInfoRepo.findByScpsmanNo(scpsmanAuthorityRespVO.getScpsmanNo());
        if (ObjectUtil.isEmpty(byScpsmanNo)) {
            return;
        }
        scpsmanAuthorityRespVO.setScpsman(byScpsmanNo.getName());
    }

}
