package com.elitesland.scp.application.service.order;

import com.elitescloud.boot.common.annotation.BusinessObjectOperation;
import com.elitescloud.boot.common.annotation.businessobject.OperationTypeEnum;
import com.elitescloud.boot.excel.common.DataExport;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.scp.application.facade.vo.order.ScpDemandOrderExportRespVO;
import com.elitesland.scp.application.facade.vo.param.order.ScpDemandOrderPageParamVO;
import com.elitesland.scp.common.ScpBusinessObjectConstant;
import com.elitesland.scp.common.ScpBusinessOperationConstant;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Component;

import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;


@Component
@Slf4j
@RequiredArgsConstructor
public class ScpDemandOrderExportServiceImpl implements DataExport<ScpDemandOrderExportRespVO, ScpDemandOrderPageParamVO> {

    private final ScpDemandOrderService scpDemandOrderService;

    @Override
    public String getTmplCode() {
        return "yst_scp_demand_order_export";
    }

    @Override
    @BusinessObjectOperation(
            permissionRef = ScpBusinessOperationConstant.SCP_DEMAND_ORDER_PAGE,
            operationType = OperationTypeEnum.EXPORT,
            operationDescription = "订货单导出",
            businessObjectType = ScpBusinessObjectConstant.SCP_DEMAND_ORDER,
            operationCode = ScpBusinessOperationConstant.YST_SCP_DEMAND_ORDER_EXPORT,
            dataPermissionEnabled = true, fieldPermissionAutoFilter = true)
    public PagingVO<ScpDemandOrderExportRespVO> executeExport(ScpDemandOrderPageParamVO queryParamVO) {
        return scpDemandOrderService.executeExport(queryParamVO);
    }
    @Override
    public String exportFileName() {
        DateTimeFormatter pattern = DateTimeFormatter.ofPattern("yyyyMMddHHmmss");
        return "订货单导出_"+ LocalDateTime.now().format(pattern);
    }
    @Override
    public Integer pageSize(){
        return 1000;
    }
}
