package com.elitesland.scp.domain.vo.survey;

import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.util.List;

@ApiModel(description = "图表")
@Data
public class SurveyAnalysisRespVO implements Serializable {

    private static final long serialVersionUID = 44067892996016803L;

    @ApiModelProperty("问卷ID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long suvId;

    @ApiModelProperty("问题类型")
    private String qusType;

    @ApiModelProperty("问题标题")
    private String qusTitle;

    @ApiModelProperty("明细")
    private List<SurveyAnalysisDetailRespVO> optionList;

}
