package com.elitesland.scp.infr.repo.calendar;

import com.elitesland.scp.domain.entity.calendar.ScpStoreDemandCalendarDO;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.querydsl.QuerydslPredicateExecutor;
import org.springframework.stereotype.Repository;

import java.util.List;

/**
* @description:  
* @author: jeesie.jiang
* @create: 2024-03-28
* @Version 1.0
**/
@Repository
public interface ScpStoreDemandCalendarRepo extends JpaRepository<ScpStoreDemandCalendarDO, Long>, QuerydslPredicateExecutor<ScpStoreDemandCalendarDO> {

    @Query(value = "select * from scp_store_demand_calendar where (delete_flag=0 or delete_flag is null) and CONCAT(COALESCE(type, ''), COALESCE(store_code, ''), COALESCE(year, ''), COALESCE(month, '')) in (?1)", nativeQuery = true)
    List<ScpStoreDemandCalendarDO> findByConcatYearAndMonthKey(List<String> concatKey);

//    @Query(value = "select * from scp_store_demand_calendar where (delete_flag=0 or delete_flag is null) and CONCAT(COALESCE(type, ''), COALESCE(store_code, ''), COALESCE(year, ''), COALESCE(month, ''), COALESCE(delivery_type, '')) in (?1)", nativeQuery = true)
//    List<ScpStoreDemandCalendarDO> findByConcatYearAndMonthAndDeliveryTypeKey(List<String> concatKey);

    @Query(value = "select * from scp_store_demand_calendar where (delete_flag=0 or delete_flag is null) " +
            "and CONCAT(COALESCE(type, ''), COALESCE(store_code, ''), COALESCE(year, ''), COALESCE(month, ''),COALESCE(day, '')) in (?1)", nativeQuery = true)
    List<ScpStoreDemandCalendarDO> findByStoreDayCalendar(List<String> concatKey);

//    @Query(value = "select * from scp_store_demand_calendar where (delete_flag=0 or delete_flag is null) " +
//            "and CONCAT(COALESCE(type, ''), COALESCE(store_code, ''), COALESCE(year, ''), COALESCE(month, ''),COALESCE(day, ''), COALESCE(delivery_type, '')) in (?1)", nativeQuery = true)
//    List<ScpStoreDemandCalendarDO> findByStoreDayCalendarAndDeliveryTypeKey(List<String> concatKey);

    @Query(value = "select distinct delivery_type from scp_store_demand_calendar ", nativeQuery = true)
    List<String> findAllDeliveryType();
}
