package com.elitesland.scp.infr.repo.mrp;

import cn.hutool.core.collection.CollectionUtil;
import com.elitesland.scp.application.facade.vo.resp.mrp.ScpMrpDPlanRespVO;
import com.elitesland.scp.domain.entity.mrp.QScpMrpDPlanDO;
import com.querydsl.core.types.Projections;
import com.querydsl.core.types.QBean;
import com.querydsl.jpa.impl.JPAQueryFactory;
import com.querydsl.jpa.impl.JPAUpdateClause;
import lombok.RequiredArgsConstructor;
import org.springframework.stereotype.Component;

import java.util.ArrayList;
import java.util.List;

@Component
@RequiredArgsConstructor
public class ScpMrpDPlanRepoProc {
    private final JPAQueryFactory jpaQueryFactory;
    private final QScpMrpDPlanDO scpMrpDPlanDO = QScpMrpDPlanDO.scpMrpDPlanDO;

    private final QBean<ScpMrpDPlanRespVO> baseBean = Projections.bean(
            ScpMrpDPlanRespVO.class,
            scpMrpDPlanDO.id,
            scpMrpDPlanDO.mrpId,
            scpMrpDPlanDO.masId,
            scpMrpDPlanDO.ouId,
            scpMrpDPlanDO.ouCode,
            scpMrpDPlanDO.ouName,
            scpMrpDPlanDO.suppId,
            scpMrpDPlanDO.suppCode,
            scpMrpDPlanDO.suppName,
            scpMrpDPlanDO.qty,
            scpMrpDPlanDO.poNo,
            scpMrpDPlanDO.poLineNo,
            scpMrpDPlanDO.pushStatus,
            scpMrpDPlanDO.pushFailReason,
            scpMrpDPlanDO.poDId,
            scpMrpDPlanDO.creator,
            scpMrpDPlanDO.createUserId,
            scpMrpDPlanDO.createTime,
            scpMrpDPlanDO.updater,
            scpMrpDPlanDO.modifyUserId,
            scpMrpDPlanDO.modifyTime,
            scpMrpDPlanDO.remark
    );

    public void updatePushStatus(List<Long> planIds, String pushStatus, String poNo, Long poDId, Integer poLineNo, String pushFailReason) {
        JPAUpdateClause updateClause = jpaQueryFactory.update(scpMrpDPlanDO)
                .set(scpMrpDPlanDO.pushStatus, pushStatus)
                .where(scpMrpDPlanDO.id.in(planIds));
        if (poNo == null) {
            updateClause.setNull(scpMrpDPlanDO.poNo);
        } else {
            updateClause.set(scpMrpDPlanDO.poNo, poNo);
        }
        if (poDId == null) {
            updateClause.setNull(scpMrpDPlanDO.poDId);
        } else {
            updateClause.set(scpMrpDPlanDO.poDId, poDId);
        }
        if (poLineNo == null) {
            updateClause.setNull(scpMrpDPlanDO.poLineNo);
        } else {
            updateClause.set(scpMrpDPlanDO.poLineNo, poLineNo);
        }
        if (pushFailReason == null) {
            updateClause.setNull(scpMrpDPlanDO.pushFailReason);
        } else {
            updateClause.set(scpMrpDPlanDO.pushFailReason, pushFailReason);
        }
        updateClause.execute();
    }

    public List<ScpMrpDPlanRespVO> findByIds(List<Long> ids) {
        if (CollectionUtil.isEmpty(ids)) {
            return new ArrayList<>();
        }
        return jpaQueryFactory.select(baseBean)
                .from(scpMrpDPlanDO)
                .where(scpMrpDPlanDO.id.in(ids))
                .fetch();
    }

    public List<ScpMrpDPlanRespVO> findByMrpId(Long mrpId) {
        return jpaQueryFactory.select(baseBean)
                .from(scpMrpDPlanDO)
                .where(scpMrpDPlanDO.mrpId.eq(mrpId))
                .fetch();
    }
}
