package com.elitesland.scp.mq;

import com.alibaba.fastjson.JSON;
import com.elitescloud.boot.mq.MessageQueueListener;
import com.elitesland.scp.boh.StoreReceiveCreateSendParam;
import com.elitesland.scp.domain.service.order.ScpDemandOrderDDomainService;
import com.elitesland.scp.domain.service.order.ScpDemandOrderDomainService;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotEmpty;
import javax.validation.constraints.NotNull;
import java.util.List;

/**
 * 回写订货单关联的门店收货单
 */
@Component
@Slf4j
@RequiredArgsConstructor
public class StoreReceiveCreateListener implements MessageQueueListener<StoreReceiveCreateSendParam> {

    private final ScpDemandOrderDomainService scpDemandOrderDomainService;
    private final ScpDemandOrderDDomainService scpDemandOrderDDomainService;

    @Override
    public @NotEmpty String[] channels() {
        return new String[]{StoreReceiveCreateSendParam.CREATE_CHANNEL};
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public void onConsume(@NotBlank String s, @NotNull StoreReceiveCreateSendParam storeReceiveSendParam) {
        log.info("回写订货单关联的门店收货单：{}", JSON.toJSONString(storeReceiveSendParam));
        updateSrcDocInfo(storeReceiveSendParam);
    }

    private void updateSrcDocInfo(StoreReceiveCreateSendParam storeReceiveSendParam) {
        storeReceiveSendParam.getOrderDocs().forEach(
                item -> {
                    List<StoreReceiveCreateSendParam.OrderItem> orderDidList = item.getOrderDidList();
                    orderDidList.forEach(row -> {
                        scpDemandOrderDDomainService.updateSrcInfo(item.getDocId(), item.getDocNo(), row.getOrderDid(), row.getLineNo());
                    });
                    scpDemandOrderDomainService.updatePushStatusById(item.getOrderId());
                });

    }
}
