/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.scp.application.service.cart;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.extra.spring.SpringUtil;
import cn.hutool.json.JSONUtil;
import com.alibaba.fastjson.JSON;
import com.elitescloud.boot.exception.BusinessException;
import com.elitescloud.cloudt.common.annotation.SysCodeProc;
import com.elitesland.inv.dto.invstk.InvWhItemTotalStkRpcDTO;
import com.elitesland.inv.dto.invstk.InvWhItemTotalStkRpcParam;
import com.elitesland.inv.enums.InvDeter2TypeEnum;
import com.elitesland.sale.api.vo.resp.MktDiscountGiftRpcBatchParam;
import com.elitesland.sale.api.vo.resp.crm.MktDiscountGiftRpcDTO;
import com.elitesland.sale.service.MktDiscountGiftRpcService;
import com.elitesland.scp.application.facade.vo.cart.AIOrderCheckParamVO;
import com.elitesland.scp.application.facade.vo.cart.AiOrderRespVO;
import com.elitesland.scp.application.facade.vo.cart.CartChangeSelectedStatusAllParamVO;
import com.elitesland.scp.application.facade.vo.cart.CartChangeSelectedStatusParamVO;
import com.elitesland.scp.application.facade.vo.cart.CartCountParamVO;
import com.elitesland.scp.application.facade.vo.cart.CartDataSummaryParamVO;
import com.elitesland.scp.application.facade.vo.cart.CartDataSummaryRespVO;
import com.elitesland.scp.application.facade.vo.cart.CartDeleteItemParamVO;
import com.elitesland.scp.application.facade.vo.cart.CartDetailParamVO;
import com.elitesland.scp.application.facade.vo.cart.CartDetailRespVO;
import com.elitesland.scp.application.facade.vo.cart.CartPriceParamVO;
import com.elitesland.scp.application.facade.vo.cart.CartToOrderFailRespVO;
import com.elitesland.scp.application.facade.vo.cart.CartToOrderSuccessRespVO;
import com.elitesland.scp.application.facade.vo.cart.OrderCheckParamVO;
import com.elitesland.scp.application.facade.vo.cart.OrderCheckRespVO;
import com.elitesland.scp.application.facade.vo.cart.OrderConfirmRespVO;
import com.elitesland.scp.application.facade.vo.cart.StoreCartAllocSaveVO;
import com.elitesland.scp.application.facade.vo.cart.StoreCartQueryParamVO;
import com.elitesland.scp.application.facade.vo.cart.StoreCartSaveVO;
import com.elitesland.scp.application.facade.vo.param.app.AppItemActivityItemPriceParamVO;
import com.elitesland.scp.application.facade.vo.param.app.AppItemPageParamVO;
import com.elitesland.scp.application.facade.vo.param.order.ScpDemandOrderParamVO;
import com.elitesland.scp.application.facade.vo.param.order.ScpDemandSetParamVO;
import com.elitesland.scp.application.facade.vo.resp.alloc.ScpAllocSettingItemRespVO;
import com.elitesland.scp.application.facade.vo.resp.app.AppItemPriceRespVO;
import com.elitesland.scp.application.facade.vo.resp.app.AppItmItemPageVO;
import com.elitesland.scp.application.facade.vo.resp.order.ScpDemandOrderRespVO;
import com.elitesland.scp.application.facade.vo.resp.order.ScpDemandSetSelectRespVO;
import com.elitesland.scp.application.facade.vo.resp.purLimit.ScpPurLimitSettingItemRespVO;
import com.elitesland.scp.application.facade.vo.resp.setting.ScpOrderSettingRespVO;
import com.elitesland.scp.application.facade.vo.save.order.ScpDemandOrderDSaveVO;
import com.elitesland.scp.application.facade.vo.save.order.ScpDemandOrderDSubmitVO;
import com.elitesland.scp.application.facade.vo.save.order.ScpDemandOrderSubmitVO;
import com.elitesland.scp.application.facade.vo.serviceconfig.ScpServiceConfigRespVO;
import com.elitesland.scp.application.service.UserService;
import com.elitesland.scp.application.service.app.AppDemandOrderService;
import com.elitesland.scp.application.service.app.AppItemActivityService;
import com.elitesland.scp.application.service.cart.ScpStoreCartService;
import com.elitesland.scp.application.service.common.CommonPriceService;
import com.elitesland.scp.application.service.order.ScpDemandOrderService;
import com.elitesland.scp.application.service.order.ScpDemandOrderSetService;
import com.elitesland.scp.application.service.serviceconfig.ScpServiceConfigService;
import com.elitesland.scp.application.service.supalloc.ScpSupplyAllocationService;
import com.elitesland.scp.application.service.whnet.ScpWhNetRelationService;
import com.elitesland.scp.common.CurrentUserDTO;
import com.elitesland.scp.common.ScpConstant;
import com.elitesland.scp.domain.convert.authority.AppItmItemConvert;
import com.elitesland.scp.domain.convert.cart.ScpStoreCartConvert;
import com.elitesland.scp.domain.entity.cart.ScpStoreCartDO;
import com.elitesland.scp.domain.entity.scpsman.ScpsmanInfoDO;
import com.elitesland.scp.domain.service.alloc.ScpAllocSettingItemDomainService;
import com.elitesland.scp.domain.service.calendar.ScpStoreDemandCalendarDomainService;
import com.elitesland.scp.domain.service.order.ScpDemandOrderDomainService;
import com.elitesland.scp.domain.service.purLimit.ScpPurLimitSettingItemDomainService;
import com.elitesland.scp.domain.service.setting.ScpOrderSettingDomainService;
import com.elitesland.scp.dto.supalloc.ScpSupplyAllocationRpcDTO;
import com.elitesland.scp.dto.whnet.ScpWhNetRelationRpcDTO;
import com.elitesland.scp.enums.ScpUdcEnum;
import com.elitesland.scp.infr.dto.order.ScpDemandOrderDTO;
import com.elitesland.scp.infr.repo.item.ScpCateItemRepoProc;
import com.elitesland.scp.infr.repo.order.ScpDemandOrderRepoProc;
import com.elitesland.scp.infr.repo.scpsman.ScpsmanInfoRepo;
import com.elitesland.scp.rmi.RmiInvStkRpcService;
import com.elitesland.scp.rmi.RmiItemService;
import com.elitesland.scp.rmi.RmiOrgStoreRpcService;
import com.elitesland.scp.rmi.RmiPriceRpcService;
import com.elitesland.scp.rmi.RmiSysUDCService;
import com.elitesland.scp.utils.BeanUtils;
import com.elitesland.scp.utils.CartRedisUtil;
import com.elitesland.scp.utils.CollectRedisUtil;
import com.elitesland.scp.utils.SysUtils;
import com.elitesland.support.provider.item.dto.ItmItemAttachmentProviderDTO;
import com.elitesland.support.provider.item.dto.ItmItemBaseRpcDTO;
import com.elitesland.support.provider.item.dto.ItmItemScpBaseRpcDTO;
import com.elitesland.support.provider.item.dto.ItmItemSimpleRpcDTO;
import com.elitesland.support.provider.item.dto.ItmItemSpuBusinessRpcDTO;
import com.elitesland.support.provider.item.param.ItmItemBaseRpcParam;
import com.elitesland.support.provider.item.param.ItmItemScpBaseRpcParam;
import com.elitesland.support.provider.item.service.ItmItemRpcService;
import com.elitesland.support.provider.org.dto.OrgStoreBaseRpcDTO;
import com.elitesland.support.provider.org.param.OrgStoreBaseRpcParam;
import com.elitesland.support.provider.org.service.OrgStoreRpcService;
import com.elitesland.support.provider.pri.service.dto.PriPriceRpcDTO;
import com.elitesland.support.provider.pri.service.param.ItmPriPriceRpcDtoParam;
import io.seata.common.util.CollectionUtils;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.core.task.TaskExecutor;
import org.springframework.data.redis.core.BoundHashOperations;
import org.springframework.stereotype.Service;

@Service
public class ScpStoreCartServiceImpl
implements ScpStoreCartService {
    private static final Logger log = LoggerFactory.getLogger(ScpStoreCartServiceImpl.class);
    @Autowired
    @Qualifier(value="cloudt_taskExecutor")
    private TaskExecutor taskExecutor;
    private final CartRedisUtil cartRedisUtil;
    private final CollectRedisUtil collectRedisUtil;
    private final RmiItemService rmiItemService;
    private final RmiPriceRpcService rmiPriceRpcService;
    private final ScpSupplyAllocationService scpSupplyAllocationService;
    private final ScpWhNetRelationService scpWhNetRelationService;
    private final RmiOrgStoreRpcService rmiOrgStoreRpcService;
    private final CommonPriceService commonPriceService;
    private final ScpOrderSettingDomainService scpOrderSettingDomainService;
    private final RmiInvStkRpcService rmiInvStkRpcService;
    private final ScpAllocSettingItemDomainService scpAllocSettingItemDomainService;
    private final ScpPurLimitSettingItemDomainService scpPurLimitSettingItemDomainService;
    private final ScpDemandOrderSetService scpDemandOrderSetService;
    private final ScpDemandOrderService scpDemandOrderService;
    private final ScpDemandOrderRepoProc scpDemandOrderRepoProc;
    private final MktDiscountGiftRpcService mktDiscountGiftRpcService;
    private final ItmItemRpcService itmItemRpcService;
    private final OrgStoreRpcService orgStoreRpcService;
    private final ScpServiceConfigService scpServiceConfigService;
    private final RmiSysUDCService rmiSysUDCService;
    private final AppItemActivityService appItemActivityService;
    private final ScpStoreDemandCalendarDomainService storeDemandCalendarDomainService;
    private final ScpCateItemRepoProc scpCateItemRepoProc;
    private final ScpsmanInfoRepo scpsmanInfoRepo;

    @Override
    @SysCodeProc
    public List<CartDetailRespVO> detail(CartDetailParamVO paramVO) {
        List spuIds;
        List skuImgByItemIds;
        List simpleItem2;
        String storeCode = paramVO.getDemandWhStCode();
        String cartType = paramVO.getCartType();
        CurrentUserDTO currentUserDTO = UserService.currentUser();
        if (currentUserDTO == null) {
            throw new BusinessException("\u5f53\u524d\u767b\u5f55\u4eba\u67e5\u8be2\u5f02\u5e38");
        }
        Long currentUserId = currentUserDTO.getUserId();
        ScpsmanInfoDO byLoginAccount = this.scpsmanInfoRepo.findByLoginAccount(currentUserDTO.getDetail().getUsername());
        log.info("\u5f53\u524d\u767b\u5f55\u4eba\u8ba2\u8d27\u8d26\u53f7:{}", (Object)JSONUtil.toJsonStr((Object)((Object)byLoginAccount)));
        if (byLoginAccount == null) {
            throw new BusinessException("\u5f53\u524d\u767b\u5f55\u4eba\u8ba2\u8d27\u8d26\u53f7\u67e5\u8be2\u5f02\u5e38");
        }
        String scpManType = byLoginAccount.getScpsmanType();
        List<ScpStoreCartDO> cartDOS = this.cartRedisUtil.getStoreCartItems(storeCode, cartType, currentUserId);
        log.info("\u8d2d\u7269\u8f66\u5546\u54c1\u6570\u91cf\uff1a{}", (Object)JSON.toJSONString(cartDOS));
        if (CollUtil.isEmpty(cartDOS)) {
            return new ArrayList<CartDetailRespVO>();
        }
        List<Long> itemIdList = cartDOS.stream().map(ScpStoreCartDO::getItemId).distinct().collect(Collectors.toList());
        AppItemPageParamVO appItemPageParamVO = new AppItemPageParamVO();
        appItemPageParamVO.setItemIds(itemIdList);
        appItemPageParamVO.setStoreCode(storeCode);
        List<AppItmItemPageVO> simpleItem = this.scpCateItemRepoProc.pageAppItemAndWhNetSku(appItemPageParamVO);
        ArrayList<Long> notExistItemId = new ArrayList<Long>();
        if (CollUtil.isNotEmpty(simpleItem)) {
            List<Long> existItemIdList = simpleItem.stream().map(AppItmItemPageVO::getItemId).toList();
            for (Long itemId : itemIdList) {
                if (existItemIdList.contains(itemId)) continue;
                notExistItemId.add(itemId);
            }
        } else {
            notExistItemId.addAll(itemIdList);
        }
        if (CollUtil.isNotEmpty(notExistItemId) && CollUtil.isNotEmpty((Collection)(simpleItem2 = this.itmItemRpcService.findSimpleItem(notExistItemId)))) {
            List<AppItmItemPageVO> notExistItemList = simpleItem2.stream().map(itmItemSimpleRpcDTO -> {
                AppItmItemPageVO appItmItemPageVO = new AppItmItemPageVO();
                appItmItemPageVO.setItemId(itmItemSimpleRpcDTO.getId());
                appItmItemPageVO.setItemCode(itmItemSimpleRpcDTO.getItemCode());
                appItmItemPageVO.setItemType2(itmItemSimpleRpcDTO.getItemType2());
                return appItmItemPageVO;
            }).toList();
            simpleItem.addAll(notExistItemList);
        }
        Map simpleItemMap = simpleItem.stream().collect(Collectors.toMap(AppItmItemPageVO::getItemId, Function.identity(), (old, item) -> item));
        ScpOrderSettingRespVO orderSetting = this.scpOrderSettingDomainService.findCacheByBusinessType(cartType, ScpUdcEnum.DEMAND_SET_TYPE_0.getValueCode());
        ArrayList<AppItmItemPageVO> originItemList = new ArrayList<AppItmItemPageVO>();
        ArrayList<AppItemActivityItemPriceParamVO> priceParamVOS = new ArrayList<AppItemActivityItemPriceParamVO>();
        for (ScpStoreCartDO cartDO : cartDOS) {
            AppItemActivityItemPriceParamVO priceParamVO = new AppItemActivityItemPriceParamVO();
            priceParamVO.setItemCode(cartDO.getItemCode());
            priceParamVO.setItemId(cartDO.getItemId());
            priceParamVO.setItemCateCode(cartDO.getItemCateCode());
            priceParamVO.setUom(cartDO.getUom());
            priceParamVO.setCombineItemCode(cartDO.getCombineItemCode());
            priceParamVO.setCombineItemFlag(cartDO.getCombineItemFlag());
            priceParamVO.setItemType2(((AppItmItemPageVO)simpleItemMap.get(cartDO.getItemId())).getItemType2());
            priceParamVO.setActivityCode(cartDO.getActivityCode());
            priceParamVOS.add(priceParamVO);
            AppItmItemPageVO item2 = new AppItmItemPageVO();
            item2.setItemId(cartDO.getItemId());
            item2.setItemCode(cartDO.getItemCode());
            item2.setItemType2(((AppItmItemPageVO)simpleItemMap.get(cartDO.getItemId())).getItemType2());
            originItemList.add(item2);
        }
        AtomicReference<Map<String, BigDecimal>> stockMapRef = new AtomicReference<Map<String, BigDecimal>>(new HashMap());
        HashMap<String, AppItemPriceRespVO> priceMap = new HashMap();
        if (CollectionUtil.isNotEmpty(priceParamVOS)) {
            priceMap = this.commonPriceService.getNewPriceAndStockDetails(priceParamVOS, storeCode, orderSetting, ScpUdcEnum.DEMAND_SET_TYPE_0.getValueCode(), stockMapRef);
        }
        Map<String, String> itemType2 = this.rmiSysUDCService.getCodeMap("yst-supp", "ITEM_TYPE2");
        Map<String, Boolean> calendarLimitMap = this.setStoreDemandCalendarLimit(storeCode, originItemList, scpManType);
        ArrayList<CartDetailRespVO> resultList = new ArrayList<CartDetailRespVO>();
        Map<String, BigDecimal> stockMap = stockMapRef.get();
        Map<String, List<ScpStoreCartDO>> spuMap = cartDOS.stream().collect(Collectors.groupingBy(c -> SysUtils.getItemKey(c.getCombineItemCode(), c.getItemCode(), c.getActivityCode())));
        for (Map.Entry<String, List<ScpStoreCartDO>> entry : spuMap.entrySet()) {
            CartDetailRespVO vo = new CartDetailRespVO();
            List<ScpStoreCartDO> storeCartDOS = entry.getValue();
            ScpStoreCartDO storeCartDO = storeCartDOS.get(0);
            vo.setSpuId(storeCartDO.getSpuId());
            vo.setSpuCode(storeCartDO.getSpuCode());
            vo.setSpuName(storeCartDO.getSpuName());
            vo.setSpec(storeCartDO.getSpec());
            vo.setUrl(storeCartDO.getUrl());
            vo.setAnotherName(storeCartDO.getAnotherName());
            vo.setCombineItemCode(storeCartDO.getCombineItemCode());
            vo.setCombineItemName(storeCartDO.getCombineItemName());
            vo.setCombineItemFlag(storeCartDO.getCombineItemFlag());
            vo.setCollectFlag(this.collectRedisUtil.existsSpuInUser(storeCode, currentUserId, SysUtils.getItemKey(storeCartDO.getCombineItemCode(), storeCartDO.getItemCode())));
            vo.setActivityCode(storeCartDO.getActivityCode());
            vo.setActivityId(storeCartDO.getActivityId());
            vo.setAllowDiscount(orderSetting.getAllowDiscount());
            ArrayList<CartDetailRespVO.ItemSpecObjectVO> itemSpecObjectVOS = new ArrayList<CartDetailRespVO.ItemSpecObjectVO>();
            for (ScpStoreCartDO scpCartDO : storeCartDOS) {
                CartDetailRespVO.ItemSpecObjectVO detailVo = new CartDetailRespVO.ItemSpecObjectVO();
                detailVo.setUom(scpCartDO.getUom());
                detailVo.setUomName(scpCartDO.getUomName());
                detailVo.setItemId(scpCartDO.getItemId());
                detailVo.setItemCode(scpCartDO.getItemCode());
                detailVo.setItemName(scpCartDO.getItemName());
                detailVo.setItemType2(scpCartDO.getItemType2());
                Optional.ofNullable(itemType2.get(scpCartDO.getItemType2())).ifPresent(detailVo::setItemType2Name);
                Boolean calendarLimit = calendarLimitMap.get(scpCartDO.getItemCode());
                detailVo.setCalendarLimit(calendarLimit != null && calendarLimit != false);
                AppItemPriceRespVO priceRespVO = (AppItemPriceRespVO)priceMap.get(SysUtils.getItemKey(scpCartDO.getCombineItemCode(), scpCartDO.getItemCode()));
                if (priceRespVO != null && scpCartDO.getSettlementPrice() == null) {
                    detailVo.setSuppCode(priceRespVO.getSuppCode());
                    detailVo.setSuppName(priceRespVO.getSuppName());
                    detailVo.setSuppId(priceRespVO.getSuppId());
                    detailVo.setItemPrice(priceRespVO.getPrice());
                    detailVo.setPrice(priceRespVO.getPrice());
                    detailVo.setCostPrice(priceRespVO.getCostPrice());
                    detailVo.setPurPrice(priceRespVO.getPurPrice());
                    detailVo.setIsProjFeeCharged(priceRespVO.getIsProjFeeCharged());
                    detailVo.setStoreCode(priceRespVO.getStoreCode());
                    detailVo.setTefPrice(priceRespVO.getTefPrice());
                    detailVo.setMefPrice(priceRespVO.getMefPrice());
                    detailVo.setOefPrice(priceRespVO.getOefPrice());
                    detailVo.setSalePrice(priceRespVO.getSalePrice());
                    detailVo.setTefFeeOuCode(priceRespVO.getTefFeeOuCode());
                    detailVo.setTefFeeOuName(priceRespVO.getTefFeeOuName());
                    detailVo.setMefFeeOuCode(priceRespVO.getMefFeeOuCode());
                    detailVo.setMefFeeOuName(priceRespVO.getMefFeeOuName());
                    detailVo.setOefFeeOuCode(priceRespVO.getOefFeeOuCode());
                    detailVo.setOefFeeOuName(priceRespVO.getOefFeeOuName());
                    vo.setCombineQty(priceRespVO.getCombineQty());
                } else {
                    detailVo.setSuppCode(scpCartDO.getSuppCode());
                    detailVo.setSuppName(scpCartDO.getSuppName());
                    detailVo.setSuppId(scpCartDO.getSuppId());
                    detailVo.setItemPrice(scpCartDO.getPrice());
                    detailVo.setCostPrice(scpCartDO.getCostPrice());
                    detailVo.setPurPrice(scpCartDO.getPurPrice());
                    detailVo.setIsProjFeeCharged(scpCartDO.getIsProjFeeCharged());
                    detailVo.setStoreCode(scpCartDO.getStoreCode());
                    detailVo.setTefPrice(scpCartDO.getTefPrice());
                    detailVo.setMefPrice(scpCartDO.getMefPrice());
                    detailVo.setOefPrice(scpCartDO.getOefPrice());
                    detailVo.setSalePrice(scpCartDO.getSalePrice());
                    detailVo.setSettlementPrice(scpCartDO.getSettlementPrice());
                    detailVo.setSettlementSalePrice(scpCartDO.getSettlementSalePrice());
                    detailVo.setDiscount(scpCartDO.getDiscount());
                    detailVo.setDiscountType(scpCartDO.getDiscountType());
                    detailVo.setDiscountTypeName(scpCartDO.getDiscountTypeName());
                    detailVo.setTefFeeOuCode(scpCartDO.getTefFeeOuCode());
                    detailVo.setTefFeeOuName(scpCartDO.getTefFeeOuName());
                    detailVo.setMefFeeOuCode(scpCartDO.getMefFeeOuCode());
                    detailVo.setMefFeeOuName(scpCartDO.getMefFeeOuName());
                    detailVo.setOefFeeOuCode(scpCartDO.getOefFeeOuCode());
                    detailVo.setOefFeeOuName(scpCartDO.getOefFeeOuName());
                }
                detailVo.setQty(SysUtils.processQtyScale(scpCartDO.getQty()));
                if (calendarLimit != null && calendarLimit.booleanValue()) {
                    detailVo.setStatus(0);
                } else {
                    detailVo.setStatus(scpCartDO.getSelectedStatus());
                }
                detailVo.setUom2(scpCartDO.getUom2());
                detailVo.setUom2Name(scpCartDO.getUom2Name());
                detailVo.setDecimalPlaces(scpCartDO.getDecimalPlaces());
                detailVo.setUomRatio(scpCartDO.getUomRatio());
                detailVo.setItemAttrName(scpCartDO.getItemAttrName());
                detailVo.setPreSaleStatus(scpCartDO.getPreSaleStatus());
                detailVo.setAvalQty(stockMap.getOrDefault(scpCartDO.getItemCode(), BigDecimal.ZERO));
                detailVo.setMoq(scpCartDO.getMoq());
                itemSpecObjectVOS.add(detailVo);
            }
            vo.setItemSpecObjectVOS(itemSpecObjectVOS);
            boolean allSelected = itemSpecObjectVOS.stream().allMatch(item -> item.getStatus() != null && item.getStatus().equals(1));
            vo.setStatus(allSelected ? 1 : 0);
            BigDecimal totalAmt = itemSpecObjectVOS.stream().filter(item -> ObjectUtil.isNotNull((Object)item.getItemPrice())).map(CartDetailRespVO.ItemSpecObjectVO::getTotalAmt).filter(Objects::nonNull).reduce(BigDecimal.ZERO, BigDecimal::add);
            vo.setTotalAmt(totalAmt);
            resultList.add(vo);
        }
        this.refreshCartPrice(paramVO, currentUserId, cartDOS, priceMap, calendarLimitMap);
        List<CartDetailRespVO> itemResultList = resultList.stream().filter(d -> StringUtils.isBlank((CharSequence)d.getCombineItemCode())).collect(Collectors.toList());
        Map<String, List<CartDetailRespVO>> subItemMap = resultList.stream().filter(d -> StringUtils.isNotBlank((CharSequence)d.getCombineItemCode())).collect(Collectors.groupingBy(CartDetailRespVO::getCombineItemCode));
        if (!subItemMap.isEmpty()) {
            subItemMap.forEach((k, v) -> {
                CartDetailRespVO combineOrderDRespVO = new CartDetailRespVO();
                CartDetailRespVO subSpu = (CartDetailRespVO)v.get(0);
                CartDetailRespVO.ItemSpecObjectVO subItem = subSpu.getItemSpecObjectVOS().get(0);
                combineOrderDRespVO.setCombineItemCode((String)k);
                combineOrderDRespVO.setCombineItemName(subSpu.getCombineItemName());
                combineOrderDRespVO.setStatus(subSpu.getStatus());
                combineOrderDRespVO.setActivityCode(subSpu.getActivityCode());
                combineOrderDRespVO.setActivityId(subSpu.getActivityId());
                combineOrderDRespVO.setSubItemList((List<CartDetailRespVO>)v);
                CartDetailRespVO.ItemSpecObjectVO itemSpecObjectVO = new CartDetailRespVO.ItemSpecObjectVO();
                itemSpecObjectVO.setItemCode(combineOrderDRespVO.getCombineItemCode());
                itemSpecObjectVO.setItemName(combineOrderDRespVO.getCombineItemName());
                if (subSpu.getCombineQty() != null) {
                    itemSpecObjectVO.setQty(subItem.getQty().divide(subSpu.getCombineQty(), 2, RoundingMode.HALF_UP));
                }
                itemSpecObjectVO.setMoq(subItem.getMoq());
                combineOrderDRespVO.setItemSpecObjectVOS(List.of(itemSpecObjectVO));
                itemResultList.add(combineOrderDRespVO);
            });
        }
        if (CollectionUtils.isNotEmpty(itemResultList) && CollectionUtils.isNotEmpty((Collection)(skuImgByItemIds = this.itmItemRpcService.findSkuImgByItemIds(spuIds = itemResultList.stream().map(CartDetailRespVO::getSpuId).filter(Objects::nonNull).distinct().collect(Collectors.toList()))))) {
            Map<Long, List<ItmItemAttachmentProviderDTO>> listMap = skuImgByItemIds.stream().collect(Collectors.groupingBy(ItmItemAttachmentProviderDTO::getItemId));
            itemResultList.forEach(d -> {
                if (CollectionUtils.isNotEmpty((Collection)((Collection)listMap.get(d.getSpuId())))) {
                    d.setFileCode(((ItmItemAttachmentProviderDTO)((List)listMap.get(d.getSpuId())).get(0)).getFileCode());
                }
            });
        }
        return itemResultList;
    }

    private void refreshCartPrice(CartDetailParamVO paramVO, Long currentUserId, List<ScpStoreCartDO> cartDOS, Map<String, AppItemPriceRespVO> priceMap, Map<String, Boolean> calendarLimitMap) {
        BoundHashOperations<String, Object, Object> storeCartOps = this.cartRedisUtil.getStoreCartOps(paramVO.getDemandWhStCode(), paramVO.getCartType(), currentUserId);
        for (ScpStoreCartDO cartDO : cartDOS) {
            Boolean calendarLimit;
            AppItemPriceRespVO priceRespVO = priceMap.get(SysUtils.getItemKey(cartDO.getCombineItemCode(), cartDO.getItemCode()));
            if (priceRespVO != null) {
                cartDO.setItemPrice(priceRespVO.getPrice());
                cartDO.setStoreCode(priceRespVO.getStoreCode());
                cartDO.setSuppId(priceRespVO.getSuppId());
                cartDO.setSuppCode(priceRespVO.getSuppCode());
                cartDO.setSuppName(priceRespVO.getSuppName());
                cartDO.setCostPrice(priceRespVO.getCostPrice());
                cartDO.setPurPrice(priceRespVO.getPurPrice());
                cartDO.setTefPrice(priceRespVO.getTefPrice());
                cartDO.setOefPrice(priceRespVO.getOefPrice());
                cartDO.setMefPrice(priceRespVO.getMefPrice());
                cartDO.setIsProjFeeCharged(priceRespVO.getIsProjFeeCharged());
            }
            if ((calendarLimit = calendarLimitMap.get(cartDO.getItemCode())) != null && calendarLimit.booleanValue()) {
                cartDO.setSelectedStatus(0);
            }
            storeCartOps.put((Object)SysUtils.generateRedisKey("SKU", cartDO.getCombineItemCode(), cartDO.getItemCode(), cartDO.getActivityCode()), (Object)JSONUtil.toJsonStr((Object)cartDO));
        }
    }

    @Override
    public Map<String, Integer> getCartCount(StoreCartQueryParamVO param) {
        HashMap<String, Integer> result = new HashMap<String, Integer>();
        Long currentUserId = UserService.currentUserId();
        List<ScpOrderSettingRespVO> enabledSettings = this.scpOrderSettingDomainService.findEnabledSetting();
        for (ScpOrderSettingRespVO setting : enabledSettings) {
            List<ScpStoreCartDO> cartDOS = this.cartRedisUtil.getStoreCartItems(param.getDemandWhStCode(), setting.getBusinessType(), currentUserId);
            result.put(setting.getBusinessType(), CollUtil.isNotEmpty(cartDOS) ? cartDOS.size() : 0);
        }
        result.values().stream().reduce(Integer::sum).ifPresent(total -> result.put("total", (Integer)total));
        return result;
    }

    @Override
    public Map<Long, BigDecimal> saveCart(StoreCartSaveVO cartSaveVO) {
        Long currentUserId = UserService.currentUserId();
        BoundHashOperations<String, Object, Object> cartOps = this.cartRedisUtil.getStoreCartOps(cartSaveVO.getDemandWhStCode(), cartSaveVO.getCartType(), currentUserId);
        ScpStoreCartServiceImpl.saveOrUpdateCart(cartSaveVO, cartOps);
        HashMap<Long, BigDecimal> result = new HashMap<Long, BigDecimal>();
        result.put(cartSaveVO.getItemId(), cartSaveVO.getQty());
        return result;
    }

    @Override
    public Map<Long, BigDecimal> saveAllocCart(StoreCartAllocSaveVO cartSaveVO) {
        Set keys;
        List<String> skuKeys;
        Long currentUserId = UserService.currentUserId();
        ScpOrderSettingRespVO orderSetting = this.scpOrderSettingDomainService.findCacheByBusinessType(cartSaveVO.getBusinessType(), ScpUdcEnum.DEMAND_SET_TYPE_0.getValueCode());
        if (orderSetting == null) {
            throw new BusinessException("\u8bf7\u5148\u914d\u7f6e\u6216\u542f\u7528\u5355\u636e\u7c7b\u578b:" + cartSaveVO.getBusinessType());
        }
        BoundHashOperations<String, Object, Object> cartOps = this.cartRedisUtil.getStoreCartOps(cartSaveVO.getDemandWhStCode(), cartSaveVO.getCartType(), currentUserId);
        ArrayList<ScpStoreCartDO> dataList = new ArrayList<ScpStoreCartDO>();
        Set keys1 = cartOps.keys();
        if (keys1 != null && !(skuKeys = (keys = keys1.stream().map(Object::toString).collect(Collectors.toSet())).stream().filter(key -> key.endsWith("ALLOC")).toList()).isEmpty()) {
            cartOps.delete(skuKeys.toArray());
        }
        this.addAllocSettingItem(currentUserId, cartSaveVO.getDemandWhStCode(), orderSetting, dataList);
        HashMap<Long, BigDecimal> result = new HashMap<Long, BigDecimal>();
        if (CollUtil.isNotEmpty(dataList)) {
            log.info("\u6dfb\u52a0\u5f3a\u914d\u8d2d\u7269\u8f66\u5546\u54c1:{}", (Object)JSONUtil.toJsonStr(dataList));
            for (ScpStoreCartDO storeCartDO : dataList) {
                String redisKey = SysUtils.generateRedisKey("SKU", storeCartDO.getCombineItemCode(), storeCartDO.getItemCode(), storeCartDO.getActivityCode());
                Object o = cartOps.get((Object)redisKey);
                if (o != null) {
                    log.info("\u8d2d\u7269\u8f66\u5f3a\u914d\u5df2\u5b58\u5728\u8be5\u5546\u54c1:{}", (Object)redisKey);
                    continue;
                }
                storeCartDO.setSelectedStatus(1);
                storeCartDO.setCreateTime(LocalDateTime.now().format(DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss")));
                log.info("\u6dfb\u52a0\u8d2d\u7269\u8f66\u5546\u54c1\u7684key:{}", (Object)redisKey);
                cartOps.put((Object)redisKey, (Object)JSON.toJSONString((Object)storeCartDO));
                result.put(storeCartDO.getItemId(), storeCartDO.getQty());
            }
        }
        return result;
    }

    @Override
    public void batchSaveCart(String storeCode, String cartType, List<StoreCartSaveVO> cartSaveVOS) {
        Long currentUserId = UserService.currentUserId();
        BoundHashOperations<String, Object, Object> cartOps = this.cartRedisUtil.getStoreCartOps(storeCode, cartType, currentUserId);
        cartSaveVOS.forEach(cartSaveVO -> ScpStoreCartServiceImpl.saveOrUpdateCart(cartSaveVO, cartOps));
    }

    @Override
    public void deleteItem(CartDeleteItemParamVO paramVO) {
        Long currentUserId = UserService.currentUserId();
        for (CartDeleteItemParamVO.ItemSpecObjectVO vo : paramVO.getItemSpecObjectVOS()) {
            for (String itemKey : vo.getItemKeys()) {
                BoundHashOperations<String, Object, Object> cartOps = this.cartRedisUtil.getStoreCartOps(paramVO.getDemandWhStCode(), paramVO.getCartType(), currentUserId);
                cartOps.delete(new Object[]{SysUtils.generateRedisKey("SKU", itemKey)});
            }
        }
    }

    @Override
    public CartDataSummaryRespVO dataSummary(CartDataSummaryParamVO paramVO) {
        Long currentUserId = UserService.currentUserId();
        List<ScpStoreCartDO> scpCartDOS = paramVO.getCheckSelectedStatusFlag() == null || paramVO.getCheckSelectedStatusFlag() != false ? this.cartRedisUtil.getCheckedShoppingCartItems(paramVO.getDemandWhStCode(), paramVO.getCartType(), currentUserId) : this.cartRedisUtil.getStoreCartItems(paramVO.getDemandWhStCode(), paramVO.getCartType(), currentUserId);
        if (CollUtil.isEmpty(scpCartDOS)) {
            return new CartDataSummaryRespVO().setItemTypeNum(0).setQtyTotal(BigDecimal.ZERO).setAmtTotal(BigDecimal.ZERO);
        }
        Map<String, List<ScpStoreCartDO>> spuMap = scpCartDOS.stream().collect(Collectors.groupingBy(ScpStoreCartDO::getSpuCode));
        CartDataSummaryRespVO resultVo = new CartDataSummaryRespVO();
        resultVo.setItemTypeNum(spuMap.size());
        BigDecimal qty = scpCartDOS.stream().map(ScpStoreCartDO::getQty).filter(Objects::nonNull).reduce(BigDecimal.ZERO, BigDecimal::add);
        BigDecimal totalAmt = scpCartDOS.stream().filter(v -> v.getItemPrice() != null || v.getSettlementPrice() != null).map(v -> {
            if (v.getSettlementPrice() != null) {
                return v.getTotalSettlementAmt();
            }
            return v.getTotalAmt();
        }).filter(Objects::nonNull).reduce(BigDecimal.ZERO, BigDecimal::add);
        resultVo.setQtyTotal(SysUtils.processQtyScale(qty));
        resultVo.setAmtTotal(SysUtils.processAmtScale(totalAmt));
        return resultVo;
    }

    @Override
    public void changeSelectedStatus(CartChangeSelectedStatusParamVO paramVO) {
        Long currentUserId = UserService.currentUserId();
        String demandWhStCode = paramVO.getDemandWhStCode();
        for (CartChangeSelectedStatusParamVO.ItemSpecObjectVO vo : paramVO.getItemSpecObjectVOS()) {
            for (CartChangeSelectedStatusParamVO.InnerItemSpecObjectVO item : vo.getInnerItemSpecObjectVOS()) {
                if (item.getItemId() == null) {
                    throw new BusinessException("\u5546\u54c1ID\u4e0d\u80fd\u4e3a\u7a7a");
                }
                ScpStoreCartDO cartItem = this.cartRedisUtil.getStoreCartItem(SysUtils.getItemKey(item.getCombineItemCode(), item.getItemCode()), demandWhStCode, paramVO.getCartType(), currentUserId);
                if (cartItem == null) {
                    log.error("\u8d2d\u7269\u8f66\u4e2d\u4e0d\u5b58\u5728\u6b64\u7269\u6599\uff1a{},\u8bf7\u5237\u65b0\u8d2d\u7269\u8f66\u91cd\u8bd5", (Object)item.getItemId());
                    continue;
                }
                cartItem.setSelectedStatus(item.getStatus());
                String redisValue = JSON.toJSONString((Object)cartItem);
                BoundHashOperations<String, Object, Object> cartOps = this.cartRedisUtil.getStoreCartOps(paramVO.getDemandWhStCode(), paramVO.getCartType(), currentUserId);
                cartOps.put((Object)SysUtils.generateRedisKey("SKU", item.getCombineItemCode(), item.getItemCode()), (Object)redisValue);
            }
        }
    }

    private void getPrice(AppItmItemPageVO appItemPriceRespVO, ScpStoreCartDO storeCartDO) {
        if (appItemPriceRespVO != null) {
            storeCartDO.setPrice(appItemPriceRespVO.getPrice());
            storeCartDO.setItemPrice(appItemPriceRespVO.getPrice());
            storeCartDO.setSuppId(appItemPriceRespVO.getSuppId());
            storeCartDO.setSuppCode(appItemPriceRespVO.getSuppCode());
            storeCartDO.setSuppName(appItemPriceRespVO.getSuppName());
            storeCartDO.setCostPrice(appItemPriceRespVO.getCostPrice());
            storeCartDO.setPurPrice(appItemPriceRespVO.getPurPrice());
            storeCartDO.setIsProjFeeCharged(appItemPriceRespVO.getIsProjFeeCharged());
            storeCartDO.setOefPrice(appItemPriceRespVO.getOefPrice());
            storeCartDO.setMefPrice(appItemPriceRespVO.getMefPrice());
            storeCartDO.setTefPrice(appItemPriceRespVO.getTefPrice());
            storeCartDO.setSalePrice(appItemPriceRespVO.getSalePrice());
            storeCartDO.setTefFeeOuCode(appItemPriceRespVO.getTefFeeOuCode());
            storeCartDO.setTefFeeOuName(appItemPriceRespVO.getTefFeeOuName());
            storeCartDO.setOefFeeOuCode(appItemPriceRespVO.getOefFeeOuCode());
            storeCartDO.setOefFeeOuName(appItemPriceRespVO.getOefFeeOuName());
            storeCartDO.setMefFeeOuCode(appItemPriceRespVO.getMefFeeOuCode());
            storeCartDO.setMefFeeOuName(appItemPriceRespVO.getMefFeeOuName());
        }
    }

    @Override
    public void updateCount(CartCountParamVO cartCountParamVO) {
        Long currentUserId = UserService.currentUserId();
        BoundHashOperations<String, Object, Object> cartOps = this.cartRedisUtil.getStoreCartOps(cartCountParamVO.getDemandWhStCode(), cartCountParamVO.getCartType(), currentUserId);
        for (CartCountParamVO.ItemSpecObjectVO vo : cartCountParamVO.getItemSpecObjectVOS()) {
            for (CartCountParamVO.InnerItemSpecObjectVO itemSpecObjectVO : vo.getInnerItemSpecObjectVOS()) {
                if (itemSpecObjectVO.getItemId() == null) {
                    throw new BusinessException("\u5546\u54c1ID\u4e0d\u80fd\u4e3a\u7a7a");
                }
                String product = (String)cartOps.get((Object)SysUtils.generateRedisKey("SKU", itemSpecObjectVO.getCombineItemCode(), itemSpecObjectVO.getItemCode()));
                if (product == null) {
                    log.error("\u8d2d\u7269\u8f66\u4e2d\u4e0d\u5b58\u5728\u6b64\u7269\u6599\uff1a{},\u8bf7\u5237\u65b0\u8d2d\u7269\u8f66\u91cd\u8bd5", (Object)itemSpecObjectVO.getItemId());
                    continue;
                }
                if (itemSpecObjectVO.getQty().compareTo(BigDecimal.ZERO) == 0) {
                    cartOps.delete(new Object[]{SysUtils.generateRedisKey("SKU", itemSpecObjectVO.getCombineItemCode(), itemSpecObjectVO.getItemCode())});
                    continue;
                }
                ScpStoreCartDO storeCartDO = (ScpStoreCartDO)JSON.parseObject((String)product, ScpStoreCartDO.class);
                storeCartDO.setQty(itemSpecObjectVO.getQty());
                String cartItemJson = JSON.toJSONString((Object)storeCartDO);
                cartOps.put((Object)SysUtils.generateRedisKey("SKU", itemSpecObjectVO.getCombineItemCode(), itemSpecObjectVO.getItemCode()), (Object)cartItemJson);
            }
        }
    }

    @Override
    public void updatePrice(CartPriceParamVO cartCountParamVO) {
        Long currentUserId = UserService.currentUserId();
        OrgStoreBaseRpcParam baseRpcParam = new OrgStoreBaseRpcParam();
        baseRpcParam.setStoreCodeList(List.of(cartCountParamVO.getDemandWhStCode()));
        OrgStoreBaseRpcDTO orgStoreBaseRpcDTO = (OrgStoreBaseRpcDTO)((List)this.orgStoreRpcService.findSimpleStoreByParam(baseRpcParam).computeData()).get(0);
        Map<String, ScpServiceConfigRespVO> configRespVOMap = null;
        boolean isServiceCharge = false;
        if (Boolean.TRUE.equals(orgStoreBaseRpcDTO.getDeliveryChargeFlag()) || Boolean.TRUE.equals(orgStoreBaseRpcDTO.getWhChargeFlag())) {
            isServiceCharge = true;
            configRespVOMap = this.scpServiceConfigService.findServiceConfigGroupByStore(orgStoreBaseRpcDTO.getStoreCode(), orgStoreBaseRpcDTO.getRegion(), orgStoreBaseRpcDTO.getStoreLevel());
        }
        BoundHashOperations<String, Object, Object> cartOps = this.cartRedisUtil.getStoreCartOps(cartCountParamVO.getDemandWhStCode(), cartCountParamVO.getCartType(), currentUserId);
        for (CartPriceParamVO.ItemSpecObjectVO vo : cartCountParamVO.getItemSpecObjectVOS()) {
            for (CartPriceParamVO.InnerItemSpecObjectVO itemSpecObjectVO : vo.getInnerItemSpecObjectVOS()) {
                if (itemSpecObjectVO.getItemId() == null) {
                    throw new BusinessException("\u5546\u54c1ID\u4e0d\u80fd\u4e3a\u7a7a");
                }
                if (itemSpecObjectVO.getSettlementPrice() == null) {
                    throw new BusinessException("\u6298\u540e\u5355\u4ef7\u4e0d\u80fd\u4e3a\u7a7a");
                }
                if (itemSpecObjectVO.getPrice() == null) {
                    throw new BusinessException("\u539f\u5355\u4ef7\u4e0d\u80fd\u4e3a\u7a7a");
                }
                if (itemSpecObjectVO.getPrice().subtract(itemSpecObjectVO.getSettlementPrice()).compareTo(BigDecimal.ONE) < 0) {
                    throw new BusinessException("\u6298\u540e\u5355\u4ef7\u5e94\u4f4e\u4e8e\u539f\u5355\u4ef7\uff0c\u4e14\u6298\u6263\u5dee\u989d\u9700\u5927\u4e8e1\u5143");
                }
                String product = (String)cartOps.get((Object)SysUtils.generateRedisKey("SKU", itemSpecObjectVO.getCombineItemCode(), itemSpecObjectVO.getItemCode()));
                if (product == null) {
                    log.error("\u8d2d\u7269\u8f66\u4e2d\u4e0d\u5b58\u5728\u6b64\u7269\u6599\uff1a{},\u8bf7\u5237\u65b0\u8d2d\u7269\u8f66\u91cd\u8bd5", (Object)itemSpecObjectVO.getItemId());
                    continue;
                }
                ScpStoreCartDO cartItem = (ScpStoreCartDO)JSON.parseObject((String)product, ScpStoreCartDO.class);
                cartItem.setSettlementPrice(itemSpecObjectVO.getSettlementPrice());
                cartItem.setDiscountType(itemSpecObjectVO.getDiscountType());
                cartItem.setDiscountTypeName(itemSpecObjectVO.getDiscountTypeName());
                cartItem.setDiscount(itemSpecObjectVO.getDiscount());
                Integer pricePlace = SysUtils.getAppPricePlace();
                if (itemSpecObjectVO.getSettlementPrice().compareTo(itemSpecObjectVO.getPrice()) != 0 && isServiceCharge && configRespVOMap != null) {
                    if (configRespVOMap.get("TECH") != null) {
                        cartItem.setTefFeeOuCode(configRespVOMap.get("TECH").getOuCode());
                    }
                    if (configRespVOMap.get("MARKET") != null) {
                        cartItem.setMefFeeOuCode(configRespVOMap.get("MARKET").getOuCode());
                    }
                    if (configRespVOMap.get("OPERATE") != null) {
                        cartItem.setOefFeeOuCode(configRespVOMap.get("OPERATE").getOuCode());
                    }
                    BigDecimal tefRatio = configRespVOMap.get("TECH") == null ? BigDecimal.ZERO : configRespVOMap.get("TECH").getFeePercentage().multiply(new BigDecimal("0.01"));
                    BigDecimal mefRatio = configRespVOMap.get("MARKET") == null ? BigDecimal.ZERO : configRespVOMap.get("MARKET").getFeePercentage().multiply(new BigDecimal("0.01"));
                    BigDecimal oefRatio = configRespVOMap.get("OPERATE") == null ? BigDecimal.ZERO : configRespVOMap.get("OPERATE").getFeePercentage().multiply(new BigDecimal("0.01"));
                    BigDecimal settlementSalePrice = itemSpecObjectVO.getSettlementPrice().divide(BigDecimal.ONE.add(tefRatio).add(mefRatio).add(oefRatio), (int)pricePlace, RoundingMode.HALF_UP);
                    cartItem.setSettlementSalePrice(settlementSalePrice);
                    cartItem.setTefPrice(settlementSalePrice.multiply(tefRatio).setScale((int)pricePlace, RoundingMode.HALF_UP));
                    cartItem.setMefPrice(settlementSalePrice.multiply(mefRatio).setScale((int)pricePlace, RoundingMode.HALF_UP));
                    cartItem.setOefPrice(cartItem.getSettlementPrice().subtract(cartItem.getSettlementSalePrice()).subtract(cartItem.getTefPrice()).subtract(cartItem.getMefPrice()));
                }
                String redisValue = JSON.toJSONString((Object)cartItem);
                cartOps.put((Object)SysUtils.generateRedisKey("SKU", itemSpecObjectVO.getCombineItemCode(), itemSpecObjectVO.getItemCode()), (Object)redisValue);
            }
        }
    }

    @Override
    public OrderCheckRespVO order(OrderCheckParamVO paramVO) {
        Optional<CartToOrderSuccessRespVO.WhAllocObject> optional;
        List allocItemInfo;
        List<String> docCodeList;
        OrderCheckRespVO resultVO = new OrderCheckRespVO();
        ArrayList<CartToOrderSuccessRespVO> successList = new ArrayList<CartToOrderSuccessRespVO>();
        ArrayList<CartToOrderFailRespVO> failList = new ArrayList<CartToOrderFailRespVO>();
        String demandWhStCode = paramVO.getDemandWhStCode();
        OrgStoreBaseRpcDTO orgStore = this.rmiOrgStoreRpcService.getOrgStoreBase(demandWhStCode);
        ScpOrderSettingRespVO orderSetting = this.scpOrderSettingDomainService.findCacheByBusinessType(paramVO.getBusinessType(), ScpUdcEnum.DEMAND_SET_TYPE_0.getValueCode());
        if (orderSetting == null) {
            throw new BusinessException("\u8bf7\u5148\u914d\u7f6e\u6216\u542f\u7528\u5355\u636e\u7c7b\u578b:" + paramVO.getBusinessType());
        }
        CurrentUserDTO currentUserDTO = UserService.currentUser();
        Long currentUserId = UserService.currentUserId();
        List<ScpStoreCartDO> cartDataList = this.cartRedisUtil.getCheckedShoppingCartItems(paramVO.getDemandWhStCode(), paramVO.getBusinessType(), currentUserId);
        if (CollUtil.isEmpty(cartDataList)) {
            log.info("\u7528\u6237:{},\u8d2d\u7269\u8f66\u6570\u636e\u4e3a\u7a7a", (Object)currentUserId);
            return new OrderCheckRespVO();
        }
        ScpsmanInfoDO byLoginAccount = this.scpsmanInfoRepo.findByLoginAccount(currentUserDTO.getDetail().getUsername());
        log.info("\u5f53\u524d\u767b\u5f55\u4eba\u8ba2\u8d27\u8d26\u53f7:{}", (Object)JSONUtil.toJsonStr((Object)((Object)byLoginAccount)));
        if (byLoginAccount == null) {
            throw new BusinessException("\u5f53\u524d\u767b\u5f55\u4eba\u8ba2\u8d27\u8d26\u53f7\u67e5\u8be2\u5f02\u5e38");
        }
        String scpManType = byLoginAccount.getScpsmanType();
        String allocBusinessType = SysUtils.getAllocBusinessType();
        if (Objects.equals(paramVO.getBusinessType(), allocBusinessType) && CollUtil.isNotEmpty(docCodeList = this.scpDemandOrderRepoProc.countAllocatedOrderByStoreCode(demandWhStCode))) {
            String docCodes = String.join((CharSequence)",", docCodeList);
            log.info("\u95e8\u5e97:{}\u5b58\u5728\u672a\u652f\u4ed8\u7684\u5f3a\u914d\u8ba2\u5355:{}", (Object)demandWhStCode, (Object)docCodes);
            throw new BusinessException("\u6709\u672a\u652f\u4ed8\u5f3a\u914d\u8ba2\u5355\uff0c\u8bf7\u5148\u652f\u4ed8");
        }
        ArrayList<ScpStoreCartDO> allocItemList = new ArrayList<ScpStoreCartDO>();
        this.addAllocSettingItem(currentUserId, demandWhStCode, orderSetting, allocItemList);
        HashMap<String, ScpStoreCartDO> allocSettingMap = new HashMap<String, ScpStoreCartDO>();
        if (CollUtil.isNotEmpty(allocItemList)) {
            List<Long> itemIdList = allocItemList.stream().map(ScpStoreCartDO::getItemId).distinct().collect(Collectors.toList());
            AppItemPageParamVO appItemPageParamVO = new AppItemPageParamVO();
            appItemPageParamVO.setItemIds(itemIdList);
            appItemPageParamVO.setStoreCode(paramVO.getDemandWhStCode());
            List<AppItmItemPageVO> simpleItem = this.scpCateItemRepoProc.pageAppItemAndWhNetSku(appItemPageParamVO);
            Map simpleItemMap = simpleItem.stream().collect(Collectors.toMap(AppItmItemPageVO::getItemId, Function.identity(), (old, item) -> item));
            ArrayList<AppItmItemPageVO> originItemList = new ArrayList<AppItmItemPageVO>();
            for (ScpStoreCartDO cartDO : allocItemList) {
                AppItmItemPageVO appItmItemPageVO = (AppItmItemPageVO)simpleItemMap.get(cartDO.getItemId());
                AppItemActivityItemPriceParamVO priceParamVO = new AppItemActivityItemPriceParamVO();
                priceParamVO.setItemCode(cartDO.getItemCode());
                priceParamVO.setItemId(cartDO.getItemId());
                priceParamVO.setItemCateCode(cartDO.getItemCateCode());
                priceParamVO.setUom(cartDO.getUom());
                priceParamVO.setCombineItemCode(cartDO.getCombineItemCode());
                priceParamVO.setCombineItemFlag(cartDO.getCombineItemFlag());
                priceParamVO.setItemType2(appItmItemPageVO == null ? cartDO.getItemType2() : appItmItemPageVO.getItemType2());
                priceParamVO.setActivityCode(cartDO.getActivityCode());
                AppItmItemPageVO item2 = new AppItmItemPageVO();
                item2.setItemId(cartDO.getItemId());
                item2.setItemCode(cartDO.getItemCode());
                item2.setItemType2(appItmItemPageVO == null ? cartDO.getItemType2() : appItmItemPageVO.getItemType2());
                originItemList.add(item2);
            }
            Map<String, Boolean> calendarLimitMap = this.setStoreDemandCalendarLimit(paramVO.getDemandWhStCode(), originItemList, scpManType);
            HashSet paramItemInfo = new HashSet();
            cartDataList.stream().filter(item -> item.getActivityCode() != null).forEach(item -> paramItemInfo.add(SysUtils.generateRedisKey("SKU", item.getCombineItemCode(), item.getItemCode(), item.getActivityCode())));
            for (ScpStoreCartDO item3 : allocItemList) {
                Boolean calendarLimit = (Boolean)calendarLimitMap.get(item3.getItemCode());
                if (calendarLimit == null || calendarLimit.booleanValue()) {
                    log.info("\u95e8\u5e97:{}\u5546\u54c1:{}\u7684\u5f3a\u914d\u88ab\u8ba2\u8d27\u65e5\u5386\u9650\u5236\uff0c\u4e0d\u9700\u8981\u68c0\u9a8c", (Object)demandWhStCode, (Object)item3.getItemCode());
                    continue;
                }
                String key = SysUtils.generateRedisKey("SKU", item3.getCombineItemCode(), item3.getItemCode(), item3.getActivityCode());
                allocSettingMap.put(key, item3);
                if (paramItemInfo.contains(key)) continue;
                throw new BusinessException("\u7f3a\u5c11\u5f3a\u914d\u5546\u54c1\uff0c\u8bf7\u5237\u65b0\u8d2d\u7269\u8f66");
            }
        }
        List<ScpStoreCartDO> dataList = CollUtil.isNotEmpty(allocItemInfo = cartDataList.stream().filter(item -> item.getActivityCode() != null).collect(Collectors.toList())) ? cartDataList.stream().filter(item -> {
            String key;
            ScpStoreCartDO scpAllocSettingItemRespVO;
            if (item.getActivityCode() != null && (scpAllocSettingItemRespVO = (ScpStoreCartDO)allocSettingMap.get(key = SysUtils.generateRedisKey("SKU", item.getCombineItemCode(), item.getItemCode(), item.getActivityCode()))) == null) {
                log.info("\u5546\u54c1:{},\u6d3b\u52a8:{},\u4e0d\u5b58\u5728\u6216\u8005\u4e0d\u9700\u8981\u5f3a\u914d\u6216\u8005\u5f3a\u914d\u5df2\u6ee1\u8db3", (Object)item.getItemCode(), (Object)item.getActivityCode());
                return false;
            }
            return true;
        }).collect(Collectors.toList()) : cartDataList;
        this.checkLimitPurchase(demandWhStCode, orderSetting, dataList);
        AtomicReference stockMapRef = new AtomicReference(new HashMap());
        Map<String, List<ScpWhNetRelationRpcDTO>> whNetMap = this.scpWhNetRelationService.findNewWhNetByParam(demandWhStCode, ScpUdcEnum.DEMAND_SET_TYPE_0.getValueCode(), dataList);
        ArrayList<ItmPriPriceRpcDtoParam> priceParamList = new ArrayList<ItmPriPriceRpcDtoParam>();
        ArrayList<OrderConfirmRespVO> confirmRespVOS = new ArrayList<OrderConfirmRespVO>();
        for (ScpStoreCartDO cartDO : dataList) {
            confirmRespVOS.addAll(this.whnetStrategy(cartDO, orgStore, orderSetting.getWhnetFreightFlag(), whNetMap, priceParamList));
        }
        Map<String, List<OrderConfirmRespVO>> confirmMap = this.buildConfirmMap(confirmRespVOS);
        InvWhItemTotalStkRpcParam stockParam = this.buildStockParam(confirmRespVOS);
        CompletableFuture<Void> future2 = CompletableFuture.runAsync(() -> this.getWhStockMap(stockParam, stockMapRef), (Executor)this.taskExecutor);
        CompletableFuture<Map> future3 = CompletableFuture.supplyAsync(() -> this.getItemMoq(orgStore.getOuCode(), dataList), (Executor)this.taskExecutor);
        CompletableFuture.allOf(future2, future3).join();
        Map itemMoqMap = new HashMap();
        try {
            itemMoqMap = future3.get();
        }
        catch (Exception e) {
            log.info("\u67e5\u8be2\u4ef7\u683c\u548c\u5546\u54c1\u6700\u5c0f\u8d77\u8ba2\u91cf\u62a5\u9519\uff1a{}", (Object)e.getMessage(), (Object)e);
            throw new BusinessException("\u67e5\u8be2\u4ef7\u683c\u548c\u5546\u54c1\u6700\u5c0f\u8d77\u8ba2\u91cf\u62a5\u9519\uff1a" + e.toString());
        }
        Map<String, List<ScpStoreCartDO>> itemMap = dataList.stream().collect(Collectors.groupingBy(ScpStoreCartDO::getSpuCode));
        for (Map.Entry<String, List<ScpStoreCartDO>> entry : itemMap.entrySet()) {
            String spuCode = entry.getKey();
            List<ScpStoreCartDO> list = entry.getValue();
            if (!itemMoqMap.containsKey(spuCode) || list.get(0).getActivityCode() != null) continue;
            ItmItemSpuBusinessRpcDTO itemInfo = (ItmItemSpuBusinessRpcDTO)((List)itemMoqMap.get(spuCode)).get(0);
            BigDecimal totalQty = list.stream().map(ScpStoreCartDO::getQty).reduce(BigDecimal.ZERO, BigDecimal::add);
            if (itemInfo.getMoq() == null || totalQty.compareTo(itemInfo.getMoq()) >= 0) continue;
            throw new BusinessException("\u5546\u54c1\uff1a" + list.get(0).getItemName() + "\u5c0f\u4e8e\u6700\u5c0f\u8d77\u8ba2\u91cf");
        }
        Map stockMap = stockMapRef.get();
        Map<String, List<ScpStoreCartDO>> spuCodeMap = dataList.stream().collect(Collectors.groupingBy(item -> SysUtils.getItemKey(item.getCombineItemCode(), item.getItemCode())));
        ArrayList<ScpDemandOrderDSaveVO> saveVOList = new ArrayList<ScpDemandOrderDSaveVO>();
        AtomicReference<BigDecimal> goodAmt = new AtomicReference<BigDecimal>(BigDecimal.ZERO);
        for (Map.Entry<String, List<ScpStoreCartDO>> entry : spuCodeMap.entrySet()) {
            ScpStoreCartDO first = entry.getValue().get(0);
            CartToOrderSuccessRespVO successVO = new CartToOrderSuccessRespVO();
            successVO.setSpuId(first.getSpuId());
            successVO.setSpuCode(first.getSpuCode());
            successVO.setSpuName(first.getSpuName());
            successVO.setAnotherName(first.getAnotherName());
            successVO.setSpec(first.getSpec());
            successVO.setUrl(first.getUrl());
            successVO.setCombineItemCode(first.getCombineItemCode());
            successVO.setCombineItemName(first.getCombineItemName());
            successVO.setCombineItemFlag(first.getCombineItemFlag());
            ArrayList<CartToOrderSuccessRespVO.ItemSpecObjectVO> itemSpecObjectVOS = new ArrayList<CartToOrderSuccessRespVO.ItemSpecObjectVO>();
            for (ScpStoreCartDO scpCartDO : entry.getValue()) {
                String activityCode = scpCartDO.getActivityCode();
                List<OrderConfirmRespVO> confirmList = confirmMap.get(SysUtils.getItemKey(scpCartDO.getCombineItemCode(), scpCartDO.getItemCode()) + activityCode);
                if (CollUtil.isEmpty(confirmList)) {
                    CartToOrderFailRespVO failVO = new CartToOrderFailRespVO();
                    failVO.setItemCode(scpCartDO.getItemCode());
                    failVO.setItemName(scpCartDO.getItemName());
                    failVO.setMsg("\u5339\u914d\u4e0d\u5230\u4ed3\u5e93\u6216\u4f9b\u5e94\u5546");
                    failList.add(failVO);
                    continue;
                }
                ArrayList<CartToOrderSuccessRespVO.WhAllocObject> whAllocObjects = new ArrayList<CartToOrderSuccessRespVO.WhAllocObject>();
                for (OrderConfirmRespVO orderConfirmRespVO : confirmList) {
                    CartToOrderSuccessRespVO.WhAllocObject whAllocObject = new CartToOrderSuccessRespVO.WhAllocObject();
                    whAllocObject.setPrice(orderConfirmRespVO.getPrice());
                    whAllocObject.setSalePrice(orderConfirmRespVO.getSalePrice());
                    whAllocObject.setSettlementPrice(orderConfirmRespVO.getSettlementPrice());
                    whAllocObject.setSettlementSalePrice(orderConfirmRespVO.getSettlementSalePrice());
                    whAllocObject.setSuppId(orderConfirmRespVO.getSuppId());
                    whAllocObject.setSuppCode(orderConfirmRespVO.getSuppCode());
                    whAllocObject.setSuppName(orderConfirmRespVO.getSuppName());
                    whAllocObject.setTefPrice(orderConfirmRespVO.getTefPrice());
                    whAllocObject.setMefPrice(orderConfirmRespVO.getMefPrice());
                    whAllocObject.setOefPrice(orderConfirmRespVO.getOefPrice());
                    whAllocObject.setIsProjFeeCharged(orderConfirmRespVO.getIsProjFeeCharged());
                    whAllocObject.setTefFeeOuCode(orderConfirmRespVO.getTefFeeOuCode());
                    whAllocObject.setTefFeeOuName(orderConfirmRespVO.getTefFeeOuName());
                    whAllocObject.setOefFeeOuCode(orderConfirmRespVO.getOefFeeOuCode());
                    whAllocObject.setOefFeeOuName(orderConfirmRespVO.getOefFeeOuName());
                    whAllocObject.setMefFeeOuCode(orderConfirmRespVO.getMefFeeOuCode());
                    whAllocObject.setMefFeeOuName(orderConfirmRespVO.getMefFeeOuName());
                    whAllocObject.setRatio(orderConfirmRespVO.getRatio());
                    whAllocObject.setQty(orderConfirmRespVO.getAllocationDeQuantity());
                    whAllocObject.setOuId(orderConfirmRespVO.getOuId());
                    whAllocObject.setOuCode(orderConfirmRespVO.getOuCode());
                    whAllocObject.setOuName(orderConfirmRespVO.getOuName());
                    whAllocObject.setSupplyType(orderConfirmRespVO.getSupplyType());
                    whAllocObject.setSupplyWhCode(orderConfirmRespVO.getSuppWhCode());
                    whAllocObject.setSupplyWhId(orderConfirmRespVO.getSuppWhId());
                    whAllocObject.setSupplyWhName(orderConfirmRespVO.getSuppWhName());
                    whAllocObject.setFreightFlag(orderConfirmRespVO.getFreightFlag());
                    whAllocObject.setFreightRatio(orderConfirmRespVO.getFreightRatio());
                    whAllocObject.setSaleOuCode(orderConfirmRespVO.getSaleOuCode());
                    whAllocObject.setSaleOuName(orderConfirmRespVO.getSaleOuName());
                    whAllocObject.setSaleCustCode(orderConfirmRespVO.getSaleCustCode());
                    if (ScpUdcEnum.SUPPLY_DEMAND_TYPE_WH.getValueCode().equals(whAllocObject.getSupplyType()) && ScpConstant.WH_DELIVERY_TYPES.contains(scpCartDO.getDeliveryType()) && (scpCartDO.getPreSaleStatus() == null || !scpCartDO.getPreSaleStatus().booleanValue())) {
                        if (stockMap != null && stockMap.containsKey(scpCartDO.getItemCode())) {
                            BigDecimal avalQty = (BigDecimal)stockMap.get(scpCartDO.getItemCode());
                            if (whAllocObject.getQty().compareTo(avalQty) > 0) {
                                if (StrUtil.isNotBlank((CharSequence)activityCode)) continue;
                                throw new BusinessException("\u5546\u54c1\u3010" + scpCartDO.getItemName() + "\u3011\u5e93\u5b58\u53ef\u7528\u91cf\u4e3a:" + avalQty + ",\u5e93\u5b58\u4e0d\u8db3");
                            }
                            whAllocObject.setAvalQty(avalQty);
                        } else {
                            if (!StrUtil.isBlank((CharSequence)activityCode)) continue;
                            throw new BusinessException("\u5546\u54c1\u3010" + scpCartDO.getItemName() + "\u3011\u5e93\u5b58\u4e0d\u8db3");
                        }
                    }
                    whAllocObjects.add(whAllocObject);
                    ScpStoreCartServiceImpl.buildSimpleOrderItem(scpCartDO, orderConfirmRespVO, whAllocObject, saveVOList);
                }
                if (CollUtil.isEmpty(whAllocObjects)) continue;
                CartToOrderSuccessRespVO.ItemSpecObjectVO itemSpecObjectVO = new CartToOrderSuccessRespVO.ItemSpecObjectVO();
                itemSpecObjectVO.setItemId(scpCartDO.getItemId());
                itemSpecObjectVO.setItemCode(scpCartDO.getItemCode());
                itemSpecObjectVO.setItemName(scpCartDO.getItemName());
                itemSpecObjectVO.setDemandQuantity(scpCartDO.getQty());
                itemSpecObjectVO.setUom(scpCartDO.getUom());
                itemSpecObjectVO.setUomName(scpCartDO.getUomName());
                itemSpecObjectVO.setUom2(scpCartDO.getUom2());
                itemSpecObjectVO.setUom2Name(scpCartDO.getUom2Name());
                itemSpecObjectVO.setDecimalPlaces(scpCartDO.getDecimalPlaces());
                itemSpecObjectVO.setUomRatio(scpCartDO.getUomRatio());
                itemSpecObjectVO.setItemType(scpCartDO.getItemType());
                itemSpecObjectVO.setDeliveryType(scpCartDO.getDeliveryType());
                itemSpecObjectVO.setItemAttrName(scpCartDO.getItemAttrName());
                itemSpecObjectVO.setActivityCode(activityCode);
                itemSpecObjectVO.setActivityId(scpCartDO.getActivityId());
                itemSpecObjectVO.setPreSaleStatus(scpCartDO.getPreSaleStatus());
                itemSpecObjectVO.setDiscount(scpCartDO.getDiscount());
                itemSpecObjectVO.setMinNum(scpCartDO.getMinNum());
                BigDecimal totalAmt = whAllocObjects.stream().map(CartToOrderSuccessRespVO.WhAllocObject::getAmt).reduce(BigDecimal.ZERO, BigDecimal::add);
                itemSpecObjectVO.setTotalAmt(totalAmt);
                itemSpecObjectVO.setWhAllocObjects(whAllocObjects);
                itemSpecObjectVOS.add(itemSpecObjectVO);
                goodAmt.updateAndGet(v -> SysUtils.processAmtScale(v.add(totalAmt)));
            }
            if (!CollUtil.isNotEmpty(itemSpecObjectVOS)) continue;
            successVO.setItemSpecObjectVOS(itemSpecObjectVOS);
            successList.add(successVO);
        }
        if (CollectionUtils.isNotEmpty(successList) && (optional = successList.stream().flatMap(item -> item.getItemSpecObjectVOS().stream()).flatMap(row -> row.getWhAllocObjects().stream()).filter(d -> ScpUdcEnum.SUPPLY_DEMAND_TYPE_WH.getValueCode().equals(d.getSupplyType())).findFirst()).isPresent()) {
            this.buildGiftItem(orgStore, successList);
        }
        resultVO.setGoodAmt(goodAmt.get());
        resultVO.setSuccess(successList);
        resultVO.setFail(failList);
        resultVO.setAllFailed(successList.isEmpty());
        int itemTypeNum = 0;
        AtomicReference<BigDecimal> qtyTotal = new AtomicReference<BigDecimal>(BigDecimal.ZERO);
        AtomicReference<BigDecimal> amtTotal = new AtomicReference<BigDecimal>(BigDecimal.ZERO);
        for (CartToOrderSuccessRespVO order : successList) {
            for (CartToOrderSuccessRespVO.ItemSpecObjectVO item4 : order.getItemSpecObjectVOS()) {
                ++itemTypeNum;
                qtyTotal.updateAndGet(v -> v.add(item4.getDemandQuantity()));
                amtTotal.updateAndGet(v -> v.add(item4.getTotalAmt()));
            }
        }
        resultVO.setItemTypeNum(itemTypeNum);
        resultVO.setAmtTotal(SysUtils.processAmtScale(amtTotal.get()));
        resultVO.setQtyTotal(qtyTotal.get());
        return resultVO;
    }

    private void buildGiftItem(OrgStoreBaseRpcDTO orgStore, List<CartToOrderSuccessRespVO> successList) {
        List<String> saleOuCodes = this.scpWhNetRelationService.findSaleOuInfo(orgStore.getStoreCode());
        if (CollectionUtils.isEmpty(saleOuCodes)) {
            return;
        }
        MktDiscountGiftRpcBatchParam giftRpcBatchParam = new MktDiscountGiftRpcBatchParam();
        giftRpcBatchParam.setOuCodes(saleOuCodes);
        giftRpcBatchParam.setType("0");
        giftRpcBatchParam.setCustCode(orgStore.getCustCode());
        ArrayList<MktDiscountGiftRpcBatchParam.ItemNumParam> itemNumParams = new ArrayList<MktDiscountGiftRpcBatchParam.ItemNumParam>();
        for (CartToOrderSuccessRespVO cart : successList) {
            List<CartToOrderSuccessRespVO.ItemSpecObjectVO> specObjectVOS = cart.getItemSpecObjectVOS();
            for (CartToOrderSuccessRespVO.ItemSpecObjectVO spec : specObjectVOS) {
                BigDecimal totalQty = spec.getWhAllocObjects().stream().map(CartToOrderSuccessRespVO.WhAllocObject::getQty).reduce(BigDecimal.ZERO, BigDecimal::add);
                MktDiscountGiftRpcBatchParam.ItemNumParam itemNumParam = new MktDiscountGiftRpcBatchParam.ItemNumParam();
                itemNumParam.setItemId(spec.getItemId());
                Long longValue = totalQty.longValue();
                itemNumParam.setNum(longValue);
                itemNumParams.add(itemNumParam);
            }
        }
        giftRpcBatchParam.setItems(itemNumParams);
        List mktDiscountGiftRpcDTOS = (List)this.mktDiscountGiftRpcService.queryAllItemGiftByParam(giftRpcBatchParam).computeData();
        if (CollectionUtils.isNotEmpty((Collection)mktDiscountGiftRpcDTOS) && CollectionUtils.isNotEmpty(mktDiscountGiftRpcDTOS = mktDiscountGiftRpcDTOS.stream().filter(d -> CollectionUtils.isNotEmpty((Collection)d.getGifts())).collect(Collectors.toList()))) {
            Map<Long, List> map = mktDiscountGiftRpcDTOS.stream().collect(Collectors.toMap(MktDiscountGiftRpcDTO::getItemId, MktDiscountGiftRpcDTO::getGifts));
            for (CartToOrderSuccessRespVO cart : successList) {
                List<CartToOrderSuccessRespVO.ItemSpecObjectVO> specObjectVOS = cart.getItemSpecObjectVOS();
                for (CartToOrderSuccessRespVO.ItemSpecObjectVO spec : specObjectVOS) {
                    List giftRpcDTOS = map.get(spec.getItemId());
                    if (!CollectionUtils.isNotEmpty((Collection)giftRpcDTOS)) continue;
                    List<CartToOrderSuccessRespVO.GiftItemVO> itemVOS = giftRpcDTOS.stream().map(gift -> {
                        CartToOrderSuccessRespVO.GiftItemVO giftItemVO = new CartToOrderSuccessRespVO.GiftItemVO();
                        giftItemVO.setDiscountGiftItemId(gift.getItemId());
                        giftItemVO.setDiscountGiftItemCode(gift.getItemCode());
                        giftItemVO.setDiscountGiftItemName(gift.getItemName());
                        giftItemVO.setQty(new BigDecimal(gift.getRealNum()));
                        giftItemVO.setSpuCode(gift.getSpuCode());
                        giftItemVO.setSpuName(gift.getSpuName());
                        giftItemVO.setUrl(gift.getUrl());
                        return giftItemVO;
                    }).collect(Collectors.toList());
                    spec.setGiftItemVOS(itemVOS);
                }
            }
        }
    }

    @Override
    public AiOrderRespVO aiOrder(AIOrderCheckParamVO paramVO) {
        OrderCheckRespVO resultVO = new OrderCheckRespVO();
        ArrayList<CartToOrderSuccessRespVO> successList = new ArrayList<CartToOrderSuccessRespVO>();
        ArrayList<CartToOrderFailRespVO> failList = new ArrayList<CartToOrderFailRespVO>();
        String demandWhStCode = paramVO.getDemandWhStCode();
        OrgStoreBaseRpcDTO orgStore = this.rmiOrgStoreRpcService.getOrgStoreBase(demandWhStCode);
        ScpOrderSettingRespVO orderSetting = this.scpOrderSettingDomainService.findCacheByBusinessType(paramVO.getBusinessType(), ScpUdcEnum.DEMAND_SET_TYPE_0.getValueCode());
        if (orderSetting == null) {
            throw new BusinessException("\u8bf7\u5148\u914d\u7f6e\u6216\u542f\u7528\u5355\u636e\u7c7b\u578b:" + paramVO.getBusinessType());
        }
        Long currentUserId = UserService.currentUserId();
        List<ScpStoreCartDO> dataList = paramVO.getItems();
        if (CollUtil.isEmpty(dataList)) {
            throw new BusinessException("\u6ca1\u6709\u6307\u5b9a\u5546\u54c1");
        }
        this.addAllocSettingItem(currentUserId, demandWhStCode, orderSetting, dataList);
        AtomicReference<Map<String, BigDecimal>> stockMapRef = new AtomicReference<Map<String, BigDecimal>>(new HashMap());
        List<String> itemCodes = dataList.stream().map(ScpStoreCartDO::getItemCode).collect(Collectors.toList());
        Map<String, List<ScpWhNetRelationRpcDTO>> whNetMap = this.scpWhNetRelationService.findNewWhNetByParam(demandWhStCode, ScpUdcEnum.DEMAND_SET_TYPE_0.getValueCode(), dataList);
        Map<String, List<ScpSupplyAllocationRpcDTO>> supplyAllocationMap = this.scpSupplyAllocationService.findSupplyAllocationByParam(demandWhStCode, ScpUdcEnum.DEMAND_SET_TYPE_0.getValueCode(), itemCodes);
        ArrayList<ItmPriPriceRpcDtoParam> priceParamList = new ArrayList<ItmPriPriceRpcDtoParam>();
        ArrayList<OrderConfirmRespVO> confirmRespVOS = new ArrayList<OrderConfirmRespVO>();
        List<String> priorities = Arrays.asList(orderSetting.getFirstPriority(), orderSetting.getSecPriority());
        block2: for (ScpStoreCartDO cartDO : dataList) {
            ArrayList<OrderConfirmRespVO> inConfirmList = new ArrayList<OrderConfirmRespVO>();
            for (String priority : priorities) {
                if (ScpUdcEnum.ORDER_PRIORITY_SUPALLOC.getValueCode().equals(priority)) {
                    inConfirmList.addAll(this.suppAllocStrategy(cartDO, orgStore, orderSetting.getSuppFreightFlag(), supplyAllocationMap, priceParamList, stockMapRef));
                } else if (ScpUdcEnum.ORDER_PRIORITY_WHNET.getValueCode().equals(priority)) {
                    inConfirmList.addAll(this.whnetStrategy(cartDO, orgStore, orderSetting.getWhnetFreightFlag(), whNetMap, priceParamList));
                }
                if (inConfirmList.isEmpty()) continue;
                confirmRespVOS.addAll(inConfirmList);
                continue block2;
            }
        }
        Map<String, List<OrderConfirmRespVO>> confirmMap = this.buildConfirmMap(confirmRespVOS);
        InvWhItemTotalStkRpcParam stockParam = this.buildStockParam(confirmRespVOS);
        CompletableFuture<List> future1 = CompletableFuture.supplyAsync(() -> {
            if (CollUtil.isEmpty((Collection)priceParamList)) {
                return new ArrayList();
            }
            return this.rmiPriceRpcService.findPriceByParam(priceParamList);
        }, (Executor)this.taskExecutor);
        CompletableFuture<Void> future2 = CompletableFuture.runAsync(() -> this.getWhStockMap(stockParam, stockMapRef), (Executor)this.taskExecutor);
        CompletableFuture<Map> future3 = CompletableFuture.supplyAsync(() -> this.getItemMoq(orgStore.getOuCode(), dataList), (Executor)this.taskExecutor);
        CompletableFuture.allOf(future1, future2, future3).join();
        ArrayList<PriPriceRpcDTO> priceList = new ArrayList();
        Map itemMoqMap = new HashMap();
        try {
            priceList = future1.get();
            itemMoqMap = future3.get();
        }
        catch (Exception e) {
            log.info("\u67e5\u8be2\u4ef7\u683c\u548c\u5546\u54c1\u6700\u5c0f\u8d77\u8ba2\u91cf\u62a5\u9519\uff1a{}", (Throwable)e);
            throw new BusinessException("\u67e5\u8be2\u4ef7\u683c\u548c\u5546\u54c1\u6700\u5c0f\u8d77\u8ba2\u91cf\u62a5\u9519\uff1a" + e.toString());
        }
        Map<String, List<ScpStoreCartDO>> itemMap = dataList.stream().collect(Collectors.groupingBy(ScpStoreCartDO::getSpuCode));
        for (Map.Entry<String, List<ScpStoreCartDO>> entry : itemMap.entrySet()) {
            String spuCode = entry.getKey();
            List<ScpStoreCartDO> list = entry.getValue();
            if (!itemMoqMap.containsKey(spuCode) || list.get(0).getActivityCode() != null) continue;
            ItmItemSpuBusinessRpcDTO itemInfo = (ItmItemSpuBusinessRpcDTO)((List)itemMoqMap.get(spuCode)).get(0);
            BigDecimal totalQty = list.stream().map(ScpStoreCartDO::getQty).collect(Collectors.reducing(BigDecimal.ZERO, BigDecimal::add));
            if (itemInfo.getMoq() == null || totalQty.compareTo(itemInfo.getMoq()) >= 0) continue;
            throw new BusinessException("\u5546\u54c1\uff1a" + list.get(0).getItemName() + "\u5c0f\u4e8e\u6700\u5c0f\u8d77\u8ba2\u91cf");
        }
        Map<String, List<PriPriceRpcDTO>> priceMap = this.buildPriceMap(priceList, priceParamList);
        Map<String, BigDecimal> stockMap = stockMapRef.get();
        Map<String, List<ScpStoreCartDO>> spuCodeMap = dataList.stream().collect(Collectors.groupingBy(ScpStoreCartDO::getSpuCode));
        ArrayList<ScpDemandOrderDSaveVO> saveVOList = new ArrayList<ScpDemandOrderDSaveVO>();
        AtomicReference<BigDecimal> goodAmt = new AtomicReference<BigDecimal>(BigDecimal.ZERO);
        for (Map.Entry<String, List<ScpStoreCartDO>> entry : spuCodeMap.entrySet()) {
            ScpStoreCartDO first = entry.getValue().get(0);
            CartToOrderSuccessRespVO successVO = new CartToOrderSuccessRespVO();
            successVO.setSpuId(first.getSpuId());
            successVO.setSpuCode(first.getSpuCode());
            successVO.setSpuName(first.getSpuName());
            successVO.setAnotherName(first.getAnotherName());
            successVO.setSpec(first.getSpec());
            successVO.setUrl(first.getUrl());
            ArrayList<CartToOrderSuccessRespVO.ItemSpecObjectVO> itemSpecObjectVOS = new ArrayList<CartToOrderSuccessRespVO.ItemSpecObjectVO>();
            for (ScpStoreCartDO scpCartDO : entry.getValue()) {
                Object activityCode;
                String itemCode = scpCartDO.getItemCode();
                List<OrderConfirmRespVO> confirmList = confirmMap.get(itemCode + (String)(activityCode = scpCartDO.getActivityCode()));
                if (CollUtil.isEmpty(confirmList)) {
                    CartToOrderFailRespVO failVO = new CartToOrderFailRespVO();
                    failVO.setItemCode(scpCartDO.getItemCode());
                    failVO.setItemName(scpCartDO.getItemName());
                    failVO.setMsg("\u5339\u914d\u4e0d\u5230\u4ed3\u5e93\u6216\u4f9b\u5e94\u5546");
                    failList.add(failVO);
                    continue;
                }
                ArrayList<CartToOrderSuccessRespVO.WhAllocObject> whAllocObjects = new ArrayList<CartToOrderSuccessRespVO.WhAllocObject>();
                for (OrderConfirmRespVO orderConfirmRespVO : confirmList) {
                    CartToOrderSuccessRespVO.WhAllocObject whAllocObject = new CartToOrderSuccessRespVO.WhAllocObject();
                    String ouCode = orderConfirmRespVO.getSaleOuCode();
                    if (StrUtil.isBlank((CharSequence)ouCode)) {
                        whAllocObject.setItemPrice(BigDecimal.ZERO);
                    } else {
                        List<PriPriceRpcDTO> priceRpcDTOS = priceMap.get(orderConfirmRespVO.getItemCode() + "@" + (String)ouCode);
                        if (CollUtil.isNotEmpty(priceRpcDTOS)) {
                            whAllocObject.setItemPrice(priceRpcDTOS.get(0).getPrice());
                        } else {
                            log.info("\u8be5\u5546\u54c1\u65e0\u4ef7\u683c, \u7f16\u7801:{},\u540d\u79f0:{}", (Object)itemCode, (Object)scpCartDO.getItemName());
                            CartToOrderFailRespVO failVO = new CartToOrderFailRespVO();
                            failVO.setItemCode(scpCartDO.getItemCode());
                            failVO.setItemName(scpCartDO.getItemName());
                            failVO.setMsg("\u8be5\u5546\u54c1\u65e0\u4ef7\u683c");
                            failList.add(failVO);
                            continue;
                        }
                    }
                    whAllocObject.setRatio(orderConfirmRespVO.getRatio());
                    whAllocObject.setQty(orderConfirmRespVO.getAllocationDeQuantity());
                    whAllocObject.setOuId(orderConfirmRespVO.getOuId());
                    whAllocObject.setOuCode(orderConfirmRespVO.getOuCode());
                    whAllocObject.setOuName(orderConfirmRespVO.getOuName());
                    whAllocObject.setSupplyType(orderConfirmRespVO.getSupplyType());
                    whAllocObject.setSupplyWhCode(orderConfirmRespVO.getSuppWhCode());
                    whAllocObject.setSupplyWhId(orderConfirmRespVO.getSuppWhId());
                    whAllocObject.setSupplyWhName(orderConfirmRespVO.getSuppWhName());
                    whAllocObject.setFreightFlag(orderConfirmRespVO.getFreightFlag());
                    whAllocObject.setFreightRatio(orderConfirmRespVO.getFreightRatio());
                    whAllocObject.setSaleOuCode(orderConfirmRespVO.getSaleOuCode());
                    whAllocObject.setSaleOuName(orderConfirmRespVO.getSaleOuName());
                    whAllocObject.setSaleCustCode(orderConfirmRespVO.getSaleCustCode());
                    if (ScpUdcEnum.SUPPLY_DEMAND_TYPE_WH.getValueCode().equals(whAllocObject.getSupplyType()) && (scpCartDO.getPreSaleStatus() == null || !scpCartDO.getPreSaleStatus().booleanValue())) {
                        if (stockMap != null && stockMap.containsKey(scpCartDO.getItemCode())) {
                            BigDecimal avalQty = stockMap.get(scpCartDO.getItemCode());
                            if (whAllocObject.getQty().compareTo(avalQty) > 0) {
                                if (StrUtil.isNotBlank((CharSequence)activityCode)) continue;
                                throw new BusinessException("\u5546\u54c1\u3010" + scpCartDO.getItemName() + "\u3011\u5e93\u5b58\u53ef\u7528\u91cf\u4e3a:" + avalQty + ",\u5e93\u5b58\u4e0d\u8db3");
                            }
                            whAllocObject.setAvalQty(avalQty);
                        } else {
                            if (!StrUtil.isBlank((CharSequence)activityCode)) continue;
                            throw new BusinessException("\u5546\u54c1\u3010" + scpCartDO.getItemName() + "\u3011\u5e93\u5b58\u4e0d\u8db3");
                        }
                    }
                    whAllocObjects.add(whAllocObject);
                    ScpStoreCartServiceImpl.buildSimpleOrderItem(scpCartDO, orderConfirmRespVO, whAllocObject, saveVOList);
                }
                if (CollUtil.isEmpty(whAllocObjects)) continue;
                CartToOrderSuccessRespVO.ItemSpecObjectVO itemSpecObjectVO = new CartToOrderSuccessRespVO.ItemSpecObjectVO();
                itemSpecObjectVO.setItemId(scpCartDO.getItemId());
                itemSpecObjectVO.setItemCode(scpCartDO.getItemCode());
                itemSpecObjectVO.setItemName(scpCartDO.getItemName());
                itemSpecObjectVO.setDemandQuantity(scpCartDO.getQty());
                itemSpecObjectVO.setUom(scpCartDO.getUom());
                itemSpecObjectVO.setUomName(scpCartDO.getUomName());
                itemSpecObjectVO.setUom2(scpCartDO.getUom2());
                itemSpecObjectVO.setUom2Name(scpCartDO.getUom2Name());
                itemSpecObjectVO.setDecimalPlaces(scpCartDO.getDecimalPlaces());
                itemSpecObjectVO.setUomRatio(scpCartDO.getUomRatio());
                itemSpecObjectVO.setItemType(scpCartDO.getItemType());
                itemSpecObjectVO.setItemAttrName(scpCartDO.getItemAttrName());
                itemSpecObjectVO.setActivityCode((String)activityCode);
                itemSpecObjectVO.setActivityId(scpCartDO.getActivityId());
                itemSpecObjectVO.setPreSaleStatus(scpCartDO.getPreSaleStatus());
                itemSpecObjectVO.setMinNum(scpCartDO.getMinNum());
                BigDecimal totalAmt = whAllocObjects.stream().map(CartToOrderSuccessRespVO.WhAllocObject::getAmt).reduce(BigDecimal.ZERO, BigDecimal::add);
                itemSpecObjectVO.setTotalAmt(totalAmt);
                itemSpecObjectVO.setWhAllocObjects(whAllocObjects);
                itemSpecObjectVOS.add(itemSpecObjectVO);
                goodAmt.updateAndGet(v -> SysUtils.processAmtScale(v.add(totalAmt)));
            }
            if (!CollUtil.isNotEmpty(itemSpecObjectVOS)) continue;
            successVO.setItemSpecObjectVOS(itemSpecObjectVOS);
            successList.add(successVO);
        }
        if (CollUtil.isNotEmpty(saveVOList)) {
            this.buildFreightItem(saveVOList, resultVO, successList);
        }
        resultVO.setGoodAmt(goodAmt.get());
        resultVO.setSuccess(successList);
        resultVO.setFail(failList);
        resultVO.setAllFailed(successList.size() == 0);
        Integer itemTypeNum = 0;
        AtomicReference<BigDecimal> qtyTotal = new AtomicReference<BigDecimal>(BigDecimal.ZERO);
        AtomicReference<BigDecimal> amtTotal = new AtomicReference<BigDecimal>(BigDecimal.ZERO);
        for (CartToOrderSuccessRespVO order : successList) {
            for (CartToOrderSuccessRespVO.ItemSpecObjectVO item : order.getItemSpecObjectVOS()) {
                itemTypeNum = itemTypeNum + 1;
                qtyTotal.updateAndGet(v -> v.add(item.getDemandQuantity()));
                amtTotal.updateAndGet(v -> v.add(item.getTotalAmt()));
            }
        }
        resultVO.setItemTypeNum(itemTypeNum);
        resultVO.setAmtTotal(SysUtils.processAmtScale(amtTotal.get()));
        resultVO.setQtyTotal(qtyTotal.get());
        if (CollectionUtil.isNotEmpty(resultVO.getFail())) {
            throw new BusinessException(resultVO.getFail().get(0).getItemName() + "  " + resultVO.getFail().get(0).getMsg());
        }
        ScpDemandOrderSubmitVO submitVO = new ScpDemandOrderSubmitVO();
        submitVO.setWithoutCart(true);
        ScpDemandSetParamVO orderSetParam = ScpDemandSetParamVO.builder().build();
        orderSetParam.setIsPushed(false);
        orderSetParam.setType("0");
        orderSetParam.setStatus(true);
        orderSetParam.setDemandDate(LocalDateTime.now().toLocalDate().atStartOfDay());
        List<ScpDemandSetSelectRespVO> orderSetList = this.scpDemandOrderSetService.demandSetSelectList(orderSetParam);
        if (CollectionUtil.isEmpty(orderSetList)) {
            throw new BusinessException("\u672a\u627e\u5230\u6709\u6548\u7684\u8ba2\u8d27\u96c6");
        }
        ScpDemandSetSelectRespVO demandOrderSet = null;
        ScpDemandOrderDomainService scpDemandOrderDomainService = (ScpDemandOrderDomainService)SpringUtil.getBean(ScpDemandOrderDomainService.class);
        for (ScpDemandSetSelectRespVO scpDemandSetSelectRespVO : orderSetList) {
            ScpDemandOrderParamVO newParamVO = ScpDemandOrderParamVO.builder().demandCode(scpDemandSetSelectRespVO.getDemandCode()).businessType(paramVO.getBusinessType()).demandWhStCode(paramVO.getDemandWhStCode()).build();
            List<ScpDemandOrderDTO> demandOrderByParam = scpDemandOrderDomainService.findDemandOrderByParam(newParamVO);
            if (!CollectionUtil.isEmpty(demandOrderByParam)) continue;
            demandOrderSet = scpDemandSetSelectRespVO;
            break;
        }
        if (demandOrderSet == null) {
            throw new BusinessException("\u8ba2\u8d27\u96c6\u5df2\u521b\u5efa\u8ba2\u8d27\u5355\uff0c\u8bf7\u521b\u5efa\u65b0\u7684\u8ba2\u8d27\u96c6");
        }
        submitVO.setDemandId(demandOrderSet.getId());
        submitVO.setDemandCode(demandOrderSet.getDemandCode());
        submitVO.setDemandName(demandOrderSet.getDemandName());
        submitVO.setDocCls("ST");
        submitVO.setType("0");
        submitVO.setDemandDate(demandOrderSet.getDemandDate());
        submitVO.setDocType(paramVO.getDocType());
        submitVO.setBusinessType(paramVO.getBusinessType());
        BeanUtil.copyProperties((Object)paramVO, (Object)submitVO, (boolean)true);
        ArrayList<ScpDemandOrderDSubmitVO> submitItemList = new ArrayList<ScpDemandOrderDSubmitVO>();
        Map<String, List<CartToOrderSuccessRespVO>> spuMap = resultVO.getSuccess().stream().collect(Collectors.groupingBy(i -> i.getSpuCode()));
        for (CartToOrderSuccessRespVO spuVo : resultVO.getSuccess()) {
            ScpDemandOrderDSubmitVO scpDemandOrderDSubmitVO = new ScpDemandOrderDSubmitVO();
            BeanUtil.copyProperties((Object)spuVo, (Object)scpDemandOrderDSubmitVO, (boolean)true);
            submitItemList.add(scpDemandOrderDSubmitVO);
            ArrayList<ScpDemandOrderDSubmitVO.ItemSpecObjectVO> itemSpecObjectVOS = new ArrayList<ScpDemandOrderDSubmitVO.ItemSpecObjectVO>();
            scpDemandOrderDSubmitVO.setItemSpecObjectVOS(itemSpecObjectVOS);
            for (CartToOrderSuccessRespVO.ItemSpecObjectVO specObjectVO : spuVo.getItemSpecObjectVOS()) {
                ScpDemandOrderDSubmitVO.ItemSpecObjectVO itemSpecVo = new ScpDemandOrderDSubmitVO.ItemSpecObjectVO();
                BeanUtil.copyProperties((Object)specObjectVO, (Object)itemSpecVo, (boolean)true);
                itemSpecObjectVOS.add(itemSpecVo);
                ArrayList<ScpDemandOrderDSubmitVO.WhAllocObject> whAllocObjects = new ArrayList<ScpDemandOrderDSubmitVO.WhAllocObject>();
                itemSpecVo.setWhAllocObjects(whAllocObjects);
                for (CartToOrderSuccessRespVO.WhAllocObject sourceWhObj : specObjectVO.getWhAllocObjects()) {
                    ScpDemandOrderDSubmitVO.WhAllocObject targetWhObj = new ScpDemandOrderDSubmitVO.WhAllocObject();
                    BeanUtil.copyProperties((Object)sourceWhObj, (Object)targetWhObj, (boolean)true);
                    whAllocObjects.add(targetWhObj);
                }
            }
        }
        submitVO.setItemList(submitItemList);
        AppDemandOrderService appDemandOrderService = (AppDemandOrderService)SpringUtil.getBean(AppDemandOrderService.class);
        long orderId = appDemandOrderService.submit(submitVO);
        Optional<ScpDemandOrderRespVO> demandOrder = this.scpDemandOrderService.findDemandOrderById(orderId);
        AiOrderRespVO respVO = new AiOrderRespVO();
        respVO.setOrderId(orderId);
        respVO.setDocNo(demandOrder.get().getDocCode());
        respVO.setTotalAmt(demandOrder.get().getAmt());
        return respVO;
    }

    @Override
    public void changeSelectedStatusAll(CartChangeSelectedStatusAllParamVO paramVO) {
        Long currentUserId = UserService.currentUserId();
        List<ScpStoreCartDO> cartItems = this.cartRedisUtil.getStoreCartItems(paramVO.getDemandWhStCode(), paramVO.getCartType(), currentUserId);
        BoundHashOperations<String, Object, Object> cartOps = this.cartRedisUtil.getStoreCartOps(paramVO.getDemandWhStCode(), paramVO.getCartType(), currentUserId);
        cartItems.forEach(row -> {
            String activityCode = row.getActivityCode();
            if (activityCode == null) {
                row.setSelectedStatus(paramVO.getStatus());
                String redisValue = JSON.toJSONString((Object)row);
                cartOps.put((Object)SysUtils.generateRedisKey("SKU", row.getCombineItemCode(), row.getItemCode()), (Object)redisValue);
            }
        });
    }

    private void addAllocSettingItem(Long currentUserId, String demandWhStCode, ScpOrderSettingRespVO orderSetting, List<ScpStoreCartDO> dataList) {
        List itemTypes = StrUtil.split((CharSequence)orderSetting.getDeliveryType(), (CharSequence)",");
        List<ScpAllocSettingItemRespVO> allocSettingItemList = this.scpAllocSettingItemDomainService.getEnableAllocSettingItemByStoreCode(demandWhStCode, orderSetting.getBusinessType(), itemTypes);
        List itemCodeList = allocSettingItemList.stream().map(ScpAllocSettingItemRespVO::getItemCode).filter(Objects::nonNull).collect(Collectors.toList());
        if (CollUtil.isEmpty(itemCodeList)) {
            return;
        }
        ItmItemScpBaseRpcParam param = new ItmItemScpBaseRpcParam();
        param.setItemCodes(itemCodeList);
        param.setBusinessBuCode(demandWhStCode);
        List<ItmItemScpBaseRpcDTO> itemList = this.rmiItemService.findItemScpBaseRpcDtoByParam(param);
        if (CollUtil.isEmpty(itemList)) {
            return;
        }
        Map allocSettingItemRespVOMap = allocSettingItemList.stream().collect(Collectors.toMap(ScpAllocSettingItemRespVO::getItemCode, Function.identity()));
        CopyOnWriteArrayList appItmItemPageVOS = CollUtil.newCopyOnWriteArrayList(new ArrayList());
        List<AppItmItemPageVO> inList = itemList.stream().map(t -> {
            AppItmItemPageVO appItmItemPageVO = new AppItmItemPageVO();
            if (Objects.equals(t.getItemType(), ScpUdcEnum.ITM_ITM_TYPE_70.getValueCode())) {
                ScpAllocSettingItemRespVO row2 = (ScpAllocSettingItemRespVO)allocSettingItemRespVOMap.get(t.getItemCode());
                appItmItemPageVO.setItemCode(t.getItemCode());
                appItmItemPageVO.setItemCateCode(t.getItemCateCode());
                appItmItemPageVO.setUom(t.getUom2());
                appItmItemPageVO.setItemId(t.getId());
                appItmItemPageVO.setItemType2(t.getItemType2());
                appItmItemPageVO.setCombineItemFlag(false);
                if (row2 != null) {
                    appItmItemPageVO.setActivityCode(row2.getActivityCode());
                }
                List subItems = t.getSubItems();
                ArrayList<AppItmItemPageVO> details = new ArrayList<AppItmItemPageVO>();
                subItems.forEach(subItem -> {
                    AppItmItemPageVO a = new AppItmItemPageVO();
                    ScpAllocSettingItemRespVO row = (ScpAllocSettingItemRespVO)allocSettingItemRespVOMap.get(subItem.getItemCode());
                    a.setItemCode(subItem.getItemCode());
                    a.setItemCateCode(subItem.getItemCateCode());
                    a.setUom(subItem.getUom2());
                    a.setItemId(subItem.getId());
                    a.setItemType2(subItem.getItemType2());
                    a.setCombineItemFlag(true);
                    a.setCombineItemCode(t.getItemCode());
                    if (row != null) {
                        a.setActivityCode(row.getActivityCode());
                    }
                    details.add(a);
                });
                appItmItemPageVO.setDetails(details);
            } else {
                ScpAllocSettingItemRespVO row = (ScpAllocSettingItemRespVO)allocSettingItemRespVOMap.get(t.getItemCode());
                appItmItemPageVO.setItemCode(t.getItemCode());
                appItmItemPageVO.setItemCateCode(t.getItemCateCode());
                appItmItemPageVO.setUom(t.getUom2());
                appItmItemPageVO.setItemId(t.getId());
                appItmItemPageVO.setItemType2(t.getItemType2());
                appItmItemPageVO.setCombineItemFlag(false);
                if (row != null) {
                    appItmItemPageVO.setActivityCode(row.getActivityCode());
                }
                ArrayList<AppItmItemPageVO> details = new ArrayList<AppItmItemPageVO>();
                AppItmItemPageVO a = new AppItmItemPageVO();
                BeanUtils.copyProperties((Object)appItmItemPageVO, (Object)a, (String[])new String[0]);
                details.add(a);
                appItmItemPageVO.setDetails(details);
            }
            return appItmItemPageVO;
        }).toList();
        appItmItemPageVOS.addAll(inList);
        this.appItemActivityService.getPriceAndStock(orderSetting.getBusinessType(), appItmItemPageVOS, demandWhStCode, ScpUdcEnum.DEMAND_SET_TYPE_0.getValueCode());
        log.info("\u5f3a\u914d\u5546\u54c1\u4ef7\u683c\u548c\u5e93\u5b58{}", (Object)JSONUtil.toJsonStr((Object)appItmItemPageVOS));
        Map priceMap = appItmItemPageVOS.stream().collect(Collectors.toMap(AppItmItemPageVO::getItemCode, Function.identity(), (t1, t2) -> t1));
        ArrayList<ScpStoreCartDO> allocItemList = new ArrayList<ScpStoreCartDO>();
        for (ItmItemScpBaseRpcDTO itmItemBaseRpcDTO : itemList) {
            AppItmItemPageVO appItemPriceRespVO;
            if (Objects.equals(itmItemBaseRpcDTO.getItemType(), ScpUdcEnum.ITM_ITM_TYPE_70.getValueCode())) {
                List subItems = itmItemBaseRpcDTO.getSubItems();
                ScpAllocSettingItemRespVO row = (ScpAllocSettingItemRespVO)allocSettingItemRespVOMap.get(itmItemBaseRpcDTO.getItemCode());
                appItemPriceRespVO = (AppItmItemPageVO)priceMap.get(itmItemBaseRpcDTO.getItemCode());
                if (ScpConstant.WH_DELIVERY_TYPES.contains(itmItemBaseRpcDTO.getItemType2()) && (appItemPriceRespVO.getAvalQty() == null || BigDecimal.ZERO.compareTo(appItemPriceRespVO.getAvalQty()) >= 0)) continue;
                List<AppItmItemPageVO> details = appItemPriceRespVO.getDetails();
                Map<Object, Object> subPriceMap = CollUtil.isNotEmpty(details) ? details.stream().collect(Collectors.toMap(AppItmItemPageVO::getItemCode, Function.identity(), (t1, t2) -> t1)) : new HashMap();
                subItems.forEach(subItem -> {
                    AppItmItemPageVO appItemPriceRespVO2 = (AppItmItemPageVO)subPriceMap.get(itmItemBaseRpcDTO.getItemCode());
                    ScpStoreCartDO storeCartDO = new ScpStoreCartDO();
                    storeCartDO.setUserId(currentUserId);
                    storeCartDO.setDemandWhStCode(demandWhStCode);
                    storeCartDO.setQty(row.getMinNum().multiply(subItem.getBomQty()));
                    storeCartDO.setActivityCode(row.getActivityCode());
                    storeCartDO.setActivityId(row.getMasId());
                    storeCartDO.setUom(subItem.getUom2());
                    storeCartDO.setUomName(subItem.getUom2Name());
                    storeCartDO.setCombineItemCode(itmItemBaseRpcDTO.getItemCode());
                    storeCartDO.setCombineItemName(itmItemBaseRpcDTO.getItemName());
                    storeCartDO.setCombineItemFlag(true);
                    storeCartDO.setItemId(subItem.getId());
                    storeCartDO.setItemCode(subItem.getItemCode());
                    storeCartDO.setItemName(subItem.getItemName());
                    storeCartDO.setAnotherName(subItem.getAnotherName());
                    storeCartDO.setUom(subItem.getUom2());
                    storeCartDO.setUomName(subItem.getUom2Name());
                    storeCartDO.setSpuId(subItem.getSpuId());
                    storeCartDO.setSpuCode(subItem.getSpuCode());
                    storeCartDO.setSpuName(subItem.getSpuName());
                    storeCartDO.setSpec(subItem.getSpec());
                    storeCartDO.setSelectedStatus(1);
                    storeCartDO.setUom2(subItem.getUom2());
                    storeCartDO.setUom2Name(subItem.getUom2Name());
                    storeCartDO.setUomRatio(subItem.getUomRatio2());
                    storeCartDO.setDecimalPlaces(subItem.getDecimalPlaces());
                    storeCartDO.setItemType(subItem.getItemType2());
                    storeCartDO.setItemType2(subItem.getItemType2());
                    storeCartDO.setItemAttrName(subItem.getItemAttrName());
                    storeCartDO.setItemCateCode(subItem.getItemCateCode());
                    storeCartDO.setMinNum(row.getMinNum().multiply(subItem.getBomQty()));
                    storeCartDO.setDeliveryType(subItem.getItemType2());
                    storeCartDO.setUrl(row.getImgUrl());
                    this.getPrice(appItemPriceRespVO2, storeCartDO);
                    if (storeCartDO.getPrice() != null) {
                        allocItemList.add(storeCartDO);
                    }
                });
                continue;
            }
            AppItmItemPageVO appItemPriceRespVO2 = (AppItmItemPageVO)priceMap.get(itmItemBaseRpcDTO.getItemCode());
            List<AppItmItemPageVO> details = appItemPriceRespVO2.getDetails();
            appItemPriceRespVO = details.get(0);
            if (ScpConstant.WH_DELIVERY_TYPES.contains(itmItemBaseRpcDTO.getItemType2()) && (appItemPriceRespVO.getAvalQty() == null || BigDecimal.ZERO.compareTo(appItemPriceRespVO.getAvalQty()) >= 0)) continue;
            ScpAllocSettingItemRespVO row = (ScpAllocSettingItemRespVO)allocSettingItemRespVOMap.get(itmItemBaseRpcDTO.getItemCode());
            ScpStoreCartDO storeCartDO = new ScpStoreCartDO();
            storeCartDO.setUserId(currentUserId);
            storeCartDO.setDemandWhStCode(demandWhStCode);
            storeCartDO.setItemId(itmItemBaseRpcDTO.getId());
            storeCartDO.setItemCode(itmItemBaseRpcDTO.getItemCode());
            storeCartDO.setItemName(itmItemBaseRpcDTO.getItemName());
            storeCartDO.setAnotherName(itmItemBaseRpcDTO.getAnotherName());
            storeCartDO.setUom(itmItemBaseRpcDTO.getUom2());
            storeCartDO.setUomName(itmItemBaseRpcDTO.getUom2Name());
            storeCartDO.setSpuId(itmItemBaseRpcDTO.getSpuId());
            storeCartDO.setSpuCode(itmItemBaseRpcDTO.getSpuCode());
            storeCartDO.setSpuName(itmItemBaseRpcDTO.getSpuName());
            storeCartDO.setSpec(itmItemBaseRpcDTO.getSpec());
            storeCartDO.setQty(row.getMinNum());
            storeCartDO.setSelectedStatus(1);
            storeCartDO.setUom2(itmItemBaseRpcDTO.getUom2());
            storeCartDO.setUom2Name(itmItemBaseRpcDTO.getUom2Name());
            storeCartDO.setUomRatio(itmItemBaseRpcDTO.getUomRatio2());
            storeCartDO.setDecimalPlaces(itmItemBaseRpcDTO.getDecimalPlaces());
            storeCartDO.setItemType(itmItemBaseRpcDTO.getItemType2());
            storeCartDO.setItemType2(itmItemBaseRpcDTO.getItemType2());
            storeCartDO.setItemAttrName(itmItemBaseRpcDTO.getItemAttrName());
            storeCartDO.setActivityCode(row.getActivityCode());
            storeCartDO.setActivityId(row.getMasId());
            storeCartDO.setItemCateCode(itmItemBaseRpcDTO.getItemCateCode());
            storeCartDO.setMinNum(row.getMinNum());
            storeCartDO.setDeliveryType(itmItemBaseRpcDTO.getItemType2());
            storeCartDO.setUrl(row.getImgUrl());
            storeCartDO.setCombineItemFlag(false);
            this.getPrice(appItemPriceRespVO, storeCartDO);
            if (storeCartDO.getPrice() == null) continue;
            allocItemList.add(storeCartDO);
        }
        log.info("\u95e8\u5e97:{},\u5f3a\u914d\u6dfb\u52a0\u5546\u54c1\u4fe1\u606f:{}", (Object)demandWhStCode, (Object)JSONUtil.toJsonStr(allocItemList));
        dataList.addAll(allocItemList);
    }

    private List<AppItmItemPageVO> getDetails(List<ItmItemScpBaseRpcDTO> source, String storeCode, String cartType, Long currentUserId, ItmItemScpBaseRpcDTO parentItem) {
        return source.stream().map(itmItemRpcDTO -> {
            AppItmItemPageVO t = new AppItmItemPageVO();
            t.setItemName(itmItemRpcDTO.getItemName());
            t.setUom(itmItemRpcDTO.getUom2());
            t.setUomName(itmItemRpcDTO.getUom2Name());
            t.setItemType(itmItemRpcDTO.getItemType());
            t.setItemType2(itmItemRpcDTO.getItemType2());
            t.setItemTypeName(itmItemRpcDTO.getItemTypeName());
            t.setItemType2Name(itmItemRpcDTO.getItemType2Name());
            t.setBrand(itmItemRpcDTO.getBrand());
            t.setBrandName(itmItemRpcDTO.getBrandName());
            t.setItemAttr2(itmItemRpcDTO.getItemAttr2());
            t.setSpec(itmItemRpcDTO.getSpec());
            t.setItemCateCode(itmItemRpcDTO.getItemCateCode());
            t.setItemCateName(itmItemRpcDTO.getItemCateFullName());
            t.setSpuId(itmItemRpcDTO.getSpuId());
            t.setSpuCode(itmItemRpcDTO.getSpuCode());
            t.setSpuName(itmItemRpcDTO.getSpuName());
            if (StrUtil.isNotBlank((CharSequence)cartType)) {
                ScpStoreCartDO storeCartItem = this.cartRedisUtil.getStoreCartItem(SysUtils.getItemKey(parentItem.getItemCode(), itmItemRpcDTO.getItemCode()), storeCode, cartType, currentUserId);
                if (storeCartItem != null) {
                    t.setQty(storeCartItem.getQty());
                } else {
                    t.setQty(BigDecimal.ZERO);
                }
            }
            t.setItemAttrName(StrUtil.isBlank((CharSequence)itmItemRpcDTO.getItemAttrName()) ? itmItemRpcDTO.getSpec() : itmItemRpcDTO.getItemAttrName());
            t.setAnotherName(itmItemRpcDTO.getAnotherName());
            t.setItemImageList(AppItmItemConvert.INSTANCE.attachmentRpcDtoToProviderDtoList(itmItemRpcDTO.getSpuAttchmentList()));
            t.setItemId(itmItemRpcDTO.getId());
            t.setItemCode(itmItemRpcDTO.getItemCode());
            t.setUom2(itmItemRpcDTO.getUom());
            t.setUom2Name(itmItemRpcDTO.getUomName());
            t.setDecimalPlaces(itmItemRpcDTO.getDecimalPlaces());
            t.setUomRatio(itmItemRpcDTO.getUomRatio2());
            t.setReceiveUom(itmItemRpcDTO.getReceiveUom());
            t.setReceiveUomRatio(itmItemRpcDTO.getReceiveUomRatio());
            t.setReceiveUomName(itmItemRpcDTO.getReceiveUomName());
            t.setMoq(itmItemRpcDTO.getMoq());
            t.setPrice(itmItemRpcDTO.getPrice());
            t.setCombineQty(itmItemRpcDTO.getBomQty());
            if (itmItemRpcDTO.getBomPid() != null) {
                t.setCombineItemFlag(Boolean.TRUE);
                t.setCombineItemCode(parentItem.getItemCode());
                t.setCombineItemName(parentItem.getItemName());
            } else {
                t.setCombineItemFlag(Boolean.FALSE);
            }
            return t;
        }).collect(Collectors.toList());
    }

    private void checkLimitPurchase(String demandWhStCode, ScpOrderSettingRespVO orderSetting, List<ScpStoreCartDO> dataList) {
        List itemTypes = StrUtil.split((CharSequence)orderSetting.getDeliveryType(), (CharSequence)",");
        List<ScpPurLimitSettingItemRespVO> allocSettingItemList = this.scpPurLimitSettingItemDomainService.getEnablePurLimitSettingItemByStoreCode(demandWhStCode, itemTypes);
        Map<Long, BigDecimal> purLimitMap = allocSettingItemList.stream().collect(Collectors.toMap(ScpPurLimitSettingItemRespVO::getItemId, ScpPurLimitSettingItemRespVO::getMinNum, (k1, k2) -> k1));
        if (CollUtil.isEmpty(purLimitMap)) {
            return;
        }
        Map<Long, BigDecimal> longBigDecimalMap = this.scpDemandOrderRepoProc.countAllocatedOrderItemByItemCodes(new ArrayList<Long>(purLimitMap.keySet()), demandWhStCode, LocalDateTime.now());
        log.info("\u9650\u8d2d\u67e5\u8be2\u7ed3\u679c\uff1a{}", longBigDecimalMap);
        if (CollUtil.isEmpty(dataList)) {
            dataList.forEach(item -> {
                BigDecimal canUseQty;
                Long itemId = item.getItemId();
                BigDecimal orderQty = item.getQty();
                BigDecimal purLimitQty = (BigDecimal)purLimitMap.get(itemId);
                BigDecimal useQty = BigDecimal.ZERO;
                if (longBigDecimalMap != null) {
                    BigDecimal bigDecimal = useQty = longBigDecimalMap.get(itemId) == null ? BigDecimal.ZERO : (BigDecimal)longBigDecimalMap.get(itemId);
                }
                if (purLimitQty != null && orderQty != null && (canUseQty = purLimitQty.subtract(useQty).subtract(orderQty)).compareTo(BigDecimal.ZERO) <= 0) {
                    throw new BusinessException("\u5546\u54c1\uff1a" + item.getItemName() + "\u9650\u8d2d\u6570\u91cf\u4e0d\u8db3,\u53ef\u7528\u4f59\u91cf\uff1a0");
                }
            });
        }
    }

    private Map<String, List<ItmItemSpuBusinessRpcDTO>> getItemMoq(String storeOuCode, List<ScpStoreCartDO> dataList) {
        List<String> spuCodes = dataList.stream().map(ScpStoreCartDO::getSpuCode).distinct().collect(Collectors.toList());
        Map<String, List<ItmItemSpuBusinessRpcDTO>> moqMap = this.rmiItemService.findMoqByParam(spuCodes, storeOuCode);
        return moqMap;
    }

    private InvWhItemTotalStkRpcParam buildStockParam(List<OrderConfirmRespVO> confirmRespVOS) {
        if (CollUtil.isNotEmpty(confirmRespVOS)) {
            List itemIds = confirmRespVOS.stream().filter(row -> ScpUdcEnum.SUPPLY_DEMAND_TYPE_WH.getValueCode().equals(row.getSupplyType())).map(OrderConfirmRespVO::getItemId).filter(Objects::nonNull).distinct().collect(Collectors.toList());
            List whIds = confirmRespVOS.stream().filter(row -> ScpUdcEnum.SUPPLY_DEMAND_TYPE_WH.getValueCode().equals(row.getSupplyType())).map(OrderConfirmRespVO::getSuppWhId).filter(Objects::nonNull).distinct().collect(Collectors.toList());
            if (CollUtil.isEmpty(itemIds) || CollUtil.isEmpty(whIds)) {
                log.info("\u67e5\u8be2\u5e93\u5b58\u5546\u54c1\u6216\u8005\u4ed3\u5e93\u4e3a\u7a7a\uff0c\u65e0\u9700\u67e5\u8be2");
                return null;
            }
            InvWhItemTotalStkRpcParam invWhItemTotalStkRpcParam = new InvWhItemTotalStkRpcParam();
            invWhItemTotalStkRpcParam.setItemIds(itemIds);
            invWhItemTotalStkRpcParam.setWhIds(whIds);
            invWhItemTotalStkRpcParam.setExcludeDeter2Types(List.of(InvDeter2TypeEnum.TRANS.getType()));
            return invWhItemTotalStkRpcParam;
        }
        return null;
    }

    private void getWhStockMap(InvWhItemTotalStkRpcParam stkRpcParam, AtomicReference<Map<String, BigDecimal>> stockMap) {
        if (stkRpcParam == null) {
            return;
        }
        List<InvWhItemTotalStkRpcDTO> invWhItemTotalStkRpcDTOS = this.rmiInvStkRpcService.queryInvWhItemTotalStk(stkRpcParam);
        if (CollUtil.isEmpty(invWhItemTotalStkRpcDTOS)) {
            return;
        }
        for (InvWhItemTotalStkRpcDTO dto : invWhItemTotalStkRpcDTOS) {
            stockMap.updateAndGet(currentMap -> {
                currentMap.put(dto.getItemCode(), dto.getAvalQty2());
                return currentMap;
            });
        }
    }

    private void buildFreightItem(List<ScpDemandOrderDSaveVO> saveVOList, OrderCheckRespVO resultVO, List<CartToOrderSuccessRespVO> successList) {
        ArrayList<CartToOrderSuccessRespVO> freightItemList = new ArrayList<CartToOrderSuccessRespVO>();
        String itemCode = SysUtils.getOrderItemSetting();
        String orderItemImgUrlSetting = SysUtils.getOrderItemImgUrlSetting();
        ItmItemBaseRpcParam itmItemBaseRpcParam = new ItmItemBaseRpcParam();
        itmItemBaseRpcParam.setItemCodes(Arrays.asList(itemCode));
        List<ItmItemBaseRpcDTO> itemBaseRpcDTOList = this.rmiItemService.findItemBaseRpcDtoByParam(itmItemBaseRpcParam);
        if (CollUtil.isEmpty(itemBaseRpcDTOList)) {
            throw new BusinessException("\u8fd0\u8d39\u5546\u54c1\u7f16\u7801\uff1a" + itemCode + "\u4e0d\u5b58\u5728");
        }
        ItmItemBaseRpcDTO shipmentItem = itemBaseRpcDTOList.get(0);
        Map<String, List<ScpDemandOrderDSaveVO>> whCodeMap = saveVOList.stream().collect(Collectors.groupingBy(row -> row.getSuppWhCode()));
        BigDecimal freightAmt = BigDecimal.ZERO;
        for (Map.Entry<String, List<ScpDemandOrderDSaveVO>> entry : whCodeMap.entrySet()) {
            List<ScpDemandOrderDSaveVO> list = entry.getValue();
            CartToOrderSuccessRespVO successVO = new CartToOrderSuccessRespVO();
            CartToOrderSuccessRespVO.ItemSpecObjectVO itemSpecObjectVO = new CartToOrderSuccessRespVO.ItemSpecObjectVO();
            CartToOrderSuccessRespVO.WhAllocObject whAllocObject = new CartToOrderSuccessRespVO.WhAllocObject();
            ScpDemandOrderDSaveVO oldSaveVO = list.get(0);
            BigDecimal amt = list.stream().filter(row -> row.getPlanAmt() != null).map(ScpDemandOrderDSaveVO::getPlanAmt).collect(Collectors.reducing(BigDecimal.ZERO, BigDecimal::add));
            whAllocObject.setItemPrice(SysUtils.processAmtScale(amt));
            whAllocObject.setRatio(oldSaveVO.getRatio());
            whAllocObject.setQty(BigDecimal.ONE);
            whAllocObject.setOuId(oldSaveVO.getOuId());
            whAllocObject.setOuCode(oldSaveVO.getOuCode());
            whAllocObject.setOuName(oldSaveVO.getOuName());
            whAllocObject.setSupplyType(oldSaveVO.getSupplyType());
            whAllocObject.setSupplyWhCode(oldSaveVO.getSuppWhCode());
            whAllocObject.setSupplyWhId(oldSaveVO.getSuppWhId());
            whAllocObject.setSupplyWhName(oldSaveVO.getSuppWhName());
            whAllocObject.setFreightFlag(oldSaveVO.getFreightFlag());
            whAllocObject.setFreightRatio(oldSaveVO.getFreightRatio());
            whAllocObject.setSaleOuCode(oldSaveVO.getSaleOuCode());
            whAllocObject.setSaleOuName(oldSaveVO.getSaleOuName());
            whAllocObject.setSaleCustCode(oldSaveVO.getSaleCustCode());
            List<CartToOrderSuccessRespVO.WhAllocObject> whAllocObjects = List.of(whAllocObject);
            itemSpecObjectVO.setItemId(shipmentItem.getId());
            itemSpecObjectVO.setItemCode(shipmentItem.getItemCode());
            itemSpecObjectVO.setItemName(shipmentItem.getItemName());
            itemSpecObjectVO.setDemandQuantity(BigDecimal.ONE);
            itemSpecObjectVO.setUom(shipmentItem.getUom2());
            itemSpecObjectVO.setUomName(shipmentItem.getUom2Name());
            itemSpecObjectVO.setUom2(shipmentItem.getUom());
            itemSpecObjectVO.setUom2Name(shipmentItem.getUomName());
            itemSpecObjectVO.setDecimalPlaces(shipmentItem.getDecimalPlaces());
            itemSpecObjectVO.setUomRatio(shipmentItem.getUomRatio2());
            itemSpecObjectVO.setItemType(shipmentItem.getItemType2());
            itemSpecObjectVO.setItemAttrName(shipmentItem.getItemAttrName());
            itemSpecObjectVO.setTotalAmt(whAllocObject.getItemPrice());
            itemSpecObjectVO.setWhAllocObjects(whAllocObjects);
            List<CartToOrderSuccessRespVO.ItemSpecObjectVO> itemSpecObjectVOS = List.of(itemSpecObjectVO);
            successVO.setSpuId(shipmentItem.getSpuId());
            successVO.setSpuCode(shipmentItem.getSpuCode());
            successVO.setSpuName(shipmentItem.getSpuName());
            successVO.setAnotherName(shipmentItem.getAnotherName());
            successVO.setSpec(shipmentItem.getSpec());
            successVO.setUrl(orderItemImgUrlSetting);
            if (CollUtil.isNotEmpty(itemSpecObjectVOS)) {
                successVO.setItemSpecObjectVOS(itemSpecObjectVOS);
                freightItemList.add(successVO);
            }
            freightAmt = SysUtils.processAmtScale(freightAmt.add(amt));
        }
        resultVO.setFreightAmt(freightAmt);
        successList.addAll(freightItemList);
    }

    private static void buildSimpleOrderItem(ScpStoreCartDO scpCartDO, OrderConfirmRespVO orderConfirmRespVO, CartToOrderSuccessRespVO.WhAllocObject whAllocObject, List<ScpDemandOrderDSaveVO> saveVOList) {
        ScpDemandOrderDSaveVO scpDemandOrderDSaveVO = new ScpDemandOrderDSaveVO();
        scpDemandOrderDSaveVO.setAllocationDeQuantity(whAllocObject.getQty());
        scpDemandOrderDSaveVO.setRatio(whAllocObject.getRatio());
        scpDemandOrderDSaveVO.setSupplyType(whAllocObject.getSupplyType());
        scpDemandOrderDSaveVO.setSuppWhId(whAllocObject.getSupplyWhId());
        scpDemandOrderDSaveVO.setSuppWhCode(whAllocObject.getSupplyWhCode());
        scpDemandOrderDSaveVO.setSuppWhName(whAllocObject.getSupplyWhName());
        scpDemandOrderDSaveVO.setDemandQuantity(whAllocObject.getQty());
        scpDemandOrderDSaveVO.setPrice(whAllocObject.getItemPrice());
        scpDemandOrderDSaveVO.setOuId(whAllocObject.getOuId());
        scpDemandOrderDSaveVO.setOuCode(whAllocObject.getOuCode());
        scpDemandOrderDSaveVO.setOuName(whAllocObject.getOuName());
        scpDemandOrderDSaveVO.setIsCalculated(Boolean.FALSE);
        scpDemandOrderDSaveVO.setIsPushed(Boolean.FALSE);
        scpDemandOrderDSaveVO.setUom2(scpCartDO.getUom2());
        scpDemandOrderDSaveVO.setUom2Name(scpCartDO.getUom2Name());
        scpDemandOrderDSaveVO.setUomRatio(scpCartDO.getUomRatio());
        if (StrUtil.isBlank((CharSequence)orderConfirmRespVO.getSaleOuCode())) {
            return;
        }
        scpDemandOrderDSaveVO.setPlanAmt(whAllocObject.getAmt());
        scpDemandOrderDSaveVO.setFreightFlag(whAllocObject.getFreightFlag());
        scpDemandOrderDSaveVO.setFreightRatio(whAllocObject.getFreightRatio());
        scpDemandOrderDSaveVO.setSaleCustCode(whAllocObject.getSaleCustCode());
        scpDemandOrderDSaveVO.setSaleOuCode(whAllocObject.getSaleOuCode());
        scpDemandOrderDSaveVO.setSaleOuName(whAllocObject.getSaleOuName());
        scpDemandOrderDSaveVO.setCombineItemName(scpCartDO.getCombineItemName());
        scpDemandOrderDSaveVO.setCombineItemCode(scpCartDO.getCombineItemCode());
        scpDemandOrderDSaveVO.setCombineItemFlag(scpCartDO.getCombineItemFlag());
        saveVOList.add(scpDemandOrderDSaveVO);
    }

    private Map<String, List<PriPriceRpcDTO>> buildPriceMap(List<PriPriceRpcDTO> priceList, List<ItmPriPriceRpcDtoParam> priceParamList) {
        if (CollUtil.isEmpty(priceList)) {
            this.getBasePrice(priceParamList, priceList);
            if (CollUtil.isEmpty(priceList)) {
                return new HashMap<String, List<PriPriceRpcDTO>>();
            }
        } else {
            Map<String, List<PriPriceRpcDTO>> inPriceMap = priceList.stream().collect(Collectors.groupingBy(PriPriceRpcDTO::getItemCode));
            priceParamList.removeAll(priceParamList.stream().filter(row -> inPriceMap.containsKey(row.getItemCode())).collect(Collectors.toList()));
            this.getBasePrice(priceParamList, priceList);
        }
        return priceList.stream().collect(Collectors.groupingBy(row -> row.getItemCode() + "@" + row.getOuCode()));
    }

    private void getBasePrice(List<ItmPriPriceRpcDtoParam> priceParamList, List<PriPriceRpcDTO> priceList) {
        if (CollUtil.isEmpty(priceParamList)) {
            return;
        }
        List<Long> itemIds = priceParamList.stream().map(ItmPriPriceRpcDtoParam::getItemId).distinct().collect(Collectors.toList());
        Map<Long, ItmItemSimpleRpcDTO> simpleItemMap = this.rmiItemService.findBaseItemMap(itemIds);
        List<ItmPriPriceRpcDtoParam> baseUomList = priceParamList.stream().map(row -> {
            ItmPriPriceRpcDtoParam param = (ItmPriPriceRpcDtoParam)BeanUtils.copyProperties((Object)row, ItmPriPriceRpcDtoParam.class, (String[])new String[0]);
            ItmItemSimpleRpcDTO simpleItem = (ItmItemSimpleRpcDTO)simpleItemMap.get(row.getItemId());
            param.setUom(simpleItem.getUom());
            return param;
        }).collect(Collectors.toList());
        List<PriPriceRpcDTO> basePriceList = this.rmiPriceRpcService.findPriceByParam(baseUomList);
        log.info("\u67e5\u8be2\u57fa\u672c\u5355\u4f4d\u4ef7\u683c:{}", (Object)JSONUtil.toJsonStr(basePriceList));
        if (CollUtil.isNotEmpty(basePriceList)) {
            List resultPriceList = basePriceList.stream().map(row -> {
                PriPriceRpcDTO priPriceRpcDTO = (PriPriceRpcDTO)BeanUtils.copyProperties((Object)row, PriPriceRpcDTO.class, (String[])new String[0]);
                ItmItemSimpleRpcDTO simpleItem = (ItmItemSimpleRpcDTO)simpleItemMap.get(row.getItemId());
                if (simpleItem.getUomRatio2() == null) {
                    return null;
                }
                if (simpleItem.getDecimalPlaces() != null) {
                    priPriceRpcDTO.setPrice(row.getPrice().multiply(simpleItem.getUomRatio2()).setScale((int)simpleItem.getDecimalPlaces(), 4));
                } else {
                    priPriceRpcDTO.setPrice(row.getPrice().multiply(simpleItem.getUomRatio2()));
                }
                return priPriceRpcDTO;
            }).filter(Objects::nonNull).collect(Collectors.toList());
            priceList.addAll(resultPriceList);
        }
    }

    private Map<String, List<OrderConfirmRespVO>> buildConfirmMap(List<OrderConfirmRespVO> confirmList) {
        if (CollUtil.isEmpty(confirmList)) {
            return new HashMap<String, List<OrderConfirmRespVO>>();
        }
        return confirmList.stream().collect(Collectors.groupingBy(row -> SysUtils.getItemKey(row.getCombineItemCode(), row.getItemCode()) + row.getActivityCode()));
    }

    private List<OrderConfirmRespVO> suppAllocStrategy(ScpStoreCartDO cartDO, OrgStoreBaseRpcDTO orgStore, Boolean freightFlag, Map<String, List<ScpSupplyAllocationRpcDTO>> supplyAllocationMap, List<ItmPriPriceRpcDtoParam> priceParamList, AtomicReference<Map<String, BigDecimal>> stockMap) {
        ArrayList<OrderConfirmRespVO> result = new ArrayList<OrderConfirmRespVO>();
        List<ScpSupplyAllocationRpcDTO> suppAllocList = supplyAllocationMap.get(cartDO.getItemCode());
        log.info("\u4f9b\u5e94\u5546\u914d\u989d\u67e5\u8be2\u7ed3\u679c:{}", (Object)JSONUtil.toJsonStr(suppAllocList));
        if (CollUtil.isEmpty(suppAllocList)) {
            return new ArrayList<OrderConfirmRespVO>();
        }
        for (ScpSupplyAllocationRpcDTO row : suppAllocList) {
            if (StrUtil.isBlank((CharSequence)row.getSaleOuCode())) continue;
            ItmPriPriceRpcDtoParam priceParam = new ItmPriPriceRpcDtoParam();
            priceParam.setPriceCls("INTERNAL_SETTLEMENT_PRICE");
            priceParam.setPriceType("INTERNAL_SETTLEMENT_PRICE");
            priceParam.setItemId(cartDO.getItemId());
            priceParam.setCustCode(row.getSaleCustCode());
            priceParam.setItemCode(cartDO.getItemCode());
            priceParam.setUom(cartDO.getUom());
            priceParam.setCurrCode("CNY");
            priceParam.setOuCode(row.getSaleOuCode());
            priceParamList.add(priceParam);
        }
        int size = suppAllocList.size();
        BigDecimal sum = BigDecimal.ZERO;
        for (int i = 0; i < size; ++i) {
            ScpSupplyAllocationRpcDTO row = suppAllocList.get(i);
            OrderConfirmRespVO orderConfirmRespVO = new OrderConfirmRespVO();
            orderConfirmRespVO.setItemId(cartDO.getItemId());
            orderConfirmRespVO.setItemCode(cartDO.getItemCode());
            orderConfirmRespVO.setItemName(cartDO.getItemName());
            orderConfirmRespVO.setSpuCode(cartDO.getSpuCode());
            orderConfirmRespVO.setSpuId(cartDO.getSpuId());
            orderConfirmRespVO.setSpuName(cartDO.getSpuName());
            orderConfirmRespVO.setUnitName(cartDO.getUomName());
            orderConfirmRespVO.setUnit(cartDO.getUom());
            orderConfirmRespVO.setSuppWhId(row.getSuppId());
            orderConfirmRespVO.setSuppWhCode(row.getSuppCode());
            orderConfirmRespVO.setSuppWhName(row.getSuppName());
            orderConfirmRespVO.setRatio(row.getAllocation());
            orderConfirmRespVO.setCurrency("CNY");
            orderConfirmRespVO.setSupplyType(ScpUdcEnum.SUPPLY_DEMAND_TYPE_SUPP.getValueCode());
            orderConfirmRespVO.setSaleOuCode(row.getSaleOuCode());
            orderConfirmRespVO.setSaleOuName(row.getSaleOuName());
            orderConfirmRespVO.setSaleCustCode(row.getSaleCustCode());
            orderConfirmRespVO.setOuId(row.getOuId());
            orderConfirmRespVO.setOuCode(row.getOuCode());
            orderConfirmRespVO.setOuName(row.getOuName());
            orderConfirmRespVO.setDemandQuantity(cartDO.getQty());
            orderConfirmRespVO.setActivityCode(cartDO.getActivityCode());
            orderConfirmRespVO.setActivityId(cartDO.getActivityId());
            stockMap.updateAndGet(currentMap -> {
                currentMap.put(cartDO.getItemCode(), new BigDecimal("9999"));
                return currentMap;
            });
            if (orgStore.getFreightFlag2().booleanValue() && freightFlag.booleanValue()) {
                orderConfirmRespVO.setFreightFlag(Boolean.TRUE);
                orderConfirmRespVO.setFreightRatio(orgStore.getFreightRatio2());
            } else {
                orderConfirmRespVO.setFreightFlag(Boolean.FALSE);
                orderConfirmRespVO.setFreightRatio(BigDecimal.ZERO);
            }
            if (orderConfirmRespVO.getDemandQuantity() == null) {
                result.add(orderConfirmRespVO);
                continue;
            }
            if (i == size - 1) {
                orderConfirmRespVO.setAllocationDeQuantity(orderConfirmRespVO.getDemandQuantity().subtract(sum));
            } else {
                BigDecimal ratioQty = orderConfirmRespVO.getDemandQuantity().multiply(orderConfirmRespVO.getRatio()).divide(BigDecimal.valueOf(100L), 0, RoundingMode.HALF_DOWN);
                orderConfirmRespVO.setAllocationDeQuantity(ratioQty);
                sum = sum.add(ratioQty);
            }
            result.add(orderConfirmRespVO);
        }
        return result;
    }

    private List<OrderConfirmRespVO> whnetStrategy(ScpStoreCartDO cartDO, OrgStoreBaseRpcDTO orgStore, Boolean freightFlag, Map<String, List<ScpWhNetRelationRpcDTO>> whNetRelationMap, List<ItmPriPriceRpcDtoParam> priceParamList) {
        ArrayList<OrderConfirmRespVO> result = new ArrayList<OrderConfirmRespVO>();
        List<ScpWhNetRelationRpcDTO> whNetRelationRpcDTOList = whNetRelationMap.get(cartDO.getItemCode());
        log.info("\u5546\u54c1\u7f16\u7801\uff1a{},\u4ed3\u7f51\u4f9b\u5e94\u5173\u7cfb\u4fe1\u606f\uff1a{}", (Object)cartDO.getItemCode(), (Object)JSONUtil.toJsonStr(whNetRelationRpcDTOList));
        if (CollUtil.isEmpty(whNetRelationRpcDTOList)) {
            return new ArrayList<OrderConfirmRespVO>();
        }
        for (ScpWhNetRelationRpcDTO row : whNetRelationRpcDTOList) {
            if (StrUtil.isBlank((CharSequence)row.getOuCode())) continue;
            ItmPriPriceRpcDtoParam priceParam = new ItmPriPriceRpcDtoParam();
            priceParam.setPriceCls("INTERNAL_SETTLEMENT_PRICE");
            priceParam.setPriceType("INTERNAL_SETTLEMENT_PRICE");
            priceParam.setItemId(cartDO.getItemId());
            priceParam.setCustCode(row.getCustCode());
            priceParam.setItemCode(cartDO.getItemCode());
            priceParam.setUom(cartDO.getUom());
            priceParam.setCurrCode("CNY");
            priceParam.setOuCode(row.getOuCode());
            priceParamList.add(priceParam);
        }
        int size = whNetRelationRpcDTOList.size();
        BigDecimal sum = BigDecimal.ZERO;
        for (int i = 0; i < size; ++i) {
            ScpWhNetRelationRpcDTO row = whNetRelationRpcDTOList.get(i);
            OrderConfirmRespVO orderConfirmRespVO = new OrderConfirmRespVO();
            orderConfirmRespVO.setItemId(cartDO.getItemId());
            orderConfirmRespVO.setItemCode(cartDO.getItemCode());
            orderConfirmRespVO.setItemName(cartDO.getItemName());
            orderConfirmRespVO.setSpuId(cartDO.getSpuId());
            orderConfirmRespVO.setSpuCode(cartDO.getSpuCode());
            orderConfirmRespVO.setSpuName(cartDO.getSpuName());
            orderConfirmRespVO.setUnitName(cartDO.getUomName());
            orderConfirmRespVO.setUnit(cartDO.getUom());
            orderConfirmRespVO.setSuppWhId(row.getSupplyWhId());
            orderConfirmRespVO.setSuppWhCode(row.getSupplyWhCode());
            orderConfirmRespVO.setSuppWhName(row.getSupplyWhName());
            orderConfirmRespVO.setRatio(row.getSupplyPercentage());
            orderConfirmRespVO.setCurrency("CNY");
            orderConfirmRespVO.setSupplyType(ScpUdcEnum.SUPPLY_DEMAND_TYPE_WH.getValueCode());
            orderConfirmRespVO.setDemandQuantity(cartDO.getQty());
            orderConfirmRespVO.setSaleOuName(row.getOuName());
            orderConfirmRespVO.setSaleOuCode(row.getOuCode());
            orderConfirmRespVO.setSaleCustCode(row.getCustCode());
            orderConfirmRespVO.setOuCode(row.getPurCompanyCode());
            orderConfirmRespVO.setOuName(row.getPurCompanyName());
            orderConfirmRespVO.setActivityCode(cartDO.getActivityCode());
            orderConfirmRespVO.setActivityId(cartDO.getActivityId());
            orderConfirmRespVO.setSuppId(cartDO.getSuppId());
            orderConfirmRespVO.setSuppCode(cartDO.getSuppCode());
            orderConfirmRespVO.setSuppName(cartDO.getSuppName());
            orderConfirmRespVO.setPrice(cartDO.getPrice());
            orderConfirmRespVO.setSalePrice(cartDO.getSalePrice());
            orderConfirmRespVO.setSettlementPrice(cartDO.getSettlementPrice());
            orderConfirmRespVO.setSettlementSalePrice(cartDO.getSettlementSalePrice());
            orderConfirmRespVO.setTefPrice(cartDO.getTefPrice());
            orderConfirmRespVO.setMefPrice(cartDO.getMefPrice());
            orderConfirmRespVO.setOefPrice(cartDO.getOefPrice());
            orderConfirmRespVO.setIsProjFeeCharged(cartDO.getIsProjFeeCharged());
            orderConfirmRespVO.setTefFeeOuCode(cartDO.getTefFeeOuCode());
            orderConfirmRespVO.setTefFeeOuName(cartDO.getTefFeeOuName());
            orderConfirmRespVO.setOefFeeOuCode(cartDO.getOefFeeOuCode());
            orderConfirmRespVO.setOefFeeOuName(cartDO.getOefFeeOuName());
            orderConfirmRespVO.setMefFeeOuCode(cartDO.getMefFeeOuCode());
            orderConfirmRespVO.setMefFeeOuName(cartDO.getMefFeeOuName());
            orderConfirmRespVO.setCombineItemCode(cartDO.getCombineItemCode());
            orderConfirmRespVO.setCombineItemName(cartDO.getCombineItemName());
            if (orderConfirmRespVO.getDemandQuantity() == null) {
                result.add(orderConfirmRespVO);
                continue;
            }
            if (i == size - 1) {
                orderConfirmRespVO.setAllocationDeQuantity(orderConfirmRespVO.getDemandQuantity().subtract(sum));
            } else {
                BigDecimal ratioQty = orderConfirmRespVO.getDemandQuantity().multiply(orderConfirmRespVO.getRatio()).divide(BigDecimal.valueOf(100L), 0, RoundingMode.HALF_DOWN);
                orderConfirmRespVO.setAllocationDeQuantity(ratioQty);
                sum = sum.add(ratioQty);
            }
            result.add(orderConfirmRespVO);
        }
        return result;
    }

    private static void saveOrUpdateCart(StoreCartSaveVO cartSaveVO, BoundHashOperations<String, Object, Object> cartOps) {
        String product = (String)cartOps.get((Object)SysUtils.generateRedisKey("SKU", cartSaveVO.getCombineItemCode(), cartSaveVO.getItemCode()));
        if (StrUtil.isBlank((CharSequence)product) && cartSaveVO.getQty().compareTo(BigDecimal.ZERO) <= 0) {
            log.error("\u8d2d\u7269\u8f66\u4e2d\u4e0d\u5b58\u5728\u6b64\u5546\u54c1:{}\uff0c\u8f93\u5165\u6570\u91cf\u9700\u8981\u5927\u4e8e\u96f6", (Object)cartSaveVO.getItemCode());
            throw new BusinessException("\u8d2d\u7269\u8f66\u4e2d\u4e0d\u5b58\u5728\u6b64\u5546\u54c1\uff0c\u8f93\u5165\u6570\u91cf\u9700\u8981\u5927\u4e8e\u96f6");
        }
        if (StrUtil.isBlank((CharSequence)product)) {
            ScpStoreCartDO storeCartDO = ScpStoreCartConvert.INSTANCE.saveVoToDo(cartSaveVO);
            storeCartDO.setSelectedStatus(1);
            storeCartDO.setCreateTime(LocalDateTime.now().format(DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss")));
            cartOps.put((Object)SysUtils.generateRedisKey("SKU", cartSaveVO.getCombineItemCode(), cartSaveVO.getItemCode()), (Object)JSON.toJSONString((Object)storeCartDO));
        } else if (cartSaveVO.getQty().compareTo(BigDecimal.ZERO) == 0) {
            cartOps.delete(new Object[]{SysUtils.generateRedisKey("SKU", cartSaveVO.getCombineItemCode(), cartSaveVO.getItemCode())});
        } else {
            ScpStoreCartDO storeCartDO = (ScpStoreCartDO)JSON.parseObject((String)product, ScpStoreCartDO.class);
            storeCartDO.setQty(cartSaveVO.getQty());
            storeCartDO.setMoq(cartSaveVO.getMoq());
            String cartItemJson = JSON.toJSONString((Object)storeCartDO);
            cartOps.put((Object)SysUtils.generateRedisKey("SKU", storeCartDO.getCombineItemCode(), storeCartDO.getItemCode()), (Object)cartItemJson);
        }
    }

    private Map<String, Boolean> setStoreDemandCalendarLimit(String storeCode, List<AppItmItemPageVO> itemList, String scpManType) {
        HashMap<String, Boolean> result = new HashMap<String, Boolean>();
        for (AppItmItemPageVO appItmItemPageVO : itemList) {
            result.put(appItmItemPageVO.getItemCode(), false);
        }
        String invisibleAccount = SysUtils.getInvisibleAccount();
        if (StrUtil.isNotBlank((CharSequence)scpManType) && StrUtil.isNotBlank((CharSequence)invisibleAccount)) {
            List invisibleAccountList = Arrays.stream(invisibleAccount.split(",")).collect(Collectors.toList());
            log.info("\u4e0d\u53ef\u89c1\u8d26\u53f7:{},\u5f53\u524d\u8d26\u53f7:{}", (Object)JSONUtil.toJsonStr(invisibleAccountList), (Object)scpManType);
            if (invisibleAccountList.contains(scpManType)) {
                OrgStoreBaseRpcParam baseRpcParam = new OrgStoreBaseRpcParam();
                baseRpcParam.setStoreCodeList(List.of(storeCode));
                OrgStoreBaseRpcDTO orgStoreBaseRpcDTO = (OrgStoreBaseRpcDTO)((List)this.orgStoreRpcService.findSimpleStoreByParam(baseRpcParam).computeData()).get(0);
                Map<String, List<AppItmItemPageVO>> deliveryTypeAndItemMap = itemList.stream().collect(Collectors.groupingBy(AppItmItemPageVO::getItemType2));
                Map<String, Boolean> canDeliveryMap = this.storeDemandCalendarDomainService.isCanDelivery(storeCode, orgStoreBaseRpcDTO.getRegion(), new ArrayList<String>(deliveryTypeAndItemMap.keySet()));
                log.info("\u5c0f\u7a0b\u5e8f\u53ef\u914d\u9001\u5546\u54c1\u7684\u914d\u9001\u7c7b\u578b:{}", (Object)JSONUtil.toJsonStr(canDeliveryMap));
                for (Map.Entry<String, List<AppItmItemPageVO>> entry : deliveryTypeAndItemMap.entrySet()) {
                    String deliveryType = entry.getKey();
                    List<AppItmItemPageVO> itemList1 = entry.getValue();
                    if (canDeliveryMap != null && canDeliveryMap.get(deliveryType) != null && canDeliveryMap.get(deliveryType).booleanValue()) {
                        for (AppItmItemPageVO appItmItemPageVO : itemList1) {
                            result.put(appItmItemPageVO.getItemCode(), false);
                        }
                        continue;
                    }
                    for (AppItmItemPageVO appItmItemPageVO : itemList1) {
                        result.put(appItmItemPageVO.getItemCode(), true);
                    }
                }
            }
        }
        log.info("\u5c0f\u7a0b\u5e8f\u5546\u54c1\u662f\u5426\u88ab\u9650\u5236:{}", (Object)JSONUtil.toJsonStr(result));
        return result;
    }

    public ScpStoreCartServiceImpl(CartRedisUtil cartRedisUtil, CollectRedisUtil collectRedisUtil, RmiItemService rmiItemService, RmiPriceRpcService rmiPriceRpcService, ScpSupplyAllocationService scpSupplyAllocationService, ScpWhNetRelationService scpWhNetRelationService, RmiOrgStoreRpcService rmiOrgStoreRpcService, CommonPriceService commonPriceService, ScpOrderSettingDomainService scpOrderSettingDomainService, RmiInvStkRpcService rmiInvStkRpcService, ScpAllocSettingItemDomainService scpAllocSettingItemDomainService, ScpPurLimitSettingItemDomainService scpPurLimitSettingItemDomainService, ScpDemandOrderSetService scpDemandOrderSetService, ScpDemandOrderService scpDemandOrderService, ScpDemandOrderRepoProc scpDemandOrderRepoProc, MktDiscountGiftRpcService mktDiscountGiftRpcService, ItmItemRpcService itmItemRpcService, OrgStoreRpcService orgStoreRpcService, ScpServiceConfigService scpServiceConfigService, RmiSysUDCService rmiSysUDCService, AppItemActivityService appItemActivityService, ScpStoreDemandCalendarDomainService storeDemandCalendarDomainService, ScpCateItemRepoProc scpCateItemRepoProc, ScpsmanInfoRepo scpsmanInfoRepo) {
        this.cartRedisUtil = cartRedisUtil;
        this.collectRedisUtil = collectRedisUtil;
        this.rmiItemService = rmiItemService;
        this.rmiPriceRpcService = rmiPriceRpcService;
        this.scpSupplyAllocationService = scpSupplyAllocationService;
        this.scpWhNetRelationService = scpWhNetRelationService;
        this.rmiOrgStoreRpcService = rmiOrgStoreRpcService;
        this.commonPriceService = commonPriceService;
        this.scpOrderSettingDomainService = scpOrderSettingDomainService;
        this.rmiInvStkRpcService = rmiInvStkRpcService;
        this.scpAllocSettingItemDomainService = scpAllocSettingItemDomainService;
        this.scpPurLimitSettingItemDomainService = scpPurLimitSettingItemDomainService;
        this.scpDemandOrderSetService = scpDemandOrderSetService;
        this.scpDemandOrderService = scpDemandOrderService;
        this.scpDemandOrderRepoProc = scpDemandOrderRepoProc;
        this.mktDiscountGiftRpcService = mktDiscountGiftRpcService;
        this.itmItemRpcService = itmItemRpcService;
        this.orgStoreRpcService = orgStoreRpcService;
        this.scpServiceConfigService = scpServiceConfigService;
        this.rmiSysUDCService = rmiSysUDCService;
        this.appItemActivityService = appItemActivityService;
        this.storeDemandCalendarDomainService = storeDemandCalendarDomainService;
        this.scpCateItemRepoProc = scpCateItemRepoProc;
        this.scpsmanInfoRepo = scpsmanInfoRepo;
    }
}

