/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.scp.application.service.mrp;

import cn.hutool.json.JSONUtil;
import com.elitescloud.boot.exception.BusinessException;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.sale2c.dto.Sale2cSoRpcDTO;
import com.elitesland.sale2c.param.Sale2cSoRpcParam;
import com.elitesland.sale2c.service.Sale2cSoRpcService;
import com.elitesland.scp.application.facade.vo.calendar.ScpStoreDemandCalendarPageParamVO;
import com.elitesland.scp.application.facade.vo.calendar.ScpStoreDemandCalendarPageVO;
import com.elitesland.scp.application.facade.vo.param.mrp.ScpThousandUseParam;
import com.elitesland.scp.application.facade.vo.param.mrp.ScpThousandUseRefParam;
import com.elitesland.scp.application.facade.vo.resp.mrp.ScpThousandUseRefVO;
import com.elitesland.scp.application.facade.vo.resp.mrp.ScpThousandUseVO;
import com.elitesland.scp.application.facade.vo.template.DemandOrderDeleteParamVO;
import com.elitesland.scp.application.facade.vo.template.DemandOrderSaveParamVO;
import com.elitesland.scp.application.service.calendar.ScpStoreDemandCalendarService;
import com.elitesland.scp.application.service.mrp.ScpThousandUseService;
import com.elitesland.scp.application.service.template.DemandOrderTemplateService;
import com.elitesland.scp.domain.convert.mrp.ScpThousandUseConvert;
import com.elitesland.scp.domain.convert.mrp.ScpThousandUseRefConvert;
import com.elitesland.scp.domain.entity.mrp.ScpThousandUseDO;
import com.elitesland.scp.domain.entity.mrp.ScpThousandUseRefDO;
import com.elitesland.scp.infr.repo.mrp.ScpThousandUseRefRepo;
import com.elitesland.scp.infr.repo.mrp.ScpThousandUseRefRepoProc;
import com.elitesland.scp.infr.repo.mrp.ScpThousandUseRepo;
import com.elitesland.scp.infr.repo.mrp.ScpThousandUseRepoProc;
import com.elitesland.scp.rmi.RmiItemService;
import com.elitesland.scp.rmi.RmiOrgStoreRpcService;
import com.elitesland.support.provider.item.dto.ItmItemRpcDTO;
import com.elitesland.support.provider.item.param.ItmItemRpcDtoParam;
import com.elitesland.support.provider.org.dto.OrgStoreDetailRpcDTO;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.time.LocalDate;
import java.time.LocalTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Service
public class ScpThousandUseServiceImpl
implements ScpThousandUseService {
    private static final Logger log = LoggerFactory.getLogger(ScpThousandUseServiceImpl.class);
    private final ScpThousandUseRepo scpThousandUseRepo;
    private final ScpThousandUseRepoProc scpThousandUseRepoProc;
    private final ScpThousandUseRefRepo scpThousandUseRefRepo;
    private final ScpThousandUseRefRepoProc scpThousandUseRefRepoProc;
    private final ScpStoreDemandCalendarService scpStoreDemandCalendarService;
    private final RmiOrgStoreRpcService rmiOrgStoreRpcService;
    private final RmiItemService rmiItemService;
    private final DemandOrderTemplateService deemandOrderTemplateService;
    private final Sale2cSoRpcService sale2cSoRpcService;

    @Override
    public PagingVO<ScpThousandUseVO> queryPaging(ScpThousandUseParam param) {
        return this.scpThousandUseRepoProc.queryPaging(param);
    }

    @Override
    public List<ScpThousandUseVO> queryListDynamic(ScpThousandUseParam param) {
        return this.scpThousandUseRepoProc.queryListDynamic(param);
    }

    @Override
    public ScpThousandUseVO queryByKey(Long key) {
        ScpThousandUseDO entity = this.scpThousandUseRepo.findById(key).orElseGet(ScpThousandUseDO::new);
        Assert.notNull((Object)entity.getId(), (String)"\u4e0d\u5b58\u5728");
        ScpThousandUseVO vo = ScpThousandUseConvert.INSTANCE.toVo(entity);
        ScpThousandUseRefParam param = new ScpThousandUseRefParam();
        param.setMasId(key);
        List<ScpThousandUseRefVO> scpThousandUseRefVOS = this.scpThousandUseRefRepoProc.queryListDynamic(param);
        vo.setScpThousandUseRefVOList(scpThousandUseRefVOS);
        return vo;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public Long save(ScpThousandUseParam param) {
        if (CollectionUtils.isEmpty(param.getScpThousandUseRefParamList())) {
            throw new BusinessException("\u5546\u54c1\u4e0d\u80fd\u4e3a\u7a7a");
        }
        Long id = null;
        if (param.getId() == null) {
            ScpThousandUseDO entityDo = ScpThousandUseConvert.INSTANCE.toDo(param);
            ScpThousandUseDO save = (ScpThousandUseDO)this.scpThousandUseRepo.save(entityDo);
            id = save.getId();
            List<ScpThousandUseRefParam> scpThousandUseRefParamList = param.getScpThousandUseRefParamList();
            ArrayList scpThousandUseRefDOList = new ArrayList();
            scpThousandUseRefParamList.stream().forEach(p -> {
                ScpThousandUseRefDO scpThousandUseRefDO = ScpThousandUseRefConvert.INSTANCE.toDo((ScpThousandUseRefParam)((Object)p));
                scpThousandUseRefDO.setMasId(save.getId());
                scpThousandUseRefDOList.add(scpThousandUseRefDO);
            });
            this.scpThousandUseRefRepo.saveAll(scpThousandUseRefDOList);
        } else {
            id = param.getId();
            this.scpThousandUseRefRepoProc.deleteSoftByMasId(Collections.singletonList(param.getId()));
            List<ScpThousandUseRefParam> scpThousandUseRefParamList = param.getScpThousandUseRefParamList();
            ArrayList scpThousandUseRefDOList = new ArrayList();
            scpThousandUseRefParamList.stream().forEach(p -> {
                ScpThousandUseRefDO scpThousandUseRefDO = ScpThousandUseRefConvert.INSTANCE.toDo((ScpThousandUseRefParam)((Object)p));
                scpThousandUseRefDO.setMasId(param.getId());
                if (scpThousandUseRefDO.getAdjustThousNum() == null) {
                    scpThousandUseRefDO.setAdjustThousNum(scpThousandUseRefDO.getEstimateThousNum());
                }
                scpThousandUseRefDOList.add(scpThousandUseRefDO);
            });
            this.scpThousandUseRefRepo.saveAll(scpThousandUseRefDOList);
        }
        if (param.getSubmitFlag() != null && param.getSubmitFlag().booleanValue()) {
            ScpThousandUseVO scpThousandUseVO = this.queryByKey(id);
            ScpThousandUseRefParam scpThousandUseRefParam = new ScpThousandUseRefParam();
            scpThousandUseRefParam.setMasId(id);
            List<ScpThousandUseRefVO> scpThousandUseRefVOS = this.scpThousandUseRefRepoProc.queryListDynamic(scpThousandUseRefParam);
            this.countAndCreatePreModel(Collections.singletonList(scpThousandUseVO), scpThousandUseRefVOS);
        }
        return id;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public ScpThousandUseVO update(ScpThousandUseParam param) {
        ScpThousandUseDO entity = this.scpThousandUseRepo.findById(param.getId()).orElseGet(ScpThousandUseDO::new);
        Assert.notNull((Object)entity.getId(), (String)"\u4e0d\u5b58\u5728");
        ScpThousandUseDO entityDo = ScpThousandUseConvert.INSTANCE.toDo(param);
        entity.copy(entityDo);
        return ScpThousandUseConvert.INSTANCE.toVo((ScpThousandUseDO)this.scpThousandUseRepo.save(entity));
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public long updateByKeyDynamic(ScpThousandUseParam param) {
        ScpThousandUseDO entity = this.scpThousandUseRepo.findById(param.getId()).orElseGet(ScpThousandUseDO::new);
        Assert.notNull((Object)entity.getId(), (String)"\u4e0d\u5b58\u5728");
        long result = this.scpThousandUseRepoProc.updateByKeyDynamic(param);
        return result;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void deleteSoft(List<Long> keys) {
        if (!keys.isEmpty()) {
            this.scpThousandUseRepoProc.deleteSoft(keys);
            this.scpThousandUseRefRepoProc.deleteSoftByMasId(keys);
        }
    }

    @Override
    @Transactional
    public void count() {
        ScpThousandUseParam param = new ScpThousandUseParam();
        List<ScpThousandUseVO> scpThousandUseVOS = this.scpThousandUseRepoProc.queryListDynamic(param);
        if (CollectionUtils.isEmpty(scpThousandUseVOS)) {
            throw new BusinessException("\u5343\u5143\u7528\u91cf\u6570\u636e\u4e0d\u80fd\u4e3a\u7a7a");
        }
        List<Long> idList = scpThousandUseVOS.stream().map(ScpThousandUseVO::getId).collect(Collectors.toList());
        ScpThousandUseRefParam refParam = new ScpThousandUseRefParam();
        refParam.setMasIdList(idList);
        List<ScpThousandUseRefVO> scpThousandUseRefVOS = this.scpThousandUseRefRepoProc.queryListDynamic(refParam);
        this.countAndCreatePreModel(scpThousandUseVOS, scpThousandUseRefVOS);
    }

    @Override
    public void checkData(ScpThousandUseParam param) {
        if (param.getValidDataStart() == null || param.getValidDataEnd() == null) {
            throw new BusinessException("\u6709\u6548\u65e5\u671f\u8d77\u6b62\u4e0d\u80fd\u4e3a\u7a7a");
        }
        param.setCheckFlag(true);
        long count = this.scpThousandUseRepoProc.count(param);
        if (count > 0L) {
            throw new BusinessException("\u5df2\u5b58\u5728\u6709\u6548\u671f\u5185\u7684\u95e8\u5e97");
        }
    }

    private void countAndCreatePreModel(List<ScpThousandUseVO> scpThousandUseVOS, List<ScpThousandUseRefVO> scpThousandUseRefVOS) {
        List<Long> demandIdList;
        List<Long> stWhIdList = scpThousandUseVOS.stream().map(ScpThousandUseVO::getStWhId).collect(Collectors.toList());
        Map<Long, List<ScpThousandUseRefVO>> scpThousandUseRefVOMap = scpThousandUseRefVOS.stream().collect(Collectors.groupingBy(ScpThousandUseRefVO::getStWhId));
        List<String> storeCodes = scpThousandUseVOS.stream().map(ScpThousandUseVO::getStWhCode).distinct().collect(Collectors.toList());
        log.info("\u95e8\u5e97\u7f16\u7801\u96c6\u5408:{}", (Object)JSONUtil.toJsonStr(storeCodes));
        List<OrgStoreDetailRpcDTO> queryByStoreCodes = this.rmiOrgStoreRpcService.queryByStoreCodes(storeCodes);
        Map storeMap = queryByStoreCodes.stream().collect(Collectors.toMap(OrgStoreDetailRpcDTO::getStoreCode, Function.identity()));
        List itemCodeList = scpThousandUseRefVOS.stream().map(ScpThousandUseRefVO::getItemCode).distinct().collect(Collectors.toList());
        ItmItemRpcDtoParam itmItemRpcDtoParam = new ItmItemRpcDtoParam();
        itmItemRpcDtoParam.setItemCodes(itemCodeList);
        List<ItmItemRpcDTO> itemRpcDtoList = this.rmiItemService.findItemRpcDtoByParam(itmItemRpcDtoParam);
        Map itemRpcDTOMap = itemRpcDtoList.stream().collect(Collectors.toMap(ItmItemRpcDTO::getItemCode, Function.identity()));
        LocalDate thirtyDate = LocalDate.now().minusMonths(1L).plusDays(1L);
        Map<String, BigDecimal> storeReceiveAmtMap = this.queryStoreReceiveAmt(storeCodes, thirtyDate);
        ScpStoreDemandCalendarPageParamVO queryParam = new ScpStoreDemandCalendarPageParamVO();
        queryParam.setStartDate(thirtyDate);
        queryParam.setEndDate(LocalDate.now());
        queryParam.setStoreIdList(stWhIdList);
        PagingVO<ScpStoreDemandCalendarPageVO> scpStoreDemandCalendarPageVOPagingVO = this.scpStoreDemandCalendarService.searchPage(queryParam);
        log.info("\u95e8\u5e97\u65e5\u5386\u96c6\u5408:{}", (Object)JSONUtil.toJsonStr(scpStoreDemandCalendarPageVOPagingVO));
        HashMap storeCoefficientMap = new HashMap();
        if (!CollectionUtils.isEmpty((Collection)scpStoreDemandCalendarPageVOPagingVO.getRecords())) {
            List records = scpStoreDemandCalendarPageVOPagingVO.getRecords();
            records.stream().forEach(p -> {
                long w = p.getDayDetails().stream().filter(s -> s.getWorkStatus().equals("W")).count();
                if (!CollectionUtils.isEmpty((Map)storeReceiveAmtMap) && storeReceiveAmtMap.containsKey(p.getStoreCode())) {
                    BigDecimal bigDecimal = (BigDecimal)storeReceiveAmtMap.get(p.getStoreCode());
                    BigDecimal coefficient = bigDecimal.divide(new BigDecimal(w), 4, RoundingMode.HALF_UP).divide(new BigDecimal(1000), 2, RoundingMode.HALF_UP);
                    storeCoefficientMap.put(p.getStoreId(), coefficient);
                }
            });
        }
        if (!CollectionUtils.isEmpty(demandIdList = scpThousandUseVOS.stream().filter(p -> StringUtils.hasText((String)p.getExt1())).map(s -> Long.valueOf(s.getExt1())).collect(Collectors.toList()))) {
            DemandOrderDeleteParamVO demandOrderDeleteParamVO = new DemandOrderDeleteParamVO();
            demandOrderDeleteParamVO.setIds(demandIdList);
            this.deemandOrderTemplateService.delete(demandOrderDeleteParamVO);
        }
        scpThousandUseVOS.stream().forEach(p -> {
            if (storeCoefficientMap.containsKey(p.getStWhId()) && scpThousandUseRefVOMap.containsKey(p.getStWhId())) {
                BigDecimal coefficient = (BigDecimal)storeCoefficientMap.get(p.getStWhId());
                List scpThousandUseRefVOS1 = (List)scpThousandUseRefVOMap.get(p.getStWhId());
                DemandOrderSaveParamVO demandOrderSaveParamVO = new DemandOrderSaveParamVO();
                demandOrderSaveParamVO.setDemandTemName(p.getStWhName() + "\u8ba2\u8d27");
                demandOrderSaveParamVO.setStartDate(p.getValidDataStart());
                demandOrderSaveParamVO.setEndDate(p.getValidDataEnd());
                demandOrderSaveParamVO.setType("0");
                demandOrderSaveParamVO.setDocType("MAIN");
                demandOrderSaveParamVO.setDemandTemStatus(1);
                demandOrderSaveParamVO.setDetailedTime("\u4e00,\u4e8c,\u4e09,\u56db,\u4e94,\u516d,\u65e5");
                DemandOrderSaveParamVO.WhStZoObject whStZoObject = new DemandOrderSaveParamVO.WhStZoObject();
                OrgStoreDetailRpcDTO orgStoreDetailRpcDTO = (OrgStoreDetailRpcDTO)storeMap.get(p.getStWhCode());
                whStZoObject.setWhStZoCode(p.getStWhCode());
                whStZoObject.setWhStZoName(p.getStWhName());
                whStZoObject.setDetailedAddress(orgStoreDetailRpcDTO.getAddressRpcDTO().getDetailAddr());
                whStZoObject.setBelongOuCode(orgStoreDetailRpcDTO.getOuCode());
                whStZoObject.setBelongOuName(orgStoreDetailRpcDTO.getOuName());
                whStZoObject.setBelongOrgCode(orgStoreDetailRpcDTO.getPcode());
                whStZoObject.setBelongOrgName(orgStoreDetailRpcDTO.getPname());
                whStZoObject.setStoreType("DIRECTSALE");
                whStZoObject.setType(0);
                List scpThousandUseRefVOS2 = (List)scpThousandUseRefVOMap.get(p.getStWhId());
                ArrayList<DemandOrderSaveParamVO.ItemObject> itemObjectList = new ArrayList<DemandOrderSaveParamVO.ItemObject>();
                scpThousandUseRefVOS2.forEach(item -> {
                    if (!itemRpcDTOMap.containsKey(item.getItemCode())) {
                        return;
                    }
                    ItmItemRpcDTO itmItemRpcDTO = (ItmItemRpcDTO)itemRpcDTOMap.get(item.getItemCode());
                    DemandOrderSaveParamVO.ItemObject itemObject = new DemandOrderSaveParamVO.ItemObject();
                    itemObject.setItemId(item.getItemId());
                    itemObject.setItemCode(item.getItemCode());
                    itemObject.setItemName(item.getItemName());
                    itemObject.setItemCateCode(itmItemRpcDTO.getItemCateCode());
                    itemObject.setItemCateName(itmItemRpcDTO.getItemCateFullName());
                    itemObject.setItemSpec(item.getItemAttr());
                    itemObject.setBasicUnitMeasure(itmItemRpcDTO.getUom());
                    itemObject.setBasicUnitMeasureName(itmItemRpcDTO.getUomName());
                    BigDecimal ratio = BigDecimal.ZERO;
                    ratio = itmItemRpcDTO.getUom2().equals(itmItemRpcDTO.getUom3()) ? itmItemRpcDTO.getUomRatio3() : itmItemRpcDTO.getUomRatio4();
                    BigDecimal qty = coefficient.multiply(item.getAdjustThousNum()).setScale(0, RoundingMode.HALF_UP);
                    itemObject.setDemandQuantity(qty.multiply(ratio));
                    itemObject.setUom2(itmItemRpcDTO.getUom2());
                    itemObject.setUom2Name(itmItemRpcDTO.getUom2Name());
                    itemObject.setQty2(qty);
                    itemObject.setDecimalPlaces(itmItemRpcDTO.getDecimalPlaces());
                    itemObject.setUomRatio(ratio);
                    itemObjectList.add(itemObject);
                });
                demandOrderSaveParamVO.setItemObjects(itemObjectList);
                demandOrderSaveParamVO.setWhStZoObjects(Collections.singletonList(whStZoObject));
                Long save = this.deemandOrderTemplateService.save(demandOrderSaveParamVO);
                ScpThousandUseParam updateParam = new ScpThousandUseParam();
                updateParam.setId(p.getId());
                updateParam.setExt1(save.toString());
                this.updateByKeyDynamic(updateParam);
            }
        });
    }

    private Map<String, BigDecimal> queryStoreReceiveAmt(List<String> storeCodeList, LocalDate thireDate) {
        Map<String, BigDecimal> storeReceiveAmtMap = new HashMap<String, BigDecimal>();
        Sale2cSoRpcParam param = new Sale2cSoRpcParam();
        param.setStoreCodeList(storeCodeList);
        param.setBusinessDateStart(thireDate.atStartOfDay());
        param.setBusinessDateEnd(LocalDate.now().atTime(LocalTime.MAX));
        param.setDocType("POST");
        List sale2cSoByParamList = (List)this.sale2cSoRpcService.findSale2cSoByParam(param).getData();
        log.info("\u67e5\u8be2\u7684\u96f6\u8d27\u5355\u4e3a{}", (Object)JSONUtil.toJsonStr((Object)sale2cSoByParamList));
        if (!CollectionUtils.isEmpty((Collection)sale2cSoByParamList)) {
            storeReceiveAmtMap = sale2cSoByParamList.stream().filter(dto -> dto.getStoreCode() != null).collect(Collectors.toMap(Sale2cSoRpcDTO::getStoreCode, Sale2cSoRpcDTO::getReceivableAmt, (amt1, amt2) -> amt1.add((BigDecimal)amt2)));
        }
        return storeReceiveAmtMap;
    }

    public ScpThousandUseServiceImpl(ScpThousandUseRepo scpThousandUseRepo, ScpThousandUseRepoProc scpThousandUseRepoProc, ScpThousandUseRefRepo scpThousandUseRefRepo, ScpThousandUseRefRepoProc scpThousandUseRefRepoProc, ScpStoreDemandCalendarService scpStoreDemandCalendarService, RmiOrgStoreRpcService rmiOrgStoreRpcService, RmiItemService rmiItemService, DemandOrderTemplateService deemandOrderTemplateService, Sale2cSoRpcService sale2cSoRpcService) {
        this.scpThousandUseRepo = scpThousandUseRepo;
        this.scpThousandUseRepoProc = scpThousandUseRepoProc;
        this.scpThousandUseRefRepo = scpThousandUseRefRepo;
        this.scpThousandUseRefRepoProc = scpThousandUseRefRepoProc;
        this.scpStoreDemandCalendarService = scpStoreDemandCalendarService;
        this.rmiOrgStoreRpcService = rmiOrgStoreRpcService;
        this.rmiItemService = rmiItemService;
        this.deemandOrderTemplateService = deemandOrderTemplateService;
        this.sale2cSoRpcService = sale2cSoRpcService;
    }
}

