/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.scp.domain.service.alloc;

import cn.hutool.core.collection.CollUtil;
import com.elitescloud.boot.exception.BusinessException;
import com.elitescloud.cloudt.common.annotation.SysCodeProc;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.scp.application.facade.vo.param.alloc.ScpAllocSettingStorePageParamVO;
import com.elitesland.scp.application.facade.vo.param.alloc.ScpAllocSettingStoreParamVO;
import com.elitesland.scp.application.facade.vo.resp.alloc.ScpAllocSettingStoreRespVO;
import com.elitesland.scp.application.facade.vo.save.alloc.ScpAllocSettingStoreSaveVO;
import com.elitesland.scp.domain.convert.alloc.ScpAllocSettingStoreConvert;
import com.elitesland.scp.domain.entity.alloc.ScpAllocSettingDO;
import com.elitesland.scp.domain.entity.alloc.ScpAllocSettingStoreDO;
import com.elitesland.scp.domain.service.alloc.ScpAllocSettingStoreDomainService;
import com.elitesland.scp.infr.repo.alloc.ScpAllocSettingRepo;
import com.elitesland.scp.infr.repo.alloc.ScpAllocSettingStoreRepo;
import com.elitesland.scp.infr.repo.alloc.ScpAllocSettingStoreRepoProc;
import com.elitesland.scp.infr.repo.order.ScpDemandOrderRepoProc;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.persistence.EntityManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class ScpAllocSettingStoreDomainServiceImpl
implements ScpAllocSettingStoreDomainService {
    private static final Logger log = LoggerFactory.getLogger(ScpAllocSettingStoreDomainServiceImpl.class);
    private final EntityManager entityManager;
    private final ScpAllocSettingStoreRepo scpAllocSettingStoreRepo;
    private final ScpAllocSettingRepo scpAllocSettingRepo;
    private final ScpAllocSettingStoreRepoProc scpAllocSettingStoreRepoProc;
    private final ScpDemandOrderRepoProc scpDemandOrderRepoProc;

    @Override
    @SysCodeProc
    public PagingVO<ScpAllocSettingStoreRespVO> page(ScpAllocSettingStorePageParamVO paramVO) {
        long count = this.scpAllocSettingStoreRepoProc.countAllocSettingStore(paramVO);
        if (count > 0L) {
            List<ScpAllocSettingStoreRespVO> storeRespVOList = this.scpAllocSettingStoreRepoProc.queryAllocSettingStore(paramVO);
            return new PagingVO(count, storeRespVOList);
        }
        return new PagingVO();
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void batchSaveAllocSettingStore(List<ScpAllocSettingStoreSaveVO> saveVOS, int batchSize) {
        this.batchInsert(ScpAllocSettingStoreConvert.INSTANCE.saveVosDOS(saveVOS), batchSize);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void deleteByMasId(Long masId) {
        this.scpAllocSettingStoreRepo.deleteByMasId(masId);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void deleteByIds(List<Long> ids) {
        this.scpAllocSettingStoreRepo.deleteByIds(ids);
    }

    @Override
    public List<Long> findMasIdByStoreCode(List<String> storeCodes) {
        return this.scpAllocSettingStoreRepoProc.findMasIdByStoreCodeIn(storeCodes);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void updateAllocNumByParam(List<Long> masIds, String storeCode) {
        this.scpAllocSettingStoreRepo.updateAllocNumByParam(masIds, storeCode);
    }

    @Override
    public List<ScpAllocSettingStoreRespVO> findByParam(ScpAllocSettingStoreParamVO paramVO) {
        return this.scpAllocSettingStoreRepoProc.findByParam(paramVO);
    }

    @Override
    public Long updateAllocSettingStore(ScpAllocSettingStoreSaveVO saveVO) {
        Optional<ScpAllocSettingStoreDO> option = this.scpAllocSettingStoreRepo.findById(saveVO.getId());
        if (option.isEmpty()) {
            throw new BusinessException("\u8ba2\u8d27\u5f3a\u914d\u95e8\u5e97ID\uff1a" + saveVO.getId() + "\u4e0d\u5b58\u5728");
        }
        ScpAllocSettingStoreDO scpAllocSettingDO = option.get();
        ScpAllocSettingStoreConvert.INSTANCE.copySaveParamToDo(saveVO, scpAllocSettingDO);
        return ((ScpAllocSettingStoreDO)this.scpAllocSettingStoreRepo.save(scpAllocSettingDO)).getId();
    }

    @Override
    @SysCodeProc
    public List<ScpAllocSettingStoreRespVO> findByMasId(Long masId) {
        ScpAllocSettingDO activityDO = this.scpAllocSettingRepo.findById(masId).orElseThrow(() -> new BusinessException("\u8ba2\u8d27\u5f3a\u914dID\uff1a" + masId + "\u4e0d\u5b58\u5728"));
        List<ScpAllocSettingStoreDO> settingStoreDOS = this.scpAllocSettingStoreRepo.findByMasId(masId);
        List<String> storeCodeList = settingStoreDOS.stream().map(ScpAllocSettingStoreDO::getStoreCode).toList();
        Map<String, Long> stringLongMap = this.scpDemandOrderRepoProc.countAllocatedOrderByStoreCodeList(storeCodeList, activityDO.getActivityCode(), activityDO.getValidFrom(), activityDO.getValidTo());
        if (CollUtil.isNotEmpty(settingStoreDOS)) {
            ArrayList<ScpAllocSettingStoreRespVO> result = new ArrayList<ScpAllocSettingStoreRespVO>();
            settingStoreDOS.forEach(settingStoreDO -> {
                ScpAllocSettingStoreRespVO scpAllocSettingStoreRespVO = ScpAllocSettingStoreConvert.INSTANCE.doToRespVO((ScpAllocSettingStoreDO)settingStoreDO);
                Long allocNum = (Long)stringLongMap.get(settingStoreDO.getStoreCode());
                scpAllocSettingStoreRespVO.setAllocNum(allocNum == null ? 0 : allocNum.intValue());
                result.add(scpAllocSettingStoreRespVO);
            });
            return result;
        }
        return new ArrayList<ScpAllocSettingStoreRespVO>();
    }

    @Override
    public List<ScpAllocSettingStoreRespVO> findEnabledByParam(ScpAllocSettingStoreParamVO paramVO) {
        return this.scpAllocSettingStoreRepoProc.findEnabledByParam(paramVO);
    }

    public void batchInsert(List<ScpAllocSettingStoreDO> dataList, int batchSize) {
        int index = 0;
        for (ScpAllocSettingStoreDO data : dataList) {
            this.entityManager.persist((Object)data);
            if (batchSize <= 1 || ++index % batchSize != 0) continue;
            this.entityManager.flush();
            this.entityManager.clear();
        }
        if (!dataList.isEmpty()) {
            this.entityManager.flush();
        }
    }

    public ScpAllocSettingStoreDomainServiceImpl(EntityManager entityManager, ScpAllocSettingStoreRepo scpAllocSettingStoreRepo, ScpAllocSettingRepo scpAllocSettingRepo, ScpAllocSettingStoreRepoProc scpAllocSettingStoreRepoProc, ScpDemandOrderRepoProc scpDemandOrderRepoProc) {
        this.entityManager = entityManager;
        this.scpAllocSettingStoreRepo = scpAllocSettingStoreRepo;
        this.scpAllocSettingRepo = scpAllocSettingRepo;
        this.scpAllocSettingStoreRepoProc = scpAllocSettingStoreRepoProc;
        this.scpDemandOrderRepoProc = scpDemandOrderRepoProc;
    }
}

