/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.scp.infr.repo.item;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.util.StrUtil;
import cn.zhxu.bs.util.StringUtils;
import com.elitesland.scp.application.facade.vo.param.app.AppItemPageParamVO;
import com.elitesland.scp.application.facade.vo.param.app.CommonItemPageParamVO;
import com.elitesland.scp.application.facade.vo.param.item.ScpCateItemHotParamVO;
import com.elitesland.scp.application.facade.vo.param.item.ScpCateItemPageParamVO;
import com.elitesland.scp.application.facade.vo.resp.app.AppItmItemPageVO;
import com.elitesland.scp.application.facade.vo.resp.app.ScpCateItemPageVO;
import com.elitesland.scp.application.facade.vo.resp.app.ScpCateItemRespVO;
import com.elitesland.scp.domain.entity.item.QScpCateItemDO;
import com.elitesland.scp.domain.entity.item.QScpCateItemSaleScopeStoreDO;
import com.elitesland.scp.domain.entity.whnet.QScpWhNetRelationDO;
import com.elitesland.scp.dto.item.ScpCateItemDTO;
import com.elitesland.scp.param.CateItemRpcParam;
import com.querydsl.core.types.EntityPath;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.ExpressionUtils;
import com.querydsl.core.types.Path;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.Projections;
import com.querydsl.core.types.dsl.BooleanExpression;
import com.querydsl.core.types.dsl.Expressions;
import com.querydsl.core.types.dsl.StringExpression;
import com.querydsl.jpa.impl.JPAQuery;
import com.querydsl.jpa.impl.JPAQueryFactory;
import com.querydsl.jpa.impl.JPAUpdateClause;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@Component
public class ScpCateItemRepoProc {
    private static final Logger log = LoggerFactory.getLogger(ScpCateItemRepoProc.class);
    private final JPAQueryFactory jpaQueryFactory;
    private final QScpCateItemDO scpCateItemDO = QScpCateItemDO.scpCateItemDO;
    private final QScpCateItemSaleScopeStoreDO scpCateItemSaleScopeStoreDO = QScpCateItemSaleScopeStoreDO.scpCateItemSaleScopeStoreDO;

    public List<String> queryByItemCodes(List<String> itemCodes) {
        JPAQuery jpaQuery = (JPAQuery)((JPAQuery)this.jpaQueryFactory.select((Expression)this.scpCateItemDO.itemCode).from((EntityPath)this.scpCateItemDO)).where((Predicate)this.scpCateItemDO.itemCode.in(itemCodes));
        return jpaQuery.fetch();
    }

    public List<String> queryItemCode(CateItemRpcParam paramVO) {
        JPAQuery jpaQuery = (JPAQuery)this.jpaQueryFactory.select((Expression)this.scpCateItemDO.itemCode).from((EntityPath)this.scpCateItemDO);
        ArrayList<BooleanExpression> predicates = new ArrayList<BooleanExpression>();
        if (CollectionUtils.isNotEmpty((Collection)paramVO.getCateCodes())) {
            predicates.add(this.scpCateItemDO.cateCode.in((Collection)paramVO.getCateCodes()));
        }
        if (CollectionUtils.isNotEmpty((Collection)paramVO.getCateIds())) {
            predicates.add(this.scpCateItemDO.cateId.in((Collection)paramVO.getCateIds()));
        }
        if (CollectionUtils.isNotEmpty((Collection)paramVO.getItemCodes())) {
            predicates.add(this.scpCateItemDO.itemCode.in((Collection)paramVO.getItemCodes()));
        }
        if (CollectionUtils.isNotEmpty((Collection)paramVO.getItemIds())) {
            predicates.add(this.scpCateItemDO.itemId.in((Collection)paramVO.getItemIds()));
        }
        jpaQuery.where(ExpressionUtils.allOf(predicates));
        return jpaQuery.fetch();
    }

    public List<ScpCateItemDTO> queryDto(CateItemRpcParam paramVO) {
        JPAQuery jpaQuery = (JPAQuery)this.jpaQueryFactory.select((Expression)Projections.bean(ScpCateItemDTO.class, (Expression[])new Expression[]{this.scpCateItemDO.cateId, this.scpCateItemDO.cateCode, this.scpCateItemDO.itemCode, this.scpCateItemDO.itemName, this.scpCateItemDO.itemId, this.scpCateItemDO.hotFlag, this.scpCateItemDO.combineItemFlag})).from((EntityPath)this.scpCateItemDO);
        ArrayList<BooleanExpression> predicates = new ArrayList<BooleanExpression>();
        if (CollectionUtils.isNotEmpty((Collection)paramVO.getCateCodes())) {
            predicates.add(this.scpCateItemDO.cateCode.in((Collection)paramVO.getCateCodes()));
        }
        if (CollectionUtils.isNotEmpty((Collection)paramVO.getCateIds())) {
            predicates.add(this.scpCateItemDO.cateId.in((Collection)paramVO.getCateIds()));
        }
        if (CollectionUtils.isNotEmpty((Collection)paramVO.getItemCodes())) {
            predicates.add(this.scpCateItemDO.itemCode.in((Collection)paramVO.getItemCodes()));
        }
        if (CollectionUtils.isNotEmpty((Collection)paramVO.getItemIds())) {
            predicates.add(this.scpCateItemDO.itemId.in((Collection)paramVO.getItemIds()));
        }
        jpaQuery.where(ExpressionUtils.allOf(predicates));
        return jpaQuery.fetch();
    }

    public Long countAppItemSpu(AppItemPageParamVO param) {
        JPAQuery jpaQuery = (JPAQuery)this.jpaQueryFactory.select((Expression)this.scpCateItemDO.count()).from((EntityPath)this.scpCateItemDO);
        if (param != null) {
            jpaQuery.where(this.getPredicates(param));
        }
        jpaQuery.orderBy(this.scpCateItemDO.spuId.desc());
        jpaQuery.groupBy(this.scpCateItemDO.spuId);
        return jpaQuery.fetchCount();
    }

    public Long countAppItemSku(AppItemPageParamVO param) {
        JPAQuery jpaQuery = (JPAQuery)this.jpaQueryFactory.select((Expression)this.scpCateItemDO.count()).from((EntityPath)this.scpCateItemDO);
        if (param != null) {
            jpaQuery.where(this.getPredicates(param));
        }
        jpaQuery.orderBy(this.scpCateItemDO.itemId.desc());
        jpaQuery.groupBy(this.scpCateItemDO.itemId);
        return jpaQuery.fetchCount();
    }

    public List<AppItmItemPageVO> pageAppItemSpu(AppItemPageParamVO param) {
        JPAQuery jpaQuery = (JPAQuery)((JPAQuery)this.jpaQueryFactory.select((Expression)Projections.bean(AppItmItemPageVO.class, (Expression[])new Expression[]{this.scpCateItemDO.cateCode.as("itemCateCode"), this.scpCateItemDO.cateId, this.scpCateItemDO.spuId, this.scpCateItemDO.spuName, this.scpCateItemDO.spuCode, this.scpCateItemDO.sortNo, this.scpCateItemDO.itemType2, this.scpCateItemDO.combineItemFlag})).distinct()).from((EntityPath)this.scpCateItemDO);
        if (param != null) {
            jpaQuery.where(this.getPredicates(param));
        }
        param.setPaging(jpaQuery);
        jpaQuery.orderBy(this.scpCateItemDO.sortNo.desc());
        jpaQuery.groupBy(new Expression[]{this.scpCateItemDO.cateCode, this.scpCateItemDO.cateId, this.scpCateItemDO.spuId, this.scpCateItemDO.spuName, this.scpCateItemDO.spuCode, this.scpCateItemDO.sortNo, this.scpCateItemDO.itemType2, this.scpCateItemDO.combineItemFlag});
        return jpaQuery.fetch();
    }

    public List<AppItmItemPageVO> pageAppItemSku(AppItemPageParamVO param) {
        JPAQuery jpaQuery = (JPAQuery)((JPAQuery)this.jpaQueryFactory.select((Expression)Projections.bean(AppItmItemPageVO.class, (Expression[])new Expression[]{this.scpCateItemDO.cateCode.as("itemCateCode"), this.scpCateItemDO.cateId, this.scpCateItemDO.spuId, this.scpCateItemDO.spuName, this.scpCateItemDO.spuCode, this.scpCateItemDO.itemCode, this.scpCateItemDO.itemType2, this.scpCateItemDO.itemId, this.scpCateItemDO.sortNo})).distinct()).from((EntityPath)this.scpCateItemDO);
        if (param != null) {
            jpaQuery.where(this.getPredicates(param));
        }
        param.setPaging(jpaQuery);
        jpaQuery.orderBy(this.scpCateItemDO.sortNo.desc());
        jpaQuery.groupBy(new Expression[]{this.scpCateItemDO.cateCode, this.scpCateItemDO.cateId, this.scpCateItemDO.spuId, this.scpCateItemDO.spuName, this.scpCateItemDO.spuCode, this.scpCateItemDO.itemCode, this.scpCateItemDO.itemType2, this.scpCateItemDO.itemId, this.scpCateItemDO.sortNo});
        return jpaQuery.fetch();
    }

    public Long countAppItemAndWhNetSku(AppItemPageParamVO param) {
        QScpWhNetRelationDO scpWhNetRelationDO = QScpWhNetRelationDO.scpWhNetRelationDO;
        JPAQuery jpaQuery = (JPAQuery)((JPAQuery)((JPAQuery)this.jpaQueryFactory.select((Expression)this.scpCateItemDO.count()).from((EntityPath)this.scpCateItemDO)).leftJoin((EntityPath)scpWhNetRelationDO)).on((Predicate)this.scpCateItemDO.itemId.eq(scpWhNetRelationDO.itemId));
        if (param != null) {
            jpaQuery.where(this.getPredicatesWithItemDo(param));
            if (CollUtil.isNotEmpty(param.getDeliveryTypes())) {
                jpaQuery.where((Predicate)scpWhNetRelationDO.id.isNotNull().and((Predicate)scpWhNetRelationDO.deliveryType.in(param.getDeliveryTypes())).or((Predicate)scpWhNetRelationDO.id.isNull().and((Predicate)this.scpCateItemDO.itemType2.in(param.getDeliveryTypes()))));
            }
        }
        jpaQuery.orderBy(this.scpCateItemDO.itemId.desc());
        jpaQuery.groupBy(this.scpCateItemDO.itemId);
        return jpaQuery.fetchCount();
    }

    public List<AppItmItemPageVO> pageAppItemAndWhNetSku(AppItemPageParamVO param) {
        QScpWhNetRelationDO scpWhNetRelationDO = QScpWhNetRelationDO.scpWhNetRelationDO;
        JPAQuery jpaQuery = (JPAQuery)((JPAQuery)((JPAQuery)((JPAQuery)this.jpaQueryFactory.select((Expression)Projections.bean(AppItmItemPageVO.class, (Expression[])new Expression[]{this.scpCateItemDO.cateCode.as("itemCateCode"), this.scpCateItemDO.cateId, this.scpCateItemDO.spuId, this.scpCateItemDO.spuName, this.scpCateItemDO.spuCode, this.scpCateItemDO.firstLetter, this.scpCateItemDO.itemCode, this.scpCateItemDO.itemId, this.scpCateItemDO.sortNo, ((StringExpression)Expressions.cases().when((Predicate)scpWhNetRelationDO.deliveryType.isNull()).then((StringExpression)this.scpCateItemDO.itemType2).otherwise((Expression)scpWhNetRelationDO.deliveryType)).as("itemType2"), this.scpCateItemDO.combineItemFlag})).distinct()).from((EntityPath)this.scpCateItemDO)).leftJoin((EntityPath)scpWhNetRelationDO)).on((Predicate)this.scpCateItemDO.itemId.eq(scpWhNetRelationDO.itemId).and((Predicate)scpWhNetRelationDO.demandWhStCode.eq((Object)param.getStoreCode())));
        if (param != null) {
            jpaQuery.where(this.getPredicatesWithItemDo(param));
            if (CollUtil.isNotEmpty(param.getDeliveryTypes())) {
                jpaQuery.where((Predicate)scpWhNetRelationDO.id.isNotNull().and((Predicate)scpWhNetRelationDO.deliveryType.in(param.getDeliveryTypes())).or((Predicate)scpWhNetRelationDO.id.isNull().and((Predicate)this.scpCateItemDO.itemType2.in(param.getDeliveryTypes()))));
            }
        }
        jpaQuery.orderBy(this.scpCateItemDO.sortNo.desc());
        jpaQuery.groupBy(new Expression[]{this.scpCateItemDO.cateCode, this.scpCateItemDO.cateId, this.scpCateItemDO.spuId, this.scpCateItemDO.spuName, this.scpCateItemDO.spuCode, this.scpCateItemDO.itemCode, this.scpCateItemDO.itemId, this.scpCateItemDO.sortNo, this.scpCateItemDO.itemType2, this.scpCateItemDO.combineItemFlag});
        return jpaQuery.fetch();
    }

    public List<String> pageItemCodesByParam(List<Long> spuIds) {
        JPAQuery jpaQuery = (JPAQuery)this.jpaQueryFactory.select((Expression)this.scpCateItemDO.itemCode).from((EntityPath)this.scpCateItemDO);
        jpaQuery.where((Predicate)this.scpCateItemDO.spuId.in(spuIds));
        return jpaQuery.fetch();
    }

    public long countItem(ScpCateItemPageParamVO paramVO) {
        JPAQuery jpaQuery = (JPAQuery)this.jpaQueryFactory.select((Expression)this.scpCateItemDO.count()).from((EntityPath)this.scpCateItemDO);
        jpaQuery.where(this.whereItemPage(paramVO));
        return jpaQuery.fetchCount();
    }

    private Predicate whereItemPage(ScpCateItemPageParamVO paramVO) {
        ArrayList<BooleanExpression> predicates = new ArrayList<BooleanExpression>();
        if (paramVO.getHotFlag() != null) {
            predicates.add(this.scpCateItemDO.hotFlag.eq(paramVO.getHotFlag()));
        }
        if (StrUtil.isNotBlank((CharSequence)paramVO.getItemType())) {
            predicates.add(this.scpCateItemDO.itemType.eq((Object)paramVO.getItemType()));
        }
        if (StrUtil.isNotBlank((CharSequence)paramVO.getItemType2())) {
            predicates.add(this.scpCateItemDO.itemType2.eq((Object)paramVO.getItemType2()));
        }
        if (StrUtil.isNotBlank((CharSequence)paramVO.getItemName())) {
            predicates.add(this.scpCateItemDO.itemName.like("%" + paramVO.getItemName() + "%"));
        }
        if (StrUtil.isNotBlank((CharSequence)paramVO.getItemCode())) {
            predicates.add(this.scpCateItemDO.itemCode.like("%" + paramVO.getItemCode() + "%"));
        }
        if (CollUtil.isNotEmpty(paramVO.getScpCateCodes())) {
            predicates.add(this.scpCateItemDO.cateCode.in(paramVO.getScpCateCodes()));
        }
        if (Objects.nonNull(paramVO.getSaleStatus())) {
            predicates.add(this.scpCateItemDO.saleStatus.eq(paramVO.getSaleStatus()));
        }
        if (Objects.nonNull(paramVO.getUpDownStatus())) {
            predicates.add(this.scpCateItemDO.upDownStatus.eq(paramVO.getUpDownStatus()));
        }
        if (Objects.nonNull(paramVO.getVisibleStatus())) {
            predicates.add(this.scpCateItemDO.visibleStatus.eq(paramVO.getVisibleStatus()));
        }
        if (Objects.nonNull(paramVO.getPreSaleStatus())) {
            predicates.add(this.scpCateItemDO.preSaleStatus.eq(paramVO.getPreSaleStatus()));
        }
        if (CollUtil.isNotEmpty(paramVO.getItemIds())) {
            predicates.add(this.scpCateItemDO.itemId.in(paramVO.getItemIds()));
        }
        return ExpressionUtils.allOf(predicates);
    }

    public List<ScpCateItemRespVO> queryItemList(ScpCateItemPageParamVO param) {
        JPAQuery jpaQuery = (JPAQuery)((JPAQuery)this.jpaQueryFactory.select((Expression)Projections.bean(ScpCateItemRespVO.class, (Expression[])new Expression[]{this.scpCateItemDO.id, this.scpCateItemDO.itemId, this.scpCateItemDO.itemCode, this.scpCateItemDO.itemName, this.scpCateItemDO.itemType, this.scpCateItemDO.itemType2, this.scpCateItemDO.combineItemFlag})).distinct()).from((EntityPath)this.scpCateItemDO);
        if (param != null) {
            jpaQuery.where(this.whereItemPage(param));
        }
        return jpaQuery.fetch();
    }

    public List<ScpCateItemPageVO> skuPage(ScpCateItemPageParamVO param) {
        JPAQuery jpaQuery = (JPAQuery)this.jpaQueryFactory.select((Expression)Projections.bean(ScpCateItemPageVO.class, (Expression[])new Expression[]{this.scpCateItemDO.id, this.scpCateItemDO.id.as("scpCateItemId"), this.scpCateItemDO.itemId, this.scpCateItemDO.itemCode, this.scpCateItemDO.itemName, this.scpCateItemDO.cateCode.as("scpCateCode"), this.scpCateItemDO.cateId.as("scpCateId"), this.scpCateItemDO.hotFlag, this.scpCateItemDO.sortNo, this.scpCateItemDO.saleStatus, this.scpCateItemDO.upDownStatus, this.scpCateItemDO.visibleStatus, this.scpCateItemDO.preSaleStatus, this.scpCateItemDO.combineItemFlag, this.scpCateItemDO.itemType2})).from((EntityPath)this.scpCateItemDO);
        if (param != null) {
            jpaQuery.where(this.whereItemPage(param));
        }
        jpaQuery.orderBy(this.scpCateItemDO.sortNo.desc());
        return jpaQuery.fetch();
    }

    public Predicate getPredicates(AppItemPageParamVO paramVO) {
        ArrayList<BooleanExpression> list = new ArrayList<BooleanExpression>();
        list.add(this.scpCateItemDO.deleteFlag.eq((Object)0));
        if (CollectionUtils.isNotEmpty(paramVO.getItemCateCodes())) {
            list.add(this.scpCateItemDO.cateCode.in(paramVO.getItemCateCodes()));
        }
        if (StringUtils.isNotBlank((String)paramVO.getKeyword())) {
            list.add(this.scpCateItemDO.itemCode.contains(paramVO.getKeyword()).or((Predicate)this.scpCateItemDO.itemName.contains(paramVO.getKeyword())).or((Predicate)this.scpCateItemDO.spuCode.contains(paramVO.getKeyword())).or((Predicate)this.scpCateItemDO.spuName.contains(paramVO.getKeyword())).or((Predicate)this.scpCateItemDO.anotherName.contains(paramVO.getKeyword())));
        }
        if (CollectionUtils.isNotEmpty(paramVO.getItemIds())) {
            list.add(this.scpCateItemDO.itemId.in(paramVO.getItemIds()));
        }
        if (ObjectUtils.isNotEmpty((Object)paramVO.getSpuId())) {
            list.add(this.scpCateItemDO.spuId.eq((Object)paramVO.getSpuId()));
        }
        if (CollUtil.isNotEmpty(paramVO.getItemTypes())) {
            list.add(this.scpCateItemDO.itemType.in(paramVO.getItemTypes()));
        }
        if (StrUtil.isNotBlank((CharSequence)paramVO.getBrand())) {
            list.add(this.scpCateItemDO.brand.like("%" + paramVO.getBrand() + "%"));
        }
        return ExpressionUtils.allOf(list);
    }

    public Predicate getPredicatesWithItemDo(AppItemPageParamVO paramVO) {
        ArrayList<BooleanExpression> list = new ArrayList<BooleanExpression>();
        list.add(this.scpCateItemDO.deleteFlag.eq((Object)0));
        if (CollectionUtils.isNotEmpty(paramVO.getItemCateCodes())) {
            list.add(this.scpCateItemDO.cateCode.in(paramVO.getItemCateCodes()));
        }
        if (StringUtils.isNotBlank((String)paramVO.getKeyword())) {
            list.add(this.scpCateItemDO.itemCode.contains(paramVO.getKeyword()).or((Predicate)this.scpCateItemDO.itemName.contains(paramVO.getKeyword())).or((Predicate)this.scpCateItemDO.spuCode.contains(paramVO.getKeyword())).or((Predicate)this.scpCateItemDO.spuName.contains(paramVO.getKeyword())).or((Predicate)this.scpCateItemDO.anotherName.contains(paramVO.getKeyword())).or((Predicate)this.scpCateItemDO.firstLetter.contains(paramVO.getKeyword())));
        }
        if (CollectionUtils.isNotEmpty(paramVO.getItemIds())) {
            list.add(this.scpCateItemDO.itemId.in(paramVO.getItemIds()));
        }
        if (ObjectUtils.isNotEmpty((Object)paramVO.getSpuId())) {
            list.add(this.scpCateItemDO.spuId.eq((Object)paramVO.getSpuId()));
        }
        if (CollUtil.isNotEmpty(paramVO.getItemTypes())) {
            list.add(this.scpCateItemDO.itemType.in(paramVO.getItemTypes()));
        }
        if (CollUtil.isNotEmpty(paramVO.getItemCodes())) {
            list.add(this.scpCateItemDO.itemCode.in(paramVO.getItemCodes()));
        }
        if (StrUtil.isNotBlank((CharSequence)paramVO.getBrand())) {
            list.add(this.scpCateItemDO.brand.like("%" + paramVO.getBrand() + "%"));
        }
        return ExpressionUtils.allOf(list);
    }

    public Long changeHotFlag(ScpCateItemHotParamVO paramVO) {
        return this.jpaQueryFactory.update((EntityPath)this.scpCateItemDO).set((Path)this.scpCateItemDO.hotFlag, (Object)paramVO.getHotFlag()).where(new Predicate[]{this.scpCateItemDO.id.in(paramVO.getItemIds())}).execute();
    }

    public void updateItemSpuInfo(String itemType2, String anotherName, Long spuId) {
        JPAUpdateClause update = this.jpaQueryFactory.update((EntityPath)this.scpCateItemDO);
        update.set((Path)this.scpCateItemDO.itemType, (Object)itemType2);
        update.set((Path)this.scpCateItemDO.anotherName, (Object)anotherName);
        update.where(new Predicate[]{this.scpCateItemDO.spuId.eq((Object)spuId)});
        update.execute();
    }

    public void updateItemBrand(String brand, Long rootCateId) {
        JPAUpdateClause update = this.jpaQueryFactory.update((EntityPath)this.scpCateItemDO);
        if (StrUtil.isNotBlank((CharSequence)brand)) {
            update.set((Path)this.scpCateItemDO.brand, (Object)brand);
        }
        update.where(new Predicate[]{this.scpCateItemDO.rootCateId.eq((Object)rootCateId)});
        update.execute();
    }

    public List<String> getFirstCateByType(List<String> itemTypes, List<String> brands) {
        JPAQuery jpaQuery = (JPAQuery)((JPAQuery)this.jpaQueryFactory.select((Expression)this.scpCateItemDO.cateCode).from((EntityPath)this.scpCateItemDO)).where((Predicate)this.scpCateItemDO.itemType.in(itemTypes).and((Predicate)this.scpCateItemDO.brand.in(brands)));
        return jpaQuery.fetch();
    }

    public Long countCommonItemSpu(CommonItemPageParamVO param) {
        JPAQuery jpaQuery = (JPAQuery)this.jpaQueryFactory.select((Expression)this.scpCateItemDO.count()).from((EntityPath)this.scpCateItemDO);
        if (param != null) {
            jpaQuery.where(this.getCommonPredicates(param));
        }
        jpaQuery.orderBy(this.scpCateItemDO.spuId.desc());
        jpaQuery.groupBy(this.scpCateItemDO.spuId);
        return jpaQuery.fetchCount();
    }

    public List<AppItmItemPageVO> pageCommonItemSpu(CommonItemPageParamVO param) {
        JPAQuery jpaQuery = (JPAQuery)((JPAQuery)this.jpaQueryFactory.select((Expression)Projections.bean(AppItmItemPageVO.class, (Expression[])new Expression[]{this.scpCateItemDO.cateCode.as("itemCateCode"), this.scpCateItemDO.cateId, this.scpCateItemDO.spuId, this.scpCateItemDO.spuName, this.scpCateItemDO.spuCode, this.scpCateItemDO.combineItemFlag})).distinct()).from((EntityPath)this.scpCateItemDO);
        if (param != null) {
            jpaQuery.where(this.getCommonPredicates(param));
        }
        param.setPaging(jpaQuery);
        jpaQuery.orderBy(this.scpCateItemDO.spuId.desc());
        jpaQuery.groupBy(new Expression[]{this.scpCateItemDO.cateCode, this.scpCateItemDO.cateId, this.scpCateItemDO.spuId, this.scpCateItemDO.spuName, this.scpCateItemDO.spuCode, this.scpCateItemDO.combineItemFlag});
        return jpaQuery.fetch();
    }

    public Predicate getCommonPredicates(CommonItemPageParamVO paramVO) {
        ArrayList<BooleanExpression> list = new ArrayList<BooleanExpression>();
        list.add(this.scpCateItemDO.deleteFlag.eq((Object)0));
        if (CollectionUtils.isNotEmpty(paramVO.getItemCateCodes())) {
            list.add(this.scpCateItemDO.cateCode.in(paramVO.getItemCateCodes()));
        }
        if (StringUtils.isNotBlank((String)paramVO.getKeyword())) {
            list.add(this.scpCateItemDO.itemCode.contains(paramVO.getKeyword()).or((Predicate)this.scpCateItemDO.itemName.contains(paramVO.getKeyword())).or((Predicate)this.scpCateItemDO.spuCode.contains(paramVO.getKeyword())).or((Predicate)this.scpCateItemDO.spuName.contains(paramVO.getKeyword())).or((Predicate)this.scpCateItemDO.anotherName.contains(paramVO.getKeyword())));
        }
        if (CollectionUtils.isNotEmpty(paramVO.getItemIds())) {
            list.add(this.scpCateItemDO.itemId.in(paramVO.getItemIds()));
        }
        if (ObjectUtils.isNotEmpty((Object)paramVO.getSpuId())) {
            list.add(this.scpCateItemDO.spuId.eq((Object)paramVO.getSpuId()));
        }
        if (CollUtil.isNotEmpty(paramVO.getItemTypes())) {
            list.add(this.scpCateItemDO.itemType.in(paramVO.getItemTypes()));
        }
        if (StrUtil.isNotBlank((CharSequence)paramVO.getBrand())) {
            list.add(this.scpCateItemDO.brand.like("%" + paramVO.getBrand() + "%"));
        }
        return ExpressionUtils.allOf(list);
    }

    public List<Long> appItemSku(AppItemPageParamVO param) {
        JPAQuery jpaQuery = (JPAQuery)((JPAQuery)this.jpaQueryFactory.select(this.scpCateItemDO.itemId).distinct()).from((EntityPath)this.scpCateItemDO);
        if (param != null) {
            jpaQuery.where(this.getPredicates(param));
        }
        return jpaQuery.fetch();
    }

    @Transactional(rollbackFor={Exception.class})
    public void updateItemNameByItemId(String itemName, Long itemId) {
        JPAUpdateClause update = this.jpaQueryFactory.update((EntityPath)this.scpCateItemDO);
        update.set((Path)this.scpCateItemDO.itemName, (Object)itemName);
        update.where(new Predicate[]{this.scpCateItemDO.itemId.eq((Object)itemId)});
        update.execute();
    }

    @Transactional(rollbackFor={Exception.class})
    public void updateSortNoById(Integer sortNo, Long id) {
        JPAUpdateClause update = this.jpaQueryFactory.update((EntityPath)this.scpCateItemDO);
        update.set(this.scpCateItemDO.sortNo, (Object)sortNo);
        update.where(new Predicate[]{this.scpCateItemDO.id.eq((Object)id)});
        update.execute();
    }

    public List<String> getVisibleAndSaleAndUpItemList(List<String> itemCodeList, String storeCode) {
        LocalDateTime localDateTime = LocalDateTime.now();
        JPAQuery jpaQuery = (JPAQuery)((JPAQuery)((JPAQuery)((JPAQuery)this.jpaQueryFactory.select((Expression)this.scpCateItemDO.itemCode).from((EntityPath)this.scpCateItemDO)).leftJoin((EntityPath)this.scpCateItemSaleScopeStoreDO)).on((Predicate)this.scpCateItemDO.id.eq(this.scpCateItemSaleScopeStoreDO.masId))).where((Predicate)this.scpCateItemDO.itemCode.in(itemCodeList).and((Predicate)this.scpCateItemSaleScopeStoreDO.storeCode.eq((Object)storeCode)).and((Predicate)this.scpCateItemDO.upDownStatus.eq(Boolean.valueOf(true))).and((Predicate)this.scpCateItemDO.saleStatus.eq(Boolean.valueOf(true))).and((Predicate)this.scpCateItemDO.saleDateStart.loe((Comparable)localDateTime)).and((Predicate)this.scpCateItemDO.saleDateEnd.goe((Comparable)localDateTime)).and((Predicate)this.scpCateItemSaleScopeStoreDO.visibleDateStart.isNull().or((Predicate)this.scpCateItemSaleScopeStoreDO.visibleDateStart.goe((Comparable)localDateTime))).and((Predicate)this.scpCateItemSaleScopeStoreDO.visibleDateEnd.isNull().or((Predicate)this.scpCateItemSaleScopeStoreDO.visibleDateEnd.loe((Comparable)localDateTime))));
        return jpaQuery.fetch();
    }

    public List<String> getSaleAndUpItemList(List<String> itemCodeList, String storeCode) {
        LocalDateTime localDateTime = LocalDateTime.now();
        JPAQuery jpaQuery = (JPAQuery)((JPAQuery)((JPAQuery)((JPAQuery)this.jpaQueryFactory.select((Expression)this.scpCateItemDO.itemCode).from((EntityPath)this.scpCateItemDO)).leftJoin((EntityPath)this.scpCateItemSaleScopeStoreDO)).on((Predicate)this.scpCateItemDO.id.eq(this.scpCateItemSaleScopeStoreDO.masId))).where((Predicate)this.scpCateItemDO.itemCode.in(itemCodeList).and((Predicate)this.scpCateItemSaleScopeStoreDO.storeCode.eq((Object)storeCode)).and((Predicate)this.scpCateItemDO.upDownStatus.eq(Boolean.valueOf(true))).and((Predicate)this.scpCateItemDO.saleStatus.eq(Boolean.valueOf(true))).and((Predicate)this.scpCateItemDO.saleDateStart.loe((Comparable)localDateTime)).and((Predicate)this.scpCateItemDO.saleDateEnd.goe((Comparable)localDateTime)));
        return jpaQuery.fetch();
    }

    public List<String> getPreSaleItemList(List<String> itemCodeList) {
        JPAQuery jpaQuery = (JPAQuery)((JPAQuery)this.jpaQueryFactory.select((Expression)this.scpCateItemDO.itemCode).from((EntityPath)this.scpCateItemDO)).where((Predicate)this.scpCateItemDO.itemCode.in(itemCodeList).and((Predicate)this.scpCateItemDO.preSaleStatus.eq(Boolean.valueOf(true))));
        return jpaQuery.fetch();
    }

    public ScpCateItemRepoProc(JPAQueryFactory jpaQueryFactory) {
        this.jpaQueryFactory = jpaQueryFactory;
    }
}

