/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.scp.provider;

import com.elitesland.scp.application.facade.vo.serviceconfig.ScpServiceConfigRespVO;
import com.elitesland.scp.application.service.serviceconfig.ScpServiceConfigService;
import com.elitesland.scp.domain.convert.serviceconifg.ScpServiceConfigConvert;
import com.elitesland.scp.dto.ScpServiceConfigParamRpcParam;
import com.elitesland.scp.dto.ScpServiceConfigRpcDTO;
import com.elitesland.scp.service.ScpServiceConfigRpcService;
import java.util.Collections;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@Service
@RestController
@RequestMapping(value={"/rpc/scp/scpServiceConfig"})
public class ScpServiceConfigRpcServiceImpl
implements ScpServiceConfigRpcService {
    private static final Logger log = LoggerFactory.getLogger(ScpServiceConfigRpcServiceImpl.class);
    private final ScpServiceConfigService scpServiceConfigService;

    public Map<String, ScpServiceConfigRpcDTO> findServiceConfigGroupByStore(ScpServiceConfigParamRpcParam paramVO) {
        log.info("\u67e5\u8be2\u95e8\u5e97\u670d\u52a1\u914d\u7f6e\uff0c\u53c2\u6570: {}", (Object)paramVO);
        try {
            Map<String, ScpServiceConfigRespVO> serviceConfigMap = this.scpServiceConfigService.findServiceConfigGroupByStore(paramVO.getStoreCode(), paramVO.getRegionCode(), paramVO.getLevel());
            if (serviceConfigMap == null || serviceConfigMap.isEmpty()) {
                return Collections.emptyMap();
            }
            return serviceConfigMap.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> ScpServiceConfigConvert.INSTANCE.respVoToRpcDto((ScpServiceConfigRespVO)entry.getValue())));
        }
        catch (Exception e) {
            log.error("\u67e5\u8be2\u95e8\u5e97\u670d\u52a1\u914d\u7f6e\u5931\u8d25\uff0c\u53c2\u6570: {}", (Object)paramVO, (Object)e);
            return Collections.emptyMap();
        }
    }

    public ScpServiceConfigRpcServiceImpl(ScpServiceConfigService scpServiceConfigService) {
        this.scpServiceConfigService = scpServiceConfigService;
    }
}

