/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.scp.provider.whnet;

import com.alibaba.fastjson.JSON;
import com.elitescloud.boot.exception.BusinessException;
import com.elitescloud.cloudt.common.base.ApiCode;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitesland.scp.application.facade.vo.whnet.ScpWhNetRelationSaveVO;
import com.elitesland.scp.application.service.whnet.ScpWhNetRelationService;
import com.elitesland.scp.common.ScpConstant;
import com.elitesland.scp.domain.convert.inv.ScpWhNetRelationConvert;
import com.elitesland.scp.dto.whnet.ScpWhNetRelationRpcDTO;
import com.elitesland.scp.param.ScpWhNetRelationParam;
import com.elitesland.scp.param.ScpWhNetRelationRpcDtoParam;
import com.elitesland.scp.param.ScpWhNetRelationRpcSaveVO;
import com.elitesland.scp.rmi.RmiOrgOuService;
import com.elitesland.scp.service.whnet.ScpWhNetRelationProvider;
import com.elitesland.support.provider.org.dto.OrgOuRpcSimpleDTO;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@Service
@RestController
@RequestMapping(value={"/rpc/scp/whnet"})
public class ScpWhNetRelationProviderImpl
implements ScpWhNetRelationProvider {
    private static final Logger log = LoggerFactory.getLogger(ScpWhNetRelationProviderImpl.class);
    private final ScpWhNetRelationService scpWhNetRelationService;
    private final RmiOrgOuService rmiOrgOuService;

    public List<ScpWhNetRelationRpcDTO> findWhNetRelationRpcDtoByParam(ScpWhNetRelationRpcDtoParam scpWhNetRelationRpcDtoParam) {
        return this.scpWhNetRelationService.findWhNetRelationRpcDtoByParam(scpWhNetRelationRpcDtoParam);
    }

    public List<ScpWhNetRelationRpcDTO> outFindWhNetRelationRpcDtoByParam(ScpWhNetRelationParam whNetRelationParam) {
        return this.scpWhNetRelationService.outFindWhNetRelationRpcDtoByParam(whNetRelationParam);
    }

    @Transactional
    public ApiResult<String> batchSaveWhNetRelation(List<ScpWhNetRelationRpcSaveVO> saveVOList) {
        log.info("\u6279\u91cf\u4fdd\u5b58\u4ed3\u7f51\u4f9b\u5e94\u94fe\u5173\u7cfb\uff0c\u53c2\u6570\uff1a{}", (Object)JSON.toJSONString(saveVOList));
        if (CollectionUtils.isEmpty(saveVOList)) {
            throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "\u4ed3\u7f51\u4f9b\u5e94\u94fe\u5173\u7cfb\u4e0d\u80fd\u4e3a\u7a7a");
        }
        List<ScpWhNetRelationSaveVO.ScpWhNetRelation> scpWhNetRelations = ScpWhNetRelationConvert.INSTANCE.rpcToSaveVo(saveVOList);
        List<String> ouCodes = scpWhNetRelations.stream().map(ScpWhNetRelationSaveVO.ScpWhNetRelation::getOuCode).filter(Objects::nonNull).distinct().collect(Collectors.toList());
        Map<String, OrgOuRpcSimpleDTO> ouMap = this.rmiOrgOuService.findOuDtoMapByOuCodes(ouCodes);
        scpWhNetRelations.forEach(scpWhNetRelation -> {
            if (scpWhNetRelation != null && scpWhNetRelation.getDeliveryType() != null && ScpConstant.PUR_DELIVERY_TYPES.contains(scpWhNetRelation.getDeliveryType())) {
                scpWhNetRelation.setPurCompanyCode(scpWhNetRelation.getOuCode());
                if (ouMap.containsKey(scpWhNetRelation.getOuCode())) {
                    scpWhNetRelation.setPurCompanyName(((OrgOuRpcSimpleDTO)ouMap.get(scpWhNetRelation.getOuCode())).getOuName());
                }
                scpWhNetRelation.setOuCode(null);
                scpWhNetRelation.setOuName(null);
            }
        });
        ScpWhNetRelationSaveVO scpWhNetRelationSaveVO = new ScpWhNetRelationSaveVO();
        scpWhNetRelationSaveVO.setScpWhNetRelations(scpWhNetRelations);
        this.scpWhNetRelationService.saveWhNetRelation(scpWhNetRelationSaveVO);
        log.info("\u6279\u91cf\u4fdd\u5b58\u4ed3\u7f51\u4f9b\u5e94\u94fe\u5173\u7cfb\uff0c\u7ed3\u679c\uff1a{}", (Object)JSON.toJSONString((Object)scpWhNetRelationSaveVO));
        return ApiResult.ok();
    }

    public ScpWhNetRelationProviderImpl(ScpWhNetRelationService scpWhNetRelationService, RmiOrgOuService rmiOrgOuService) {
        this.scpWhNetRelationService = scpWhNetRelationService;
        this.rmiOrgOuService = rmiOrgOuService;
    }
}

