/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.scp.utils.excel.listener;

import com.alibaba.excel.context.AnalysisContext;
import com.alibaba.excel.event.AnalysisEventListener;
import com.alibaba.excel.read.metadata.holder.ReadRowHolder;
import com.elitesland.scp.utils.excel.DchExcelColumnCheckUtil;
import com.elitesland.scp.utils.excel.DchExcelImportVO;
import com.google.gson.Gson;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DchExcelDataListener
extends AnalysisEventListener<Map<Integer, String>> {
    private static final Logger LOGGER = LoggerFactory.getLogger(DchExcelDataListener.class);
    private static final int BATCH_COUNT = 5;
    private DchExcelImportVO dchExcelImportVO = new DchExcelImportVO();
    private List<String> errMsgList = this.dchExcelImportVO.getErrMsgList();
    private List<Map<Integer, Object>> dataMapsList = this.dchExcelImportVO.getDataMapsList();

    public Optional<DchExcelImportVO> getDchExcelImportVO() {
        return Optional.of(this.dchExcelImportVO);
    }

    public void invokeHeadMap(Map<Integer, String> headMap, AnalysisContext context) {
        LOGGER.info("invokeHeadMap \u89e3\u6790\u5230\u4e00\u6761\u5934\u6570\u636e:{}", (Object)new Gson().toJson(headMap));
        ReadRowHolder readRowHolder = context.readRowHolder();
        int rowindex = readRowHolder.getRowIndex();
        if (rowindex == 0) {
            if (StringUtils.isBlank((CharSequence)headMap.get(1))) {
                // empty if block
            }
            this.dchExcelImportVO.setTableName(headMap.get(1));
        } else if (rowindex == 1) {
            if (StringUtils.isBlank((CharSequence)headMap.get(1))) {
                // empty if block
            }
            this.dchExcelImportVO.setType(headMap.get(1));
        }
        this.dchExcelImportVO.getHeadMapList().add(headMap);
    }

    public void invoke(Map<Integer, String> data, AnalysisContext context) {
        LOGGER.info("invoke \u89e3\u6790\u5230\u4e00\u6761\u6570\u636e:{}", (Object)new Gson().toJson(data));
        ReadRowHolder readRowHolder = context.readRowHolder();
        int rowindex = readRowHolder.getRowIndex();
        Map<Integer, String> headMap1 = this.dchExcelImportVO.getHeadMapList().get(0);
        Map<Integer, String> headMap3 = this.dchExcelImportVO.getHeadMapList().get(3);
        HashMap hashMap = new HashMap(16);
        data.forEach((integer, value) -> {
            String columnType = (String)headMap1.get(integer);
            String columnMust = (String)headMap3.get(integer);
            if (columnType == null) {
                hashMap.put(integer, value);
            } else if (columnType.startsWith("VARCHAR")) {
                if (this.checkBank((String)value, columnMust, rowindex, (Integer)integer, hashMap)) {
                    if (!DchExcelColumnCheckUtil.CheckStringlength(value, columnType)) {
                        this.errMsgList.add(this.getErrString(rowindex, (Integer)integer, "\u957f\u5ea6\u8d85\u8fc7\u9650\u5236.", (String)value));
                    } else {
                        hashMap.put(integer, value);
                    }
                }
            } else if (columnType.startsWith("INTEGER") || columnType.startsWith("TINYINT")) {
                if (this.checkBank((String)value, columnMust, rowindex, (Integer)integer, hashMap)) {
                    if (!DchExcelColumnCheckUtil.CheckIntegerLength(value, columnType)) {
                        this.errMsgList.add(this.getErrString(rowindex, (Integer)integer, "\u6570\u636e\u7c7b\u578b\u6216\u957f\u5ea6\u9519\u8bef.", (String)value));
                    } else {
                        hashMap.put(integer, Integer.valueOf(value));
                    }
                }
            } else if (columnType.startsWith("NUMERIC")) {
                if (this.checkBank((String)value, columnMust, rowindex, (Integer)integer, hashMap)) {
                    if (!DchExcelColumnCheckUtil.CheckFloatLength(value, columnType)) {
                        this.errMsgList.add(this.getErrString(rowindex, (Integer)integer, "\u6570\u636e\u7c7b\u578b\u6216\u957f\u5ea6\u9519\u8bef.", (String)value));
                    } else {
                        hashMap.put(integer, Float.valueOf(value));
                    }
                }
            } else if (columnType.startsWith("DATETIME")) {
                if (this.checkBank((String)value, columnMust, rowindex, (Integer)integer, hashMap)) {
                    if (!DchExcelColumnCheckUtil.checkDateTime(value, columnType)) {
                        this.errMsgList.add(this.getErrString(rowindex, (Integer)integer, "\u6570\u636e\u7c7b\u578b\u9519\u8bef.", (String)value));
                    } else {
                        hashMap.put(integer, value);
                    }
                }
            } else {
                hashMap.put(integer, value);
            }
        });
        this.dataMapsList.add(hashMap);
    }

    private boolean checkBank(String value, String columnMust, Integer rowindex, Integer integer, HashMap<Integer, Object> hashMap) {
        boolean columnMustBo = columnMust == null || !"*".equals(columnMust);
        if (StringUtils.isBlank((CharSequence)value) && !columnMustBo) {
            this.errMsgList.add(this.getErrString(rowindex, integer, "\u6570\u636e\u4e0d\u53ef\u4e3a\u7a7a.", value));
            return false;
        }
        if (StringUtils.isBlank((CharSequence)value) && columnMustBo) {
            hashMap.put(integer, null);
            return false;
        }
        return true;
    }

    private String getErrString(int rowindex, Integer integer, String msg, String value) {
        Map<Integer, String> headMap1 = this.dchExcelImportVO.getHeadMapList().get(0);
        Map<Integer, String> headMap3 = this.dchExcelImportVO.getHeadMapList().get(2);
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("\u7b2c").append(rowindex).append("\u884c->\u7b2c").append(integer).append("\u5217->").append(headMap1.get(integer)).append(headMap3.get(integer)).append("->").append(msg).append("\u503c:").append(value);
        return stringBuffer.toString();
    }

    public void doAfterAllAnalysed(AnalysisContext context) {
    }
}

