package com.elitesland.scp.application.facade.vo.param.setting;


import com.elitescloud.boot.common.param.AbstractOrderQueryParam;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.ToString;

import javax.validation.constraints.NotBlank;
import java.util.List;

@Data
@ApiModel(value = "单据类型查询参数")
@ToString(callSuper = true)
@EqualsAndHashCode(callSuper = true)
public class ScpOrderSettingBaseParamVO extends AbstractOrderQueryParam {

    @ApiModelProperty("单据类型")
    private String docType;

    @ApiModelProperty("业务类型")
    @NotBlank(message = "业务类型不能为空")
    private String businessType;

    @ApiModelProperty("品牌")
    private List<String> brands;

}
