package com.elitesland.scp.application.service.calendar;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.scp.application.facade.vo.calendar.*;
import com.elitesland.scp.application.facade.vo.param.calendar.ScpStoreDemandCalendarParam;
import com.elitesland.scp.application.facade.vo.resp.calendar.ScpStoreCalendarExportRespVO;
import com.elitesland.scp.application.facade.vo.resp.calendar.ScpStoreDemandCalendarRespVO;

import java.util.List;

/**
* @description:  
* @author: jeesie.jiang
* @create: 2024-03-28
* @Version 1.0
**/
public interface ScpStoreDemandCalendarService {


    List<ScpStoreDemandCalendarRespVO> listCalendarVOs(ScpStoreDemandCalendarParam scpStoreDemandCalendarParam);


    PagingVO<ScpStoreDemandCalendarPageVO> searchPage(ScpStoreDemandCalendarPageParamVO paramVo);


    void saveStoreCalendar(ScpStoreDemandCalendarSaveVO createParam);

    void deleteStoreCalendar(List<ScpStoreDemandCalendarParamVO> deleteParam);

    ScpStoreDemandCalendarRespVO findStoreCalendarDetail(ScpStoreDemandCalendarParamVO param);

    /**
     * 根据状态\日期校验门店信息是否存在
     * @return
     */
    Boolean isExistStoreByDateAndWorkStatus(ScpCalendarStoreQueryParamVO paramVO);


    /**
     * 根据日期及状态查询门店信息
     * @param paramVO
     * @return
     */
    List<ScpCalendarStoreRespVO> listCalendarStoreByParam(ScpCalendarStoreQueryParamVO paramVO);

    PagingVO<ScpStoreCalendarExportRespVO> export(ScpStoreDemandCalendarPageParamVO paramVO);
}