package com.elitesland.scp.domain.service.authority;

import cn.hutool.core.collection.CollUtil;
import com.elitescloud.boot.core.support.udc.support.SysUdcProxyService;
import com.elitescloud.boot.exception.BusinessException;
import com.elitesland.scp.application.facade.vo.resp.authority.ScpsmanAuthorityDRespVO;
import com.elitesland.scp.domain.entity.authority.ScpsmanAuthorityDDO;
import com.elitesland.scp.enums.ScpUdcEnum;
import com.elitesland.scp.infr.repo.authority.ScpDemandAuthorityDRepo;
import com.elitesland.scp.infr.repo.authority.ScpDemandAuthorityDRepoProc;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;

import java.util.List;

@Slf4j
@Service
@RequiredArgsConstructor
public class ScpDemandAuthprityDServiceImpl implements ScpDemandAuthorityDService {

    private final ScpDemandAuthorityDRepoProc scpDemandAuthorityDRepoProc;
    private final ScpDemandAuthorityDRepo scpDemandAuthorityDRepo;
    private final SysUdcProxyService sysUdcProxyService;
    private final ScpDemandAuthorityManager scpDemandAuthorityManager;

    @Override
    public void deleteByIds(List<Long> ids) {
        scpDemandAuthorityDRepoProc.deleteByIds(ids);
    }

    @Override
    public void deleteByDIds(List<Long> ids) {
        if (CollUtil.isEmpty(ids)) {
            return;
        }
        scpDemandAuthorityDRepoProc.deleteByDIds(ids);

        var filterIds = scpDemandAuthorityDRepoProc.filterNoManual(ids);
        if (!filterIds.isEmpty()) {
            throw new BusinessException("只能删除手工添加的权限");
        }
    }


    @Override
    public List<ScpsmanAuthorityDRespVO> findbyMasId(Long id) {
        List<ScpsmanAuthorityDRespVO> scpsmanAuthorityDRespVOS = scpDemandAuthorityDRepoProc.findbyMasId(id);
        //udc翻译
        sysUdcProxyService.translate(scpsmanAuthorityDRespVOS);

        // 区域翻译
        scpDemandAuthorityManager.convertRegionName(scpsmanAuthorityDRespVOS, t -> ScpUdcEnum.SCPSMAN_AUTHORITY_TYPE_1.getValueCode().equals(t.getType() + ""),
                ScpsmanAuthorityDRespVO::getRegion, ScpsmanAuthorityDRespVO::setRegionName);

        return scpsmanAuthorityDRespVOS;
    }

    @Override
    public List<ScpsmanAuthorityDDO> saveScpManAuthority(List<ScpsmanAuthorityDDO> collect) {
        return scpDemandAuthorityDRepo.saveAll(collect);
    }


}
