package com.elitesland.scp.domain.service.purLimit;

import cn.hutool.core.collection.CollUtil;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.scp.application.facade.vo.param.purLimit.ScpPurLimitSettingRegionPageParamVO;
import com.elitesland.scp.application.facade.vo.resp.purLimit.ScpPurLimitSettingRegionRespVO;
import com.elitesland.scp.application.facade.vo.save.purLimit.ScpPurLimitSettingRegionSaveVO;
import com.elitesland.scp.domain.convert.purLimit.ScpPurLimitSettingRegionConvert;
import com.elitesland.scp.domain.entity.purLimit.ScpPurLimitSettingRegionDO;
import com.elitesland.scp.infr.repo.purLimit.ScpPurLimitSettingRegionRepo;
import com.elitesland.scp.infr.repo.purLimit.ScpPurLimitSettingRegionRepoProc;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.ArrayList;
import java.util.List;

@Slf4j
@Service
@RequiredArgsConstructor
public class ScpPurLimitSettingRegionDomainServiceImpl implements ScpPurLimitSettingRegionDomainService {

    private final ScpPurLimitSettingRegionRepo scpPurLimitSettingRegionRepo;
    private final ScpPurLimitSettingRegionRepoProc scpPurLimitSettingRegionRepoProc;

    @Override
    public List<ScpPurLimitSettingRegionRespVO> findByMasId(Long masId) {
        List<ScpPurLimitSettingRegionDO> settingItemDOS = scpPurLimitSettingRegionRepo.findByMasId(masId);
        if (CollUtil.isNotEmpty(settingItemDOS)) {
            return ScpPurLimitSettingRegionConvert.INSTANCE.dosToRespVOS(settingItemDOS);
        }
        return new ArrayList<>();
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public void batchSaveSettingRegion(List<ScpPurLimitSettingRegionSaveVO> saveVOS) {
        scpPurLimitSettingRegionRepo.saveAll(ScpPurLimitSettingRegionConvert.INSTANCE.saveVosDOS(saveVOS));
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public void deleteByMasId(Long masId) {
        scpPurLimitSettingRegionRepo.deleteByMasId(masId);
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public void deleteByIds(List<Long> ids) {
        scpPurLimitSettingRegionRepo.deleteByIds(ids);
    }

    @Override
    public PagingVO<ScpPurLimitSettingRegionRespVO> page(ScpPurLimitSettingRegionPageParamVO paramVO) {
        long count = scpPurLimitSettingRegionRepoProc.countPurLimitSettingRegion(paramVO);
        if (count > 0) {
            List<ScpPurLimitSettingRegionRespVO> respVOList = scpPurLimitSettingRegionRepoProc.queryPurLimitSettingRegion(paramVO);
            return new PagingVO<>(count, respVOList);
        }
        return new PagingVO<>();
    }

    @Override
    public List<Long> findMasIdByRegionCode(String regionCode) {
        return scpPurLimitSettingRegionRepoProc.findMasIdByRegionCode(regionCode);
    }
}
