package com.elitesland.scp.application.facade.vo.serviceconfig;

import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import java.io.Serializable;

/**
 * @author chaofeng.xia
 * @since 2025/5/23
 */
@Data
@ApiModel("项目服务配置详情查询")
public class ScpServiceConfigBaseParamVO implements Serializable {

    @ApiModelProperty("类型")
    @NotBlank(message = "项目服务配置类型 为空")
    private String type;

    @ApiModelProperty("区域id/门店id")
    @NotNull(message = "区域id/门店id 为空")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long regionStoreId;

}

