package com.elitesland.scp.domain.entity.survey;

import com.elitescloud.boot.model.entity.BaseModel;
import com.elitescloud.cloudt.common.annotation.Comment;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;
import lombok.experimental.Accessors;
import org.hibernate.annotations.DynamicInsert;
import org.hibernate.annotations.DynamicUpdate;
import org.hibernate.annotations.Where;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;
import java.io.Serial;
import java.io.Serializable;

@Entity
@Table(name = "scp_survey_answer", indexes = {
})
@Comment("问卷")
@Getter
@Setter
@DynamicInsert
@DynamicUpdate
@Accessors(chain = true)
@Where(clause = "delete_flag = 0 or delete_flag is null")
public class SurveyAnswerDO extends BaseModel implements Serializable {
    @Serial
    private static final long serialVersionUID = -4254921460115216468L;

    @ApiModelProperty("问卷ID")
    @Column(name = "suv_id")
    private Long suvId;

    @ApiModelProperty("问题ID")
    @Column(name = "qus_id")
    private Long qusId;

    @ApiModelProperty("选项ID")
    @Column(name = "opt_id")
    private Long optId;

    @ApiModelProperty("填空题")
    @Column(name = "opt_content")
    private String optContent;

    @ApiModelProperty("用户ID")
    @Column(name = "user_id")
    private Long userId;

    @ApiModelProperty("账号")
    @Column(name = "username")
    private String username;

    @ApiModelProperty("公司ID")
    @Column(name = "ouId")
    private Long ouId;

    @ApiModelProperty("公司编码")
    @Column(name = "ou_code")
    private String ouCode;

    @ApiModelProperty("公司名称")
    @Column(name = "ou_name")
    private String ouName;



}
