/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.scp.mq;

import com.alibaba.fastjson.JSON;
import com.elitescloud.boot.mq.MessageQueueListener;
import com.elitesland.scp.infr.repo.supalloc.ScpSupplyAllocationRepoProc;
import com.elitesland.scp.infr.repo.template.ScpDemandOrderTemplateRepoProc;
import com.elitesland.scp.infr.repo.whnet.ScpWhNetRelationRepoProc;
import com.elitesland.support.provider.out.OrgStoreUpdateMqParam;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotEmpty;
import javax.validation.constraints.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@Component
public class OrgStoreUpdateListener
implements MessageQueueListener<OrgStoreUpdateMqParam> {
    private static final Logger log = LoggerFactory.getLogger(OrgStoreUpdateListener.class);
    private final ScpWhNetRelationRepoProc scpWhNetRelationRepoProc;
    private final ScpSupplyAllocationRepoProc scpSupplyAllocationRepoProc;
    private final ScpDemandOrderTemplateRepoProc scpDemandOrderTemplateRepoProc;

    @NotEmpty
    public String[] channels() {
        return new String[]{"org_store_update"};
    }

    @Transactional(rollbackFor={Exception.class})
    public void onConsume(@NotBlank String s, @NotNull OrgStoreUpdateMqParam orgStoreUpdateMqParam) {
        log.info("\u95e8\u5e97\u53d8\u66f4\uff1a" + JSON.toJSONString((Object)orgStoreUpdateMqParam));
        Long storeId = orgStoreUpdateMqParam.getStoreId();
        String storeName = orgStoreUpdateMqParam.getStoreName();
        this.scpWhNetRelationRepoProc.updateStoreNameByStoreId(storeId, storeName);
        this.scpSupplyAllocationRepoProc.updateStoreNameByStoreId(storeId, storeName);
        this.scpDemandOrderTemplateRepoProc.updateStoreNameByStoreId(storeId, storeName);
    }

    public OrgStoreUpdateListener(ScpWhNetRelationRepoProc scpWhNetRelationRepoProc, ScpSupplyAllocationRepoProc scpSupplyAllocationRepoProc, ScpDemandOrderTemplateRepoProc scpDemandOrderTemplateRepoProc) {
        this.scpWhNetRelationRepoProc = scpWhNetRelationRepoProc;
        this.scpSupplyAllocationRepoProc = scpSupplyAllocationRepoProc;
        this.scpDemandOrderTemplateRepoProc = scpDemandOrderTemplateRepoProc;
    }
}

