package com.elitesland.scp.application.web.app.activity;

import cn.hutool.json.JSONUtil;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.scp.application.facade.vo.param.app.AppItemActivityParamVO;
import com.elitesland.scp.application.facade.vo.param.app.AppItemPageParamVO;
import com.elitesland.scp.application.facade.vo.param.app.AppItemSpecParamVO;
import com.elitesland.scp.application.facade.vo.param.app.CommonItemPageParamVO;
import com.elitesland.scp.application.facade.vo.resp.app.AppItemActivityRespVO;
import com.elitesland.scp.application.facade.vo.resp.app.AppItemSpecRespVO;
import com.elitesland.scp.application.facade.vo.resp.app.AppItmItemPageVO;
import com.elitesland.scp.application.facade.vo.resp.app.AppItmSpuRespVO;
import com.elitesland.scp.application.service.app.AppItemActivityService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.AllArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.http.MediaType;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import java.util.concurrent.ExecutionException;


@Slf4j
@Api(tags = "移动端-甲指乙采商品")
@RestController
@RequestMapping(value = "/dbo/app/activity", produces = MediaType.APPLICATION_JSON_VALUE)
@AllArgsConstructor
public class AppDboItemActivityController {

    private final AppItemActivityService appItemActivityService;

    @PostMapping("/skuItems")
    @ApiOperation("商品列表 - 商品列表(sku)")
    public ApiResult<PagingVO<AppItmItemPageVO>> queryDboSkuItemList(@RequestBody @Validated AppItemPageParamVO paramVO) throws ExecutionException, InterruptedException {
        log.info("[APP-SCP-ITEMlIST] query  paramVO ={}", JSONUtil.toJsonStr(paramVO));
        return ApiResult.ok(appItemActivityService.skuDboItemPage(paramVO));
    }

}
