package com.elitesland.scp.domain.entity.stock;

import com.elitescloud.boot.model.entity.BaseModel;
import com.elitescloud.cloudt.common.annotation.Comment;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.experimental.Accessors;
import org.hibernate.annotations.DynamicInsert;
import org.hibernate.annotations.DynamicUpdate;
import org.hibernate.annotations.Where;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;
import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDateTime;


/**
* @description: 供应链计划-预测安全库存目标库存
* @author: jeesie.jiang
* @create: 2025-01-21
* @Version 1.0
**/
@Data
@DynamicInsert
@DynamicUpdate
@Entity
@Where(clause = "delete_flag = 0 or delete_flag is null")
@Table(name = "scp_predict_st_stock")
@org.hibernate.annotations.Table(appliesTo = "scp_predict_st_stock", comment = "供应链计划-预测安全库存目标库存")
public class ScpPredictStStockDO extends BaseModel implements Serializable {

    @Column(name = "mas_id", columnDefinition = "bigint")
    @Comment("主表ID")
    private Long masId;

    @Column(name = "st_id", columnDefinition = "bigint")
    @Comment("主表ID")
    private Long stId;

    @Column(name = "ou_id", columnDefinition = "bigint")
    @Comment("公司ID")
    private Long ouId;

    @Column(name = "ou_code", columnDefinition = "varchar(40)")
    @Comment("公司编码")
    private String ouCode;

    @Column(name = "ou_name", columnDefinition = "varchar(48)")
    @Comment("公司名称")
    private String ouName;

    @Column(name = "wh_id", columnDefinition = "bigint")
    @Comment("仓库ID")
    private Long whId;

    @Column(name = "wh_code", columnDefinition = "varchar(40)")
    @Comment("仓库编码")
    private String whCode;

    @Column(name = "wh_name", columnDefinition = "varchar(48)")
    @Comment("仓库名称")
    private String whName;

    @Column(name = "item_id", columnDefinition = "bigint")
    @Comment("商品ID")
    private Long itemId;

    @Column(name = "item_code", columnDefinition = "varchar(40)")
    @Comment("商品编码")
    private String itemCode;

    @Column(name = "item_name", columnDefinition = "varchar(48)")
    @Comment("商品名称")
    private String itemName;

    @Column(name = "safety_qty", columnDefinition = "decimal(20,8)")
    @Comment("安全库存")
    private BigDecimal safetyQty;

    @Column(name = "target_qty", columnDefinition = "decimal(20,8)")
    @Comment("安全库存")
    private BigDecimal targetQty;

    @Column(name = "plan_uom", columnDefinition = "varchar(10)")
    @Comment("计划单位")
    private String planUom;

    @Column(name = "uom", columnDefinition = "varchar(10)")
    @Comment("计划基本单位")
    private String uom;

    @Column(name = "item_type2", columnDefinition = "varchar(40)")
    @Comment("商品类型2")
    private String itemType2;

    @Column(name = "item_cate_code", columnDefinition = "varchar(40)")
    @Comment("商品类型2")
    private String itemCateCode;

    @Column(name = "brand", columnDefinition = "varchar(40)")
    @Comment("品牌")
    private String brand;

    @Column(name = "io_qty", columnDefinition = "decimal(20,8)")
    @Comment("统计库存")
    private BigDecimal ioQty;

    @Column(name = "uom_ratio", columnDefinition = "decimal(20,8),default 1")
    @Comment("转换率")
    private BigDecimal uomRatio;

    @Column(name = "pred_safety_qty", columnDefinition = "decimal(20,8)")
    @Comment("预测安全库存")
    private BigDecimal predSafetyQty;

    @Column(name = "pred_target_qty", columnDefinition = "decimal(20,8)")
    @Comment("预测目标库存")
    private BigDecimal predTargetQty;

    @Column(name = "business_id", columnDefinition = "varchar(63)")
    @Comment("业务keyID")
    private String businessId;

    /**
     * 采购交期(天)
     */
    @ApiModelProperty(value = "采购交期(天)")
    @Comment("采购交期(天)")
    @Column(length = 20)
    private Integer purDelivPeriod;

    @ApiModelProperty(value = "采购提前期(天)")
    @Comment("采购提前期(天)")
    @Column(length = 20)
    private Integer purAheadPeriod;

    @ApiModelProperty(value = "收货处理天数(天)")
    @Comment("收货处理天数(天)")
    @Column(length = 20)
    private Integer recvHandlerDays;


    @ApiModelProperty(value = "安全库存系数")
    @Comment("安全库存系数")
    @Column(name = "safe_stock_ratio",columnDefinition = "decimal(20,4) default 1")
    private BigDecimal safeStockRatio;

    @ApiModelProperty(value = "目标库存系数")
    @Comment("目标库存系数")
    @Column(name = "target_stock_ratio",columnDefinition = "decimal(20,4) default 1")
    private BigDecimal targetStockRatio;

    @ApiModelProperty(value = "是否生成MRP计划")
    @Comment("是否生成MRP计划")
    @Column(name = "mrp_flag",columnDefinition = "tinyint(1) default 0")
    private Boolean mrpFlag;

    @ApiModelProperty(name = "有效小数为准")
    @Comment("有效小数为准")
    @Column(name = "decimal_places",columnDefinition = "int(11) default 4")
    private Integer decimalPlaces;

}