package com.elitesland.scp.infr.repo.scpsman;

import cn.hutool.core.collection.CollectionUtil;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.scp.application.facade.vo.scpsman.SalesmanComponentPageRespVO;
import com.elitesland.scp.application.facade.vo.scpsman.SalesmanParamVO;
import com.elitesland.scp.domain.entity.scpsman.QScpsmanInfoDO;
import com.querydsl.core.types.ExpressionUtils;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.Projections;
import com.querydsl.jpa.impl.JPAQuery;
import com.querydsl.jpa.impl.JPAQueryFactory;
import lombok.RequiredArgsConstructor;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Component;

import java.util.ArrayList;
import java.util.List;

/**
 * @Auther: Mark
 * @Date: 2024/3/22 10:37
 * @Description:
 */
@Component
@RequiredArgsConstructor
public class ScpsmanComponentRepoProc {
    private final JPAQueryFactory jpaQueryFactory;
    private static final QScpsmanInfoDO scpsmanInfoDO = QScpsmanInfoDO.scpsmanInfoDO;


    public PagingVO<SalesmanComponentPageRespVO> salemanComponemtPage(SalesmanParamVO paramVO){
        JPAQuery<SalesmanComponentPageRespVO> query = jpaQueryFactory.select(Projections.bean(SalesmanComponentPageRespVO.class,
                scpsmanInfoDO.id,
                scpsmanInfoDO.scpsmanNo,
                scpsmanInfoDO.scpsmanType,
                scpsmanInfoDO.loginAccount,
                scpsmanInfoDO.name,
                scpsmanInfoDO.ouName,
                scpsmanInfoDO.ouId,
                scpsmanInfoDO.ouCode,
                scpsmanInfoDO.enableStatus
        )).from(scpsmanInfoDO)
                .where(componmentPageWhere(paramVO));
        paramVO.setPaging(query);
        paramVO.fillOrders(query, scpsmanInfoDO);
        return PagingVO.<SalesmanComponentPageRespVO>builder()
                .total(query.fetchCount())
                .records(query.fetch())
                .build();
    }



    public Predicate componmentPageWhere(SalesmanParamVO paramVO){
        List<Predicate> list = new ArrayList<>();
        list.add(scpsmanInfoDO.deleteFlag.eq(0));
        if(StringUtils.isNotBlank(paramVO.getEmpCodeName())){
            list.add(scpsmanInfoDO.name.contains(paramVO.getEmpCodeName()).or(scpsmanInfoDO.scpsmanNo.contains(paramVO.getEmpCodeName())));
        }
        if(ObjectUtils.isNotEmpty(paramVO.getEnableStatus())){
            list.add(scpsmanInfoDO.enableStatus.eq(paramVO.getEnableStatus()));
        }
        if(CollectionUtil.isNotEmpty(paramVO.getSalesmanTypeList())){
            list.add(scpsmanInfoDO.scpsmanType.in(paramVO.getSalesmanTypeList()));
        }
        if(StringUtils.isNotEmpty(paramVO.getLoginAccount())){
            list.add(scpsmanInfoDO.loginAccount.contains(paramVO.getLoginAccount()));
        }
        if(ObjectUtils.isNotEmpty(paramVO.getOuId())){
            list.add(scpsmanInfoDO.ouId.eq(paramVO.getOuId()));
        }
        if(StringUtils.isNotBlank(paramVO.getOuCode())){
            list.add(scpsmanInfoDO.ouCode.eq(paramVO.getOuCode()));
        }
        if(StringUtils.isNotBlank(paramVO.getOuCodeName())){
            list.add(scpsmanInfoDO.ouCode.contains(paramVO.getOuCodeName()).or(scpsmanInfoDO.ouName.contains(paramVO.getOuCodeName())));
        }
        if(CollectionUtil.isNotEmpty(paramVO.getCodes())){
            list.add(scpsmanInfoDO.scpsmanNo.in(paramVO.getCodes()));
        }
        return ExpressionUtils.allOf(list);
    }

}
