package com.elitesland.scp.application.service.mrp;


import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.scp.application.facade.vo.param.mrp.ScpThousandUseRefParam;
import com.elitesland.scp.application.facade.vo.resp.mrp.ScpThousandUseRefVO;

import java.util.List;

/**
 * 千元用量商品关联
 *
 * @author wangly
 * @date 2025-03-29
 */
public interface ScpThousandUseRefService {

    /**
     * 分页列表
     *
     * @param param 条件
     * @return {@link PagingVO}<{@link ScpThousandUseRefVO}>
     */
    PagingVO<ScpThousandUseRefVO> queryPaging(ScpThousandUseRefParam param);

    /**
     * 查询列表
     *
     * @param param 条件参数
     * @return {@link List}<{@link ScpThousandUseRefVO}>
     */
    List<ScpThousandUseRefVO> queryListDynamic(ScpThousandUseRefParam param);

    /**
     * 通过主键查询
     *
     * @param key 主键
     * @return {@link ScpThousandUseRefVO}
     */
    ScpThousandUseRefVO queryByKey(Long key);

    /**
     * 新增
     *
     * @param param 单据数据
     * @return {@link ScpThousandUseRefVO}
     */
    ScpThousandUseRefVO insert(ScpThousandUseRefParam param);

    /**
     * 修改
     *
     * @param param 单据数据
     * @return {@link ScpThousandUseRefVO}
     */
    ScpThousandUseRefVO update(ScpThousandUseRefParam param);

    /**
     * 修改,置空的字段需需要借助 protected List<String> nullFields;
     *
     * @param param 单据数据
     * @return {@link long}
     */
    long updateByKeyDynamic(ScpThousandUseRefParam param);

    /**
     * 逻辑删除
     *
     * @param keys 主键集合
     */
    void deleteSoft(List<Long> keys);

}
