/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.scp.domain.service.whnet;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.collection.CollectionUtil;
import com.elitescloud.cloudt.common.annotation.SysCodeProc;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.scp.application.facade.vo.param.app.AppItemPageParamVO;
import com.elitesland.scp.application.facade.vo.whnet.ScpWhNetRelationExportRespVO;
import com.elitesland.scp.application.facade.vo.whnet.ScpWhNetRelationPageParamVO;
import com.elitesland.scp.application.facade.vo.whnet.ScpWhNetRelationPageVO;
import com.elitesland.scp.application.facade.vo.whnet.ScpWhNetRelationRespVO;
import com.elitesland.scp.domain.convert.inv.ScpWhNetRelationConvert;
import com.elitesland.scp.domain.entity.whnet.ScpWhNetRelationDO;
import com.elitesland.scp.domain.service.whnet.ScpWhNetRelationDomainService;
import com.elitesland.scp.infr.dto.whnet.ScpWhNetRelationDTO;
import com.elitesland.scp.infr.repo.whnet.ScpWhNetRelationRepo;
import com.elitesland.scp.infr.repo.whnet.ScpWhNetRelationRepoProc;
import com.elitesland.scp.rmi.RmiOrgOuService;
import com.elitesland.support.provider.org.dto.OrgOuRpcSimpleDTO;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class ScpWhNetRelationDomainServiceImpl
implements ScpWhNetRelationDomainService {
    private static final Logger log = LoggerFactory.getLogger(ScpWhNetRelationDomainServiceImpl.class);
    private final ScpWhNetRelationRepoProc scpWhNetRelationRepoProc;
    private final ScpWhNetRelationRepo scpWhNetRelationRepo;
    private final RmiOrgOuService rmiOrgOuService;

    @Override
    @SysCodeProc
    public PagingVO<ScpWhNetRelationPageVO> page(ScpWhNetRelationPageParamVO queryParam) {
        PagingVO<ScpWhNetRelationPageVO> page = this.scpWhNetRelationRepoProc.page(queryParam);
        if (CollUtil.isNotEmpty((Collection)page.getRecords())) {
            List<String> concatKey = page.getRecords().stream().map(d -> d.getDemandWhStCode() + this.setEmptyStringStr(d.getDeliveryType()) + this.setEmptyStringStr(d.getItemCateCode()) + this.setEmptyStringStr(d.getItemCode())).toList();
            HashSet<String> storeCodeSet = new HashSet<String>();
            HashSet<String> deliverySet = new HashSet<String>();
            HashSet<String> itemCodeSet = new HashSet<String>();
            HashSet<String> itemCateCodeSet = new HashSet<String>();
            for (ScpWhNetRelationPageVO record : page.getRecords()) {
                Optional.ofNullable(record.getDemandWhStCode()).ifPresent(storeCodeSet::add);
                Optional.ofNullable(record.getDeliveryType()).ifPresent(deliverySet::add);
                Optional.ofNullable(record.getItemCode()).ifPresent(itemCodeSet::add);
                Optional.ofNullable(record.getItemCateCode()).ifPresent(itemCateCodeSet::add);
            }
            List<ScpWhNetRelationDO> relationDOList = this.scpWhNetRelationRepoProc.findByConcatKey(storeCodeSet, deliverySet, itemCodeSet, itemCateCodeSet);
            Map<String, List<ScpWhNetRelationDO>> scpWhNetMap = relationDOList.stream().filter(d -> concatKey.contains(d.getDemandWhStCode() + this.setEmptyStringStr(d.getDeliveryType()) + this.setEmptyStringStr(d.getItemCateCode()) + this.setEmptyStringStr(d.getItemCode()))).collect(Collectors.groupingBy(d -> d.getDemandWhStCode() + this.setEmptyStringStr(d.getItemCateCode()) + this.setEmptyStringStr(d.getItemCode())));
            List<String> purCompanyCodes = page.getRecords().stream().map(ScpWhNetRelationPageVO::getPurCompanyCode).filter(StringUtils::isNotBlank).toList();
            Map<String, OrgOuRpcSimpleDTO> ouMap = this.rmiOrgOuService.findOuDtoMapByOuCodes(purCompanyCodes);
            page.getRecords().forEach(d -> {
                if (scpWhNetMap.get(d.getDemandWhStCode() + this.setEmptyStringStr(d.getItemCateCode()) + this.setEmptyStringStr(d.getItemCode())) != null) {
                    OrgOuRpcSimpleDTO ouDTO;
                    List scpWhNetRelationDOS = (List)scpWhNetMap.get(d.getDemandWhStCode() + this.setEmptyStringStr(d.getDeliveryType()) + this.setEmptyStringStr(d.getItemCateCode()) + this.setEmptyStringStr(d.getItemCode()));
                    if (!CollectionUtil.isEmpty((Collection)scpWhNetRelationDOS)) {
                        BigDecimal sum = scpWhNetRelationDOS.stream().map(ScpWhNetRelationDO::getSupplyPercentage).filter(Objects::nonNull).reduce(BigDecimal.ZERO, BigDecimal::add);
                        d.setSupplyPercentageSum(sum);
                    }
                    if ((ouDTO = (OrgOuRpcSimpleDTO)ouMap.get(d.getPurCompanyCode())) != null) {
                        d.setPurCompanyName(ouDTO.getOuName());
                    }
                }
            });
        }
        return page;
    }

    public String setEmptyStringStr(String str) {
        return str == null ? "" : str;
    }

    @Override
    public List<ScpWhNetRelationDO> findByConcatKey(Set<String> concatKey) {
        ArrayList<String> stringList = new ArrayList<String>(concatKey);
        return this.scpWhNetRelationRepo.findByConcatKey(stringList);
    }

    @Override
    public List<ScpWhNetRelationDO> findByBusinessKey(String demandWhStCode, String deliveryType, String itemCateCode, String itemCode) {
        return this.scpWhNetRelationRepoProc.findByAllBusinessKey(demandWhStCode, deliveryType, itemCateCode, itemCode);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void deleteByConcatKey(Set<String> concatKey) {
        if (CollUtil.isEmpty(concatKey)) {
            return;
        }
        ArrayList<String> stringList = new ArrayList<String>(concatKey);
        this.scpWhNetRelationRepo.deleteByConcatKey(stringList);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void createBatch(List<ScpWhNetRelationDTO> scpWhNetRelationList) {
        this.scpWhNetRelationRepo.saveAll(scpWhNetRelationList.stream().map(ScpWhNetRelationConvert.INSTANCE::dtoToDo).collect(Collectors.toList()));
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void deleteBatch(List<Long> ids) {
        this.scpWhNetRelationRepo.deleteAllById(ids);
    }

    @Override
    @SysCodeProc
    public PagingVO<ScpWhNetRelationExportRespVO> exportSearch(ScpWhNetRelationPageParamVO queryParam) {
        PagingVO<ScpWhNetRelationExportRespVO> page = this.scpWhNetRelationRepoProc.exportSearch(queryParam);
        if (CollUtil.isNotEmpty((Collection)page.getRecords())) {
            this.pageHandeler(page);
        }
        return page;
    }

    @Override
    @SysCodeProc
    public PagingVO<ScpWhNetRelationPageVO> queryitemByStoreCode(AppItemPageParamVO paramVO) {
        PagingVO<ScpWhNetRelationPageVO> page = this.scpWhNetRelationRepoProc.queryitemByStoreCode(paramVO);
        return page;
    }

    @Override
    public List<ScpWhNetRelationDO> findByIds(List<Long> ids) {
        return this.scpWhNetRelationRepo.findByIdIn(ids);
    }

    private void pageHandeler(PagingVO<ScpWhNetRelationExportRespVO> page) {
        List<String> concatKey = page.getRecords().stream().map(d -> d.getDemandWhStCode() + this.setEmptyStringStr(d.getDeliveryType()) + this.setEmptyStringStr(d.getItemCateCode()) + this.setEmptyStringStr(d.getItemCode())).collect(Collectors.toList());
        List<ScpWhNetRelationDO> relationDOList = this.scpWhNetRelationRepo.findByConcatKey(concatKey);
        Map<String, List<ScpWhNetRelationDO>> scpWhNetMap = relationDOList.stream().collect(Collectors.groupingBy(d -> d.getDemandWhStCode() + this.setEmptyStringStr(d.getItemCateCode()) + this.setEmptyStringStr(d.getItemCode())));
        page.getRecords().forEach(d -> {
            d.setStatusName("\u542f\u7528");
            if (Boolean.FALSE.equals(d.getStatus())) {
                d.setStatusName("\u7981\u7528");
            }
            if (scpWhNetMap.get(d.getDemandWhStCode() + this.setEmptyStringStr(d.getItemCateCode()) + this.setEmptyStringStr(d.getItemCode())) != null) {
                BigDecimal sum = ((List)scpWhNetMap.get(d.getDemandWhStCode() + this.setEmptyStringStr(d.getItemCateCode()) + this.setEmptyStringStr(d.getItemCode()))).stream().map(ScpWhNetRelationDO::getSupplyPercentage).filter(Objects::nonNull).reduce(BigDecimal.ZERO, BigDecimal::add);
                d.setSupplyPercentageSum(sum);
            }
        });
    }

    @Override
    public List<ScpWhNetRelationRespVO> findAllNotItem() {
        return this.scpWhNetRelationRepoProc.findAllNotItem();
    }

    public ScpWhNetRelationDomainServiceImpl(ScpWhNetRelationRepoProc scpWhNetRelationRepoProc, ScpWhNetRelationRepo scpWhNetRelationRepo, RmiOrgOuService rmiOrgOuService) {
        this.scpWhNetRelationRepoProc = scpWhNetRelationRepoProc;
        this.scpWhNetRelationRepo = scpWhNetRelationRepo;
        this.rmiOrgOuService = rmiOrgOuService;
    }
}

