/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.scp.pay.controller;

import cn.hutool.json.JSONUtil;
import com.elitescloud.boot.common.annotation.BusinessObjectOperation;
import com.elitescloud.boot.common.annotation.businessobject.OperationTypeEnum;
import com.elitesland.scp.pay.service.AccountBatchBindService;
import com.elitesland.scp.pay.service.PaymentService;
import com.elitesland.scp.pay.service.RefundsService;
import com.tenpay.business.entpay.mse.sdk.exception.EntpayException;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.configurationprocessor.json.JSONException;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/notify"})
public class NotifyVerifyController {
    private static final Logger log = LoggerFactory.getLogger(NotifyVerifyController.class);
    private final PaymentService paymentService;
    private final RefundsService refundsService;
    private final AccountBatchBindService accountBatchBindService;

    @ResponseBody
    @PostMapping(value={"/payments/app-registering-pay"})
    public String paymentNotify(HttpServletRequest request, @RequestBody String body, @RequestHeader(value="TBEP-Authorization") String authorization) throws EntpayException, JSONException {
        log.info("\u652f\u4ed8\u56de\u8c03\u901a\u77e5\u6570\u636e,body\uff1a{},authorization:{}", (Object)JSONUtil.toJsonStr((Object)body), (Object)JSONUtil.toJsonStr((Object)authorization));
        return this.paymentService.paymentNotify(body, authorization);
    }

    @ResponseBody
    @PostMapping(value={"/refund"})
    public String refundNotify(HttpServletRequest request, @RequestBody String body, @RequestHeader(value="TBEP-Authorization") String authorization) throws EntpayException, JSONException {
        return this.refundsService.refundNotify(body, authorization);
    }

    @ResponseBody
    @PostMapping(value={"/bind"})
    @BusinessObjectOperation(operationType=OperationTypeEnum.SAVE, operationDescription="\u6279\u91cf\u5f00\u6237\u56de\u8c03\u901a\u77e5", allowRepeatRequest=false, repeatIntervalMillis=3000, businessParamValueKey="#p0")
    public String bindNotify(HttpServletRequest request, @RequestBody String body, @RequestHeader(value="TBEP-Authorization") String authorization) throws EntpayException, JSONException {
        log.info("\u6279\u91cf\u5f00\u6237\u56de\u8c03\u901a\u77e5\u6570\u636e,body\uff1a{},authorization:{}", (Object)JSONUtil.toJsonStr((Object)body), (Object)JSONUtil.toJsonStr((Object)authorization));
        return this.accountBatchBindService.accountBindNotify(body, authorization);
    }

    public NotifyVerifyController(PaymentService paymentService, RefundsService refundsService, AccountBatchBindService accountBatchBindService) {
        this.paymentService = paymentService;
        this.refundsService = refundsService;
        this.accountBatchBindService = accountBatchBindService;
    }
}

