package com.elitesland.scp.application.facade.vo.resp.mrp;

import com.elitescloud.boot.common.param.BaseViewModel;
import com.elitescloud.cloudt.common.annotation.SysCode;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.util.List;

@Data
@ApiModel("物料需求计划")
public class ScpMrpRespVO extends BaseViewModel implements Serializable {

    private static final long serialVersionUID = -5275637264888676750L;

    @ApiModelProperty("mrp批次")
    private String mrpLotNo;

    @ApiModelProperty("预测批次")
    private String predLotNo;

    @ApiModelProperty("计算状态")
    @SysCode(sys = "yst-suplan", mod = "MRP_CAlC_STATUS")
    private String calcStatus;
    private String calcStatusName;

    @ApiModelProperty("推送状态")
    @SysCode(sys = "yst-suplan", mod = "MRP_PUSH_STATUS")
    private String pushStatus;
    private String pushStatusName;

    @ApiModelProperty("公司名称 多公司，用；隔开")
    private String ouName;

    @ApiModelProperty("物料需求计划明细")
    private List<ScpMrpDRespVO> scpMrpDRespVOList;

    @ApiModelProperty("计算失败原因")
    private String calcFailReason;

    @ApiModelProperty("推送失败原因")
    private String pushFailReason;


}
