package com.elitesland.scp.application.facade.vo.save.calendar;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import java.io.Serializable;

@Data
@ApiModel(value = "单据类型配置保存参数")
public class ScpStoreCalendarSetLineSaveVO implements Serializable {
    private static final long serialVersionUID = -3342841575717594695L;

    @ApiModelProperty("记录唯一ID")
    private Long id;

    @NotNull(message = "主表ID不能为空")
    private Long masId;

    @ApiModelProperty(value = "星期x,[1:星期一，2:星期二，3：星期三，依次类推]",required = true)
    @NotNull(message = "星期X不能为空")
    private Integer todayWeek;

    @ApiModelProperty(value = "区域/门店ID",required = true)
    @NotNull(message = "区域/门店ID不能为空")
    private Long storeId;

    @ApiModelProperty(value = "区域/门店编码",required = true)
    @NotBlank(message = "区域/门店编码不能为空")
    private String storeCode;

    @ApiModelProperty(value = "区域/门店名称",required = true)
    @NotBlank(message = "区域/门店名称不能为空")
    private String storeName;

    @ApiModelProperty(value = "经营性质",required = true)
    private String storeType2;

    @ApiModelProperty(value = "公司ID",required = true)
    private Long ouId;

    @ApiModelProperty(value = "公司编码",required = true)
    private String ouCode;

    @ApiModelProperty(value = "客户ID",required = true)
    private Long custId;

    @ApiModelProperty(value = "客户编码",required = true)
    private String custCode;

    @ApiModelProperty(value = "品牌编码",required = true)
    private String brandCode;

    @ApiModelProperty(value = "区域编码",required = true)
    private String regionCode;

}
