package com.elitesland.scp.application.facade.vo.template;

import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import java.io.Serializable;
import java.math.BigDecimal;

/**
 * @Auther: Mark
 * @Date: 2024/4/29 10:58
 * @Description:
 */
@Data
@ApiModel("下单成功部分数据结果")
public class DemandOrderApplySuccessRespVO implements Serializable {

    @ApiModelProperty("商品id")
    private Long itemId;

    @ApiModelProperty("商品编号")
    private String itemCode;

    @ApiModelProperty("商品名称")
    private String itemName;

    @ApiModelProperty("SPU商品编码")
    @NotNull(message = "SPU商品编码不能为空")
    private String spuItemCode;
    private String spuItemName;

    @ApiModelProperty("spuId")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long spuId;


    @ApiModelProperty(value = "商品单位", required = true)
    @NotBlank(message = "商品单位不能为空")
    private String uom;
    private String uomName;

    @ApiModelProperty(value = "需求数量")
    private BigDecimal demandQuantity;

    @ApiModelProperty(value = "商品品类编码")
    private String itemCateCode;

    @ApiModelProperty(value = "商品品类名称")
    private String itemCateName;

    @ApiModelProperty(value = "商品规格2(1单规格 0多规格)")
    private String itemAttr2;

    @ApiModelProperty("spu规格型号")
    private String spec;

    @ApiModelProperty("基本单位数量")
    private BigDecimal qty2;

    @ApiModelProperty("基本单位")
    private String uom2;

    @ApiModelProperty("基本单位名称")
    private String uom2Name;

    @ApiModelProperty("小数位数")
    private Integer decimalPlaces;

    @ApiModelProperty("单位转换率")
    private BigDecimal uomRatio;

    @ApiModelProperty("商品类型")
    private String itemType;

    @ApiModelProperty("商品价格")
    private BigDecimal itemPrice;

    @ApiModelProperty("供应商ID")
    private Long suppId;

    @ApiModelProperty("供应商编码")
    private String suppCode;

    @ApiModelProperty("门店编码")
    private String storeCode;

    @ApiModelProperty("仓配结算价")
    private BigDecimal costPrice;

    @ApiModelProperty("采购价")
    private BigDecimal purPrice;

    @ApiModelProperty("科技费价格")
    private BigDecimal tefPrice;

    @ApiModelProperty("营销费价格")
    private BigDecimal mefPrice;

    @ApiModelProperty("运营费价格")
    private BigDecimal oefPrice;

    @ApiModelProperty("是否收取项目费用")
    private Boolean isProjFeeCharged;

}
