package com.elitesland.scp.application.service.app;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.lang.Assert;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import com.elitescloud.boot.exception.BusinessException;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.scp.application.enums.ScpUdcEnum;
import com.elitesland.scp.application.facade.vo.param.app.AppStorePasswordModifyParamVO;
import com.elitesland.scp.application.facade.vo.param.app.AppStorePasswordPaymentParamVO;
import com.elitesland.scp.application.facade.vo.param.authority.ScpManAuthorityParam;
import com.elitesland.scp.application.facade.vo.resp.authority.ScpManAuthorityPageRespVO;
import com.elitesland.scp.application.service.UserService;
import com.elitesland.scp.common.CurrentUserDTO;
import com.elitesland.scp.domain.bo.ScpsmanRegionBO;
import com.elitesland.scp.domain.service.authority.ScpDemandAuthorityService;
import com.elitesland.scp.enums.UdcEnum;
import com.elitesland.scp.infr.repo.authority.ScpDemandAuthorityRepoProc;
import com.elitesland.scp.infr.repo.scpsman.ScpsmanInfoRepoProc;
import com.elitesland.scp.infr.repo.scpsman.ScpsmanRegionRepoProc;
import com.elitesland.support.provider.org.dto.OrgStoreBaseRpcDTO;
import com.elitesland.support.provider.org.param.OrgStoreBaseRpcParam;
import com.elitesland.support.provider.org.param.OrgStorePasswordModifyRpcParam;
import com.elitesland.support.provider.org.service.OrgStoreRpcService;
import lombok.AllArgsConstructor;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.crypto.password.PasswordEncoder;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

import javax.transaction.Transactional;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;

/**
 * @author jeesie
 * @description:
 * @datetime 2025年 06月 09日 15:49
 * @version: 1.0
 */
@Slf4j
@Service
@RequiredArgsConstructor
public class AppStorePasswordPaymentServiceImpl implements AppStorePasswordPaymentService {

   private final OrgStoreRpcService orgStoreRpcService;
   private final ScpsmanInfoRepoProc scpsmanInfoRepoProc;
   private final ScpsmanRegionRepoProc scpsmanRegionRepoProc;


    @Override
    @Transactional(rollbackOn = Exception.class)
    public void setPassword(AppStorePasswordPaymentParamVO param) {
        //查询当前登录用户,校验修改权限
        verifyScpmanAuthority(param.getStoreCode());
        OrgStorePasswordModifyRpcParam passwordModifyRpcParam = new OrgStorePasswordModifyRpcParam();
        passwordModifyRpcParam.setFlag(0);
        passwordModifyRpcParam.setNewPayPassword(param.getPayPassword());
        passwordModifyRpcParam.setStoreCode(param.getStoreCode());
        //支付密码(BCrypt加密)，加密方式：$2a$10$...
        orgStoreRpcService.setStorePayPassword(passwordModifyRpcParam).computeData();
    }

    @Override
    public void modifyPassword(AppStorePasswordModifyParamVO param) {
        //查询当前登录用户,校验修改权限
        verifyScpmanAuthority(param.getStoreCode());
        OrgStorePasswordModifyRpcParam passwordModifyRpcParam = new OrgStorePasswordModifyRpcParam();
        passwordModifyRpcParam.setFlag(1);
        passwordModifyRpcParam.setNewPayPassword(param.getPayPassword());
        passwordModifyRpcParam.setOldPayPassword(param.getOldPayPassword());
        passwordModifyRpcParam.setStoreCode(param.getStoreCode());
        //支付密码(BCrypt加密)，加密方式：$2a$10$...
        log.info("修改支付密码入参：{}", passwordModifyRpcParam);
        orgStoreRpcService.setStorePayPassword(passwordModifyRpcParam).computeData();
    }

    private void verifyScpmanAuthority(String param) {
        CurrentUserDTO currentUserDTO = UserService.currentUser();
        if (ObjectUtil.isEmpty(currentUserDTO)) {
            throw new BusinessException("当前登录人查询异常");
        }

        var scpsmanInfo = scpsmanInfoRepoProc.getByScpsmanNo(currentUserDTO.getDetail().getUsername());
        Assert.notNull(scpsmanInfo, "计划员信息不存在");

        if (!ObjectUtil.equal(scpsmanInfo.getScpsmanType(), UdcEnum.SALE_SCPSMAN_TYPE_SHOPOWNER.getValueCode())) {
            throw new BusinessException("当前用户无门店支付密码修改权限");
        }

        // 判断是否有门店权限
        if (Boolean.TRUE.equals(scpsmanInfo.getJurisdictionAll())) {
            return;
        }
        var scpsmanRegionList = scpsmanRegionRepoProc.listBoByMasId(scpsmanInfo.getId());
        if (scpsmanRegionList.isEmpty()) {
            throw new BusinessException("当前用户无该门店的操作权限");
        }

        Set<String> regionCodes = new HashSet<>(scpsmanRegionList.size());
        for (ScpsmanRegionBO bo : scpsmanRegionList) {
            if (StrUtil.isBlank(bo.getRegionCode())) {
                continue;
            }
            if (ScpUdcEnum.SCPSMAN_REGION_TYPE_STORE.getValueCode().equals(bo.getRegionType())) {
                // 门店
                if (bo.getRegionCode().equals(param)) {
                    return;
                }
                continue;
            }
            if (ScpUdcEnum.SCPSMAN_REGION_TYPE_REGION.getValueCode().equals(bo.getRegionType())) {
                // 区域
                regionCodes.add(bo.getRegionCode());
            }
        }
        if (!regionCodes.isEmpty()) {
            log.info("查询管理区域的门店：{}", com.elitescloud.boot.util.JSONUtil.toJsonString(regionCodes));
            OrgStoreBaseRpcParam orgStoreParam = new OrgStoreBaseRpcParam();
            orgStoreParam.setRegionList(new ArrayList<>(regionCodes));
            var storeList = orgStoreRpcService.findSimpleStoreByParam(orgStoreParam).computeData();
            if (CollUtil.isNotEmpty(storeList)) {
                for (OrgStoreBaseRpcDTO orgStoreBaseRpcDTO : storeList) {
                    if (param.equals(orgStoreBaseRpcDTO.getStoreCode())) {
                        return;
                    }
                }
            }
        }
        throw new BusinessException("当前用户无该门店的操作权限");
    }

}
