package com.elitesland.scp.application.service.wechat;

import cn.hutool.http.HttpUtil;
import cn.hutool.json.JSONObject;
import cn.hutool.json.JSONUtil;
import com.elitescloud.boot.SpringContextHolder;
import com.elitescloud.boot.auth.model.OAuthToken;
import com.elitescloud.boot.exception.BusinessException;
import com.elitescloud.boot.redis.util.RedisUtils;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.system.param.AuthUserIdQueryDTO;
import com.elitescloud.cloudt.system.provider.SysUserPermissionRpcService;
import com.elitesland.scp.application.facade.vo.wechat.WechatAccessTokenVO;
import com.elitesland.scp.common.ScpConstant;
import com.elitesland.scp.config.WechatProperties;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.security.crypto.encrypt.TextEncryptor;
import org.springframework.stereotype.Service;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.TimeUnit;

@Slf4j
@Service
@RequiredArgsConstructor
public class WechatServiceImpl implements WechatService {

    private final WechatProperties wechatProperties;

    private final RedisUtils redisUtils;

    @Override
    public String oauth2LoginUrl() {
        //第三方 构造网页授权链接
        String getWechatLogin = ScpConstant.THIRD_BUS_WECHAT_AUTHORIZE_URL;
        // 转换成登录地址
        String loginUrl = getWechatLogin.replace(ScpConstant.APP_ID, wechatProperties.getCorpId())
                .replace(ScpConstant.REDIRECT_URI, wechatProperties.getRedirectUrl())
                .replace(ScpConstant.AGENTID, wechatProperties.getAgentId());
        log.info("企业微信内登录重定向url:" + loginUrl);
        return loginUrl;
    }

    @Override
    public String getEnterpriseAccessToken(String corpid, String corpsecret, String type) {
        Map<String, Object> params = new HashMap<>(2);
        params.put("corpid", corpid);
        params.put("corpsecret", corpsecret);
        Object accessToken = redisUtils.get("wxEnterprise" + "-" + corpid + "-" + type);
        if (Objects.isNull(accessToken)) {
            String body = HttpUtil.get(wechatProperties.getProviderTokenUrl(), params, 7200);
            log.info("getProviderToken出参" + body);
            WechatAccessTokenVO weChat = JSONUtil.toBean(body, WechatAccessTokenVO.class);
            if (weChat.getErrcode() == null || weChat.getErrcode() == 0) {
                accessToken = weChat.getAccess_token();
                redisUtils.set("wxEnterprise" + "-" + corpid + "-" + type, accessToken, weChat.getExpires_in(), TimeUnit.SECONDS);
            }
        }
        return (String) accessToken;
    }

    @Override
    public String pcLogin(String code) {
        // 	授权登录服务商的网站时，使用应用提供商的provider_access_token
        String accessToken = getEnterpriseAccessToken(wechatProperties.getCorpId(), wechatProperties.getH5Corpsecret(), ScpConstant.WECHAT_LOGIN_TYPE_PC);
        //  获取访问用户身份
        Map<String, Object> param = new HashMap<>(2);
        param.put("access_token", accessToken);
        param.put("code", code);
        String result = HttpUtil.get(ScpConstant.USER_INFO_URL, param, 7200);
        log.info("PC登录获取访问用户身份:{}", result);
        JSONObject userInfoObject = JSONUtil.parseObj(result);
        Integer errcode = (Integer) userInfoObject.get("errcode");
        if (errcode != 0) {
            throw new BusinessException("获取用户信息失败:" + userInfoObject.get("errmsg"));
        }
        String userid = (String) userInfoObject.get("userid");

        AuthUserIdQueryDTO queryDTO = new AuthUserIdQueryDTO();
        // 加密手机号
        queryDTO.setUserIdCypher(SpringContextHolder.getBean(TextEncryptor.class).encrypt(userid));
        ApiResult<OAuthToken> tokenResult = SpringContextHolder.getBean(SysUserPermissionRpcService.class)
                .authByOuterKey(queryDTO);
        log.info("PC登录调用系统域换取token接口:{}", tokenResult);
        if (tokenResult.isSuccess() && tokenResult.getData() != null) {
            OAuthToken data = tokenResult.getData();
            return data.getTokenType() + " " + data.getAccessToken();
        } else {
            throw new BusinessException("登录失败:" + tokenResult.getMsg());
        }
    }

    @Override
    public String mgLogin(String code) {
        // 	授权登录服务商的网站时，使用应用提供商的provider_access_token
        String accessToken = getEnterpriseAccessToken(wechatProperties.getCorpId(), wechatProperties.getMgCorpsecret(), ScpConstant.WECHAT_LOGIN_TYPE_MG);
        //  获取访问用户身份
        Map<String, Object> param = new HashMap<>(3);
        param.put("access_token", accessToken);
        param.put("js_code", code);
        param.put("grant_type", "authorization_code");
        String result = HttpUtil.get(ScpConstant.MG_LOGIN_URL, param, 7200);
        log.info("小程序登录临时登录凭证:" + result);
        JSONObject jsonObject = JSONUtil.parseObj(result);
        Integer errcode = (Integer) jsonObject.get("errcode");
        if (errcode != 0) {
            throw new BusinessException("临时登录凭证校验失败:" + jsonObject.get("errmsg"));
        }
        String userid = (String) jsonObject.get("userid");
        AuthUserIdQueryDTO queryDTO = new AuthUserIdQueryDTO();
        // 加密手机号
        queryDTO.setUserIdCypher(SpringContextHolder.getBean(TextEncryptor.class).encrypt(userid));
        ApiResult<OAuthToken> tokenResult = SpringContextHolder.getBean(SysUserPermissionRpcService.class)
                .authByOuterKey(queryDTO);
        log.info("小程序登录调用系统域换取token接口:{}", tokenResult);
        if (tokenResult.isSuccess() && tokenResult.getData() != null) {
            OAuthToken data = tokenResult.getData();
            return data.getTokenType() + " " + data.getAccessToken();
        } else {
            throw new BusinessException("登录失败:" + tokenResult.getMsg());
        }
    }

    @Override
    public String webLoginUrl() {
        // 构造网页授权链接
        String getWechatLogin = ScpConstant.SSO_WECHAT_AUTHORIZE_URL;
        // 转换成登录地址
        String loginUrl = getWechatLogin.replace(ScpConstant.LOGIN_TYPE, wechatProperties.getLoginType())
                .replace(ScpConstant.APP_ID, wechatProperties.getCorpId())
                .replace(ScpConstant.REDIRECT_URI, wechatProperties.getRedirectUrl());
        log.info("企业微信SSO登录重定向url:" + loginUrl);
        return loginUrl;
    }
}

