package com.elitesland.scp.domain.entity.mrp;

import com.elitescloud.boot.model.entity.BaseModel;
import com.elitescloud.cloudt.common.annotation.Comment;
import lombok.Data;
import lombok.experimental.Accessors;
import org.hibernate.annotations.DynamicInsert;
import org.hibernate.annotations.DynamicUpdate;
import org.hibernate.annotations.Where;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;
import java.io.Serializable;


/**
 * 物料需求计划表
 *
 * @author chaofeng.xia
 * @since 2025/1/14
 */
@Data
@DynamicInsert
@DynamicUpdate
@Entity
@Table(name = "scp_mrp")
@Where(clause = "delete_flag = 0 or delete_flag is null")
@Accessors(chain = true)
@org.hibernate.annotations.Table(appliesTo = "scp_mrp", comment = "物料需求计划表")
public class ScpMrpDO extends BaseModel implements Serializable {

    @Column(name = "mrp_lot_no", columnDefinition = "varchar(64)")
    @Comment("mrp批次")
    private String mrpLotNo;

    @Column(name = "pred_lot_no", columnDefinition = "varchar(64)")
    @Comment("预测批次")
    private String predLotNo;

    @Column(name = "calc_status", columnDefinition = "varchar(20)")
    @Comment("计算状态")
    private String calcStatus;

    @Column(name = "calc_fail_reason", columnDefinition = "varchar(511)")
    @Comment("计算失败原因")
    private String calcFailReason;

    @Column(name = "push_status", columnDefinition = "varchar(20)")
    @Comment("推送状态")
    private String pushStatus;

    @Column(name = "push_fail_reason", columnDefinition = "varchar(511)")
    @Comment("推送失败原因")
    private String pushFailReason;
}