package com.elitesland.scp.domain.service.serviceconfig;

import com.elitescloud.cloudt.common.annotation.SysCodeProc;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.scp.application.facade.vo.serviceconfig.ScpServiceConfigExportRespVO;
import com.elitesland.scp.application.facade.vo.serviceconfig.ScpServiceConfigPageParamVO;
import com.elitesland.scp.application.facade.vo.serviceconfig.ScpServiceConfigPageVO;
import com.elitesland.scp.application.facade.vo.serviceconfig.ScpServiceConfigRespVO;
import com.elitesland.scp.domain.convert.serviceconifg.ScpServiceConfigConvert;
import com.elitesland.scp.domain.entity.serviceconfig.ScpServiceConfigDO;
import com.elitesland.scp.infr.repo.serviceconfig.ScpServiceConfigRepo;
import com.elitesland.scp.infr.repo.serviceconfig.ScpServiceConfigRepoProc;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.*;

/**
 * @author chaofeng.xia
 * @since 2025/5/26
 */
@Slf4j
@Service
@RequiredArgsConstructor
public class ScpServiceConfigDomainServiceImpl implements ScpServiceConfigDomainService {

    private final ScpServiceConfigRepoProc scpServiceConfigRepoProc;

    private final ScpServiceConfigRepo scpServiceConfigRepo;

    @Override
    @SysCodeProc
    public PagingVO<ScpServiceConfigPageVO> page(ScpServiceConfigPageParamVO queryParam) {
        return scpServiceConfigRepoProc.page(queryParam);
    }

    @Override
    public List<ScpServiceConfigDO> findByBusinessKey(Collection<String> businessKeys) {
        return scpServiceConfigRepo.findAllByBusinessKeyIn(businessKeys);
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public void deleteBatch(List<Long> ids) {
        scpServiceConfigRepo.deleteAllById(ids);
    }

    @Override
    @SysCodeProc
    public PagingVO<ScpServiceConfigExportRespVO> exportSearch(ScpServiceConfigPageParamVO queryParam) {
        return scpServiceConfigRepoProc.exportSearch(queryParam);
    }

    @Override
    public List<ScpServiceConfigDO> findByIds(List<Long> ids) {
        return scpServiceConfigRepo.findByIdIn(ids);
    }

    @Override
    public ScpServiceConfigRespVO findById(Long id) {
        return scpServiceConfigRepo.findById(id).map(ScpServiceConfigConvert.INSTANCE::doToRespVO).orElse(null);
    }
}
