package com.elitesland.scp.domain.service.survey;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.scp.domain.vo.survey.*;

import java.util.List;

public interface SurveyService {

    PagingVO<SurveyRespVO> search(SurveyPagingParam searchParam);

    Long saveOrUpdate(SurveySaveParam saveVO);

    void cancel(List<Long> idList);

    Integer publish(SurveyPublishParam param);

    SurveyRespVO get(Long id);

    List<SurveyCheckRespVO> findSurvey();

    List<SurveyCheckRespVO> findSurvey(String username, List<String> storeCodeList);

    void fillSurvey(String storeCode, List<SurveyAnswerSaveParam> saveParamList);

    SurveyRespVO fillDetail(Long id);

    PagingVO<SurveyAnswerRespVO> fillDetailList(SurveyPagingParam param);

    List<SurveyAnalysisRespVO> surveyAnalysis(Long id);
}
