package com.elitesland.scp.infr.repo.item;

import com.elitesland.scp.domain.entity.item.ScpCateItemSaleScopeStoreDO;
import com.elitesland.scp.domain.entity.item.ScpCateItemVisibleScopeStoreDO;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.Modifying;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.querydsl.QuerydslPredicateExecutor;
import org.springframework.transaction.annotation.Transactional;

import java.util.List;

public interface ScpCateItemVisibleScopeStoreRepo extends JpaRepository<ScpCateItemVisibleScopeStoreDO, Long>, QuerydslPredicateExecutor<ScpCateItemVisibleScopeStoreDO> {


    @Transactional//事务的注解
    @Modifying//增删改必须有这个注解
    @Query(value = "delete from scp_cate_item_sale_scope_store where mas_id = ?1", nativeQuery = true)
    void deleteByMasId(Long masId);


    List<ScpCateItemVisibleScopeStoreDO> findAllByMasId(Long masId);
}
