package com.elitesland.scp.infr.repo.survey;

import com.elitescloud.boot.jpa.common.BaseRepoProc;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.scp.domain.entity.survey.*;
import com.elitesland.scp.domain.vo.survey.SurveyAnswerParam;
import com.elitesland.scp.domain.vo.survey.SurveyAnswerRespVO;
import com.elitesland.scp.domain.vo.survey.SurveyPagingParam;
import com.querydsl.core.types.ExpressionUtils;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.Projections;
import com.querydsl.core.types.dsl.Expressions;
import com.querydsl.core.types.dsl.StringTemplate;
import com.querydsl.jpa.impl.JPAQuery;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Repository;

import java.util.ArrayList;
import java.util.List;

@Repository
public class SurveyAnswerRepoProc extends BaseRepoProc<SurveyDO> {

    private final static QSurveyDO surveyDO = QSurveyDO.surveyDO;
    private final static QSurveyPublishDO surveyPublishDO = QSurveyPublishDO.surveyPublishDO;
    private final static QSurveyAnswerDO surveyAnswerDO = QSurveyAnswerDO.surveyAnswerDO;
    private final static QSurveyQuestionDO surveyQuestionDO = QSurveyQuestionDO.surveyQuestionDO;
    private final static QSurveyOptionDO surveyOptionDO = QSurveyOptionDO.surveyOptionDO;

    protected SurveyAnswerRepoProc() {
        super(surveyDO);
    }

    public static StringTemplate DATE_FORMAT(Object arg1){
        return Expressions.stringTemplate("DATE_FORMAT({0}, '%Y-%m-%d %H:%i:%s')", arg1);
    }

    public static StringTemplate concat(Object arg1, Object arg2){
        return Expressions.stringTemplate("concat({0}, {0})", arg1, arg2);
    }

    /**
     * 分页查询
     *
     * @param queryVO 条件
     * @return 分页结果
     */
    public PagingVO<SurveyAnswerRespVO> search(SurveyPagingParam queryVO) {
        // 单独查询数量
        JPAQuery<Long> jpaCountQuery = jpaQueryFactory.select(
                        Expressions.numberTemplate(Long.class, "count(distinct concat({0}, {1}))",
                                surveyAnswerDO.suvId, surveyAnswerDO.ouCode))
                .from(surveyAnswerDO)
                .where(where(queryVO));
        long count = jpaCountQuery.fetchOne();
        if(count <= 0){
            return PagingVO.<SurveyAnswerRespVO>builder()
                    .total(count)
                    .records(new ArrayList<>())
                    .build();
        }

        JPAQuery<SurveyAnswerRespVO> jpaQuery = jpaQueryFactory.selectDistinct(
                        Projections.bean(SurveyAnswerRespVO.class,
                                surveyAnswerDO.suvId,
                                DATE_FORMAT(surveyAnswerDO.createTime).as("fillTimeStr"),
                                surveyAnswerDO.creator,
                                surveyAnswerDO.ouCode,
                                surveyPublishDO.ouId,
                                surveyPublishDO.ouName
                        ))
                .from(surveyAnswerDO)
                .leftJoin(surveyPublishDO).on(surveyAnswerDO.suvId.eq(surveyPublishDO.suvId).and(surveyPublishDO.ouCode.eq(surveyAnswerDO.ouCode)))
                .where(where(queryVO))
                .orderBy(DATE_FORMAT(surveyAnswerDO.createTime).desc());
        queryVO.setPaging(jpaQuery);
        return PagingVO.<SurveyAnswerRespVO>builder()
                .total(count)
                .records(jpaQuery.fetch())
                .build();
    }

    private Predicate where(SurveyPagingParam param) {
        Predicate predicate = Expressions.ONE.eq(Expressions.ONE);
        if (param.getSuvId() != null) {
            predicate = ExpressionUtils.and(predicate, surveyAnswerDO.suvId.eq(param.getSuvId()));
        }
        return predicate;
    }


    public List<SurveyAnswerRespVO> findAnswer(SurveyAnswerParam queryVO) {
        JPAQuery<SurveyAnswerRespVO> jpaQuery = jpaQueryFactory.select(
                        Projections.bean(SurveyAnswerRespVO.class,
                                surveyAnswerDO.id,
                                surveyAnswerDO.suvId,
                                surveyAnswerDO.qusId,
                                surveyAnswerDO.ouCode,
                                surveyQuestionDO.qusType,
                                surveyQuestionDO.qusTitle,
                                surveyQuestionDO.sortNo,
                                surveyAnswerDO.optId,
                                surveyAnswerDO.optContent,
                                surveyOptionDO.sortNo.as("opSortNo"),
                                surveyOptionDO.opContent
                        ))
                .from(surveyAnswerDO)
                .leftJoin(surveyQuestionDO).on(surveyAnswerDO.qusId.eq(surveyQuestionDO.id))
                .leftJoin(surveyOptionDO).on(surveyAnswerDO.optId.eq(surveyOptionDO.id))
                .where(whereAnswer(queryVO))
                .orderBy(surveyQuestionDO.sortNo.asc());
        return jpaQuery.fetch();
    }

    private Predicate whereAnswer(SurveyAnswerParam param) {
        Predicate predicate = Expressions.ONE.eq(Expressions.ONE);
        if (param.getSuvId() != null) {
            predicate = ExpressionUtils.and(predicate, surveyAnswerDO.suvId.eq(param.getSuvId()));
        }
        if (StringUtils.isNotEmpty(param.getCreator())) {
            predicate = ExpressionUtils.and(predicate, surveyAnswerDO.creator.eq(param.getCreator()));
        }
        if (CollectionUtils.isNotEmpty(param.getOuCodeList())) {
            predicate = ExpressionUtils.and(predicate, surveyAnswerDO.ouCode.in(param.getOuCodeList()));
        }
        return predicate;
    }


}
