/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.scp.infr.repo.msg;

import com.elitescloud.boot.common.param.IdCodeNameParam;
import com.elitescloud.boot.jpa.common.BaseRepoProc;
import com.elitesland.scp.domain.entity.msg.QScpMessageDO;
import com.elitesland.scp.domain.entity.msg.QScpMessageReceiverDO;
import com.elitesland.scp.domain.entity.msg.ScpMessageReceiverDO;
import com.querydsl.core.types.EntityPath;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.Path;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.SubQueryExpression;
import com.querydsl.core.types.dsl.EntityPathBase;
import com.querydsl.jpa.JPAExpressions;
import com.querydsl.jpa.impl.JPAQuery;
import java.time.LocalDateTime;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotEmpty;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

@Repository
public class ScpMessageReceiverRepoProc
extends BaseRepoProc<ScpMessageReceiverDO> {
    private static final QScpMessageReceiverDO QDO = QScpMessageReceiverDO.scpMessageReceiverDO;
    private static final QScpMessageDO QDO_MSG = QScpMessageDO.scpMessageDO;

    public ScpMessageReceiverRepoProc() {
        super((EntityPathBase)QDO);
    }

    public void deleteByMessageId(long messageId) {
        super.deleteByValue(ScpMessageReceiverRepoProc.QDO.messageId, (Object)messageId);
    }

    public void deleteByMessageId(Collection<Long> messageIds) {
        super.deleteByValue(ScpMessageReceiverRepoProc.QDO.messageId, messageIds);
    }

    @Transactional(rollbackFor={Exception.class})
    public void updateViewed(long messageId, @NotBlank String receiverType, @NotBlank String receiver) {
        this.jpaQueryFactory.update((EntityPath)QDO).set((Path)ScpMessageReceiverRepoProc.QDO.viewed, (Object)true).set(ScpMessageReceiverRepoProc.QDO.viewTime, (Object)LocalDateTime.now()).where(new Predicate[]{ScpMessageReceiverRepoProc.QDO.messageId.eq((Object)messageId).and((Predicate)ScpMessageReceiverRepoProc.QDO.receiverId.eq((Object)receiver)).and((Predicate)ScpMessageReceiverRepoProc.QDO.receiverType.eq((Object)receiverType)).and((Predicate)ScpMessageReceiverRepoProc.QDO.viewed.eq(Boolean.valueOf(false)))}).execute();
    }

    public void deleteReceivers(long messageId, String receiverType, Collection<String> receivers) {
        super.delete((Predicate)ScpMessageReceiverRepoProc.QDO.messageId.eq((Object)messageId).and((Predicate)ScpMessageReceiverRepoProc.QDO.receiverId.in(receivers)).and((Predicate)ScpMessageReceiverRepoProc.QDO.receiverType.eq((Object)receiverType)));
    }

    public List<String> getReceivers(long messageId, @NotBlank String receiverType) {
        return ((JPAQuery)((JPAQuery)this.jpaQueryFactory.select((Expression)ScpMessageReceiverRepoProc.QDO.receiverId).from((EntityPath)QDO)).where((Predicate)ScpMessageReceiverRepoProc.QDO.messageId.eq((Object)messageId).and((Predicate)ScpMessageReceiverRepoProc.QDO.receiverType.eq((Object)receiverType)))).fetch();
    }

    public Map<Long, List<IdCodeNameParam>> getReceivers(Collection<Long> messageIds) {
        return ((JPAQuery)((JPAQuery)this.jpaQueryFactory.select(new Expression[]{ScpMessageReceiverRepoProc.QDO.messageId, ScpMessageReceiverRepoProc.QDO.receiverType, ScpMessageReceiverRepoProc.QDO.receiverId}).from((EntityPath)QDO)).where((Predicate)ScpMessageReceiverRepoProc.QDO.messageId.in(messageIds))).fetch().stream().collect(Collectors.groupingBy(t -> (Long)t.get(ScpMessageReceiverRepoProc.QDO.messageId), Collectors.mapping(t -> new IdCodeNameParam(null, (String)t.get((Expression)ScpMessageReceiverRepoProc.QDO.receiverId), (String)t.get((Expression)ScpMessageReceiverRepoProc.QDO.receiverType)), Collectors.toList())));
    }

    public Long countUnView(@NotBlank String receiverType, @NotBlank String receiver) {
        return (Long)((JPAQuery)((JPAQuery)this.jpaQueryFactory.select((Expression)QDO_MSG.count()).from((EntityPath)QDO_MSG)).where((Predicate)ScpMessageReceiverRepoProc.QDO_MSG.id.in((SubQueryExpression)JPAExpressions.select(ScpMessageReceiverRepoProc.QDO.messageId).from(new EntityPath[]{QDO}).where(new Predicate[]{ScpMessageReceiverRepoProc.QDO.receiverId.eq((Object)receiver).and((Predicate)ScpMessageReceiverRepoProc.QDO.receiverType.eq((Object)receiverType)).and((Predicate)ScpMessageReceiverRepoProc.QDO.viewed.eq(Boolean.valueOf(false)))})).and((Predicate)ScpMessageReceiverRepoProc.QDO_MSG.published.eq(Boolean.valueOf(true)).and((Predicate)ScpMessageReceiverRepoProc.QDO_MSG.publishTime.before((Comparable)LocalDateTime.now()))).and((Predicate)ScpMessageReceiverRepoProc.QDO_MSG.invalidTime.isNull().or((Predicate)ScpMessageReceiverRepoProc.QDO_MSG.invalidTime.after((Comparable)LocalDateTime.now()))))).fetchOne();
    }

    public Map<Long, Boolean> queryViewed(@NotEmpty Collection<Long> messageIds, @NotBlank String receiverType, @NotBlank String receiver) {
        return ((JPAQuery)((JPAQuery)this.jpaQueryFactory.select(new Expression[]{ScpMessageReceiverRepoProc.QDO.messageId, ScpMessageReceiverRepoProc.QDO.viewed}).from((EntityPath)QDO)).where((Predicate)ScpMessageReceiverRepoProc.QDO.receiverId.eq((Object)receiver).and((Predicate)ScpMessageReceiverRepoProc.QDO.messageId.in(messageIds)).and((Predicate)ScpMessageReceiverRepoProc.QDO.receiverType.eq((Object)receiverType)))).fetch().stream().collect(Collectors.toMap(t -> (Long)t.get(ScpMessageReceiverRepoProc.QDO.messageId), t -> (Boolean)t.get((Expression)ScpMessageReceiverRepoProc.QDO.viewed), (t1, t2) -> t1));
    }
}

