/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.scp.infr.repo.msg;

import com.elitescloud.boot.jpa.common.BaseRepoProc;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.scp.application.facade.vo.query.msg.CommonPublishedMessagePageQueryVO;
import com.elitesland.scp.application.facade.vo.query.msg.ScpMessagePageMngQueryVO;
import com.elitesland.scp.domain.entity.msg.QScpMessageDO;
import com.elitesland.scp.domain.entity.msg.QScpMessageReceiverDO;
import com.elitesland.scp.domain.entity.msg.ScpMessageDO;
import com.querydsl.core.types.EntityPath;
import com.querydsl.core.types.Path;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.dsl.EntityPathBase;
import com.querydsl.core.types.dsl.SimpleExpression;
import com.querydsl.core.types.dsl.StringExpression;
import com.querydsl.jpa.JPAExpressions;
import com.querydsl.jpa.JPQLQuery;
import java.time.LocalDateTime;
import java.util.Collection;
import javax.validation.constraints.NotEmpty;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Sort;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.StringUtils;

@Repository
public class ScpMessageRepoProc
extends BaseRepoProc<ScpMessageDO> {
    private static final QScpMessageDO QDO = QScpMessageDO.scpMessageDO;
    private static final QScpMessageReceiverDO QDO_RECEIVER = QScpMessageReceiverDO.scpMessageReceiverDO;

    public ScpMessageRepoProc() {
        super((EntityPathBase)QDO);
    }

    public void updateTxtId(long id, long txtId) {
        super.updateValue(ScpMessageRepoProc.QDO.txtId, (Object)txtId, id);
    }

    @Transactional(rollbackFor={Exception.class})
    public void updatePublish(@NotEmpty Collection<Long> ids, LocalDateTime publishTime) {
        this.jpaQueryFactory.update((EntityPath)QDO).set((Path)ScpMessageRepoProc.QDO.published, (Object)true).set(ScpMessageRepoProc.QDO.publishTime, (Object)publishTime).where(new Predicate[]{ScpMessageRepoProc.QDO.id.in(ids).and((Predicate)ScpMessageRepoProc.QDO.published.eq(Boolean.valueOf(false))).and((Predicate)ScpMessageRepoProc.QDO.publishTime.isNull())}).execute();
    }

    @Transactional(rollbackFor={Exception.class})
    public void updatePublish(@NotEmpty Collection<Long> ids) {
        this.jpaQueryFactory.update((EntityPath)QDO).set((Path)ScpMessageRepoProc.QDO.published, (Object)true).where(new Predicate[]{ScpMessageRepoProc.QDO.id.in(ids).and((Predicate)ScpMessageRepoProc.QDO.published.eq(Boolean.valueOf(false))).and((Predicate)ScpMessageRepoProc.QDO.publishTime.isNotNull())}).execute();
    }

    @Transactional(rollbackFor={Exception.class})
    public void updateRevoke(@NotEmpty Collection<Long> ids) {
        this.jpaQueryFactory.update((EntityPath)QDO).set((Path)ScpMessageRepoProc.QDO.published, (Object)false).setNull(ScpMessageRepoProc.QDO.publishTime).where(new Predicate[]{ScpMessageRepoProc.QDO.id.in(ids).and((Predicate)ScpMessageRepoProc.QDO.published.eq(Boolean.valueOf(true)))}).execute();
    }

    public PagingVO<ScpMessageDO> pageMng(ScpMessagePageMngQueryVO queryVO) {
        Predicate predate = BaseRepoProc.PredicateBuilder.builder().andEq(ScpMessageRepoProc.QDO.authorId, (Object)queryVO.getAuthorId()).andLike((StringExpression)ScpMessageRepoProc.QDO.title, queryVO.getTitle()).andEq((SimpleExpression)ScpMessageRepoProc.QDO.category, (Object)queryVO.getCategory()).andEq((SimpleExpression)ScpMessageRepoProc.QDO.messageType, (Object)queryVO.getMessageType()).andEq((SimpleExpression)ScpMessageRepoProc.QDO.top, (Object)queryVO.getTop()).andEq((SimpleExpression)ScpMessageRepoProc.QDO.published, (Object)queryVO.getPublished()).andBetween(ScpMessageRepoProc.QDO.publishTime, (Comparable)queryVO.getPublishTimeStart(), (Comparable)queryVO.getPublishTimeEnd()).andIn(ScpMessageRepoProc.QDO.id, (Collection)queryVO.getIdSet()).andLike(new StringExpression[]{ScpMessageRepoProc.QDO.title, ScpMessageRepoProc.QDO.summaries}, queryVO.getKeyword()).build();
        return super.queryByPage(predate, queryVO.getPageRequest(), ScpMessageRepoProc.QDO.createTime.desc());
    }

    public PagingVO<ScpMessageDO> pagePublished(String receiverType, CommonPublishedMessagePageQueryVO queryVO) {
        JPQLQuery subQueryReceiver = null;
        if (StringUtils.hasText((String)queryVO.getReceiverId()) && StringUtils.hasText((String)receiverType)) {
            subQueryReceiver = (JPQLQuery)JPAExpressions.select(ScpMessageRepoProc.QDO_RECEIVER.messageId).from(new EntityPath[]{QDO_RECEIVER}).where(new Predicate[]{ScpMessageRepoProc.QDO_RECEIVER.receiverId.eq((Object)queryVO.getReceiverId()).and((Predicate)ScpMessageRepoProc.QDO_RECEIVER.receiverType.eq((Object)receiverType))});
        }
        Predicate predate = BaseRepoProc.PredicateBuilder.builder().andIn(subQueryReceiver != null, ScpMessageRepoProc.QDO.id, subQueryReceiver).andEq((SimpleExpression)ScpMessageRepoProc.QDO.category, (Object)queryVO.getCategory()).andEq((SimpleExpression)ScpMessageRepoProc.QDO.messageType, (Object)queryVO.getMessageType()).andLoe(ScpMessageRepoProc.QDO.publishTime, (Comparable)LocalDateTime.now()).and((Predicate)ScpMessageRepoProc.QDO.invalidTime.isNull().or((Predicate)ScpMessageRepoProc.QDO.invalidTime.after((Comparable)LocalDateTime.now()))).andBetween(ScpMessageRepoProc.QDO.publishTime, (Comparable)queryVO.getPublishTimeStart(), (Comparable)queryVO.getPublishTimeEnd()).andEq((SimpleExpression)ScpMessageRepoProc.QDO.published, (Object)true).andLike((StringExpression)ScpMessageRepoProc.QDO.title, queryVO.getTitle()).andLike(new StringExpression[]{ScpMessageRepoProc.QDO.title, ScpMessageRepoProc.QDO.summaries}, queryVO.getKeyword()).build();
        PageRequest pageRequest = queryVO.getPageRequest();
        pageRequest = pageRequest.withSort(Sort.Direction.DESC, new String[]{ScpMessageRepoProc.QDO.top.getMetadata().getName(), ScpMessageRepoProc.QDO.publishTime.getMetadata().getName()});
        return super.queryByPage(predate, pageRequest);
    }
}

