package com.elitesland.scp.application.facade.vo.cart;

import com.elitesland.scp.domain.entity.cart.ScpStoreCartDO;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.util.List;

/**
 * @Auther: Mark
 * @Date: 2024/3/26 17:13
 * @Description:
 */
@Data
@ApiModel("下单校验参数")
public class AIOrderCheckParamVO implements Serializable {

    @ApiModelProperty(value = "门店编码", required = true)
    @NotBlank(message = "门店编码不能为空")
    private String demandWhStCode;

    @ApiModelProperty(value = "单据类型", required = true)
    private String docType;

    @ApiModelProperty(value = "业务类型", required = true)
    @NotBlank(message = "业务类型不能为空")
    private String businessType;

    @ApiModelProperty(value = "下单商品 AI下单使用")
    private List<ScpStoreCartDO> items;

    @ApiModelProperty(value = "需求仓库id/门店id", required = true)
    @NotNull(message = "门店ID不能为空")
    private Long demandWhStId;

    @ApiModelProperty(value = "需求仓库名称/门店名称", required = true)
    @NotBlank(message = "门店名称不能为空")
    private String demandWhStName;

    @ApiModelProperty(value = "需求日期", required = true)
    @NotNull(message = "需求日期不能为空")
    private LocalDateTime demandDate;

    @ApiModelProperty("门店经营性质")
    private String storeType2;

    @ApiModelProperty("店面等级")
    private String storeLevel;

    @ApiModelProperty("收货地址号")
    private Long recvAddrNo;

    @ApiModelProperty("收货联系人")
    private String recvContactName;

    @ApiModelProperty("收货联系电话")
    private String recvContactTel;

    @ApiModelProperty("收货国家")
    private String recvCountry;

    @ApiModelProperty("收货省")
    private String recvProvince;

    @ApiModelProperty("收货市")
    private String recvCity;

    @ApiModelProperty("收货区县")
    private String recvCounty;

    @ApiModelProperty("收货详细地址")
    private String recvDetailaddr;
}
