package com.elitesland.scp.application.facade.vo.cart;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import javax.validation.constraints.NotBlank;
import java.io.Serializable;

@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
@ApiModel(value = "购物车强配商品保存对象", description = "购物车")
public class StoreCartAllocSaveVO implements Serializable {
    private static final long serialVersionUID = 3257501573580086493L;

    @ApiModelProperty(value = "门店编码", required = true)
    @NotBlank(message = "门店编码不能为空")
    private String demandWhStCode;

    @ApiModelProperty(value = "采购车类型", required = true)
    @NotBlank(message = "采购车类型不能为空")
    private String cartType;

    @ApiModelProperty(value = "业务类型", required = true)
    @NotBlank(message = "业务类型不能为空")
    private String businessType;
}
